/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.lib.configurate.loader;

import io.github.rothes.esu.lib.configurate.BasicConfigurationNode;
import io.github.rothes.esu.lib.configurate.ConfigurationNode;
import io.github.rothes.esu.lib.configurate.loader.ConfigurationFormats;
import io.github.rothes.esu.lib.configurate.loader.ConfigurationLoader;
import java.net.URL;
import java.nio.file.Path;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ConfigurationFormat {
    public static @Nullable ConfigurationFormat forExtension(String extension) {
        @Nullable ConfigurationFormats.Holder holder = ConfigurationFormats.BY_EXTENSION.get(extension);
        return holder == null ? null : holder.get();
    }

    public static Set<ConfigurationFormat> supportedFormats() {
        return ConfigurationFormats.unwrappedFormats();
    }

    public String id();

    public Set<String> supportedExtensions();

    default public ConfigurationLoader<? extends @NonNull Object> create(Path file) {
        return this.create(file, (ConfigurationNode)BasicConfigurationNode.factory().createNode());
    }

    public ConfigurationLoader<? extends @NonNull Object> create(Path var1, ConfigurationNode var2);

    default public ConfigurationLoader<? extends @NonNull Object> create(URL url) {
        return this.create(url, (ConfigurationNode)BasicConfigurationNode.factory().createNode());
    }

    public ConfigurationLoader<? extends @NonNull Object> create(URL var1, ConfigurationNode var2);
}

