/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.command.parser.location;

import io.github.rothes.esu.bukkit.command.parser.location.ChunkLocation;
import io.github.rothes.esu.core.util.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.incendo.cloud.bukkit.BukkitCaptionKeys;
import org.incendo.cloud.bukkit.BukkitCommandContextKeys;
import org.incendo.cloud.bukkit.parser.location.LocationCoordinate;
import org.incendo.cloud.bukkit.parser.location.LocationCoordinateParser;
import org.incendo.cloud.bukkit.parser.location.LocationCoordinateType;
import org.incendo.cloud.bukkit.parser.location.LocationParser;
import org.incendo.cloud.caption.Caption;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u0017*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00f8\u0001\u0000J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0018"}, d2={"Lio/github/rothes/esu/bukkit/command/parser/location/ChunkLocationParser;", "C", "Lorg/incendo/cloud/parser/ArgumentParser;", "Lio/github/rothes/esu/bukkit/command/parser/location/ChunkLocation;", "Lorg/incendo/cloud/suggestion/BlockingSuggestionProvider$Strings;", "<init>", "()V", "locationCoordinateParser", "Lorg/incendo/cloud/bukkit/parser/location/LocationCoordinateParser;", "toLocalSpace", "Ljava/lang/invoke/MethodHandle;", "getSuggestions", "parse", "Lorg/incendo/cloud/parser/ArgumentParseResult;", "commandContext", "Lorg/incendo/cloud/context/CommandContext;", "commandInput", "Lorg/incendo/cloud/context/CommandInput;", "stringSuggestions", "", "", "input", "LocationParseException", "Companion", "bukkit"})
public final class ChunkLocationParser<C>
implements ArgumentParser<C, ChunkLocation>,
BlockingSuggestionProvider.Strings<C> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocationCoordinateParser<C> locationCoordinateParser = new LocationCoordinateParser();
    @NotNull
    private final MethodHandle toLocalSpace;
    @NotNull
    private final MethodHandle getSuggestions;

    public ChunkLocationParser() {
        Class[] classArray = new Class[]{Location.class, Vector.class};
        this.toLocalSpace = ReflectionUtils.INSTANCE.getHandle(LocationParser.class.getDeclaredMethod("toLocalSpace", classArray));
        classArray = new Class[]{Integer.TYPE, CommandContext.class, CommandInput.class};
        this.getSuggestions = ReflectionUtils.INSTANCE.getHandle(LocationParser.class.getDeclaredMethod("getSuggestions", classArray));
    }

    @NotNull
    public ArgumentParseResult<ChunkLocation> parse(@NotNull CommandContext<C> commandContext, @NotNull CommandInput commandInput) {
        if (commandInput.remainingTokens() < 2) {
            return ChunkLocationParser.parse$wrongFormatException(commandContext, commandInput);
        }
        LocationCoordinate[] coordinates = new LocationCoordinate[2];
        for (int i = 0; i < 2; ++i) {
            if (((CharSequence)commandInput.peekString()).length() == 0) {
                return ChunkLocationParser.parse$wrongFormatException(commandContext, commandInput);
            }
            ArgumentParseResult coordinate = this.locationCoordinateParser.parse(commandContext, commandInput);
            if (coordinate.failure().isPresent()) {
                return ArgumentParseResult.failure((Throwable)((Throwable)coordinate.failure().get()));
            }
            coordinates[i] = coordinate.parsedValue().orElseThrow(ChunkLocationParser::parse$lambda$0);
        }
        CommandSender bukkitSender = (CommandSender)commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
        CommandSender commandSender = bukkitSender;
        Location location = commandSender instanceof BlockCommandSender ? ((BlockCommandSender)bukkitSender).getBlock().getLocation() : (commandSender instanceof Entity ? ((Entity)bukkitSender).getLocation() : new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0));
        location.setX((double)(location.getBlockX() >> 4));
        location.setZ((double)(location.getBlockZ() >> 4));
        LocationCoordinate locationCoordinate = coordinates[0];
        Intrinsics.checkNotNull(locationCoordinate);
        if (locationCoordinate.type() == LocationCoordinateType.LOCAL) {
            LocationCoordinate locationCoordinate2 = coordinates[1];
            Intrinsics.checkNotNull(locationCoordinate2);
            if (locationCoordinate2.type() != LocationCoordinateType.LOCAL) {
                return ArgumentParseResult.failure((Throwable)((Throwable)((Object)new LocationParseException(commandContext, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_LOCATION_MIXED_LOCAL_ABSOLUTE, ""))));
            }
        }
        LocationCoordinate locationCoordinate3 = coordinates[0];
        Intrinsics.checkNotNull(locationCoordinate3);
        if (locationCoordinate3.type() == LocationCoordinateType.ABSOLUTE) {
            LocationCoordinate locationCoordinate4 = coordinates[0];
            Intrinsics.checkNotNull(locationCoordinate4);
            location.setX(locationCoordinate4.coordinate());
        } else {
            LocationCoordinate locationCoordinate5 = coordinates[0];
            Intrinsics.checkNotNull(locationCoordinate5);
            if (locationCoordinate5.type() == LocationCoordinateType.RELATIVE) {
                LocationCoordinate locationCoordinate6 = coordinates[0];
                Intrinsics.checkNotNull(locationCoordinate6);
                location.add(locationCoordinate6.coordinate(), 0.0, 0.0);
            }
        }
        LocationCoordinate locationCoordinate7 = coordinates[1];
        Intrinsics.checkNotNull(locationCoordinate7);
        if (locationCoordinate7.type() == LocationCoordinateType.ABSOLUTE) {
            LocationCoordinate locationCoordinate8 = coordinates[1];
            Intrinsics.checkNotNull(locationCoordinate8);
            location.setZ(locationCoordinate8.coordinate());
        } else {
            LocationCoordinate locationCoordinate9 = coordinates[1];
            Intrinsics.checkNotNull(locationCoordinate9);
            if (locationCoordinate9.type() == LocationCoordinateType.RELATIVE) {
                LocationCoordinate locationCoordinate10 = coordinates[1];
                Intrinsics.checkNotNull(locationCoordinate10);
                location.add(0.0, 0.0, locationCoordinate10.coordinate());
            } else {
                LocationCoordinate locationCoordinate11 = coordinates[0];
                Intrinsics.checkNotNull(locationCoordinate11);
                double d = locationCoordinate11.coordinate();
                LocationCoordinate locationCoordinate12 = coordinates[1];
                Intrinsics.checkNotNull(locationCoordinate12);
                Vector declaredPos = new Vector(d, 0.0, locationCoordinate12.coordinate());
                Location local = this.toLocalSpace.invokeExact(location, declaredPos);
                return ArgumentParseResult.success((Object)new ChunkLocation(location.getWorld(), local.getX(), local.getZ()));
            }
        }
        return ArgumentParseResult.success((Object)new ChunkLocation(location.getWorld(), location.getX(), location.getZ()));
    }

    @NotNull
    public Iterable<String> stringSuggestions(@NotNull CommandContext<C> commandContext, @NotNull CommandInput input) {
        return this.getSuggestions.invokeExact(2, commandContext, input);
    }

    private static final <C> ArgumentParseResult<ChunkLocation> parse$wrongFormatException(CommandContext<C> $commandContext, CommandInput $commandInput) {
        return ArgumentParseResult.failure((Throwable)((Throwable)((Object)new LocationParseException($commandContext, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_LOCATION_INVALID_FORMAT, $commandInput.remainingInput()))));
    }

    private static final NullPointerException parse$lambda$0() {
        return new NullPointerException();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00070\u0005\"\u0006\b\u0001\u0010\u0006\u0018\u0001H\u0086\b\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/bukkit/command/parser/location/ChunkLocationParser$Companion;", "", "<init>", "()V", "parser", "Lorg/incendo/cloud/parser/ParserDescriptor;", "C", "Lio/github/rothes/esu/bukkit/command/parser/location/ChunkLocation;", "bukkit"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <C> ParserDescriptor<C, ChunkLocation> parser() {
            boolean $i$f$parser = false;
            return ParserDescriptor.of((ArgumentParser)new ChunkLocationParser(), ChunkLocation.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/github/rothes/esu/bukkit/command/parser/location/ChunkLocationParser$LocationParseException;", "Lorg/incendo/cloud/exception/parsing/ParserException;", "context", "Lorg/incendo/cloud/context/CommandContext;", "caption", "Lorg/incendo/cloud/caption/Caption;", "input", "", "<init>", "(Lorg/incendo/cloud/context/CommandContext;Lorg/incendo/cloud/caption/Caption;Ljava/lang/String;)V", "bukkit"})
    private static final class LocationParseException
    extends ParserException {
        public LocationParseException(@NotNull CommandContext<?> context, @NotNull Caption caption, @NotNull String input) {
            CaptionVariable[] captionVariableArray = new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)};
            super(LocationParser.class, context, caption, captionVariableArray);
        }
    }
}

