/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.user;

import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.user.BukkitUser;
import io.github.rothes.esu.bukkit.util.version.adapter.PlayerAdapter;
import io.github.rothes.esu.core.colorscheme.ColorScheme;
import io.github.rothes.esu.core.colorscheme.ColorSchemes;
import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.MultiLangConfiguration;
import io.github.rothes.esu.core.storage.StorageManager;
import io.github.rothes.esu.core.util.AdventureConverter;
import io.github.rothes.esu.lib.adventure.audience.Audience;
import io.github.rothes.esu.lib.adventure.text.minimessage.MiniMessage;
import io.github.rothes.esu.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tJT\u00102\u001a\u000203\"\b\b\u0000\u00104*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H4072\u0019\u00108\u001a\u0015\u0012\u0004\u0012\u0002H4\u0012\u0006\u0012\u0004\u0018\u00010\u001f09\u00a2\u0006\u0002\b:2\u0012\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020=0<\"\u00020=H\u0016\u00a2\u0006\u0002\u0010>J\u0013\u0010?\u001a\u00020,2\b\u0010@\u001a\u0004\u0018\u00010AH\u0096\u0002J\b\u0010B\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00058F@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\tR\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u001c\u0010$\u001a\u0004\u0018\u00010\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010!\"\u0004\b*\u0010'R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010-R$\u0010.\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020,@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010-\"\u0004\b0\u00101\u00a8\u0006C"}, d2={"Lio/github/rothes/esu/bukkit/user/PlayerUser;", "Lio/github/rothes/esu/bukkit/user/BukkitUser;", "uuid", "Ljava/util/UUID;", "initPlayer", "Lorg/bukkit/entity/Player;", "<init>", "(Ljava/util/UUID;Lorg/bukkit/entity/Player;)V", "player", "(Lorg/bukkit/entity/Player;)V", "getUuid", "()Ljava/util/UUID;", "audience", "Lio/github/rothes/esu/lib/adventure/audience/Audience;", "getAudience", "()Lio/github/rothes/esu/lib/adventure/audience/Audience;", "value", "playerCache", "getPlayerCache", "()Lorg/bukkit/entity/Player;", "setPlayerCache$bukkit", "getPlayer", "commandSender", "Lorg/bukkit/command/CommandSender;", "getCommandSender", "()Lorg/bukkit/command/CommandSender;", "dbId", "", "getDbId", "()I", "nameUnsafe", "", "getNameUnsafe", "()Ljava/lang/String;", "clientLocale", "getClientLocale", "languageUnsafe", "getLanguageUnsafe", "setLanguageUnsafe", "(Ljava/lang/String;)V", "colorSchemeUnsafe", "getColorSchemeUnsafe", "setColorSchemeUnsafe", "isOnline", "", "()Z", "logonBefore", "getLogonBefore", "setLogonBefore$bukkit", "(Z)V", "kick", "", "T", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "locales", "Lio/github/rothes/esu/core/configuration/MultiLangConfiguration;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "params", "", "Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;", "(Lio/github/rothes/esu/core/configuration/MultiLangConfiguration;Lkotlin/jvm/functions/Function1;[Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;)V", "equals", "other", "", "hashCode", "bukkit"})
public final class PlayerUser
extends BukkitUser {
    @NotNull
    private final UUID uuid;
    @Nullable
    private Player playerCache;
    private final int dbId;
    @Nullable
    private String languageUnsafe;
    @Nullable
    private String colorSchemeUnsafe;
    private boolean logonBefore;

    public PlayerUser(@NotNull UUID uuid, @Nullable Player initPlayer) {
        this.uuid = uuid;
        this.playerCache = initPlayer;
        StorageManager.UserData userData = StorageManager.INSTANCE.getUserData(this.getUuid());
        this.dbId = userData.getDbId();
        this.setLanguageUnsafe(userData.getLanguage());
        this.setColorSchemeUnsafe(userData.getColorScheme());
    }

    public /* synthetic */ PlayerUser(UUID uUID, Player player, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            player = null;
        }
        this(uUID, player);
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public PlayerUser(@NotNull Player player) {
        this(player.getUniqueId(), player);
    }

    @Override
    @NotNull
    public Audience getAudience() {
        return InternalsKt.getAudience((CommandSender)this.getPlayer());
    }

    @Nullable
    public final Player getPlayerCache() {
        Player cache = this.playerCache;
        if (cache != null && cache.isOnline() && PlayerAdapter.Companion.getConnected((OfflinePlayer)cache)) {
            return cache;
        }
        Player get = Bukkit.getPlayer((UUID)this.getUuid());
        if (get != null) {
            this.playerCache = get;
            return get;
        }
        Player player = cache;
        if (player == null) {
            throw new IllegalStateException(("Player " + this.getUuid() + " is not online and there's no cached instance!").toString());
        }
        return player;
    }

    public final void setPlayerCache$bukkit(@Nullable Player player) {
        this.playerCache = player;
    }

    @NotNull
    public final Player getPlayer() {
        Player player = this.getPlayerCache();
        Intrinsics.checkNotNull((Object)player);
        return player;
    }

    @Override
    @NotNull
    public CommandSender getCommandSender() {
        return (CommandSender)this.getPlayer();
    }

    @Override
    public int getDbId() {
        return this.dbId;
    }

    @Override
    @Nullable
    public String getNameUnsafe() {
        Player player = this.getPlayerCache();
        return player != null ? player.getName() : null;
    }

    @Override
    @NotNull
    public String getClientLocale() {
        return this.getPlayer().getLocale();
    }

    @Override
    @Nullable
    public String getLanguageUnsafe() {
        return this.languageUnsafe;
    }

    @Override
    public void setLanguageUnsafe(@Nullable String string) {
        this.languageUnsafe = string;
    }

    @Override
    @Nullable
    public String getColorSchemeUnsafe() {
        return this.colorSchemeUnsafe;
    }

    @Override
    public void setColorSchemeUnsafe(@Nullable String string) {
        this.colorSchemeUnsafe = string;
    }

    @Override
    public boolean isOnline() {
        Player player = this.getPlayerCache();
        return player != null ? player.isOnline() : false;
    }

    public final boolean getLogonBefore() {
        return this.logonBefore;
    }

    public final void setLogonBefore$bukkit(boolean bl) {
        this.logonBefore = bl;
    }

    @Override
    public <T extends ConfigurationPart> void kick(@NotNull MultiLangConfiguration<T> locales, @NotNull Function1<? super T, String> block, TagResolver ... params) {
        Player player = this.getPlayer();
        MiniMessage miniMessage = MiniMessage.miniMessage();
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)params);
        Object r = ColorSchemes.INSTANCE.getSchemes().get(this.getColorScheme(), PlayerUser::kick$lambda$0);
        Intrinsics.checkNotNull(r);
        spreadBuilder.add(r);
        player.kick(AdventureConverter.INSTANCE.getServer(miniMessage.deserialize(this.localed(locales, block), (TagResolver[])spreadBuilder.toArray((Object[])new TagResolver[spreadBuilder.size()]))));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type io.github.rothes.esu.bukkit.user.PlayerUser");
        PlayerUser cfr_ignored_0 = (PlayerUser)object2;
        if (this.getDbId() != ((PlayerUser)other).getDbId()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getUuid(), (Object)((PlayerUser)other).getUuid());
    }

    public int hashCode() {
        int result = this.getDbId();
        result = 31 * result + this.getUuid().hashCode();
        return result;
    }

    private static final TagResolver kick$lambda$0(ColorScheme $this$get) {
        return $this$get.getTagResolver();
    }
}

