/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.util;

import com.google.gson.reflect.TypeToken;
import io.github.rothes.esu.core.util.DataSerializer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0086\u0002J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0086\u0002J\u0013\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0003H\u0086\u0002J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\nH\u0086\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u0015\u001a\u00020\rR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/rothes/esu/core/util/FileHashes;", "", "folder", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "hashes", "data", "Lio/github/rothes/esu/core/util/FileHashes$Data;", "get", "", "key", "set", "", "value", "file", "verify", "", "modifier", "store", "clear", "save", "Data", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFileHashes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHashes.kt\nio/github/rothes/esu/core/util/FileHashes\n+ 2 DataSerializer.kt\nio/github/rothes/esu/core/util/DataSerializer\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n29#2:73\n24#2,2:74\n1#3:76\n*S KotlinDebug\n*F\n+ 1 FileHashes.kt\nio/github/rothes/esu/core/util/FileHashes\n*L\n17#1:73\n17#1:74,2\n*E\n"})
public final class FileHashes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File hashes;
    @NotNull
    private final Data data;

    /*
     * WARNING - void declaration
     */
    public FileHashes(@NotNull File folder) {
        Data data;
        this.hashes = FilesKt.resolve(folder, "fileHashes");
        if (!this.hashes.exists()) {
            data = new Data(this, null, 1, null);
        } else {
            void $this$iv$iv;
            void this_$iv;
            DataSerializer dataSerializer = DataSerializer.INSTANCE;
            String $this$deserialize$iv = FilesKt.readText$default(this.hashes, null, 1, null);
            boolean $i$f$deserialize = false;
            void var5_5 = this_$iv;
            String str$iv$iv = $this$deserialize$iv;
            TypeToken typeToken$iv$iv = TypeToken.get(Data.class);
            boolean $i$f$deserializeObj = false;
            data = (Data)$this$iv$iv.getGson().fromJson(str$iv$iv, typeToken$iv$iv.getType());
        }
        this.data = data;
    }

    @Nullable
    public final String get(@NotNull String key) {
        return this.data.getSha1().get(key);
    }

    public final void set(@NotNull String key, @NotNull String value) {
        this.data.getSha1().put(key, value);
    }

    @Nullable
    public final String get(@NotNull File file) {
        return this.get(file.getName());
    }

    public final void set(@NotNull File file, @NotNull String value) {
        this.data.getSha1().put(file.getName(), value);
    }

    public final boolean verify(@NotNull File file, @Nullable String modifier) {
        String suffix;
        block5: {
            Object object;
            block4: {
                object = modifier;
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                String string = ":" + it;
                object = string;
                if (string != null) break block5;
            }
            object = suffix = "";
        }
        if (!file.exists()) {
            return false;
        }
        return Intrinsics.areEqual(Companion.getSha1(file), this.get(file.getName() + suffix));
    }

    public static /* synthetic */ boolean verify$default(FileHashes fileHashes, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return fileHashes.verify(file, string);
    }

    public final void store(@NotNull File file, @Nullable String modifier) {
        Object object;
        block3: {
            block2: {
                object = modifier;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = ":" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String suffix = object;
        this.set(file.getName() + suffix, Companion.getSha1(file));
    }

    public static /* synthetic */ void store$default(FileHashes fileHashes, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        fileHashes.store(file, string);
    }

    public final void clear() {
        this.data.getSha1().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        if (!this.hashes.exists()) {
            this.hashes.getParentFile().mkdirs();
            this.hashes.createNewFile();
        }
        Object object = this.hashes;
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)object;
            boolean bl = false;
            Writer writer2 = writer.append(DataSerializer.INSTANCE.serialize(this.data));
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/github/rothes/esu/core/util/FileHashes$Companion;", "", "<init>", "()V", "sha1", "", "Ljava/io/File;", "getSha1$annotations", "(Ljava/io/File;)V", "getSha1", "(Ljava/io/File;)Ljava/lang/String;", "core"})
    @SourceDebugExtension(value={"SMAP\nFileHashes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHashes.kt\nio/github/rothes/esu/core/util/FileHashes$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String getSha1(@NotNull File $this$sha1) {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            Closeable closeable = new FileInputStream($this$sha1);
            Throwable throwable = null;
            try {
                FileInputStream input = (FileInputStream)closeable;
                boolean bl = false;
                byte[] buffer = new byte[8192];
                int bytesRead = 0;
                while (true) {
                    int n;
                    int it = n = input.read(buffer);
                    boolean bl2 = false;
                    bytesRead = it;
                    if (n == -1) break;
                    messageDigest.update(buffer, 0, bytesRead);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            byte[] hashBytes = messageDigest.digest();
            return HexExtensionsKt.toHexString$default(hashBytes, null, 1, null);
        }

        public static /* synthetic */ void getSha1$annotations(File file) {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/github/rothes/esu/core/util/FileHashes$Data;", "", "sha1", "", "", "<init>", "(Lio/github/rothes/esu/core/util/FileHashes;Ljava/util/Map;)V", "getSha1", "()Ljava/util/Map;", "core"})
    public final class Data {
        @NotNull
        private final Map<String, String> sha1;
        final /* synthetic */ FileHashes this$0;

        public Data(@NotNull FileHashes this$0, Map<String, String> sha1) {
            this.this$0 = this$0;
            this.sha1 = sha1;
        }

        public /* synthetic */ Data(FileHashes fileHashes, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(fileHashes, map);
        }

        @NotNull
        public final Map<String, String> getSha1() {
            return this.sha1;
        }
    }
}

