/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.velocity.module.networkthrottle;

import com.github.retrooper.packetevents.protocol.PacketSide;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import io.github.rothes.esu.core.command.annotation.ShortPerm;
import io.github.rothes.esu.core.configuration.MultiConfiguration;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.core.util.ComponentUtils;
import io.github.rothes.esu.lib.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import io.github.rothes.esu.velocity.module.NetworkThrottleModule;
import io.github.rothes.esu.velocity.module.VelocityModule;
import io.github.rothes.esu.velocity.module.networkthrottle.Analyser;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.DecoderChannelHandler;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.EncoderChannelHandler;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.Injector;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.PacketData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Flag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u0018R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR#\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/Analyser;", "", "<init>", "()V", "value", "", "running", "getRunning", "()Z", "", "startTime", "getStartTime", "()J", "stopTime", "getStopTime", "records", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/github/retrooper/packetevents/protocol/packettype/PacketTypeCommon;", "", "Lio/github/rothes/esu/velocity/module/networkthrottle/Analyser$PacketRecord;", "getRecords", "()Ljava/util/concurrent/ConcurrentHashMap;", "start", "enable", "", "disable", "reset", "PacketRecord", "EncoderHandler", "DecoderHandler", "velocity"})
public final class Analyser {
    @NotNull
    public static final Analyser INSTANCE = new Analyser();
    private static boolean running;
    private static long startTime;
    private static long stopTime;
    @NotNull
    private static final ConcurrentHashMap<PacketTypeCommon, List<PacketRecord>> records;

    private Analyser() {
    }

    public final boolean getRunning() {
        return running;
    }

    public final long getStartTime() {
        return startTime;
    }

    public final long getStopTime() {
        return stopTime;
    }

    @NotNull
    public final ConcurrentHashMap<PacketTypeCommon, List<PacketRecord>> getRecords() {
        return records;
    }

    public final boolean start() {
        if (running) {
            return false;
        }
        running = true;
        this.reset();
        Injector.INSTANCE.registerHandler(EncoderHandler.INSTANCE);
        Injector.INSTANCE.registerHandler(DecoderHandler.INSTANCE);
        return true;
    }

    public final void enable() {
        VelocityModule.registerCommands$default(NetworkThrottleModule.INSTANCE, new Object(){

            @Command(value="vnetwork analyser start")
            @ShortPerm(value="analyser")
            public final void analyserStart(User sender) {
                if (Analyser.INSTANCE.start()) {
                    sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.1::analyserStart$lambda$0, new TagResolver[0]);
                } else {
                    sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.1::analyserStart$lambda$1, new TagResolver[0]);
                }
            }

            @Command(value="vnetwork analyser stop")
            @ShortPerm(value="analyser")
            public final void analyserStop(User sender) {
                if (Analyser.INSTANCE.disable()) {
                    sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.1::analyserStop$lambda$2, new TagResolver[0]);
                } else {
                    sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.1::analyserStop$lambda$3, new TagResolver[0]);
                }
            }

            @Command(value="vnetwork analyser reset")
            @ShortPerm(value="analyser")
            public final void analyserReset(User sender) {
                Analyser.INSTANCE.reset();
                sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.1::analyserReset$lambda$4, new TagResolver[0]);
            }

            /*
             * WARNING - void declaration
             */
            @Command(value="vnetwork analyser view")
            @ShortPerm(value="analyser")
            public final void analyserView(User sender, @Flag(value="side") PacketSide side, @Flag(value="player") Player players, @Flag(value="server") RegisteredServer servers, @Flag(value="limit") int limit) {
                Map $this$filterValues$iv;
                LinkedList it;
                Object $this$forEach$iv;
                TagResolver[] tagResolverArray;
                Iterator<T> result$iv;
                Serializable serializable;
                Map.Entry it2;
                TagResolver[] tagResolverArray2;
                K k;
                TagResolver[] tagResolverArray3;
                void $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv = Analyser.INSTANCE.getRecords();
                boolean $i$f$mapValues = false;
                Map map = $this$mapValues$iv;
                TagResolver[] destination$iv$iv = (TagResolver[])new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean bl = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    tagResolverArray3 = destination$iv$iv;
                    boolean bl2 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    k = it$iv$iv.getKey();
                    tagResolverArray2 = tagResolverArray3;
                    boolean bl22 = false;
                    serializable = new LinkedList<E>((Collection)it2.getValue());
                    tagResolverArray2.put(k, serializable);
                }
                TagResolver[] it3 = destination$iv$iv;
                boolean bl3 = false;
                if (side != null) {
                    TagResolver[] $this$filterKeys$iv = it3;
                    boolean bl4 = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        PacketTypeCommon it4 = (PacketTypeCommon)entry$iv.getKey();
                        boolean bl42 = false;
                        if (!(it4.getSide() == side)) continue;
                        ((HashMap)((Object)result$iv)).put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    tagResolverArray = (Map)((Object)result$iv);
                } else {
                    tagResolverArray = it3;
                }
                Map it4 = $this$mapValues$iv = tagResolverArray;
                boolean bl5 = false;
                if (players != null) {
                    $this$forEach$iv = it4.values();
                    boolean bl6 = false;
                    result$iv = $this$forEach$iv.iterator();
                    while (result$iv.hasNext()) {
                        E element$iv = result$iv.next();
                        it = (LinkedList)element$iv;
                        boolean bl62 = false;
                        it.removeIf(arg_0 -> enable.1.analyserView$lambda$11$lambda$10$lambda$9(arg_0 -> enable.1.analyserView$lambda$11$lambda$10$lambda$8(players, arg_0), arg_0));
                    }
                }
                it4 = $this$mapValues$iv;
                boolean bl7 = false;
                if (servers != null) {
                    $this$forEach$iv = it4.values();
                    boolean bl8 = false;
                    result$iv = $this$forEach$iv.iterator();
                    while (result$iv.hasNext()) {
                        T element$iv = result$iv.next();
                        it = (LinkedList)element$iv;
                        boolean bl82 = false;
                        it.removeIf(arg_0 -> enable.1.analyserView$lambda$15$lambda$14$lambda$13(arg_0 -> enable.1.analyserView$lambda$15$lambda$14$lambda$12(servers, arg_0), arg_0));
                    }
                }
                boolean $i$f$filterValues = false;
                Map<K, V> result$iv2 = new LinkedHashMap<K, V>();
                for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
                    LinkedList it5 = (LinkedList)entry.getValue();
                    boolean bl9 = false;
                    boolean bl10 = !((Collection)it5).isEmpty();
                    if (!bl10) continue;
                    ((HashMap)result$iv2).put(entry.getKey(), entry.getValue());
                }
                $this$filterValues$iv = result$iv2;
                $i$f$mapValues = false;
                result$iv2 = $this$mapValues$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean bl11 = false;
                $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    long l;
                    PacketRecord it6;
                    long l2;
                    void it5;
                    void it$iv$iv;
                    Map.Entry bl42 = (Map.Entry)element$iv$iv$iv;
                    tagResolverArray3 = destination$iv$iv;
                    boolean bl12 = false;
                    it2 = (Map.Entry)element$iv$iv$iv;
                    k = it$iv$iv.getKey();
                    tagResolverArray2 = tagResolverArray3;
                    boolean bl112 = false;
                    LinkedList list = (LinkedList)it5.getValue();
                    Iterable iterable = list;
                    Integer n = list.size();
                    long l3 = 0L;
                    for (T t : iterable) {
                        PacketRecord packetRecord = (PacketRecord)t;
                        l2 = l3;
                        boolean bl122 = false;
                        long l4 = it6.getUncompressedSize();
                        l3 = l2 + l4;
                    }
                    l2 = l3;
                    iterable = list;
                    Long l5 = l2;
                    l3 = 0L;
                    for (T t : iterable) {
                        void it7;
                        it6 = (PacketRecord)t;
                        l = l3;
                        boolean bl13 = false;
                        long l6 = it7.getCompressedSize();
                        l3 = l + l6;
                    }
                    l = l3;
                    serializable = TuplesKt.to(n, TuplesKt.to(l5, l));
                    tagResolverArray2.put(k, serializable);
                }
                Iterable $this$sortedByDescending$iv = destination$iv$iv.entrySet();
                boolean $i$f$sortedByDescending = false;
                List<T> entries = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)b;
                        boolean bl = false;
                        Comparable comparable = (Long)((Pair)((Pair)it.getValue()).getSecond()).getSecond();
                        it = (Map.Entry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Long)((Pair)((Pair)it.getValue()).getSecond()).getSecond()));
                    }
                });
                if (entries.isEmpty()) {
                    sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.1::analyserView$lambda$21, new TagResolver[0]);
                    return;
                }
                sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.1::analyserView$lambda$22, new TagResolver[0]);
                for (Map.Entry entry : CollectionsKt.take((Iterable)entries, limit)) {
                    PacketTypeCommon k2 = (PacketTypeCommon)entry.getKey();
                    Pair entry3 = (Pair)entry.getValue();
                    int n = ((Number)entry3.component1()).intValue();
                    Pair v = (Pair)entry3.component2();
                    long uncompressed = ((Number)v.component1()).longValue();
                    long compressed = ((Number)v.component2()).longValue();
                    MultiConfiguration multiConfiguration = NetworkThrottleModule.INSTANCE.getLocale();
                    Function1<NetworkThrottleModule.ModuleLang, MessageData> function1 = enable.1::analyserView$lambda$23;
                    tagResolverArray3 = new TagResolver[4];
                    String string = k2.getName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    tagResolverArray3[0] = ComponentUtils.INSTANCE.unparsed("packet-type", string);
                    tagResolverArray3[1] = ComponentUtils.INSTANCE.unparsed("counts", n);
                    tagResolverArray3[2] = ComponentUtils.bytes$default(ComponentUtils.INSTANCE, uncompressed, "uncompressed-size", null, null, null, null, 60, null);
                    tagResolverArray3[3] = ComponentUtils.bytes$default(ComponentUtils.INSTANCE, compressed, "compressed-size", null, null, null, null, 60, null);
                    sender.sendMessage(multiConfiguration, function1, tagResolverArray3);
                }
                TagResolver[] tagResolverArray4 = new TagResolver[1];
                tagResolverArray4[0] = ComponentUtils.duration-KLykuaI$default(ComponentUtils.INSTANCE, DurationKt.toDuration(Analyser.INSTANCE.getRunning() ? System.currentTimeMillis() - Analyser.INSTANCE.getStartTime() : Analyser.INSTANCE.getStopTime() - Analyser.INSTANCE.getStartTime(), DurationUnit.MILLISECONDS), sender, null, 4, null);
                sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.1::analyserView$lambda$24, tagResolverArray4);
            }

            public static /* synthetic */ void analyserView$default(enable.1 var0, User user, PacketSide packetSide, Player player, RegisteredServer registeredServer, int n, int n2, Object object) {
                if ((n2 & 2) != 0) {
                    packetSide = null;
                }
                if ((n2 & 4) != 0) {
                    player = null;
                }
                if ((n2 & 8) != 0) {
                    registeredServer = null;
                }
                if ((n2 & 0x10) != 0) {
                    n = 7;
                }
                var0.analyserView(user, packetSide, player, registeredServer, n);
            }

            private static final MessageData analyserStart$lambda$0(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getAnalyser().getStarted();
            }

            private static final MessageData analyserStart$lambda$1(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getAnalyser().getAlreadyStarted();
            }

            private static final MessageData analyserStop$lambda$2(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getAnalyser().getStopped();
            }

            private static final MessageData analyserStop$lambda$3(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getAnalyser().getAlreadyStopped();
            }

            private static final MessageData analyserReset$lambda$4(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getAnalyser().getReset();
            }

            private static final boolean analyserView$lambda$11$lambda$10$lambda$8(Player $players, PacketRecord record) {
                return Intrinsics.areEqual($players, record.getPlayer());
            }

            private static final boolean analyserView$lambda$11$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean analyserView$lambda$15$lambda$14$lambda$12(RegisteredServer $servers, PacketRecord record) {
                return Intrinsics.areEqual($servers, record.getServer());
            }

            private static final boolean analyserView$lambda$15$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final MessageData analyserView$lambda$21(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getAnalyser().getView().getNoData();
            }

            private static final MessageData analyserView$lambda$22(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getAnalyser().getView().getHeader();
            }

            private static final MessageData analyserView$lambda$23(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getAnalyser().getView().getEntry();
            }

            private static final MessageData analyserView$lambda$24(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getAnalyser().getView().getFooter();
            }
        }, null, 2, null);
    }

    public final boolean disable() {
        if (!running) {
            return false;
        }
        running = false;
        stopTime = System.currentTimeMillis();
        Injector.INSTANCE.unregisterHandler(EncoderHandler.INSTANCE);
        Injector.INSTANCE.unregisterHandler(DecoderHandler.INSTANCE);
        return true;
    }

    public final void reset() {
        startTime = System.currentTimeMillis();
        records.clear();
    }

    static {
        records = new ConcurrentHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/Analyser$DecoderHandler;", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/DecoderChannelHandler;", "<init>", "()V", "decode", "", "packetData", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/PacketData;", "velocity"})
    public static final class DecoderHandler
    implements DecoderChannelHandler {
        @NotNull
        public static final DecoderHandler INSTANCE = new DecoderHandler();

        private DecoderHandler() {
        }

        @Override
        public void decode(@NotNull PacketData packetData) {
            Player player;
            List records = INSTANCE.getRecords().computeIfAbsent(packetData.getPacketType(), arg_0 -> DecoderHandler.decode$lambda$1(DecoderHandler::decode$lambda$0, arg_0));
            Object object = player = packetData.getPlayer();
            records.add(new PacketRecord(player, object != null && (object = object.getCurrentServer()) != null && (object = (ServerConnection)OptionalsKt.getOrNull(object)) != null ? object.getServer() : null, packetData.getUncompressedSize(), packetData.getCompressedSize()));
        }

        private static final List decode$lambda$0(PacketTypeCommon it) {
            return Collections.synchronizedList(new ArrayList());
        }

        private static final List decode$lambda$1(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/Analyser$EncoderHandler;", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/EncoderChannelHandler;", "<init>", "()V", "encode", "", "packetData", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/PacketData;", "velocity"})
    public static final class EncoderHandler
    implements EncoderChannelHandler {
        @NotNull
        public static final EncoderHandler INSTANCE = new EncoderHandler();

        private EncoderHandler() {
        }

        @Override
        public void encode(@NotNull PacketData packetData) {
            Player player;
            List records = INSTANCE.getRecords().computeIfAbsent(packetData.getPacketType(), arg_0 -> EncoderHandler.encode$lambda$1(EncoderHandler::encode$lambda$0, arg_0));
            Object object = player = packetData.getPlayer();
            records.add(new PacketRecord(player, object != null && (object = object.getCurrentServer()) != null && (object = (ServerConnection)OptionalsKt.getOrNull(object)) != null ? object.getServer() : null, packetData.getUncompressedSize(), packetData.getCompressedSize()));
        }

        @Override
        public void flush() {
            EncoderChannelHandler.super.flush();
        }

        private static final List encode$lambda$0(PacketTypeCommon it) {
            return Collections.synchronizedList(new ArrayList());
        }

        private static final List encode$lambda$1(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J5\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/Analyser$PacketRecord;", "", "player", "Lcom/velocitypowered/api/proxy/Player;", "server", "Lcom/velocitypowered/api/proxy/server/RegisteredServer;", "uncompressedSize", "", "compressedSize", "<init>", "(Lcom/velocitypowered/api/proxy/Player;Lcom/velocitypowered/api/proxy/server/RegisteredServer;II)V", "getPlayer", "()Lcom/velocitypowered/api/proxy/Player;", "getServer", "()Lcom/velocitypowered/api/proxy/server/RegisteredServer;", "getUncompressedSize", "()I", "getCompressedSize", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "velocity"})
    public static final class PacketRecord {
        @Nullable
        private final Player player;
        @Nullable
        private final RegisteredServer server;
        private final int uncompressedSize;
        private final int compressedSize;

        public PacketRecord(@Nullable Player player, @Nullable RegisteredServer server, int uncompressedSize, int compressedSize) {
            this.player = player;
            this.server = server;
            this.uncompressedSize = uncompressedSize;
            this.compressedSize = compressedSize;
        }

        @Nullable
        public final Player getPlayer() {
            return this.player;
        }

        @Nullable
        public final RegisteredServer getServer() {
            return this.server;
        }

        public final int getUncompressedSize() {
            return this.uncompressedSize;
        }

        public final int getCompressedSize() {
            return this.compressedSize;
        }

        @Nullable
        public final Player component1() {
            return this.player;
        }

        @Nullable
        public final RegisteredServer component2() {
            return this.server;
        }

        public final int component3() {
            return this.uncompressedSize;
        }

        public final int component4() {
            return this.compressedSize;
        }

        @NotNull
        public final PacketRecord copy(@Nullable Player player, @Nullable RegisteredServer server, int uncompressedSize, int compressedSize) {
            return new PacketRecord(player, server, uncompressedSize, compressedSize);
        }

        public static /* synthetic */ PacketRecord copy$default(PacketRecord packetRecord, Player player, RegisteredServer registeredServer, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                player = packetRecord.player;
            }
            if ((n3 & 2) != 0) {
                registeredServer = packetRecord.server;
            }
            if ((n3 & 4) != 0) {
                n = packetRecord.uncompressedSize;
            }
            if ((n3 & 8) != 0) {
                n2 = packetRecord.compressedSize;
            }
            return packetRecord.copy(player, registeredServer, n, n2);
        }

        @NotNull
        public String toString() {
            return "PacketRecord(player=" + this.player + ", server=" + this.server + ", uncompressedSize=" + this.uncompressedSize + ", compressedSize=" + this.compressedSize + ")";
        }

        public int hashCode() {
            int result = this.player == null ? 0 : this.player.hashCode();
            result = result * 31 + (this.server == null ? 0 : this.server.hashCode());
            result = result * 31 + Integer.hashCode(this.uncompressedSize);
            result = result * 31 + Integer.hashCode(this.compressedSize);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PacketRecord)) {
                return false;
            }
            PacketRecord packetRecord = (PacketRecord)other;
            if (!Intrinsics.areEqual(this.player, packetRecord.player)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.server, packetRecord.server)) {
                return false;
            }
            if (this.uncompressedSize != packetRecord.uncompressedSize) {
                return false;
            }
            return this.compressedSize == packetRecord.compressedSize;
        }
    }
}

