/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.event.RawUserChatEvent;
import io.github.rothes.esu.bukkit.event.RawUserEmoteEvent;
import io.github.rothes.esu.bukkit.event.RawUserReplyEvent;
import io.github.rothes.esu.bukkit.event.RawUserWhisperEvent;
import io.github.rothes.esu.bukkit.event.UserLoginEvent;
import io.github.rothes.esu.bukkit.module.BukkitModule;
import io.github.rothes.esu.bukkit.user.BukkitUser;
import io.github.rothes.esu.bukkit.user.ConsoleUser;
import io.github.rothes.esu.bukkit.user.PlayerUser;
import io.github.rothes.esu.bukkit.util.ComponentBukkitUtils;
import io.github.rothes.esu.bukkit.util.extension.ListenerExt;
import io.github.rothes.esu.bukkit.util.version.adapter.PlayerAdapter;
import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.configuration.BaseModuleConfiguration;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.core.util.AdventureConverter;
import io.github.rothes.esu.core.util.ComponentUtils;
import io.github.rothes.esu.lib.adventure.text.Component;
import io.github.rothes.esu.lib.adventure.text.ComponentLike;
import io.github.rothes.esu.lib.adventure.text.TextComponent;
import io.github.rothes.esu.lib.adventure.text.TextReplacementConfig;
import io.github.rothes.esu.lib.adventure.text.minimessage.Context;
import io.github.rothes.esu.lib.adventure.text.minimessage.MiniMessage;
import io.github.rothes.esu.lib.adventure.text.minimessage.tag.Tag;
import io.github.rothes.esu.lib.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import io.github.rothes.esu.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Commands;
import org.incendo.cloud.annotations.Flag;
import org.incendo.cloud.annotations.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004\u001f !\"B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0012\u0010\u0012\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\fJ\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u001e\u00a8\u0006#"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule;", "Lio/github/rothes/esu/bukkit/module/BukkitModule;", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig;", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang;", "<init>", "()V", "enable", "", "disable", "parseMessage", "Lio/github/rothes/esu/lib/adventure/text/Component;", "sender", "Lio/github/rothes/esu/core/user/User;", "raw", "", "modifiers", "", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$PrefixedMessageModifier;", "drop", "n", "", "setItem", "matchModifier", "text", "playerDisplay", "Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;", "viewer", "key", "user", "map", "", "ChatHandler", "Listeners", "ModuleConfig", "ModuleLang", "bukkit"})
public final class EsuChatModule
extends BukkitModule<ModuleConfig, ModuleLang> {
    @NotNull
    public static final EsuChatModule INSTANCE = new EsuChatModule();

    private EsuChatModule() {
    }

    @Override
    public void enable() {
        Listeners.INSTANCE.enable();
        if (((ModuleConfig)this.getConfig()).getWhisper().getEnabled()) {
            BukkitModule.registerCommands$default(this, ChatHandler.Whisper.INSTANCE, null, 2, null);
        }
        if (((ModuleConfig)this.getConfig()).getEmote().getEnabled()) {
            BukkitModule.registerCommands$default(this, ChatHandler.Emote.INSTANCE, null, 2, null);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            ChatHandler.Whisper.INSTANCE.checkSpyOnJoin(InternalsKt.getUser(player));
        }
    }

    @Override
    public void disable() {
        super.disable();
        Listeners.INSTANCE.disable();
    }

    @NotNull
    public final Component parseMessage(@NotNull User sender, @NotNull String raw, @NotNull List<ModuleConfig.PrefixedMessageModifier> modifiers) {
        ModuleConfig.PrefixedMessageModifier modifier = this.matchModifier(sender, raw, modifiers);
        MiniMessage miniMessage = MiniMessage.miniMessage();
        TagResolver[] tagResolverArray = new TagResolver[3];
        tagResolverArray[0] = ComponentUtils.INSTANCE.component("message", (ComponentLike)Component.text((String)(modifier != null && modifier.getRemovePrefix() ? StringsKt.drop((String)raw, (int)modifier.getMessagePrefix().length()) : raw)));
        Object object = modifier;
        if (object == null || (object = ((ModuleConfig.PrefixedMessageModifier)object).getHead()) == null) {
            object = "";
        }
        tagResolverArray[1] = ComponentUtils.INSTANCE.parsed("head", object);
        Object object2 = modifier;
        if (object2 == null || (object2 = ((ModuleConfig.PrefixedMessageModifier)object2).getFoot()) == null) {
            object2 = "";
        }
        tagResolverArray[2] = ComponentUtils.INSTANCE.parsed("foot", object2);
        return miniMessage.deserialize("<head><message><foot>", tagResolverArray);
    }

    @NotNull
    public final Component parseMessage(@NotNull User sender, @NotNull Component raw, @NotNull List<ModuleConfig.PrefixedMessageModifier> modifiers) {
        Component component;
        ModuleConfig.PrefixedMessageModifier modifier = this.matchModifier(sender, ComponentUtils.INSTANCE.getPlainText(raw), modifiers);
        MiniMessage miniMessage = MiniMessage.miniMessage();
        TagResolver[] tagResolverArray = new TagResolver[3];
        if (modifier != null && modifier.getRemovePrefix()) {
            int times = modifier.getMessagePrefix().length();
            component = this.drop(raw, times);
        } else {
            component = raw;
        }
        tagResolverArray[0] = ComponentUtils.INSTANCE.component("message", (ComponentLike)component);
        Object object = modifier;
        if (object == null || (object = ((ModuleConfig.PrefixedMessageModifier)object).getHead()) == null) {
            object = "";
        }
        tagResolverArray[1] = ComponentUtils.INSTANCE.parsed("head", object);
        Object object2 = modifier;
        if (object2 == null || (object2 = ((ModuleConfig.PrefixedMessageModifier)object2).getFoot()) == null) {
            object2 = "";
        }
        tagResolverArray[2] = ComponentUtils.INSTANCE.parsed("foot", object2);
        return miniMessage.deserialize("<head><message><foot>", tagResolverArray);
    }

    @NotNull
    public final Component drop(@NotNull Component $this$drop, int n) {
        return $this$drop.replaceText(arg_0 -> EsuChatModule.drop$lambda$0(n, arg_0));
    }

    @NotNull
    public final Component setItem(@NotNull Component $this$setItem, @NotNull User sender) {
        return sender instanceof PlayerUser ? $this$setItem.replaceText(arg_0 -> EsuChatModule.setItem$lambda$0(sender, arg_0)) : $this$setItem;
    }

    private final ModuleConfig.PrefixedMessageModifier matchModifier(User sender, String text, List<ModuleConfig.PrefixedMessageModifier> modifiers) {
        Object v0;
        block1: {
            Iterable iterable = modifiers;
            for (Object t : iterable) {
                CharSequence charSequence;
                ModuleConfig.PrefixedMessageModifier it = (ModuleConfig.PrefixedMessageModifier)t;
                boolean bl = false;
                String perm = it.getPermission();
                if (!(!(it.getRemovePrefix() && text.length() <= it.getMessagePrefix().length() || !StringsKt.startsWith$default((String)text, (String)it.getMessagePrefix(), (boolean)false, (int)2, null) || !((charSequence = (CharSequence)perm) == null || charSequence.length() == 0) && !sender.hasPermission(perm)))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final TagResolver playerDisplay(@NotNull User viewer, @NotNull String key, @NotNull User user) {
        return this.playerDisplay(viewer, MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)user)));
    }

    @NotNull
    public final TagResolver playerDisplay(@NotNull User viewer, @NotNull Map<String, ? extends User> map) {
        Object[] objectArray = new String[]{"pd", "player_display"};
        return TagResolver.resolver((Set)SetsKt.setOf((Object[])objectArray), (arg_0, arg_1) -> EsuChatModule.playerDisplay$lambda$0(map, viewer, arg_0, arg_1));
    }

    private static final void drop$lambda$0(int $n, TextReplacementConfig.Builder it) {
        String string = ".";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        it.match(pattern).replacement("").times($n);
    }

    private static final void setItem$lambda$0(User $sender, TextReplacementConfig.Builder it) {
        it.matchLiteral("[i]").replacement(arg_0 -> EsuChatModule.setItem$lambda$0$0($sender, arg_0));
    }

    private static final ComponentLike setItem$lambda$0$0(User $sender, TextComponent.Builder builder) {
        return (ComponentLike)AdventureConverter.INSTANCE.getEsu(((PlayerUser)$sender).getPlayer().getInventory().getItemInMainHand().displayName());
    }

    private static final Tag playerDisplay$lambda$0(Map $map, User $viewer, ArgumentQueue arg, Context context) {
        Tag.Argument pop = arg.popOr("One argument required for player_display");
        String id = pop.value();
        User user = (User)$map.get(id);
        if (user == null) {
            throw context.newException("Unknown player_display argument: " + id);
        }
        TagResolver[] tagResolverArray = new TagResolver[]{ComponentBukkitUtils.INSTANCE.papi(user), user instanceof PlayerUser ? ComponentUtils.INSTANCE.component("player_key", (ComponentLike)PlayerAdapter.Companion.getDisplayName_(((PlayerUser)user).getPlayer())) : ComponentUtils.INSTANCE.parsed("player_key", MiniMessage.miniMessage().escapeTags(user.getName())), ComponentUtils.INSTANCE.parsed("player_key_name", MiniMessage.miniMessage().escapeTags(user.getName()))};
        return Tag.selfClosingInserting((Component)$viewer.buildMiniMessage(INSTANCE.getLocale(), EsuChatModule::playerDisplay$lambda$0$0, tagResolverArray));
    }

    private static final String playerDisplay$lambda$0$0(ModuleLang $this$buildMiniMessage) {
        return $this$buildMiniMessage.getPlayerDisplay();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler;", "", "<init>", "()V", "Whisper", "Emote", "Chat", "bukkit"})
    public static final class ChatHandler {
        @NotNull
        public static final ChatHandler INSTANCE = new ChatHandler();

        private ChatHandler() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\nJ \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Chat;", "", "<init>", "()V", "chat", "", "sender", "Lio/github/rothes/esu/core/user/User;", "message", "", "Lio/github/rothes/esu/lib/adventure/text/Component;", "broadcastChat", "msg", "shout", "", "bukkit"})
        @SourceDebugExtension(value={"SMAP\nEsuChatModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EsuChatModule.kt\nio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Chat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,567:1\n774#2:568\n865#2,2:569\n1563#2:571\n1634#2,3:572\n*S KotlinDebug\n*F\n+ 1 EsuChatModule.kt\nio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Chat\n*L\n256#1:568\n256#1:569,2\n265#1:571\n265#1:572,3\n*E\n"})
        public static final class Chat {
            @NotNull
            public static final Chat INSTANCE = new Chat();

            private Chat() {
            }

            public final void chat(@NotNull User sender, @NotNull String message) {
                this.chat(sender, (Component)Component.text((String)message));
            }

            public final void chat(@NotNull User sender, @NotNull Component message) {
                Component component;
                boolean isShout = false;
                ModuleConfig.Chat.RangedChat rangedChat = ((ModuleConfig)EsuChatModule.INSTANCE.getConfig()).getChat().getRangedChat();
                if (rangedChat.getEnabled()) {
                    String plainText = ComponentUtils.INSTANCE.getPlainText(message);
                    if (!Intrinsics.areEqual((Object)plainText, (Object)rangedChat.getShoutPrefix()) && StringsKt.startsWith$default((String)plainText, (String)rangedChat.getShoutPrefix(), (boolean)false, (int)2, null) && EsuChatModule.INSTANCE.hasPerm(sender, "chat.shout")) {
                        isShout = true;
                        component = EsuChatModule.INSTANCE.drop(message, rangedChat.getShoutPrefix().length());
                    } else {
                        component = message;
                    }
                } else {
                    component = message;
                }
                Component shoutHandled = component;
                Component msg = EsuChatModule.INSTANCE.parseMessage(sender, shoutHandled, ((ModuleConfig)EsuChatModule.INSTANCE.getConfig()).getChat().getPrefixedMessageModifiers());
                this.broadcastChat(sender, msg, isShout);
            }

            /*
             * WARNING - void declaration
             */
            private final void broadcastChat(User sender, Component msg, boolean shout) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Player player;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                ModuleConfig.Chat config = ((ModuleConfig)EsuChatModule.INSTANCE.getConfig()).getChat();
                ModuleConfig.Chat.ChatFormat format = config.getRangedChat().getEnabled() && shout ? config.getRangedChat().getShoutFormat() : config.getFormat();
                Iterable iterable = Bukkit.getOnlinePlayers();
                boolean $i$f$filter = false;
                TagResolver[] tagResolverArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    player = (Player)element$iv$iv;
                    boolean bl2 = false;
                    if (!config.getRangedChat().getEnabled() || shout || !(sender instanceof PlayerUser)) {
                        bl = true;
                    } else {
                        Location sl = ((PlayerUser)sender).getPlayer().getLocation();
                        Location pl = player.getLocation();
                        bl = Intrinsics.areEqual((Object)sl.getWorld(), (Object)pl.getWorld()) && sl.distanceSquared(pl) <= (double)(config.getRangedChat().getRadius() * config.getRangedChat().getRadius());
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    player = (Player)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(InternalsKt.getUser((Player)it));
                }
                List users = (List)destination$iv$iv;
                TagResolver.Single message = ComponentUtils.INSTANCE.component("message", (ComponentLike)msg);
                TagResolver papi = ComponentBukkitUtils.INSTANCE.papi(sender);
                for (PlayerUser user : users) {
                    TagResolver[] tagResolverArray2 = new TagResolver[]{message, papi, ComponentUtils.INSTANCE.pLang((User)user, EsuChatModule.INSTANCE.getLocale(), Chat::broadcastChat$lambda$2, new TagResolver[0]), EsuChatModule.INSTANCE.playerDisplay(user, "sender", sender)};
                    user.message(format.getPlayer(), tagResolverArray2);
                }
                tagResolverArray = new TagResolver[]{message, papi, ComponentUtils.INSTANCE.pLang((User)ConsoleUser.INSTANCE, EsuChatModule.INSTANCE.getLocale(), Chat::broadcastChat$lambda$3, new TagResolver[0]), EsuChatModule.INSTANCE.playerDisplay(ConsoleUser.INSTANCE, "sender", sender)};
                ConsoleUser.INSTANCE.message(format.getConsole(), tagResolverArray);
            }

            private static final Map broadcastChat$lambda$2(ModuleLang $this$pLang) {
                return $this$pLang.getChat().getPlaceholders();
            }

            private static final Map broadcastChat$lambda$3(ModuleLang $this$pLang) {
                return $this$pLang.getChat().getPlaceholders();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Emote;", "", "<init>", "()V", "emote", "", "sender", "Lio/github/rothes/esu/core/user/User;", "message", "", "bukkit"})
        @SourceDebugExtension(value={"SMAP\nEsuChatModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EsuChatModule.kt\nio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Emote\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,567:1\n1563#2:568\n1634#2,3:569\n*S KotlinDebug\n*F\n+ 1 EsuChatModule.kt\nio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Emote\n*L\n217#1:568\n217#1:569,3\n*E\n"})
        public static final class Emote {
            @NotNull
            public static final Emote INSTANCE = new Emote();

            private Emote() {
            }

            /*
             * WARNING - void declaration
             */
            @Command(value="emote|me <message>")
            public final void emote(@NotNull User sender, @Argument(parserName="greedyString") @NotNull String message) {
                void $this$mapTo$iv$iv;
                Component msg = EsuChatModule.INSTANCE.parseMessage(sender, message, ((ModuleConfig)EsuChatModule.INSTANCE.getConfig()).getEmote().getPrefixedMessageModifiers());
                TagResolver papi = ComponentBukkitUtils.INSTANCE.papi(sender);
                SpreadBuilder $this$map$iv = (SpreadBuilder)Bukkit.getOnlinePlayers();
                boolean $i$f$map = false;
                SpreadBuilder spreadBuilder = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player player = (Player)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(InternalsKt.getUser((Player)it));
                }
                for (BukkitUser user : CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)ConsoleUser.INSTANCE)) {
                    spreadBuilder = new SpreadBuilder[]{EsuChatModule.INSTANCE.playerDisplay(user, "sender", sender), ComponentUtils.INSTANCE.component("message", (ComponentLike)msg), papi};
                    SpreadBuilder tags = spreadBuilder;
                    MessageData messageData = ((ModuleConfig)EsuChatModule.INSTANCE.getConfig()).getEmote().getFormat();
                    spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add((Object)ComponentUtils.INSTANCE.pLang((User)user, EsuChatModule.INSTANCE.getLocale(), Emote::emote$lambda$1, new TagResolver[0]));
                    spreadBuilder.addSpread((Object)tags);
                    user.message(messageData, (TagResolver[])spreadBuilder.toArray((Object[])new TagResolver[spreadBuilder.size()]));
                }
            }

            private static final Map emote$lambda$1(ModuleLang $this$pLang) {
                return $this$pLang.getEmote().getPlaceholders();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J$\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u00062\b\b\u0003\u0010\u0017\u001a\u00020\u0018H\u0007J$\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u00062\b\b\u0003\u0010\u0017\u001a\u00020\u0018H\u0007J$\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u00062\b\b\u0003\u0010\u0017\u001a\u00020\u0018H\u0007J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\bRN\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Whisper;", "", "<init>", "()V", "last", "Lcom/google/common/cache/Cache;", "Lio/github/rothes/esu/core/user/User;", "kotlin.jvm.PlatformType", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Whisper$LastTarget;", "spying", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "whisper", "", "sender", "receiver", "message", "", "reply", "spyToggle", "spyEnable", "spyDisable", "user", "silent", "", "checkSpyOnJoin", "updateLast", "lastTarget", "LastTarget", "bukkit"})
        @SourceDebugExtension(value={"SMAP\nEsuChatModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EsuChatModule.kt\nio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Whisper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,567:1\n1#2:568\n*E\n"})
        public static final class Whisper {
            @NotNull
            public static final Whisper INSTANCE = new Whisper();
            private static final Cache<User, LastTarget> last = CacheBuilder.newBuilder().expireAfterAccess(8L, TimeUnit.HOURS).build();
            @NotNull
            private static final HashSet<User> spying;

            private Whisper() {
            }

            /*
             * WARNING - void declaration
             */
            @Command(value="whisper|msg|w|m|tell <receiver> <message>")
            public final void whisper(@NotNull User sender, @NotNull User receiver, @Argument(parserName="greedyString") @NotNull String message) {
                void it;
                Component parsed = EsuChatModule.INSTANCE.parseMessage(sender, message, ((ModuleConfig)EsuChatModule.INSTANCE.getConfig()).getWhisper().getPrefixedMessageModifiers());
                TagResolver papi = ComponentBukkitUtils.INSTANCE.papi(sender);
                TagResolver.Single msg = ComponentUtils.INSTANCE.component("message", (ComponentLike)parsed);
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"sender", (Object)sender), TuplesKt.to((Object)"receiver", (Object)receiver)};
                Map pd = MapsKt.mapOf((Pair[])pairArray);
                pairArray = new TagResolver[]{msg, papi, EsuChatModule.INSTANCE.playerDisplay(sender, pd), ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::whisper$lambda$0, new TagResolver[0])};
                sender.message(((ModuleConfig)EsuChatModule.INSTANCE.getConfig()).getWhisper().getFormats().getOutgoing(), (TagResolver[])pairArray);
                pairArray = new TagResolver[]{msg, papi, EsuChatModule.INSTANCE.playerDisplay(receiver, pd), ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::whisper$lambda$1, new TagResolver[0])};
                receiver.message(((ModuleConfig)EsuChatModule.INSTANCE.getConfig()).getWhisper().getFormats().getIncoming(), (TagResolver[])pairArray);
                LastTarget lastTarget = (LastTarget)last.getIfPresent((Object)receiver);
                User user = receiver;
                User user2 = sender;
                Object object = this;
                boolean bl = false;
                boolean bl2 = it == null || !Intrinsics.areEqual((Object)it.getUser(), (Object)sender) || !it.getInitiative();
                boolean bl3 = bl2;
                User user3 = user;
                boolean initiative = ((Whisper)object).updateLast(user2, new LastTarget(user3, bl3)).getInitiative();
                this.updateLast(receiver, new LastTarget(sender, !initiative));
                for (User user4 : spying) {
                    void $this$whisper_u24lambda_u243;
                    if (!user4.isOnline() || Intrinsics.areEqual((Object)user4, (Object)sender) || Intrinsics.areEqual((Object)user4, (Object)receiver)) continue;
                    ModuleConfig.Whisper.Formats.Spy spy = ((ModuleConfig)EsuChatModule.INSTANCE.getConfig()).getWhisper().getFormats().getSpy();
                    object = user4;
                    boolean bl4 = false;
                    TagResolver[] tagResolverArray = new TagResolver[]{msg, papi, EsuChatModule.INSTANCE.playerDisplay(receiver, pd), ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::whisper$lambda$4, new TagResolver[0])};
                    object.message(initiative ? $this$whisper_u24lambda_u243.getSend() : $this$whisper_u24lambda_u243.getReply(), tagResolverArray);
                }
            }

            @Command(value="reply|r <message>")
            public final void reply(@NotNull User sender, @Argument(parserName="greedyString") @NotNull String message) {
                User last;
                LastTarget lastTarget = (LastTarget)Whisper.last.getIfPresent((Object)sender);
                User user = last = lastTarget != null ? lastTarget.getUser() : null;
                if (last == null) {
                    TagResolver[] tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::reply$lambda$1, new TagResolver[0])};
                    sender.sendMessage(EsuChatModule.INSTANCE.getLocale(), Whisper::reply$lambda$0, tagResolverArray);
                    return;
                }
                if (!last.isOnline()) {
                    TagResolver[] tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::reply$lambda$3, new TagResolver[0])};
                    sender.sendMessage(EsuChatModule.INSTANCE.getLocale(), Whisper::reply$lambda$2, tagResolverArray);
                    return;
                }
                this.whisper(sender, last, message);
            }

            @Commands(value={@Command(value="spy"), @Command(value="spy toggle")})
            @Permission(value={"esu.esuChat.spy"})
            public final void spyToggle(@NotNull User sender) {
                Whisper.spyToggle$default(this, sender, sender, false, 4, null);
            }

            @Command(value="spy enable")
            @Permission(value={"esu.esuChat.spy"})
            public final void spyEnable(@NotNull User sender) {
                Whisper.spyEnable$default(this, sender, sender, false, 4, null);
            }

            @Command(value="spy disable")
            @Permission(value={"esu.esuChat.spy"})
            public final void spyDisable(@NotNull User sender) {
                Whisper.spyDisable$default(this, sender, sender, false, 4, null);
            }

            @Command(value="spy toggle <user>")
            @Permission(value={"esu.esuChat.spy.other"})
            public final void spyToggle(@NotNull User sender, @NotNull User user, @Flag(value="silent") boolean silent) {
                if (!spying.contains(user)) {
                    this.spyEnable(sender, user, silent);
                } else {
                    this.spyDisable(sender, user, silent);
                }
            }

            public static /* synthetic */ void spyToggle$default(Whisper whisper, User user, User user2, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    user2 = user;
                }
                if ((n & 4) != 0) {
                    bl = false;
                }
                whisper.spyToggle(user, user2, bl);
            }

            @Command(value="spy enable <user>")
            @Permission(value={"esu.esuChat.spy.other"})
            public final void spyEnable(@NotNull User sender, @NotNull User user, @Flag(value="silent") boolean silent) {
                boolean added = spying.add(user);
                if (added) {
                    TagResolver[] tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::spyEnable$lambda$1, new TagResolver[0]), ComponentBukkitUtils.INSTANCE.user(user, "user"), ComponentUtils.INSTANCE.component("enable-state", (ComponentLike)ComponentUtils.INSTANCE.enabled(true, sender))};
                    sender.sendMessage(EsuChatModule.INSTANCE.getLocale(), Whisper::spyEnable$lambda$0, tagResolverArray);
                    if (!silent && !Intrinsics.areEqual((Object)sender, (Object)user)) {
                        tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::spyEnable$lambda$3, new TagResolver[0]), ComponentBukkitUtils.INSTANCE.user(user, "user"), ComponentUtils.INSTANCE.component("enable-state", (ComponentLike)ComponentUtils.INSTANCE.enabled(true, sender))};
                        user.sendMessage(EsuChatModule.INSTANCE.getLocale(), Whisper::spyEnable$lambda$2, tagResolverArray);
                    }
                } else {
                    TagResolver[] tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::spyEnable$lambda$5, new TagResolver[0]), ComponentBukkitUtils.INSTANCE.user(user, "user")};
                    sender.sendMessage(EsuChatModule.INSTANCE.getLocale(), Whisper::spyEnable$lambda$4, tagResolverArray);
                }
            }

            public static /* synthetic */ void spyEnable$default(Whisper whisper, User user, User user2, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    user2 = user;
                }
                if ((n & 4) != 0) {
                    bl = false;
                }
                whisper.spyEnable(user, user2, bl);
            }

            @Command(value="spy disable <user>")
            @Permission(value={"esu.esuChat.spy.other"})
            public final void spyDisable(@NotNull User sender, @NotNull User user, @Flag(value="silent") boolean silent) {
                boolean removed = spying.remove(user);
                if (removed) {
                    TagResolver[] tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::spyDisable$lambda$1, new TagResolver[0]), ComponentBukkitUtils.INSTANCE.user(user, "user"), ComponentUtils.INSTANCE.component("enable-state", (ComponentLike)ComponentUtils.INSTANCE.enabled(false, sender))};
                    sender.sendMessage(EsuChatModule.INSTANCE.getLocale(), Whisper::spyDisable$lambda$0, tagResolverArray);
                    if (!silent && !Intrinsics.areEqual((Object)sender, (Object)user)) {
                        tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::spyDisable$lambda$3, new TagResolver[0]), ComponentBukkitUtils.INSTANCE.user(user, "user"), ComponentUtils.INSTANCE.component("enable-state", (ComponentLike)ComponentUtils.INSTANCE.enabled(false, sender))};
                        user.sendMessage(EsuChatModule.INSTANCE.getLocale(), Whisper::spyDisable$lambda$2, tagResolverArray);
                    }
                } else {
                    TagResolver[] tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.pLang(sender, EsuChatModule.INSTANCE.getLocale(), Whisper::spyDisable$lambda$5, new TagResolver[0]), ComponentBukkitUtils.INSTANCE.user(user, "user")};
                    sender.sendMessage(EsuChatModule.INSTANCE.getLocale(), Whisper::spyDisable$lambda$4, tagResolverArray);
                }
            }

            public static /* synthetic */ void spyDisable$default(Whisper whisper, User user, User user2, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    user2 = user;
                }
                if ((n & 4) != 0) {
                    bl = false;
                }
                whisper.spyDisable(user, user2, bl);
            }

            public final void checkSpyOnJoin(@NotNull User user) {
                if (EsuChatModule.INSTANCE.hasPerm(user, "spy.enableOnJoin")) {
                    this.spyEnable(user, user, true);
                }
            }

            @NotNull
            public final LastTarget updateLast(@NotNull User user, @NotNull LastTarget lastTarget) {
                LastTarget present;
                LastTarget lastTarget2 = present = (LastTarget)last.getIfPresent((Object)user);
                LastTarget value = Intrinsics.areEqual((Object)(lastTarget2 != null ? lastTarget2.getUser() : null), (Object)lastTarget.getUser()) ? present : lastTarget;
                last.put((Object)user, (Object)value);
                return value;
            }

            private static final Map whisper$lambda$0(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getPlaceholders();
            }

            private static final Map whisper$lambda$1(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getPlaceholders();
            }

            private static final Map whisper$lambda$4(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getSpy().getPlaceholders();
            }

            private static final MessageData reply$lambda$0(ModuleLang $this$message) {
                return $this$message.getWhisper().getReplyNoLastTarget();
            }

            private static final Map reply$lambda$1(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getPlaceholders();
            }

            private static final MessageData reply$lambda$2(ModuleLang $this$message) {
                return $this$message.getWhisper().getReceiverOffline();
            }

            private static final Map reply$lambda$3(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getPlaceholders();
            }

            private static final MessageData spyEnable$lambda$0(ModuleLang $this$message) {
                return $this$message.getWhisper().getSpy().getEnabled();
            }

            private static final Map spyEnable$lambda$1(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getSpy().getPlaceholders();
            }

            private static final MessageData spyEnable$lambda$2(ModuleLang $this$message) {
                return $this$message.getWhisper().getSpy().getEnabled();
            }

            private static final Map spyEnable$lambda$3(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getSpy().getPlaceholders();
            }

            private static final MessageData spyEnable$lambda$4(ModuleLang $this$message) {
                return $this$message.getWhisper().getSpy().getAlreadyEnabled();
            }

            private static final Map spyEnable$lambda$5(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getSpy().getPlaceholders();
            }

            private static final MessageData spyDisable$lambda$0(ModuleLang $this$message) {
                return $this$message.getWhisper().getSpy().getDisabled();
            }

            private static final Map spyDisable$lambda$1(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getSpy().getPlaceholders();
            }

            private static final MessageData spyDisable$lambda$2(ModuleLang $this$message) {
                return $this$message.getWhisper().getSpy().getDisabled();
            }

            private static final Map spyDisable$lambda$3(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getSpy().getPlaceholders();
            }

            private static final MessageData spyDisable$lambda$4(ModuleLang $this$message) {
                return $this$message.getWhisper().getSpy().getAlreadyDisabled();
            }

            private static final Map spyDisable$lambda$5(ModuleLang $this$pLang) {
                return $this$pLang.getWhisper().getSpy().getPlaceholders();
            }

            static {
                Object[] objectArray = new User[]{ConsoleUser.INSTANCE};
                spying = SetsKt.hashSetOf((Object[])objectArray);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ChatHandler$Whisper$LastTarget;", "", "user", "Lio/github/rothes/esu/core/user/User;", "initiative", "", "<init>", "(Lio/github/rothes/esu/core/user/User;Z)V", "getUser", "()Lio/github/rothes/esu/core/user/User;", "getInitiative", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "bukkit"})
            public static final class LastTarget {
                @NotNull
                private final User user;
                private final boolean initiative;

                public LastTarget(@NotNull User user, boolean initiative) {
                    this.user = user;
                    this.initiative = initiative;
                }

                @NotNull
                public final User getUser() {
                    return this.user;
                }

                public final boolean getInitiative() {
                    return this.initiative;
                }

                @NotNull
                public final User component1() {
                    return this.user;
                }

                public final boolean component2() {
                    return this.initiative;
                }

                @NotNull
                public final LastTarget copy(@NotNull User user, boolean initiative) {
                    return new LastTarget(user, initiative);
                }

                public static /* synthetic */ LastTarget copy$default(LastTarget lastTarget, User user, boolean bl, int n, Object object) {
                    if ((n & 1) != 0) {
                        user = lastTarget.user;
                    }
                    if ((n & 2) != 0) {
                        bl = lastTarget.initiative;
                    }
                    return lastTarget.copy(user, bl);
                }

                @NotNull
                public String toString() {
                    return "LastTarget(user=" + this.user + ", initiative=" + this.initiative + ")";
                }

                public int hashCode() {
                    int result = this.user.hashCode();
                    result = result * 31 + Boolean.hashCode(this.initiative);
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof LastTarget)) {
                        return false;
                    }
                    LastTarget lastTarget = (LastTarget)other;
                    if (!Intrinsics.areEqual((Object)this.user, (Object)lastTarget.user)) {
                        return false;
                    }
                    return this.initiative == lastTarget.initiative;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$Listeners;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "enable", "", "disable", "onChat", "e", "Lio/github/rothes/esu/bukkit/event/RawUserChatEvent;", "onEmote", "Lio/github/rothes/esu/bukkit/event/RawUserEmoteEvent;", "onWhisper", "Lio/github/rothes/esu/bukkit/event/RawUserWhisperEvent;", "onReply", "Lio/github/rothes/esu/bukkit/event/RawUserReplyEvent;", "onPlayerJoin", "Lio/github/rothes/esu/bukkit/event/UserLoginEvent;", "onPlayerLeave", "Lorg/bukkit/event/player/PlayerQuitEvent;", "bukkit"})
    public static final class Listeners
    implements Listener {
        @NotNull
        public static final Listeners INSTANCE = new Listeners();

        private Listeners() {
        }

        public final void enable() {
            ListenerExt.register$default(ListenerExt.INSTANCE, INSTANCE, null, 1, null);
        }

        public final void disable() {
            ListenerExt.INSTANCE.unregister(INSTANCE);
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public final void onChat(@NotNull RawUserChatEvent e) {
            if (!((ModuleConfig)INSTANCE.getConfig()).getChat().getEnabled()) {
                return;
            }
            ChatHandler.Chat.INSTANCE.chat((User)e.getUser(), e.getMessage());
            e.setCancelled(true);
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public final void onEmote(@NotNull RawUserEmoteEvent e) {
            if (((ModuleConfig)INSTANCE.getConfig()).getEmote().getInterceptNamespaces()) {
                ChatHandler.Emote.INSTANCE.emote(e.getUser(), e.getMessage());
                e.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public final void onWhisper(@NotNull RawUserWhisperEvent e) {
            if (((ModuleConfig)INSTANCE.getConfig()).getWhisper().getInterceptNamespaces()) {
                Object object = e.getTargetPlayer();
                if (object == null || (object = InternalsKt.getUser(object)) == null) {
                    return;
                }
                Object target = object;
                ChatHandler.Whisper.INSTANCE.whisper(e.getUser(), (User)target, e.getMessage());
                e.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public final void onReply(@NotNull RawUserReplyEvent e) {
            if (((ModuleConfig)INSTANCE.getConfig()).getWhisper().getInterceptNamespaces()) {
                ChatHandler.Whisper.INSTANCE.reply(e.getUser(), e.getMessage());
                e.setCancelled(true);
            }
        }

        @EventHandler
        public final void onPlayerJoin(@NotNull UserLoginEvent e) {
            ChatHandler.Whisper.INSTANCE.checkSpyOnJoin(e.getUser());
        }

        @EventHandler
        public final void onPlayerLeave(@NotNull PlayerQuitEvent e) {
            PlayerUser user = InternalsKt.getUser(e.getPlayer());
            ChatHandler.Whisper.INSTANCE.spyDisable(user, user, true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseModuleConfiguration;", "chat", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat;", "emote", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Emote;", "whisper", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper;", "<init>", "(Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Emote;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper;)V", "getChat", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat;", "getEmote", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Emote;", "getWhisper", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Chat", "Emote", "Whisper", "PrefixedMessageModifier", "bukkit"})
    public static final class ModuleConfig
    extends BaseModuleConfiguration {
        @NotNull
        private final Chat chat;
        @NotNull
        private final Emote emote;
        @NotNull
        private final Whisper whisper;

        public ModuleConfig(@NotNull Chat chat, @NotNull Emote emote, @NotNull Whisper whisper) {
            super(false, 1, null);
            this.chat = chat;
            this.emote = emote;
            this.whisper = whisper;
        }

        public /* synthetic */ ModuleConfig(Chat chat, Emote emote, Whisper whisper, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                chat = new Chat(false, null, null, null, 15, null);
            }
            if ((n & 2) != 0) {
                emote = new Emote(false, null, false, null, 15, null);
            }
            if ((n & 4) != 0) {
                whisper = new Whisper(false, null, false, null, 15, null);
            }
            this(chat, emote, whisper);
        }

        @NotNull
        public final Chat getChat() {
            return this.chat;
        }

        @NotNull
        public final Emote getEmote() {
            return this.emote;
        }

        @NotNull
        public final Whisper getWhisper() {
            return this.whisper;
        }

        @NotNull
        public final Chat component1() {
            return this.chat;
        }

        @NotNull
        public final Emote component2() {
            return this.emote;
        }

        @NotNull
        public final Whisper component3() {
            return this.whisper;
        }

        @NotNull
        public final ModuleConfig copy(@NotNull Chat chat, @NotNull Emote emote, @NotNull Whisper whisper) {
            return new ModuleConfig(chat, emote, whisper);
        }

        public static /* synthetic */ ModuleConfig copy$default(ModuleConfig moduleConfig, Chat chat, Emote emote, Whisper whisper, int n, Object object) {
            if ((n & 1) != 0) {
                chat = moduleConfig.chat;
            }
            if ((n & 2) != 0) {
                emote = moduleConfig.emote;
            }
            if ((n & 4) != 0) {
                whisper = moduleConfig.whisper;
            }
            return moduleConfig.copy(chat, emote, whisper);
        }

        @NotNull
        public String toString() {
            return "ModuleConfig(chat=" + this.chat + ", emote=" + this.emote + ", whisper=" + this.whisper + ")";
        }

        public int hashCode() {
            int result = this.chat.hashCode();
            result = result * 31 + this.emote.hashCode();
            result = result * 31 + this.whisper.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleConfig)) {
                return false;
            }
            ModuleConfig moduleConfig = (ModuleConfig)other;
            if (!Intrinsics.areEqual((Object)this.chat, (Object)moduleConfig.chat)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.emote, (Object)moduleConfig.emote)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.whisper, (Object)moduleConfig.whisper);
        }

        public ModuleConfig() {
            this(null, null, null, 7, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002 !B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat;", "", "enabled", "", "format", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$ChatFormat;", "rangedChat", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$RangedChat;", "prefixedMessageModifiers", "", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$PrefixedMessageModifier;", "<init>", "(ZLio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$ChatFormat;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$RangedChat;Ljava/util/List;)V", "getEnabled", "()Z", "getFormat", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$ChatFormat;", "getRangedChat", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$RangedChat;", "getPrefixedMessageModifiers", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "RangedChat", "ChatFormat", "bukkit"})
        public static final class Chat {
            private final boolean enabled;
            @Comment(value="'player' is what players see, and 'console' is what printed to console.")
            @NotNull
            private final ChatFormat format;
            @Comment(value="\n                By enabling this, players only receive chat messages from nearby players, of the same world.\n            ")
            @NotNull
            private final RangedChat rangedChat;
            @Comment(value="\n                If the message player sent starts with 'messagePrefix' and player has the permission,\n                the 'head' and 'foot' will be appended to the chat message.\n            ")
            @NotNull
            private final List<PrefixedMessageModifier> prefixedMessageModifiers;

            public Chat(boolean enabled, @NotNull ChatFormat format, @NotNull RangedChat rangedChat, @NotNull List<PrefixedMessageModifier> prefixedMessageModifiers) {
                this.enabled = enabled;
                this.format = format;
                this.rangedChat = rangedChat;
                this.prefixedMessageModifiers = prefixedMessageModifiers;
            }

            public /* synthetic */ Chat(boolean bl, ChatFormat chatFormat, RangedChat rangedChat, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                if ((n & 2) != 0) {
                    chatFormat = new ChatFormat(MessageData.Companion.getMessage("\\<<pd:sender>> <message>"), MessageData.Companion.getMessage("<#48c0c0>\\<<pd:sender>> <message>"));
                }
                if ((n & 4) != 0) {
                    rangedChat = new RangedChat(false, 0, null, null, 15, null);
                }
                if ((n & 8) != 0) {
                    Object[] objectArray = new PrefixedMessageModifier[]{new PrefixedMessageModifier(">", false, "", "<green>", "</green>"), new PrefixedMessageModifier("*", true, "", "<gradient:#c8b3fd:#4bacc8>", "</gradient>")};
                    list = CollectionsKt.listOf((Object[])objectArray);
                }
                this(bl, chatFormat, rangedChat, list);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            @NotNull
            public final ChatFormat getFormat() {
                return this.format;
            }

            @NotNull
            public final RangedChat getRangedChat() {
                return this.rangedChat;
            }

            @NotNull
            public final List<PrefixedMessageModifier> getPrefixedMessageModifiers() {
                return this.prefixedMessageModifiers;
            }

            public final boolean component1() {
                return this.enabled;
            }

            @NotNull
            public final ChatFormat component2() {
                return this.format;
            }

            @NotNull
            public final RangedChat component3() {
                return this.rangedChat;
            }

            @NotNull
            public final List<PrefixedMessageModifier> component4() {
                return this.prefixedMessageModifiers;
            }

            @NotNull
            public final Chat copy(boolean enabled, @NotNull ChatFormat format, @NotNull RangedChat rangedChat, @NotNull List<PrefixedMessageModifier> prefixedMessageModifiers) {
                return new Chat(enabled, format, rangedChat, prefixedMessageModifiers);
            }

            public static /* synthetic */ Chat copy$default(Chat chat, boolean bl, ChatFormat chatFormat, RangedChat rangedChat, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = chat.enabled;
                }
                if ((n & 2) != 0) {
                    chatFormat = chat.format;
                }
                if ((n & 4) != 0) {
                    rangedChat = chat.rangedChat;
                }
                if ((n & 8) != 0) {
                    list = chat.prefixedMessageModifiers;
                }
                return chat.copy(bl, chatFormat, rangedChat, list);
            }

            @NotNull
            public String toString() {
                return "Chat(enabled=" + this.enabled + ", format=" + this.format + ", rangedChat=" + this.rangedChat + ", prefixedMessageModifiers=" + this.prefixedMessageModifiers + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.enabled);
                result = result * 31 + this.format.hashCode();
                result = result * 31 + this.rangedChat.hashCode();
                result = result * 31 + ((Object)this.prefixedMessageModifiers).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Chat)) {
                    return false;
                }
                Chat chat = (Chat)other;
                if (this.enabled != chat.enabled) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.format, (Object)chat.format)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.rangedChat, (Object)chat.rangedChat)) {
                    return false;
                }
                return Intrinsics.areEqual(this.prefixedMessageModifiers, chat.prefixedMessageModifiers);
            }

            public Chat() {
                this(false, null, null, null, 15, null);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$ChatFormat;", "", "player", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "console", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getPlayer", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getConsole", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
            public static final class ChatFormat {
                @NotNull
                private final MessageData player;
                @NotNull
                private final MessageData console;

                public ChatFormat(@NotNull MessageData player, @NotNull MessageData console) {
                    this.player = player;
                    this.console = console;
                }

                public /* synthetic */ ChatFormat(MessageData messageData, MessageData messageData2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 1) != 0) {
                        messageData = new MessageData(null, null, null, null, null, 31, null);
                    }
                    if ((n & 2) != 0) {
                        messageData2 = new MessageData(null, null, null, null, null, 31, null);
                    }
                    this(messageData, messageData2);
                }

                @NotNull
                public final MessageData getPlayer() {
                    return this.player;
                }

                @NotNull
                public final MessageData getConsole() {
                    return this.console;
                }

                @NotNull
                public final MessageData component1() {
                    return this.player;
                }

                @NotNull
                public final MessageData component2() {
                    return this.console;
                }

                @NotNull
                public final ChatFormat copy(@NotNull MessageData player, @NotNull MessageData console) {
                    return new ChatFormat(player, console);
                }

                public static /* synthetic */ ChatFormat copy$default(ChatFormat chatFormat, MessageData messageData, MessageData messageData2, int n, Object object) {
                    if ((n & 1) != 0) {
                        messageData = chatFormat.player;
                    }
                    if ((n & 2) != 0) {
                        messageData2 = chatFormat.console;
                    }
                    return chatFormat.copy(messageData, messageData2);
                }

                @NotNull
                public String toString() {
                    return "ChatFormat(player=" + this.player + ", console=" + this.console + ")";
                }

                public int hashCode() {
                    int result = this.player.hashCode();
                    result = result * 31 + this.console.hashCode();
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ChatFormat)) {
                        return false;
                    }
                    ChatFormat chatFormat = (ChatFormat)other;
                    if (!Intrinsics.areEqual((Object)this.player, (Object)chatFormat.player)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.console, (Object)chatFormat.console);
                }

                public ChatFormat() {
                    this(null, null, 3, null);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$RangedChat;", "", "enabled", "", "radius", "", "shoutPrefix", "", "shoutFormat", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$ChatFormat;", "<init>", "(ZILjava/lang/String;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$ChatFormat;)V", "getEnabled", "()Z", "getRadius", "()I", "getShoutPrefix", "()Ljava/lang/String;", "getShoutFormat", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Chat$ChatFormat;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "bukkit"})
            public static final class RangedChat {
                private final boolean enabled;
                private final int radius;
                @Comment(value="\n                    Player with `esu.esuchat.chat.shout` permission can use this perfix to bypass ranged chat.\n                    By default, players own this permission.\n                    Use this prefix before prefixedMessageModifiers.\n                ")
                @NotNull
                private final String shoutPrefix;
                @NotNull
                private final ChatFormat shoutFormat;

                public RangedChat(boolean enabled, int radius, @NotNull String shoutPrefix, @NotNull ChatFormat shoutFormat) {
                    this.enabled = enabled;
                    this.radius = radius;
                    this.shoutPrefix = shoutPrefix;
                    this.shoutFormat = shoutFormat;
                }

                public /* synthetic */ RangedChat(boolean bl, int n, String string, ChatFormat chatFormat, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n2 & 1) != 0) {
                        bl = false;
                    }
                    if ((n2 & 2) != 0) {
                        n = 5000;
                    }
                    if ((n2 & 4) != 0) {
                        string = "!";
                    }
                    if ((n2 & 8) != 0) {
                        chatFormat = new ChatFormat(MessageData.Companion.getMessage("\\<<pd:sender>> <pl:shout><message>"), MessageData.Companion.getMessage("<#48c0c0>\\<<pd:sender>> <pl:shout><message>"));
                    }
                    this(bl, n, string, chatFormat);
                }

                public final boolean getEnabled() {
                    return this.enabled;
                }

                public final int getRadius() {
                    return this.radius;
                }

                @NotNull
                public final String getShoutPrefix() {
                    return this.shoutPrefix;
                }

                @NotNull
                public final ChatFormat getShoutFormat() {
                    return this.shoutFormat;
                }

                public final boolean component1() {
                    return this.enabled;
                }

                public final int component2() {
                    return this.radius;
                }

                @NotNull
                public final String component3() {
                    return this.shoutPrefix;
                }

                @NotNull
                public final ChatFormat component4() {
                    return this.shoutFormat;
                }

                @NotNull
                public final RangedChat copy(boolean enabled, int radius, @NotNull String shoutPrefix, @NotNull ChatFormat shoutFormat) {
                    return new RangedChat(enabled, radius, shoutPrefix, shoutFormat);
                }

                public static /* synthetic */ RangedChat copy$default(RangedChat rangedChat, boolean bl, int n, String string, ChatFormat chatFormat, int n2, Object object) {
                    if ((n2 & 1) != 0) {
                        bl = rangedChat.enabled;
                    }
                    if ((n2 & 2) != 0) {
                        n = rangedChat.radius;
                    }
                    if ((n2 & 4) != 0) {
                        string = rangedChat.shoutPrefix;
                    }
                    if ((n2 & 8) != 0) {
                        chatFormat = rangedChat.shoutFormat;
                    }
                    return rangedChat.copy(bl, n, string, chatFormat);
                }

                @NotNull
                public String toString() {
                    return "RangedChat(enabled=" + this.enabled + ", radius=" + this.radius + ", shoutPrefix=" + this.shoutPrefix + ", shoutFormat=" + this.shoutFormat + ")";
                }

                public int hashCode() {
                    int result = Boolean.hashCode(this.enabled);
                    result = result * 31 + Integer.hashCode(this.radius);
                    result = result * 31 + this.shoutPrefix.hashCode();
                    result = result * 31 + this.shoutFormat.hashCode();
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof RangedChat)) {
                        return false;
                    }
                    RangedChat rangedChat = (RangedChat)other;
                    if (this.enabled != rangedChat.enabled) {
                        return false;
                    }
                    if (this.radius != rangedChat.radius) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.shoutPrefix, (Object)rangedChat.shoutPrefix)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.shoutFormat, (Object)rangedChat.shoutFormat);
                }

                public RangedChat() {
                    this(false, 0, null, null, 15, null);
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Emote;", "", "enabled", "", "format", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "interceptNamespaces", "prefixedMessageModifiers", "", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$PrefixedMessageModifier;", "<init>", "(ZLio/github/rothes/esu/core/configuration/data/MessageData;ZLjava/util/List;)V", "getEnabled", "()Z", "getFormat", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getInterceptNamespaces", "getPrefixedMessageModifiers", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class Emote {
            @Comment(value="Enable esu emote/me commands.")
            private final boolean enabled;
            @NotNull
            private final MessageData format;
            @Comment(value="Enabling this will redirect all emote commands to the esu one, to avoid mixing usage.")
            private final boolean interceptNamespaces;
            @NotNull
            private final List<PrefixedMessageModifier> prefixedMessageModifiers;

            public Emote(boolean enabled, @NotNull MessageData format, boolean interceptNamespaces, @NotNull List<PrefixedMessageModifier> prefixedMessageModifiers) {
                this.enabled = enabled;
                this.format = format;
                this.interceptNamespaces = interceptNamespaces;
                this.prefixedMessageModifiers = prefixedMessageModifiers;
            }

            public /* synthetic */ Emote(boolean bl, MessageData messageData, boolean bl2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                if ((n & 2) != 0) {
                    messageData = MessageData.Companion.getMessage("<pl:prefix><pdc><pd:sender></pdc> <message>");
                }
                if ((n & 4) != 0) {
                    bl2 = true;
                }
                if ((n & 8) != 0) {
                    list = CollectionsKt.listOf((Object)new PrefixedMessageModifier("", true, "", "<gray>", "</gray>"));
                }
                this(bl, messageData, bl2, list);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            @NotNull
            public final MessageData getFormat() {
                return this.format;
            }

            public final boolean getInterceptNamespaces() {
                return this.interceptNamespaces;
            }

            @NotNull
            public final List<PrefixedMessageModifier> getPrefixedMessageModifiers() {
                return this.prefixedMessageModifiers;
            }

            public final boolean component1() {
                return this.enabled;
            }

            @NotNull
            public final MessageData component2() {
                return this.format;
            }

            public final boolean component3() {
                return this.interceptNamespaces;
            }

            @NotNull
            public final List<PrefixedMessageModifier> component4() {
                return this.prefixedMessageModifiers;
            }

            @NotNull
            public final Emote copy(boolean enabled, @NotNull MessageData format, boolean interceptNamespaces, @NotNull List<PrefixedMessageModifier> prefixedMessageModifiers) {
                return new Emote(enabled, format, interceptNamespaces, prefixedMessageModifiers);
            }

            public static /* synthetic */ Emote copy$default(Emote emote, boolean bl, MessageData messageData, boolean bl2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = emote.enabled;
                }
                if ((n & 2) != 0) {
                    messageData = emote.format;
                }
                if ((n & 4) != 0) {
                    bl2 = emote.interceptNamespaces;
                }
                if ((n & 8) != 0) {
                    list = emote.prefixedMessageModifiers;
                }
                return emote.copy(bl, messageData, bl2, list);
            }

            @NotNull
            public String toString() {
                return "Emote(enabled=" + this.enabled + ", format=" + this.format + ", interceptNamespaces=" + this.interceptNamespaces + ", prefixedMessageModifiers=" + this.prefixedMessageModifiers + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.enabled);
                result = result * 31 + this.format.hashCode();
                result = result * 31 + Boolean.hashCode(this.interceptNamespaces);
                result = result * 31 + ((Object)this.prefixedMessageModifiers).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Emote)) {
                    return false;
                }
                Emote emote = (Emote)other;
                if (this.enabled != emote.enabled) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.format, (Object)emote.format)) {
                    return false;
                }
                if (this.interceptNamespaces != emote.interceptNamespaces) {
                    return false;
                }
                return Intrinsics.areEqual(this.prefixedMessageModifiers, emote.prefixedMessageModifiers);
            }

            public Emote() {
                this(false, null, false, null, 15, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001d"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$PrefixedMessageModifier;", "", "messagePrefix", "", "removePrefix", "", "permission", "head", "foot", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getMessagePrefix", "()Ljava/lang/String;", "getRemovePrefix", "()Z", "getPermission", "getHead", "getFoot", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "bukkit"})
        public static final class PrefixedMessageModifier {
            @NotNull
            private final String messagePrefix;
            private final boolean removePrefix;
            @Nullable
            private final String permission;
            @NotNull
            private final String head;
            @NotNull
            private final String foot;

            public PrefixedMessageModifier(@NotNull String messagePrefix, boolean removePrefix, @Nullable String permission, @NotNull String head, @NotNull String foot) {
                this.messagePrefix = messagePrefix;
                this.removePrefix = removePrefix;
                this.permission = permission;
                this.head = head;
                this.foot = foot;
            }

            public /* synthetic */ PrefixedMessageModifier(String string, boolean bl, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = "";
                }
                if ((n & 2) != 0) {
                    bl = false;
                }
                if ((n & 4) != 0) {
                    string2 = "";
                }
                if ((n & 8) != 0) {
                    string3 = "";
                }
                if ((n & 0x10) != 0) {
                    string4 = "";
                }
                this(string, bl, string2, string3, string4);
            }

            @NotNull
            public final String getMessagePrefix() {
                return this.messagePrefix;
            }

            public final boolean getRemovePrefix() {
                return this.removePrefix;
            }

            @Nullable
            public final String getPermission() {
                return this.permission;
            }

            @NotNull
            public final String getHead() {
                return this.head;
            }

            @NotNull
            public final String getFoot() {
                return this.foot;
            }

            @NotNull
            public final String component1() {
                return this.messagePrefix;
            }

            public final boolean component2() {
                return this.removePrefix;
            }

            @Nullable
            public final String component3() {
                return this.permission;
            }

            @NotNull
            public final String component4() {
                return this.head;
            }

            @NotNull
            public final String component5() {
                return this.foot;
            }

            @NotNull
            public final PrefixedMessageModifier copy(@NotNull String messagePrefix, boolean removePrefix, @Nullable String permission, @NotNull String head, @NotNull String foot) {
                return new PrefixedMessageModifier(messagePrefix, removePrefix, permission, head, foot);
            }

            public static /* synthetic */ PrefixedMessageModifier copy$default(PrefixedMessageModifier prefixedMessageModifier, String string, boolean bl, String string2, String string3, String string4, int n, Object object) {
                if ((n & 1) != 0) {
                    string = prefixedMessageModifier.messagePrefix;
                }
                if ((n & 2) != 0) {
                    bl = prefixedMessageModifier.removePrefix;
                }
                if ((n & 4) != 0) {
                    string2 = prefixedMessageModifier.permission;
                }
                if ((n & 8) != 0) {
                    string3 = prefixedMessageModifier.head;
                }
                if ((n & 0x10) != 0) {
                    string4 = prefixedMessageModifier.foot;
                }
                return prefixedMessageModifier.copy(string, bl, string2, string3, string4);
            }

            @NotNull
            public String toString() {
                return "PrefixedMessageModifier(messagePrefix=" + this.messagePrefix + ", removePrefix=" + this.removePrefix + ", permission=" + this.permission + ", head=" + this.head + ", foot=" + this.foot + ")";
            }

            public int hashCode() {
                int result = this.messagePrefix.hashCode();
                result = result * 31 + Boolean.hashCode(this.removePrefix);
                result = result * 31 + (this.permission == null ? 0 : this.permission.hashCode());
                result = result * 31 + this.head.hashCode();
                result = result * 31 + this.foot.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PrefixedMessageModifier)) {
                    return false;
                }
                PrefixedMessageModifier prefixedMessageModifier = (PrefixedMessageModifier)other;
                if (!Intrinsics.areEqual((Object)this.messagePrefix, (Object)prefixedMessageModifier.messagePrefix)) {
                    return false;
                }
                if (this.removePrefix != prefixedMessageModifier.removePrefix) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.permission, (Object)prefixedMessageModifier.permission)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.head, (Object)prefixedMessageModifier.head)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.foot, (Object)prefixedMessageModifier.foot);
            }

            public PrefixedMessageModifier() {
                this(null, false, null, null, null, 31, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001eB5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper;", "", "enabled", "", "formats", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper$Formats;", "interceptNamespaces", "prefixedMessageModifiers", "", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$PrefixedMessageModifier;", "<init>", "(ZLio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper$Formats;ZLjava/util/List;)V", "getEnabled", "()Z", "getFormats", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper$Formats;", "getInterceptNamespaces", "getPrefixedMessageModifiers", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Formats", "bukkit"})
        public static final class Whisper {
            @Comment(value="Enable esu whisper commands.")
            private final boolean enabled;
            @NotNull
            private final Formats formats;
            private final boolean interceptNamespaces;
            @NotNull
            private final List<PrefixedMessageModifier> prefixedMessageModifiers;

            public Whisper(boolean enabled, @NotNull Formats formats, boolean interceptNamespaces, @NotNull List<PrefixedMessageModifier> prefixedMessageModifiers) {
                this.enabled = enabled;
                this.formats = formats;
                this.interceptNamespaces = interceptNamespaces;
                this.prefixedMessageModifiers = prefixedMessageModifiers;
            }

            public /* synthetic */ Whisper(boolean bl, Formats formats, boolean bl2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                if ((n & 2) != 0) {
                    formats = new Formats(null, null, null, 7, null);
                }
                if ((n & 4) != 0) {
                    bl2 = true;
                }
                if ((n & 8) != 0) {
                    Object[] objectArray = new PrefixedMessageModifier[]{new PrefixedMessageModifier(">", false, "", "<green>", "</green>"), new PrefixedMessageModifier("*", true, "", "<gradient:#c8b3fd:#4bacc8>", "</gradient>")};
                    list = CollectionsKt.listOf((Object[])objectArray);
                }
                this(bl, formats, bl2, list);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            @NotNull
            public final Formats getFormats() {
                return this.formats;
            }

            public final boolean getInterceptNamespaces() {
                return this.interceptNamespaces;
            }

            @NotNull
            public final List<PrefixedMessageModifier> getPrefixedMessageModifiers() {
                return this.prefixedMessageModifiers;
            }

            public final boolean component1() {
                return this.enabled;
            }

            @NotNull
            public final Formats component2() {
                return this.formats;
            }

            public final boolean component3() {
                return this.interceptNamespaces;
            }

            @NotNull
            public final List<PrefixedMessageModifier> component4() {
                return this.prefixedMessageModifiers;
            }

            @NotNull
            public final Whisper copy(boolean enabled, @NotNull Formats formats, boolean interceptNamespaces, @NotNull List<PrefixedMessageModifier> prefixedMessageModifiers) {
                return new Whisper(enabled, formats, interceptNamespaces, prefixedMessageModifiers);
            }

            public static /* synthetic */ Whisper copy$default(Whisper whisper, boolean bl, Formats formats, boolean bl2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = whisper.enabled;
                }
                if ((n & 2) != 0) {
                    formats = whisper.formats;
                }
                if ((n & 4) != 0) {
                    bl2 = whisper.interceptNamespaces;
                }
                if ((n & 8) != 0) {
                    list = whisper.prefixedMessageModifiers;
                }
                return whisper.copy(bl, formats, bl2, list);
            }

            @NotNull
            public String toString() {
                return "Whisper(enabled=" + this.enabled + ", formats=" + this.formats + ", interceptNamespaces=" + this.interceptNamespaces + ", prefixedMessageModifiers=" + this.prefixedMessageModifiers + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.enabled);
                result = result * 31 + this.formats.hashCode();
                result = result * 31 + Boolean.hashCode(this.interceptNamespaces);
                result = result * 31 + ((Object)this.prefixedMessageModifiers).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Whisper)) {
                    return false;
                }
                Whisper whisper = (Whisper)other;
                if (this.enabled != whisper.enabled) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.formats, (Object)whisper.formats)) {
                    return false;
                }
                if (this.interceptNamespaces != whisper.interceptNamespaces) {
                    return false;
                }
                return Intrinsics.areEqual(this.prefixedMessageModifiers, whisper.prefixedMessageModifiers);
            }

            public Whisper() {
                this(false, null, false, null, 15, null);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0019B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper$Formats;", "", "incoming", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "outgoing", "spy", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper$Formats$Spy;", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper$Formats$Spy;)V", "getIncoming", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getOutgoing", "getSpy", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper$Formats$Spy;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Spy", "bukkit"})
            public static final class Formats {
                @NotNull
                private final MessageData incoming;
                @NotNull
                private final MessageData outgoing;
                @NotNull
                private final Spy spy;

                public Formats(@NotNull MessageData incoming, @NotNull MessageData outgoing, @NotNull Spy spy) {
                    this.incoming = incoming;
                    this.outgoing = outgoing;
                    this.spy = spy;
                }

                public /* synthetic */ Formats(MessageData messageData, MessageData messageData2, Spy spy, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 1) != 0) {
                        messageData = MessageData.Companion.getMessage("<pl:prefix><pdc><pd:sender> <sc>\u27a1 <tdc><message><sound:minecraft:entity.silverfish.ambient:voice:0.2:2:-7007683334921848987>");
                    }
                    if ((n & 2) != 0) {
                        messageData2 = MessageData.Companion.getMessage("<pl:prefix><sc>\u27a1 <pdc><pd:receiver> <tc><message>");
                    }
                    if ((n & 4) != 0) {
                        spy = new Spy(null, null, 3, null);
                    }
                    this(messageData, messageData2, spy);
                }

                @NotNull
                public final MessageData getIncoming() {
                    return this.incoming;
                }

                @NotNull
                public final MessageData getOutgoing() {
                    return this.outgoing;
                }

                @NotNull
                public final Spy getSpy() {
                    return this.spy;
                }

                @NotNull
                public final MessageData component1() {
                    return this.incoming;
                }

                @NotNull
                public final MessageData component2() {
                    return this.outgoing;
                }

                @NotNull
                public final Spy component3() {
                    return this.spy;
                }

                @NotNull
                public final Formats copy(@NotNull MessageData incoming, @NotNull MessageData outgoing, @NotNull Spy spy) {
                    return new Formats(incoming, outgoing, spy);
                }

                public static /* synthetic */ Formats copy$default(Formats formats, MessageData messageData, MessageData messageData2, Spy spy, int n, Object object) {
                    if ((n & 1) != 0) {
                        messageData = formats.incoming;
                    }
                    if ((n & 2) != 0) {
                        messageData2 = formats.outgoing;
                    }
                    if ((n & 4) != 0) {
                        spy = formats.spy;
                    }
                    return formats.copy(messageData, messageData2, spy);
                }

                @NotNull
                public String toString() {
                    return "Formats(incoming=" + this.incoming + ", outgoing=" + this.outgoing + ", spy=" + this.spy + ")";
                }

                public int hashCode() {
                    int result = this.incoming.hashCode();
                    result = result * 31 + this.outgoing.hashCode();
                    result = result * 31 + this.spy.hashCode();
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Formats)) {
                        return false;
                    }
                    Formats formats = (Formats)other;
                    if (!Intrinsics.areEqual((Object)this.incoming, (Object)formats.incoming)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.outgoing, (Object)formats.outgoing)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.spy, (Object)formats.spy);
                }

                public Formats() {
                    this(null, null, null, 7, null);
                }

                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleConfig$Whisper$Formats$Spy;", "", "send", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "reply", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getSend", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getReply", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
                public static final class Spy {
                    @NotNull
                    private final MessageData send;
                    @NotNull
                    private final MessageData reply;

                    public Spy(@NotNull MessageData send, @NotNull MessageData reply) {
                        this.send = send;
                        this.reply = reply;
                    }

                    public /* synthetic */ Spy(MessageData messageData, MessageData messageData2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                        if ((n & 1) != 0) {
                            messageData = MessageData.Companion.getMessage("<pl:prefix><pc>[<pdc><pd:sender> <sdc>\u27a1 <tdc><pd:receiver><pc>] <tc><message>");
                        }
                        if ((n & 2) != 0) {
                            messageData2 = MessageData.Companion.getMessage("<pl:prefix><pc>[<tdc><pd:receiver> <sc>\u2b05 <pdc><pd:sender><pc>] <tdc><message>");
                        }
                        this(messageData, messageData2);
                    }

                    @NotNull
                    public final MessageData getSend() {
                        return this.send;
                    }

                    @NotNull
                    public final MessageData getReply() {
                        return this.reply;
                    }

                    @NotNull
                    public final MessageData component1() {
                        return this.send;
                    }

                    @NotNull
                    public final MessageData component2() {
                        return this.reply;
                    }

                    @NotNull
                    public final Spy copy(@NotNull MessageData send, @NotNull MessageData reply) {
                        return new Spy(send, reply);
                    }

                    public static /* synthetic */ Spy copy$default(Spy spy, MessageData messageData, MessageData messageData2, int n, Object object) {
                        if ((n & 1) != 0) {
                            messageData = spy.send;
                        }
                        if ((n & 2) != 0) {
                            messageData2 = spy.reply;
                        }
                        return spy.copy(messageData, messageData2);
                    }

                    @NotNull
                    public String toString() {
                        return "Spy(send=" + this.send + ", reply=" + this.reply + ")";
                    }

                    public int hashCode() {
                        int result = this.send.hashCode();
                        result = result * 31 + this.reply.hashCode();
                        return result;
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof Spy)) {
                            return false;
                        }
                        Spy spy = (Spy)other;
                        if (!Intrinsics.areEqual((Object)this.send, (Object)spy.send)) {
                            return false;
                        }
                        return Intrinsics.areEqual((Object)this.reply, (Object)spy.reply);
                    }

                    public Spy() {
                        this(null, null, 3, null);
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001:\u0004%&'(B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "playerDisplay", "", "chat", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Chat;", "emote", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Emote;", "whisper", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Whisper;", "ignore", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Ignore;", "<init>", "(Ljava/lang/String;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Chat;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Emote;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Whisper;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Ignore;)V", "getPlayerDisplay", "()Ljava/lang/String;", "getChat", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Chat;", "getEmote", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Emote;", "getWhisper", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Whisper;", "getIgnore", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Ignore;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Chat", "Emote", "Whisper", "Ignore", "bukkit"})
    public static final class ModuleLang
    implements ConfigurationPart {
        @Comment(value="This is being used with <pd:player_key>.")
        @NotNull
        private final String playerDisplay;
        @NotNull
        private final Chat chat;
        @NotNull
        private final Emote emote;
        @NotNull
        private final Whisper whisper;
        @NotNull
        private final Ignore ignore;

        public ModuleLang(@NotNull String playerDisplay, @NotNull Chat chat, @NotNull Emote emote, @NotNull Whisper whisper, @NotNull Ignore ignore) {
            this.playerDisplay = playerDisplay;
            this.chat = chat;
            this.emote = emote;
            this.whisper = whisper;
            this.ignore = ignore;
        }

        public /* synthetic */ ModuleLang(String string, Chat chat, Emote emote, Whisper whisper, Ignore ignore, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "<hover:show_text:'<pc>Click to whisper <pdc><player_key>'><click:suggest_command:/m <player_key_name> ><player_key></hover>";
            }
            if ((n & 2) != 0) {
                chat = new Chat(null, 1, null);
            }
            if ((n & 4) != 0) {
                emote = new Emote(null, 1, null);
            }
            if ((n & 8) != 0) {
                whisper = new Whisper(null, null, null, null, 15, null);
            }
            if ((n & 0x10) != 0) {
                ignore = new Ignore(null, null, null, 7, null);
            }
            this(string, chat, emote, whisper, ignore);
        }

        @NotNull
        public final String getPlayerDisplay() {
            return this.playerDisplay;
        }

        @NotNull
        public final Chat getChat() {
            return this.chat;
        }

        @NotNull
        public final Emote getEmote() {
            return this.emote;
        }

        @NotNull
        public final Whisper getWhisper() {
            return this.whisper;
        }

        @NotNull
        public final Ignore getIgnore() {
            return this.ignore;
        }

        @NotNull
        public final String component1() {
            return this.playerDisplay;
        }

        @NotNull
        public final Chat component2() {
            return this.chat;
        }

        @NotNull
        public final Emote component3() {
            return this.emote;
        }

        @NotNull
        public final Whisper component4() {
            return this.whisper;
        }

        @NotNull
        public final Ignore component5() {
            return this.ignore;
        }

        @NotNull
        public final ModuleLang copy(@NotNull String playerDisplay, @NotNull Chat chat, @NotNull Emote emote, @NotNull Whisper whisper, @NotNull Ignore ignore) {
            return new ModuleLang(playerDisplay, chat, emote, whisper, ignore);
        }

        public static /* synthetic */ ModuleLang copy$default(ModuleLang moduleLang, String string, Chat chat, Emote emote, Whisper whisper, Ignore ignore, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleLang.playerDisplay;
            }
            if ((n & 2) != 0) {
                chat = moduleLang.chat;
            }
            if ((n & 4) != 0) {
                emote = moduleLang.emote;
            }
            if ((n & 8) != 0) {
                whisper = moduleLang.whisper;
            }
            if ((n & 0x10) != 0) {
                ignore = moduleLang.ignore;
            }
            return moduleLang.copy(string, chat, emote, whisper, ignore);
        }

        @NotNull
        public String toString() {
            return "ModuleLang(playerDisplay=" + this.playerDisplay + ", chat=" + this.chat + ", emote=" + this.emote + ", whisper=" + this.whisper + ", ignore=" + this.ignore + ")";
        }

        public int hashCode() {
            int result = this.playerDisplay.hashCode();
            result = result * 31 + this.chat.hashCode();
            result = result * 31 + this.emote.hashCode();
            result = result * 31 + this.whisper.hashCode();
            result = result * 31 + this.ignore.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleLang)) {
                return false;
            }
            ModuleLang moduleLang = (ModuleLang)other;
            if (!Intrinsics.areEqual((Object)this.playerDisplay, (Object)moduleLang.playerDisplay)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.chat, (Object)moduleLang.chat)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.emote, (Object)moduleLang.emote)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.whisper, (Object)moduleLang.whisper)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ignore, (Object)moduleLang.ignore);
        }

        public ModuleLang() {
            this(null, null, null, null, null, 31, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Chat;", "", "placeholders", "", "", "<init>", "(Ljava/util/Map;)V", "getPlaceholders", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "bukkit"})
        public static final class Chat {
            @NotNull
            private final Map<String, String> placeholders;

            public Chat(@NotNull Map<String, String> placeholders) {
                this.placeholders = placeholders;
            }

            public /* synthetic */ Chat(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"shout", (Object)"<pc><hover:show_text:'<pc>Shout chat message'>\ud83d\udce3 </hover>"));
                }
                this(map);
            }

            @NotNull
            public final Map<String, String> getPlaceholders() {
                return this.placeholders;
            }

            @NotNull
            public final Map<String, String> component1() {
                return this.placeholders;
            }

            @NotNull
            public final Chat copy(@NotNull Map<String, String> placeholders) {
                return new Chat(placeholders);
            }

            public static /* synthetic */ Chat copy$default(Chat chat, Map map, int n, Object object) {
                if ((n & 1) != 0) {
                    map = chat.placeholders;
                }
                return chat.copy(map);
            }

            @NotNull
            public String toString() {
                return "Chat(placeholders=" + this.placeholders + ")";
            }

            public int hashCode() {
                return ((Object)this.placeholders).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Chat)) {
                    return false;
                }
                Chat chat = (Chat)other;
                return Intrinsics.areEqual(this.placeholders, chat.placeholders);
            }

            public Chat() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Emote;", "", "placeholders", "", "", "<init>", "(Ljava/util/Map;)V", "getPlaceholders", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "bukkit"})
        public static final class Emote {
            @NotNull
            private final Map<String, String> placeholders;

            public Emote(@NotNull Map<String, String> placeholders) {
                this.placeholders = placeholders;
            }

            public /* synthetic */ Emote(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"prefix", (Object)"<pc><hover:show_text:'<pc>Emote message'>* </hover>"));
                }
                this(map);
            }

            @NotNull
            public final Map<String, String> getPlaceholders() {
                return this.placeholders;
            }

            @NotNull
            public final Map<String, String> component1() {
                return this.placeholders;
            }

            @NotNull
            public final Emote copy(@NotNull Map<String, String> placeholders) {
                return new Emote(placeholders);
            }

            public static /* synthetic */ Emote copy$default(Emote emote, Map map, int n, Object object) {
                if ((n & 1) != 0) {
                    map = emote.placeholders;
                }
                return emote.copy(map);
            }

            @NotNull
            public String toString() {
                return "Emote(placeholders=" + this.placeholders + ")";
            }

            public int hashCode() {
                return ((Object)this.placeholders).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Emote)) {
                    return false;
                }
                Emote emote = (Emote)other;
                return Intrinsics.areEqual(this.placeholders, emote.placeholders);
            }

            public Emote() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Ignore;", "", "placeholders", "", "", "ignoringPlayer", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "receivingPlayer", "<init>", "(Ljava/util/Map;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getPlaceholders", "()Ljava/util/Map;", "getIgnoringPlayer", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getReceivingPlayer", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "bukkit"})
        public static final class Ignore {
            @NotNull
            private final Map<String, String> placeholders;
            @NotNull
            private final MessageData ignoringPlayer;
            @NotNull
            private final MessageData receivingPlayer;

            public Ignore(@NotNull Map<String, String> placeholders, @NotNull MessageData ignoringPlayer, @NotNull MessageData receivingPlayer) {
                this.placeholders = placeholders;
                this.ignoringPlayer = ignoringPlayer;
                this.receivingPlayer = receivingPlayer;
            }

            public /* synthetic */ Ignore(Map map, MessageData messageData, MessageData messageData2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"prefix", (Object)"<sc>[<sdc>Ignore<sc>] "));
                }
                if ((n & 2) != 0) {
                    messageData = MessageData.Companion.getMessage("<pl:prefix><nc>You are now <vnc>ignoring</vnc> <pdc><player></pdc>.");
                }
                if ((n & 4) != 0) {
                    messageData2 = MessageData.Companion.getMessage("<pl:prefix><pc>You are now <vpc>receiving</vpc> <pdc><player></pdc>.");
                }
                this(map, messageData, messageData2);
            }

            @NotNull
            public final Map<String, String> getPlaceholders() {
                return this.placeholders;
            }

            @NotNull
            public final MessageData getIgnoringPlayer() {
                return this.ignoringPlayer;
            }

            @NotNull
            public final MessageData getReceivingPlayer() {
                return this.receivingPlayer;
            }

            @NotNull
            public final Map<String, String> component1() {
                return this.placeholders;
            }

            @NotNull
            public final MessageData component2() {
                return this.ignoringPlayer;
            }

            @NotNull
            public final MessageData component3() {
                return this.receivingPlayer;
            }

            @NotNull
            public final Ignore copy(@NotNull Map<String, String> placeholders, @NotNull MessageData ignoringPlayer, @NotNull MessageData receivingPlayer) {
                return new Ignore(placeholders, ignoringPlayer, receivingPlayer);
            }

            public static /* synthetic */ Ignore copy$default(Ignore ignore, Map map, MessageData messageData, MessageData messageData2, int n, Object object) {
                if ((n & 1) != 0) {
                    map = ignore.placeholders;
                }
                if ((n & 2) != 0) {
                    messageData = ignore.ignoringPlayer;
                }
                if ((n & 4) != 0) {
                    messageData2 = ignore.receivingPlayer;
                }
                return ignore.copy(map, messageData, messageData2);
            }

            @NotNull
            public String toString() {
                return "Ignore(placeholders=" + this.placeholders + ", ignoringPlayer=" + this.ignoringPlayer + ", receivingPlayer=" + this.receivingPlayer + ")";
            }

            public int hashCode() {
                int result = ((Object)this.placeholders).hashCode();
                result = result * 31 + this.ignoringPlayer.hashCode();
                result = result * 31 + this.receivingPlayer.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Ignore)) {
                    return false;
                }
                Ignore ignore = (Ignore)other;
                if (!Intrinsics.areEqual(this.placeholders, ignore.placeholders)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.ignoringPlayer, (Object)ignore.ignoringPlayer)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.receivingPlayer, (Object)ignore.receivingPlayer);
            }

            public Ignore() {
                this(null, null, null, 7, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001eB;\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J=\u0010\u0017\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Whisper;", "", "placeholders", "", "", "replyNoLastTarget", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "receiverOffline", "spy", "Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Whisper$Spy;", "<init>", "(Ljava/util/Map;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Whisper$Spy;)V", "getPlaceholders", "()Ljava/util/Map;", "getReplyNoLastTarget", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getReceiverOffline", "getSpy", "()Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Whisper$Spy;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Spy", "bukkit"})
        public static final class Whisper {
            @NotNull
            private final Map<String, String> placeholders;
            @NotNull
            private final MessageData replyNoLastTarget;
            @NotNull
            private final MessageData receiverOffline;
            @NotNull
            private final Spy spy;

            public Whisper(@NotNull Map<String, String> placeholders, @NotNull MessageData replyNoLastTarget, @NotNull MessageData receiverOffline, @NotNull Spy spy) {
                this.placeholders = placeholders;
                this.replyNoLastTarget = replyNoLastTarget;
                this.receiverOffline = receiverOffline;
                this.spy = spy;
            }

            public /* synthetic */ Whisper(Map map, MessageData messageData, MessageData messageData2, Spy spy, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"prefix", (Object)"<sdc><hover:show_text:'<pc>Whisper channel'>\ud83d\udce8 </hover>"));
                }
                if ((n & 2) != 0) {
                    messageData = MessageData.Companion.getMessage("<ec>There's no last direct message target.");
                }
                if ((n & 4) != 0) {
                    messageData2 = MessageData.Companion.getMessage("<ec>The receiver is not online.");
                }
                if ((n & 8) != 0) {
                    spy = new Spy(null, null, null, null, null, 31, null);
                }
                this(map, messageData, messageData2, spy);
            }

            @NotNull
            public final Map<String, String> getPlaceholders() {
                return this.placeholders;
            }

            @NotNull
            public final MessageData getReplyNoLastTarget() {
                return this.replyNoLastTarget;
            }

            @NotNull
            public final MessageData getReceiverOffline() {
                return this.receiverOffline;
            }

            @NotNull
            public final Spy getSpy() {
                return this.spy;
            }

            @NotNull
            public final Map<String, String> component1() {
                return this.placeholders;
            }

            @NotNull
            public final MessageData component2() {
                return this.replyNoLastTarget;
            }

            @NotNull
            public final MessageData component3() {
                return this.receiverOffline;
            }

            @NotNull
            public final Spy component4() {
                return this.spy;
            }

            @NotNull
            public final Whisper copy(@NotNull Map<String, String> placeholders, @NotNull MessageData replyNoLastTarget, @NotNull MessageData receiverOffline, @NotNull Spy spy) {
                return new Whisper(placeholders, replyNoLastTarget, receiverOffline, spy);
            }

            public static /* synthetic */ Whisper copy$default(Whisper whisper, Map map, MessageData messageData, MessageData messageData2, Spy spy, int n, Object object) {
                if ((n & 1) != 0) {
                    map = whisper.placeholders;
                }
                if ((n & 2) != 0) {
                    messageData = whisper.replyNoLastTarget;
                }
                if ((n & 4) != 0) {
                    messageData2 = whisper.receiverOffline;
                }
                if ((n & 8) != 0) {
                    spy = whisper.spy;
                }
                return whisper.copy(map, messageData, messageData2, spy);
            }

            @NotNull
            public String toString() {
                return "Whisper(placeholders=" + this.placeholders + ", replyNoLastTarget=" + this.replyNoLastTarget + ", receiverOffline=" + this.receiverOffline + ", spy=" + this.spy + ")";
            }

            public int hashCode() {
                int result = ((Object)this.placeholders).hashCode();
                result = result * 31 + this.replyNoLastTarget.hashCode();
                result = result * 31 + this.receiverOffline.hashCode();
                result = result * 31 + this.spy.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Whisper)) {
                    return false;
                }
                Whisper whisper = (Whisper)other;
                if (!Intrinsics.areEqual(this.placeholders, whisper.placeholders)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.replyNoLastTarget, (Object)whisper.replyNoLastTarget)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.receiverOffline, (Object)whisper.receiverOffline)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.spy, (Object)whisper.spy);
            }

            public Whisper() {
                this(null, null, null, null, 15, null);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003JG\u0010\u0018\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lio/github/rothes/esu/bukkit/module/EsuChatModule$ModuleLang$Whisper$Spy;", "", "placeholders", "", "", "enabled", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "disabled", "alreadyEnabled", "alreadyDisabled", "<init>", "(Ljava/util/Map;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getPlaceholders", "()Ljava/util/Map;", "getEnabled", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getDisabled", "getAlreadyEnabled", "getAlreadyDisabled", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "bukkit"})
            public static final class Spy {
                @NotNull
                private final Map<String, String> placeholders;
                @NotNull
                private final MessageData enabled;
                @NotNull
                private final MessageData disabled;
                @NotNull
                private final MessageData alreadyEnabled;
                @NotNull
                private final MessageData alreadyDisabled;

                public Spy(@NotNull Map<String, String> placeholders, @NotNull MessageData enabled, @NotNull MessageData disabled, @NotNull MessageData alreadyEnabled, @NotNull MessageData alreadyDisabled) {
                    this.placeholders = placeholders;
                    this.enabled = enabled;
                    this.disabled = disabled;
                    this.alreadyEnabled = alreadyEnabled;
                    this.alreadyDisabled = alreadyDisabled;
                }

                public /* synthetic */ Spy(Map map, MessageData messageData, MessageData messageData2, MessageData messageData3, MessageData messageData4, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 1) != 0) {
                        map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"prefix", (Object)"<sc>[<sdc>SPY<sc>] "));
                    }
                    if ((n & 2) != 0) {
                        messageData = MessageData.Companion.getMessage("<pl:prefix><pdc><capitalize:'<enable-state>'> <pc>spy for <pdc><user></pdc>.");
                    }
                    if ((n & 4) != 0) {
                        messageData2 = MessageData.Companion.getMessage("<pl:prefix><pdc><capitalize:'<enable-state>'> <pc>spy for <pdc><user></pdc>.");
                    }
                    if ((n & 8) != 0) {
                        messageData3 = MessageData.Companion.getMessage("<pl:prefix><edc><user> <ec>has already enabled spy.");
                    }
                    if ((n & 0x10) != 0) {
                        messageData4 = MessageData.Companion.getMessage("<pl:prefix><edc><user> <ec>has already disabled spy.");
                    }
                    this(map, messageData, messageData2, messageData3, messageData4);
                }

                @NotNull
                public final Map<String, String> getPlaceholders() {
                    return this.placeholders;
                }

                @NotNull
                public final MessageData getEnabled() {
                    return this.enabled;
                }

                @NotNull
                public final MessageData getDisabled() {
                    return this.disabled;
                }

                @NotNull
                public final MessageData getAlreadyEnabled() {
                    return this.alreadyEnabled;
                }

                @NotNull
                public final MessageData getAlreadyDisabled() {
                    return this.alreadyDisabled;
                }

                @NotNull
                public final Map<String, String> component1() {
                    return this.placeholders;
                }

                @NotNull
                public final MessageData component2() {
                    return this.enabled;
                }

                @NotNull
                public final MessageData component3() {
                    return this.disabled;
                }

                @NotNull
                public final MessageData component4() {
                    return this.alreadyEnabled;
                }

                @NotNull
                public final MessageData component5() {
                    return this.alreadyDisabled;
                }

                @NotNull
                public final Spy copy(@NotNull Map<String, String> placeholders, @NotNull MessageData enabled, @NotNull MessageData disabled, @NotNull MessageData alreadyEnabled, @NotNull MessageData alreadyDisabled) {
                    return new Spy(placeholders, enabled, disabled, alreadyEnabled, alreadyDisabled);
                }

                public static /* synthetic */ Spy copy$default(Spy spy, Map map, MessageData messageData, MessageData messageData2, MessageData messageData3, MessageData messageData4, int n, Object object) {
                    if ((n & 1) != 0) {
                        map = spy.placeholders;
                    }
                    if ((n & 2) != 0) {
                        messageData = spy.enabled;
                    }
                    if ((n & 4) != 0) {
                        messageData2 = spy.disabled;
                    }
                    if ((n & 8) != 0) {
                        messageData3 = spy.alreadyEnabled;
                    }
                    if ((n & 0x10) != 0) {
                        messageData4 = spy.alreadyDisabled;
                    }
                    return spy.copy(map, messageData, messageData2, messageData3, messageData4);
                }

                @NotNull
                public String toString() {
                    return "Spy(placeholders=" + this.placeholders + ", enabled=" + this.enabled + ", disabled=" + this.disabled + ", alreadyEnabled=" + this.alreadyEnabled + ", alreadyDisabled=" + this.alreadyDisabled + ")";
                }

                public int hashCode() {
                    int result = ((Object)this.placeholders).hashCode();
                    result = result * 31 + this.enabled.hashCode();
                    result = result * 31 + this.disabled.hashCode();
                    result = result * 31 + this.alreadyEnabled.hashCode();
                    result = result * 31 + this.alreadyDisabled.hashCode();
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Spy)) {
                        return false;
                    }
                    Spy spy = (Spy)other;
                    if (!Intrinsics.areEqual(this.placeholders, spy.placeholders)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.enabled, (Object)spy.enabled)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.disabled, (Object)spy.disabled)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.alreadyEnabled, (Object)spy.alreadyEnabled)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.alreadyDisabled, (Object)spy.alreadyDisabled);
                }

                public Spy() {
                    this(null, null, null, null, null, 31, null);
                }
            }
        }
    }
}

