/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.config;

import io.github.rothes.esu.core.EsuCore;
import io.github.rothes.esu.core.configuration.ConfigLoader;
import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.configuration.meta.RemovedNode;
import io.github.rothes.esu.core.util.NetworkUtils;
import io.github.rothes.esu.lib.org.spongepowered.configurate.objectmapping.meta.PostProcess;
import io.github.rothes.esu.lib.org.spongepowered.configurate.objectmapping.meta.Setting;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000bH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/core/config/EsuConfig;", "", "<init>", "()V", "initialized", "", "getInitialized$core", "()Z", "setInitialized$core", "(Z)V", "data", "Lio/github/rothes/esu/core/config/EsuConfig$ConfigData;", "get", "reloadConfig", "", "load", "ConfigData", "core"})
@SourceDebugExtension(value={"SMAP\nEsuConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EsuConfig.kt\nio/github/rothes/esu/core/config/EsuConfig\n+ 2 ConfigLoader.kt\nio/github/rothes/esu/core/configuration/ConfigLoader\n*L\n1#1,173:1\n159#2:174\n*S KotlinDebug\n*F\n+ 1 EsuConfig.kt\nio/github/rothes/esu/core/config/EsuConfig\n*L\n39#1:174\n*E\n"})
public final class EsuConfig {
    @NotNull
    public static final EsuConfig INSTANCE = new EsuConfig();
    private static boolean initialized;
    private static ConfigData data;

    private EsuConfig() {
    }

    public final boolean getInitialized$core() {
        return initialized;
    }

    public final void setInitialized$core(boolean bl) {
        initialized = bl;
    }

    @NotNull
    public final ConfigData get() {
        ConfigData configData = data;
        if (configData == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData = null;
        }
        return configData;
    }

    public final void reloadConfig() {
        data = this.load();
        initialized = true;
        ConfigData configData = data;
        if (configData == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData = null;
        }
        URLConnection.setDefaultUseCaches("jar", !configData.getDisableJarFileCache());
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigData load() {
        void this_$iv;
        ConfigLoader configLoader = ConfigLoader.INSTANCE;
        Path path$iv = EsuCore.Companion.getInstance().baseConfigPath().resolve("config.yml");
        boolean $i$f$load = false;
        return this_$iv.loadSimple(path$iv, ConfigData.class);
    }

    static {
        URLConnection.setDefaultUseCaches("jar", false);
        INSTANCE.reloadConfig();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 42\u00020\u0001:\u0003456Bg\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\"\u001a\u00020#H\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010(\u001a\u00020\u000bH\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u000eH\u00c2\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003Ji\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010.\u001a\u00020\u00052\b\u0010/\u001a\u0004\u0018\u000100H\u00d6\u0003J\t\u00101\u001a\u000202H\u00d6\u0001J\t\u00103\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0016\u0010\u0010\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\u001f\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00067"}, d2={"Lio/github/rothes/esu/core/config/EsuConfig$ConfigData;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "locale", "", "forceTrueColorConsole", "", "legacyColorChar", "localeSoftLinkPath", "Ljava/util/Optional;", "Ljava/nio/file/Path;", "database", "Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$Database;", "defaultColorScheme", "mavenRepoInternal", "Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$MavenRepo;", "updateChecker", "disableJarFileCache", "<init>", "(Ljava/lang/String;ZZLjava/util/Optional;Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$Database;Ljava/lang/String;Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$MavenRepo;ZZ)V", "getLocale", "()Ljava/lang/String;", "getForceTrueColorConsole", "()Z", "getLegacyColorChar", "getLocaleSoftLinkPath", "()Ljava/util/Optional;", "getDatabase", "()Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$Database;", "getDefaultColorScheme", "getUpdateChecker", "getDisableJarFileCache", "mavenRepo", "getMavenRepo", "()Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$MavenRepo;", "postProcess", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "MavenRepo", "Database", "core"})
    public static final class ConfigData
    implements ConfigurationPart {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String locale;
        @Comment(value="\n            Enable this will force to print TrueColor messages in console. This would provide a pretty look.\n            Disable this, or change your terminal software if you see weird chars in console.\n        ")
        private final boolean forceTrueColorConsole;
        @Comment(value="\n            By setting this to true, you can enable legacy color char support.\n            You will able to use `&` char to set color/formats.\n        ")
        private final boolean legacyColorChar;
        @Comment(value="\n            Automatically create soft link for locale directories.\n            You can specify the path to ESU plugin directory from another server.\n            Example: /home/user/server/plugins/ESU\n        ")
        @NotNull
        private final Optional<Path> localeSoftLinkPath;
        @NotNull
        private final Database database;
        @NotNull
        private final String defaultColorScheme;
        @Setting(value="maven-repository")
        @Comment(value="\n            The Maven repository to download dependencies from. Do not set if you don't know about it.\n            Delete or set to null will re-run the latency test, and select the best automatically.\n        ")
        @NotNull
        private MavenRepo mavenRepoInternal;
        private final boolean updateChecker;
        @Comment(value="\n            Set this to true will disable caching reading files in jars. This is globally in jvm.\n            If you frequently hot-update plugins, setting this to true will reduce errors,\n             but may reduce performance in some specific scenarios.\n        ")
        private final boolean disableJarFileCache;

        public ConfigData(@NotNull String locale, boolean forceTrueColorConsole, boolean legacyColorChar, @NotNull Optional<Path> localeSoftLinkPath, @NotNull Database database, @NotNull String defaultColorScheme, @NotNull MavenRepo mavenRepoInternal, boolean updateChecker, boolean disableJarFileCache) {
            this.locale = locale;
            this.forceTrueColorConsole = forceTrueColorConsole;
            this.legacyColorChar = legacyColorChar;
            this.localeSoftLinkPath = localeSoftLinkPath;
            this.database = database;
            this.defaultColorScheme = defaultColorScheme;
            this.mavenRepoInternal = mavenRepoInternal;
            this.updateChecker = updateChecker;
            this.disableJarFileCache = disableJarFileCache;
        }

        public /* synthetic */ ConfigData(String object, boolean bl, boolean bl2, Optional optional, Database database, String string, MavenRepo mavenRepo, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                String string2 = Locale.getDefault().getLanguage();
                String string3 = Locale.getDefault().getCountry().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                object = string2 + "_" + string3;
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                optional = Optional.empty();
            }
            if ((n & 0x10) != 0) {
                database = new Database(null, null, 0, null, null, null, 63, null);
            }
            if ((n & 0x20) != 0) {
                string = "amethyst";
            }
            if ((n & 0x40) != 0) {
                mavenRepo = new MavenRepo(null, null, 3, null);
            }
            if ((n & 0x80) != 0) {
                bl3 = true;
            }
            if ((n & 0x100) != 0) {
                bl4 = false;
            }
            this((String)object, bl, bl2, optional, database, string, mavenRepo, bl3, bl4);
        }

        @NotNull
        public final String getLocale() {
            return this.locale;
        }

        public final boolean getForceTrueColorConsole() {
            return this.forceTrueColorConsole;
        }

        public final boolean getLegacyColorChar() {
            return this.legacyColorChar;
        }

        @NotNull
        public final Optional<Path> getLocaleSoftLinkPath() {
            return this.localeSoftLinkPath;
        }

        @NotNull
        public final Database getDatabase() {
            return this.database;
        }

        @NotNull
        public final String getDefaultColorScheme() {
            return this.defaultColorScheme;
        }

        public final boolean getUpdateChecker() {
            return this.updateChecker;
        }

        public final boolean getDisableJarFileCache() {
            return this.disableJarFileCache;
        }

        @NotNull
        public final MavenRepo getMavenRepo() {
            return this.mavenRepoInternal;
        }

        @PostProcess
        private final void postProcess() {
            if (((CharSequence)this.getMavenRepo().getId()).length() == 0 || ((CharSequence)this.getMavenRepo().getUrl()).length() == 0) {
                this.mavenRepoInternal = Companion.findBestMavenRepo();
            }
        }

        @NotNull
        public final String component1() {
            return this.locale;
        }

        public final boolean component2() {
            return this.forceTrueColorConsole;
        }

        public final boolean component3() {
            return this.legacyColorChar;
        }

        @NotNull
        public final Optional<Path> component4() {
            return this.localeSoftLinkPath;
        }

        @NotNull
        public final Database component5() {
            return this.database;
        }

        @NotNull
        public final String component6() {
            return this.defaultColorScheme;
        }

        private final MavenRepo component7() {
            return this.mavenRepoInternal;
        }

        public final boolean component8() {
            return this.updateChecker;
        }

        public final boolean component9() {
            return this.disableJarFileCache;
        }

        @NotNull
        public final ConfigData copy(@NotNull String locale, boolean forceTrueColorConsole, boolean legacyColorChar, @NotNull Optional<Path> localeSoftLinkPath, @NotNull Database database, @NotNull String defaultColorScheme, @NotNull MavenRepo mavenRepoInternal, boolean updateChecker, boolean disableJarFileCache) {
            return new ConfigData(locale, forceTrueColorConsole, legacyColorChar, localeSoftLinkPath, database, defaultColorScheme, mavenRepoInternal, updateChecker, disableJarFileCache);
        }

        public static /* synthetic */ ConfigData copy$default(ConfigData configData, String string, boolean bl, boolean bl2, Optional optional, Database database, String string2, MavenRepo mavenRepo, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                string = configData.locale;
            }
            if ((n & 2) != 0) {
                bl = configData.forceTrueColorConsole;
            }
            if ((n & 4) != 0) {
                bl2 = configData.legacyColorChar;
            }
            if ((n & 8) != 0) {
                optional = configData.localeSoftLinkPath;
            }
            if ((n & 0x10) != 0) {
                database = configData.database;
            }
            if ((n & 0x20) != 0) {
                string2 = configData.defaultColorScheme;
            }
            if ((n & 0x40) != 0) {
                mavenRepo = configData.mavenRepoInternal;
            }
            if ((n & 0x80) != 0) {
                bl3 = configData.updateChecker;
            }
            if ((n & 0x100) != 0) {
                bl4 = configData.disableJarFileCache;
            }
            return configData.copy(string, bl, bl2, optional, database, string2, mavenRepo, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "ConfigData(locale=" + this.locale + ", forceTrueColorConsole=" + this.forceTrueColorConsole + ", legacyColorChar=" + this.legacyColorChar + ", localeSoftLinkPath=" + this.localeSoftLinkPath + ", database=" + this.database + ", defaultColorScheme=" + this.defaultColorScheme + ", mavenRepoInternal=" + this.mavenRepoInternal + ", updateChecker=" + this.updateChecker + ", disableJarFileCache=" + this.disableJarFileCache + ")";
        }

        public int hashCode() {
            int result = this.locale.hashCode();
            result = result * 31 + Boolean.hashCode(this.forceTrueColorConsole);
            result = result * 31 + Boolean.hashCode(this.legacyColorChar);
            result = result * 31 + this.localeSoftLinkPath.hashCode();
            result = result * 31 + this.database.hashCode();
            result = result * 31 + this.defaultColorScheme.hashCode();
            result = result * 31 + this.mavenRepoInternal.hashCode();
            result = result * 31 + Boolean.hashCode(this.updateChecker);
            result = result * 31 + Boolean.hashCode(this.disableJarFileCache);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfigData)) {
                return false;
            }
            ConfigData configData = (ConfigData)other;
            if (!Intrinsics.areEqual(this.locale, configData.locale)) {
                return false;
            }
            if (this.forceTrueColorConsole != configData.forceTrueColorConsole) {
                return false;
            }
            if (this.legacyColorChar != configData.legacyColorChar) {
                return false;
            }
            if (!Intrinsics.areEqual(this.localeSoftLinkPath, configData.localeSoftLinkPath)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.database, configData.database)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.defaultColorScheme, configData.defaultColorScheme)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.mavenRepoInternal, configData.mavenRepoInternal)) {
                return false;
            }
            if (this.updateChecker != configData.updateChecker) {
                return false;
            }
            return this.disableJarFileCache == configData.disableJarFileCache;
        }

        public ConfigData() {
            this(null, false, false, null, null, null, null, false, false, 511, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$Companion;", "", "<init>", "()V", "findBestMavenRepo", "Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$MavenRepo;", "core"})
        @SourceDebugExtension(value={"SMAP\nEsuConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EsuConfig.kt\nio/github/rothes/esu/core/config/EsuConfig$ConfigData$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1563#2:174\n1634#2,3:175\n1056#2:178\n*S KotlinDebug\n*F\n+ 1 EsuConfig.kt\nio/github/rothes/esu/core/config/EsuConfig$ConfigData$Companion\n*L\n95#1:174\n95#1:175,3\n97#1:178\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MavenRepo findBestMavenRepo() {
                Iterator<Pair> $this$sortedBy$iv;
                void $this$mapTo$iv$iv;
                EsuCore.Companion.getInstance().info("Running latency test of maven repositories...");
                MavenRepo def = new MavenRepo("central", "https://maven-central.storage-download.googleapis.com/maven2/");
                MavenRepo[] mavenRepoArray = new MavenRepo[]{new MavenRepo("aliyun", "https://maven.aliyun.com/repository/public/"), def, new MavenRepo("central", "https://maven-central-eu.storage-download.googleapis.com/maven2/"), new MavenRepo("central", "https://maven-central-asia.storage-download.googleapis.com/maven2/")};
                List<MavenRepo> repos = CollectionsKt.listOf(mavenRepoArray);
                Iterable $this$map$iv = repos;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MavenRepo mavenRepo = (MavenRepo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to(it, NetworkUtils.INSTANCE.getUriLatency(it.getUrl())));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                List<Pair> tested = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        long l = ((Number)it.getSecond()).longValue() >= 0L ? ((Number)it.getSecond()).longValue() : Long.MAX_VALUE;
                        it = (Pair)b;
                        Comparable comparable = Long.valueOf(l);
                        bl = false;
                        return ComparisonsKt.compareValues(comparable, ((Number)it.getSecond()).longValue() >= 0L ? ((Number)it.getSecond()).longValue() : Long.MAX_VALUE);
                    }
                });
                for (Pair pair : tested) {
                    MavenRepo repo = (MavenRepo)pair.component1();
                    long latency = ((Number)pair.component2()).longValue();
                    EsuCore.Companion.getInstance().info("'" + repo.getUrl() + "': " + latency + "ms");
                }
                Pair best = CollectionsKt.first(tested);
                return ((Number)best.getSecond()).longValue() != Long.MAX_VALUE ? (MavenRepo)best.getFirst() : def;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010$\u001a\u00020%H\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0006H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003JE\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u00020\u0006H\u00d6\u0001J\t\u00101\u001a\u00020\u0003H\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000fR\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u001e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u0018\u0010 \u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u0018\u0010\"\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\r\u00a8\u00062"}, d2={"Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$Database;", "", "databaseType", "", "host", "port", "", "database", "username", "password", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDatabaseType", "()Ljava/lang/String;", "setDatabaseType", "(Ljava/lang/String;)V", "getHost", "setHost", "getPort", "()I", "setPort", "(I)V", "getDatabase", "setDatabase", "getUsername", "setUsername", "getPassword", "setPassword", "driverClassName", "getDriverClassName", "url", "getUrl", "jdbcDriver", "getJdbcDriver", "jdbcUrl", "getJdbcUrl", "upgrade", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "core"})
        public static final class Database {
            @Comment(value="\n                The database software you want to use.\n                Supports 'H2'(built-in file system db), 'MySQL', 'MariaDB'\n            ")
            @NotNull
            private String databaseType;
            @Comment(value="\n                Below settings are only needed when you have a database server.\n            ")
            @NotNull
            private String host;
            private int port;
            @NotNull
            private String database;
            @NotNull
            private String username;
            @NotNull
            private String password;
            @RemovedNode(since="0.9.1")
            @Nullable
            private final String jdbcDriver;
            @RemovedNode(since="0.9.1")
            @Nullable
            private final String jdbcUrl;

            public Database(@NotNull String databaseType, @NotNull String host, int port, @NotNull String database, @NotNull String username, @NotNull String password) {
                this.databaseType = databaseType;
                this.host = host;
                this.port = port;
                this.database = database;
                this.username = username;
                this.password = password;
            }

            public /* synthetic */ Database(String string, String string2, int n, String string3, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    string = "H2";
                }
                if ((n2 & 2) != 0) {
                    string2 = "127.0.0.1";
                }
                if ((n2 & 4) != 0) {
                    n = 3306;
                }
                if ((n2 & 8) != 0) {
                    string3 = "esu";
                }
                if ((n2 & 0x10) != 0) {
                    string4 = "root";
                }
                if ((n2 & 0x20) != 0) {
                    string5 = "root";
                }
                this(string, string2, n, string3, string4, string5);
            }

            @NotNull
            public final String getDatabaseType() {
                return this.databaseType;
            }

            public final void setDatabaseType(@NotNull String string) {
                this.databaseType = string;
            }

            @NotNull
            public final String getHost() {
                return this.host;
            }

            public final void setHost(@NotNull String string) {
                this.host = string;
            }

            public final int getPort() {
                return this.port;
            }

            public final void setPort(int n) {
                this.port = n;
            }

            @NotNull
            public final String getDatabase() {
                return this.database;
            }

            public final void setDatabase(@NotNull String string) {
                this.database = string;
            }

            @NotNull
            public final String getUsername() {
                return this.username;
            }

            public final void setUsername(@NotNull String string) {
                this.username = string;
            }

            @NotNull
            public final String getPassword() {
                return this.password;
            }

            public final void setPassword(@NotNull String string) {
                this.password = string;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @NotNull
            public final String getDriverClassName() {
                String string = this.databaseType.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                String string2 = string;
                switch (string2.hashCode()) {
                    case 73844866: {
                        if (string2.equals("MYSQL")) return "com.mysql.jdbc.Driver";
                        throw new IllegalStateException(("Unsupported database type: " + this.databaseType).toString());
                    }
                    case 1557169620: {
                        if (string2.equals("MARIADB")) return "org.mariadb.jdbc.Driver";
                        throw new IllegalStateException(("Unsupported database type: " + this.databaseType).toString());
                    }
                    case 2282: {
                        if (!string2.equals("H2")) throw new IllegalStateException(("Unsupported database type: " + this.databaseType).toString());
                        return "org.h2.Driver";
                    }
                }
                throw new IllegalStateException(("Unsupported database type: " + this.databaseType).toString());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @NotNull
            public final String getUrl() {
                String string;
                block6: {
                    String string2 = this.databaseType.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                    String string3 = string2;
                    switch (string3.hashCode()) {
                        case 73844866: {
                            if (string3.equals("MYSQL")) break;
                            throw new IllegalStateException(("Unsupported database type: " + this.databaseType).toString());
                        }
                        case 1557169620: {
                            if (!string3.equals("MARIADB")) {
                                throw new IllegalStateException(("Unsupported database type: " + this.databaseType).toString());
                            }
                            break block6;
                        }
                        case 2282: {
                            if (!string3.equals("H2")) throw new IllegalStateException(("Unsupported database type: " + this.databaseType).toString());
                            string = "jdbc:h2:file:./plugins/" + PathsKt.getName(EsuCore.Companion.getInstance().baseConfigPath()) + "/h2;MODE=MYSQL";
                            return string;
                        }
                    }
                    string = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database;
                    return string;
                }
                string = "jdbc:mariadb://" + this.host + ":" + this.port + "/" + this.database;
                return string;
                throw new IllegalStateException(("Unsupported database type: " + this.databaseType).toString());
            }

            @Nullable
            public final String getJdbcDriver() {
                return this.jdbcDriver;
            }

            @Nullable
            public final String getJdbcUrl() {
                return this.jdbcUrl;
            }

            @PostProcess
            private final void upgrade() {
                block15: {
                    if (this.jdbcUrl == null) break block15;
                    Object object = new char[]{':'};
                    List split = StringsKt.split$default((CharSequence)this.jdbcUrl, object, false, 3, 2, null);
                    if (split.size() < 3) {
                        return;
                    }
                    switch ((Object)((String)split.get(1))) {
                        case "h2": {
                            this.databaseType = "H2";
                            break;
                        }
                        case "mariadb": 
                        case "mysql": {
                            String string = ((String)split.get(1)).toUpperCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                            this.databaseType = string;
                            MatchResult reg = new Regex("//(.+):(.+)/(.+)").matchEntire((CharSequence)split.get(2));
                            if (reg == null) break;
                            Object object2 = reg.getGroups().get(1);
                            if (object2 == null || (object2 = ((MatchGroup)object2).getValue()) == null) {
                                object2 = this.host;
                            }
                            this.host = object2;
                            Object object3 = reg.getGroups().get(2);
                            int n = this.port = object3 != null && (object3 = ((MatchGroup)object3).getValue()) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : this.port;
                            Object object4 = reg.getGroups().get(3);
                            if (object4 == null || (object4 = ((MatchGroup)object4).getValue()) == null) {
                                object4 = this.database;
                            }
                            this.database = object4;
                        }
                    }
                }
            }

            @NotNull
            public final String component1() {
                return this.databaseType;
            }

            @NotNull
            public final String component2() {
                return this.host;
            }

            public final int component3() {
                return this.port;
            }

            @NotNull
            public final String component4() {
                return this.database;
            }

            @NotNull
            public final String component5() {
                return this.username;
            }

            @NotNull
            public final String component6() {
                return this.password;
            }

            @NotNull
            public final Database copy(@NotNull String databaseType, @NotNull String host, int port, @NotNull String database, @NotNull String username, @NotNull String password) {
                return new Database(databaseType, host, port, database, username, password);
            }

            public static /* synthetic */ Database copy$default(Database database, String string, String string2, int n, String string3, String string4, String string5, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = database.databaseType;
                }
                if ((n2 & 2) != 0) {
                    string2 = database.host;
                }
                if ((n2 & 4) != 0) {
                    n = database.port;
                }
                if ((n2 & 8) != 0) {
                    string3 = database.database;
                }
                if ((n2 & 0x10) != 0) {
                    string4 = database.username;
                }
                if ((n2 & 0x20) != 0) {
                    string5 = database.password;
                }
                return database.copy(string, string2, n, string3, string4, string5);
            }

            @NotNull
            public String toString() {
                return "Database(databaseType=" + this.databaseType + ", host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", username=" + this.username + ", password=" + this.password + ")";
            }

            public int hashCode() {
                int result = this.databaseType.hashCode();
                result = result * 31 + this.host.hashCode();
                result = result * 31 + Integer.hashCode(this.port);
                result = result * 31 + this.database.hashCode();
                result = result * 31 + this.username.hashCode();
                result = result * 31 + this.password.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Database)) {
                    return false;
                }
                Database database = (Database)other;
                if (!Intrinsics.areEqual(this.databaseType, database.databaseType)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.host, database.host)) {
                    return false;
                }
                if (this.port != database.port) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.database, database.database)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.username, database.username)) {
                    return false;
                }
                return Intrinsics.areEqual(this.password, database.password);
            }

            public Database() {
                this(null, null, 0, null, null, null, 63, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/github/rothes/esu/core/config/EsuConfig$ConfigData$MavenRepo;", "", "id", "", "url", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
        public static final class MavenRepo {
            @NotNull
            private final String id;
            @NotNull
            private final String url;

            public MavenRepo(@NotNull String id, @NotNull String url) {
                this.id = id;
                this.url = url;
            }

            public /* synthetic */ MavenRepo(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = "";
                }
                if ((n & 2) != 0) {
                    string2 = "";
                }
                this(string, string2);
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final String getUrl() {
                return this.url;
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            @NotNull
            public final String component2() {
                return this.url;
            }

            @NotNull
            public final MavenRepo copy(@NotNull String id, @NotNull String url) {
                return new MavenRepo(id, url);
            }

            public static /* synthetic */ MavenRepo copy$default(MavenRepo mavenRepo, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = mavenRepo.id;
                }
                if ((n & 2) != 0) {
                    string2 = mavenRepo.url;
                }
                return mavenRepo.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "MavenRepo(id=" + this.id + ", url=" + this.url + ")";
            }

            public int hashCode() {
                int result = this.id.hashCode();
                result = result * 31 + this.url.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MavenRepo)) {
                    return false;
                }
                MavenRepo mavenRepo = (MavenRepo)other;
                if (!Intrinsics.areEqual(this.id, mavenRepo.id)) {
                    return false;
                }
                return Intrinsics.areEqual(this.url, mavenRepo.url);
            }

            public MavenRepo() {
                this(null, null, 3, null);
            }
        }
    }
}

