/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle;

import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.module.NetworkThrottleModule;
import io.github.rothes.esu.bukkit.util.ServerCompatibility;
import io.github.rothes.esu.bukkit.util.extension.ListenerExt;
import io.github.rothes.esu.bukkit.util.scheduler.ScheduledTask;
import io.github.rothes.esu.bukkit.util.scheduler.Scheduler;
import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.CommonFeature;
import io.github.rothes.esu.core.module.Feature;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import io.github.rothes.esu.lib.packetevents.PacketEvents;
import io.github.rothes.esu.lib.packetevents.event.PacketListenerAbstract;
import io.github.rothes.esu.lib.packetevents.event.PacketListenerCommon;
import io.github.rothes.esu.lib.packetevents.event.PacketListenerPriority;
import io.github.rothes.esu.lib.packetevents.event.PacketReceiveEvent;
import io.github.rothes.esu.lib.packetevents.protocol.packettype.PacketType;
import io.github.rothes.esu.lib.packetevents.wrapper.play.client.WrapperPlayClientSettings;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0003\"#$B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/HighLatencyAdjust;", "Lio/github/rothes/esu/core/module/CommonFeature;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/HighLatencyAdjust$FeatureConfig;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/HighLatencyAdjust$FeatureLang;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "NO_TIME", "", "adjusted", "Ljava/util/HashMap;", "Lorg/bukkit/entity/Player;", "", "Lkotlin/collections/HashMap;", "getAdjusted", "()Ljava/util/HashMap;", "startTime", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "getStartTime", "()Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "task", "Lio/github/rothes/esu/bukkit/util/scheduler/ScheduledTask;", "getTask", "()Lio/github/rothes/esu/bukkit/util/scheduler/ScheduledTask;", "setTask", "(Lio/github/rothes/esu/bukkit/util/scheduler/ScheduledTask;)V", "onQuit", "", "e", "Lorg/bukkit/event/player/PlayerQuitEvent;", "checkUnavailable", "Lio/github/rothes/esu/core/module/Feature$AvailableCheck;", "onEnable", "onDisable", "FeatureConfig", "FeatureLang", "PacketListeners", "bukkit"})
@SourceDebugExtension(value={"SMAP\nHighLatencyAdjust.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighLatencyAdjust.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/HighLatencyAdjust\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class HighLatencyAdjust
extends CommonFeature<FeatureConfig, FeatureLang>
implements Listener {
    @NotNull
    public static final HighLatencyAdjust INSTANCE;
    private static final long NO_TIME = -1L;
    @NotNull
    private static final HashMap<Player, Integer> adjusted;
    @NotNull
    private static final Object2LongOpenHashMap<Player> startTime;
    @Nullable
    private static ScheduledTask task;

    private HighLatencyAdjust() {
    }

    @NotNull
    public final HashMap<Player, Integer> getAdjusted() {
        return adjusted;
    }

    @NotNull
    public final Object2LongOpenHashMap<Player> getStartTime() {
        return startTime;
    }

    @Nullable
    public final ScheduledTask getTask() {
        return task;
    }

    public final void setTask(@Nullable ScheduledTask scheduledTask) {
        task = scheduledTask;
    }

    @EventHandler
    public final void onQuit(@NotNull PlayerQuitEvent e) {
        adjusted.remove(e.getPlayer());
        startTime.removeLong((Object)e.getPlayer());
    }

    @Override
    @Nullable
    public Feature.AvailableCheck checkUnavailable() {
        Feature.AvailableCheck availableCheck = super.checkUnavailable();
        if (availableCheck == null) {
            HighLatencyAdjust it = this;
            boolean bl = false;
            if (!ServerCompatibility.INSTANCE.isPaper()) {
                InternalsKt.getPlugin().err("[HighLatencyAdjust] This feature requires Paper server");
                return Feature.AvailableCheck.Companion.fail((Function1<? super User, MessageData>)((Function1)HighLatencyAdjust::checkUnavailable$lambda$0$0));
            }
            availableCheck = null;
        }
        return availableCheck;
    }

    @Override
    public void onEnable() {
        for (Map.Entry<UUID, Integer> entry : NetworkThrottleModule.INSTANCE.getData().getOriginalViewDistance().entrySet()) {
            UUID uuid = entry.getKey();
            int v = ((Number)entry.getValue()).intValue();
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            ((Map)adjusted).put(player, v);
        }
        NetworkThrottleModule.INSTANCE.getData().getOriginalViewDistance().clear();
        task = Scheduler.asyncTicks$default(Scheduler.INSTANCE, 0L, 300L, null, HighLatencyAdjust::onEnable$lambda$0, 4, null);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)PacketListeners.INSTANCE);
        ListenerExt.register$default(ListenerExt.INSTANCE, this, null, 1, null);
    }

    @Override
    public void onDisable() {
        if (InternalsKt.getPlugin().isEnabled() || InternalsKt.getPlugin().getDisabledHot()) {
            for (Map.Entry<Player, Integer> entry : adjusted.entrySet()) {
                Player player = entry.getKey();
                Integer v = entry.getValue();
                NetworkThrottleModule.INSTANCE.getData().getOriginalViewDistance().put(player.getUniqueId(), v);
            }
        }
        ScheduledTask scheduledTask = task;
        if (scheduledTask != null) {
            scheduledTask.cancel();
        }
        task = null;
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)PacketListeners.INSTANCE);
        ListenerExt.INSTANCE.unregister(this);
        adjusted.clear();
        startTime.clear();
    }

    private static final MessageData checkUnavailable$lambda$0$0(User it) {
        return MessageData.Companion.getMessage("This feature requires Paper server");
    }

    private static final Unit onEnable$lambda$0() {
        long now = System.currentTimeMillis();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getPing() >= ((FeatureConfig)INSTANCE.getConfig()).getLatencyThreshold()) {
                long last = startTime.getLong((Object)player);
                if (last == -1L) {
                    ((Map)startTime).put(player, now);
                    continue;
                }
                if (now - last < ((FeatureConfig)INSTANCE.getConfig()).getDuration().toMillis()) continue;
                startTime.removeLong((Object)player);
                if (!adjusted.containsKey(player)) {
                    ((Map)adjusted).put(player, player.getClientViewDistance());
                    player.setSendViewDistance(Math.min(player.getClientViewDistance(), player.getViewDistance()) - 1);
                } else {
                    if (player.getSendViewDistance() <= ((FeatureConfig)INSTANCE.getConfig()).getMinViewDistance()) continue;
                    int n = player.getSendViewDistance();
                    player.setSendViewDistance(n + -1);
                }
                InternalsKt.getUser(player).sendMessage(INSTANCE.getLang(), HighLatencyAdjust::onEnable$lambda$0$0, new TagResolver[0]);
                continue;
            }
            startTime.removeLong((Object)player);
        }
        return Unit.INSTANCE;
    }

    private static final MessageData onEnable$lambda$0$0(FeatureLang $this$message) {
        return $this$message.getAdjustedWarning();
    }

    static {
        Object2LongOpenHashMap object2LongOpenHashMap;
        INSTANCE = new HighLatencyAdjust();
        adjusted = new HashMap();
        Object2LongOpenHashMap it = object2LongOpenHashMap = new Object2LongOpenHashMap();
        boolean bl = false;
        it.defaultReturnValue(-1L);
        startTime = object2LongOpenHashMap;
    }

    @Comment(value="\n            Adjust the settings the players with high latency to lower value.\n            So they won't affect average quality of all players.\n            ")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006 "}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/HighLatencyAdjust$FeatureConfig;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "enabled", "", "latencyThreshold", "", "duration", "Ljava/time/Duration;", "newViewDistanceToReset", "minViewDistance", "<init>", "(ZILjava/time/Duration;ZI)V", "getEnabled", "()Z", "getLatencyThreshold", "()I", "getDuration", "()Ljava/time/Duration;", "getNewViewDistanceToReset", "getMinViewDistance", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "", "bukkit"})
    public static final class FeatureConfig
    implements ConfigurationPart {
        private final boolean enabled;
        @Comment(value="Trigger a adjust when player's ping is greater than or equal this.")
        private final int latencyThreshold;
        @Comment(value="The high ping must keep for the duration to trigger a adjust finally.")
        @NotNull
        private final java.time.Duration duration;
        @Comment(value="Plugin detects CLIENT_SETTINGS packets to reset the view distance for players.\nIf true, player must change the client view distance for a reset;\nIf false, any new settings could reset the view distance for the player.")
        private final boolean newViewDistanceToReset;
        private final int minViewDistance;

        public FeatureConfig(boolean enabled, int latencyThreshold, @NotNull java.time.Duration duration, boolean newViewDistanceToReset, int minViewDistance) {
            this.enabled = enabled;
            this.latencyThreshold = latencyThreshold;
            this.duration = duration;
            this.newViewDistanceToReset = newViewDistanceToReset;
            this.minViewDistance = minViewDistance;
        }

        public /* synthetic */ FeatureConfig(boolean bl, int n, java.time.Duration duration, boolean bl2, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                bl = false;
            }
            if ((n3 & 2) != 0) {
                n = 150;
            }
            if ((n3 & 4) != 0) {
                long l = Duration.Companion.parse-UwyO8pc("1m");
                int n4 = Duration.getNanosecondsComponent-impl((long)l);
                long l2 = Duration.getInWholeSeconds-impl((long)l);
                java.time.Duration duration2 = java.time.Duration.ofSeconds(l2, n4);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toComponents-impl(...)");
                duration = duration2;
            }
            if ((n3 & 8) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 5;
            }
            this(bl, n, duration, bl2, n2);
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final int getLatencyThreshold() {
            return this.latencyThreshold;
        }

        @NotNull
        public final java.time.Duration getDuration() {
            return this.duration;
        }

        public final boolean getNewViewDistanceToReset() {
            return this.newViewDistanceToReset;
        }

        public final int getMinViewDistance() {
            return this.minViewDistance;
        }

        public final boolean component1() {
            return this.enabled;
        }

        public final int component2() {
            return this.latencyThreshold;
        }

        @NotNull
        public final java.time.Duration component3() {
            return this.duration;
        }

        public final boolean component4() {
            return this.newViewDistanceToReset;
        }

        public final int component5() {
            return this.minViewDistance;
        }

        @NotNull
        public final FeatureConfig copy(boolean enabled, int latencyThreshold, @NotNull java.time.Duration duration, boolean newViewDistanceToReset, int minViewDistance) {
            return new FeatureConfig(enabled, latencyThreshold, duration, newViewDistanceToReset, minViewDistance);
        }

        public static /* synthetic */ FeatureConfig copy$default(FeatureConfig featureConfig, boolean bl, int n, java.time.Duration duration, boolean bl2, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                bl = featureConfig.enabled;
            }
            if ((n3 & 2) != 0) {
                n = featureConfig.latencyThreshold;
            }
            if ((n3 & 4) != 0) {
                duration = featureConfig.duration;
            }
            if ((n3 & 8) != 0) {
                bl2 = featureConfig.newViewDistanceToReset;
            }
            if ((n3 & 0x10) != 0) {
                n2 = featureConfig.minViewDistance;
            }
            return featureConfig.copy(bl, n, duration, bl2, n2);
        }

        @NotNull
        public String toString() {
            return "FeatureConfig(enabled=" + this.enabled + ", latencyThreshold=" + this.latencyThreshold + ", duration=" + this.duration + ", newViewDistanceToReset=" + this.newViewDistanceToReset + ", minViewDistance=" + this.minViewDistance + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.enabled);
            result = result * 31 + Integer.hashCode(this.latencyThreshold);
            result = result * 31 + this.duration.hashCode();
            result = result * 31 + Boolean.hashCode(this.newViewDistanceToReset);
            result = result * 31 + Integer.hashCode(this.minViewDistance);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig featureConfig = (FeatureConfig)other;
            if (this.enabled != featureConfig.enabled) {
                return false;
            }
            if (this.latencyThreshold != featureConfig.latencyThreshold) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.duration, (Object)featureConfig.duration)) {
                return false;
            }
            if (this.newViewDistanceToReset != featureConfig.newViewDistanceToReset) {
                return false;
            }
            return this.minViewDistance == featureConfig.minViewDistance;
        }

        public FeatureConfig() {
            this(false, 0, null, false, 0, 31, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/HighLatencyAdjust$FeatureLang;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "adjustedWarning", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getAdjustedWarning", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "bukkit"})
    public static final class FeatureLang
    implements ConfigurationPart {
        @NotNull
        private final MessageData adjustedWarning;

        public FeatureLang(@NotNull MessageData adjustedWarning) {
            this.adjustedWarning = adjustedWarning;
        }

        public /* synthetic */ FeatureLang(MessageData messageData, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                messageData = MessageData.Companion.getMessage("<ec><b>Warning: </b><pc>Your network latency seems to be high. \nTo enhance your experience, we have adjusted your view distance. You can always adjust it yourself in the game options.");
            }
            this(messageData);
        }

        @NotNull
        public final MessageData getAdjustedWarning() {
            return this.adjustedWarning;
        }

        @NotNull
        public final MessageData component1() {
            return this.adjustedWarning;
        }

        @NotNull
        public final FeatureLang copy(@NotNull MessageData adjustedWarning) {
            return new FeatureLang(adjustedWarning);
        }

        public static /* synthetic */ FeatureLang copy$default(FeatureLang featureLang, MessageData messageData, int n, Object object) {
            if ((n & 1) != 0) {
                messageData = featureLang.adjustedWarning;
            }
            return featureLang.copy(messageData);
        }

        @NotNull
        public String toString() {
            return "FeatureLang(adjustedWarning=" + this.adjustedWarning + ")";
        }

        public int hashCode() {
            return this.adjustedWarning.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureLang)) {
                return false;
            }
            FeatureLang featureLang = (FeatureLang)other;
            return Intrinsics.areEqual((Object)this.adjustedWarning, (Object)featureLang.adjustedWarning);
        }

        public FeatureLang() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/HighLatencyAdjust$PacketListeners;", "Lio/github/rothes/esu/lib/packetevents/event/PacketListenerAbstract;", "<init>", "()V", "onPacketReceive", "", "event", "Lio/github/rothes/esu/lib/packetevents/event/PacketReceiveEvent;", "bukkit"})
    private static final class PacketListeners
    extends PacketListenerAbstract {
        @NotNull
        public static final PacketListeners INSTANCE = new PacketListeners();

        private PacketListeners() {
            super(PacketListenerPriority.HIGHEST);
        }

        public void onPacketReceive(@NotNull PacketReceiveEvent event) {
            if (event.getPacketType() == PacketType.Play.Client.CLIENT_SETTINGS) {
                WrapperPlayClientSettings wrapper = new WrapperPlayClientSettings(event);
                Player player = (Player)event.getPlayer();
                Integer n = INSTANCE.getAdjusted().get(player);
                if (n == null) {
                    return;
                }
                int old = n;
                int viewDistance = wrapper.getViewDistance();
                if (!((FeatureConfig)INSTANCE.getConfig()).getNewViewDistanceToReset() || old != viewDistance) {
                    INSTANCE.getAdjusted().remove(player);
                    INSTANCE.getStartTime().removeLong((Object)player);
                    player.setSendViewDistance(-1);
                }
            }
        }
    }
}

