/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module;

import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.module.BukkitModule;
import io.github.rothes.esu.bukkit.util.extension.ListenerExt;
import io.github.rothes.esu.bukkit.util.scheduler.Scheduler;
import io.github.rothes.esu.bukkit.util.version.adapter.AttributeAdapter;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.configuration.BaseModuleConfiguration;
import io.github.rothes.esu.core.module.configuration.EmptyConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0012\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/bukkit/module/SpawnProtectModule;", "Lio/github/rothes/esu/bukkit/module/BukkitModule;", "Lio/github/rothes/esu/bukkit/module/SpawnProtectModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/EmptyConfiguration;", "<init>", "()V", "enable", "", "disable", "reloadConfig", "update", "witherNerfKey", "Lorg/bukkit/NamespacedKey;", "Lorg/jetbrains/annotations/Nullable;", "handleEntity", "e", "Lorg/bukkit/entity/Entity;", "resetEntity", "Listeners", "ModuleConfig", "bukkit"})
@SourceDebugExtension(value={"SMAP\nSpawnProtectModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnProtectModule.kt\nio/github/rothes/esu/bukkit/module/SpawnProtectModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n295#2,2:185\n*S KotlinDebug\n*F\n+ 1 SpawnProtectModule.kt\nio/github/rothes/esu/bukkit/module/SpawnProtectModule\n*L\n79#1:185,2\n*E\n"})
public final class SpawnProtectModule
extends BukkitModule<ModuleConfig, EmptyConfiguration> {
    @NotNull
    public static final SpawnProtectModule INSTANCE = new SpawnProtectModule();
    @NotNull
    private static final NamespacedKey witherNerfKey;

    private SpawnProtectModule() {
        super(ModuleConfig.class, EmptyConfiguration.class);
    }

    @Override
    public void enable() {
        this.update();
        ListenerExt.register$default(ListenerExt.INSTANCE, Listeners.INSTANCE, null, 1, null);
    }

    @Override
    public void disable() {
        super.disable();
        if (InternalsKt.getPlugin().isEnabled()) {
            for (World world : Bukkit.getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    Scheduler.schedule$default(Scheduler.INSTANCE, chunk.getBlock(0, 0, 0).getLocation(), null, () -> SpawnProtectModule.disable$lambda$0(chunk), 2, null);
                }
            }
        }
        ListenerExt.INSTANCE.unregister(Listeners.INSTANCE);
    }

    @Override
    public void reloadConfig() {
        super.reloadConfig();
        if (this.getEnabled()) {
            this.update();
        }
    }

    public final void update() {
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                Scheduler.schedule$default(Scheduler.INSTANCE, chunk.getBlock(0, 0, 0).getLocation(), null, () -> SpawnProtectModule.update$lambda$0(chunk), 2, null);
            }
        }
    }

    public final void handleEntity(@NotNull Entity e) {
        Object v0;
        block3: {
            if (!(e instanceof Wither)) {
                return;
            }
            this.resetEntity(e);
            Iterable $this$firstOrNull$iv = ((ModuleConfig)this.getConfig()).getSpawnWitherNerf();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ModuleConfig.SpawnWitherNerf it = (ModuleConfig.SpawnWitherNerf)element$iv;
                boolean bl = false;
                if (!((double)it.getRadius() >= Math.max(Math.abs(((Wither)e).getLocation().getX()), Math.abs(((Wither)e).getLocation().getZ())))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        ModuleConfig.SpawnWitherNerf spawnWitherNerf = v0;
        if (spawnWitherNerf == null) {
            return;
        }
        ModuleConfig.SpawnWitherNerf nerf = spawnWitherNerf;
        AttributeInstance attributeInstance = ((Wither)e).getAttribute(AttributeAdapter.Companion.getFLYING_SPEED());
        Intrinsics.checkNotNull((Object)attributeInstance);
        attributeInstance.addTransientModifier(new AttributeModifier(witherNerfKey, (double)-1 + nerf.getSpeedModifier(), AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        AttributeInstance attributeInstance2 = ((Wither)e).getAttribute(AttributeAdapter.Companion.getMOVEMENT_SPEED());
        Intrinsics.checkNotNull((Object)attributeInstance2);
        attributeInstance2.addTransientModifier(new AttributeModifier(witherNerfKey, (double)-1 + nerf.getSpeedModifier(), AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        AttributeInstance attributeInstance3 = ((Wither)e).getAttribute(AttributeAdapter.Companion.getFOLLOW_RANGE());
        Intrinsics.checkNotNull((Object)attributeInstance3);
        attributeInstance3.addTransientModifier(new AttributeModifier(witherNerfKey, (double)-1 + nerf.getFollowRangeModifier(), AttributeModifier.Operation.MULTIPLY_SCALAR_1));
    }

    public final void resetEntity(@NotNull Entity e) {
        block3: {
            if (!(e instanceof Wither)) {
                return;
            }
            AttributeInstance attributeInstance = ((Wither)e).getAttribute(AttributeAdapter.Companion.getFLYING_SPEED());
            if (attributeInstance != null) {
                attributeInstance.removeModifier((Key)witherNerfKey);
            }
            AttributeInstance attributeInstance2 = ((Wither)e).getAttribute(AttributeAdapter.Companion.getMOVEMENT_SPEED());
            if (attributeInstance2 != null) {
                attributeInstance2.removeModifier((Key)witherNerfKey);
            }
            AttributeInstance attributeInstance3 = ((Wither)e).getAttribute(AttributeAdapter.Companion.getFOLLOW_RANGE());
            if (attributeInstance3 == null) break block3;
            attributeInstance3.removeModifier((Key)witherNerfKey);
        }
    }

    private static final Unit disable$lambda$0(Chunk $chunk) {
        for (Entity entity : $chunk.getEntities()) {
            INSTANCE.resetEntity(entity);
        }
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$0(Chunk $chunk) {
        for (Entity entity : $chunk.getEntities()) {
            INSTANCE.handleEntity(entity);
        }
        return Unit.INSTANCE;
    }

    static {
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)"wither-mod", (Plugin)((Plugin)InternalsKt.getBootstrap()));
        Intrinsics.checkNotNull((Object)namespacedKey);
        witherNerfKey = namespacedKey;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fH\u0007J\u001e\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lio/github/rothes/esu/bukkit/module/SpawnProtectModule$Listeners;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onEntitySpawn", "", "e", "Lorg/bukkit/event/entity/EntitySpawnEvent;", "onChunkLoad", "Lorg/bukkit/event/world/ChunkLoadEvent;", "onPistonPushWaterlogged", "Lorg/bukkit/event/block/BlockPistonExtendEvent;", "Lorg/bukkit/event/block/BlockPistonRetractEvent;", "handleWaterloggedPush", "blocks", "", "Lorg/bukkit/block/Block;", "Lorg/bukkit/event/block/BlockPistonEvent;", "bukkit"})
    @SourceDebugExtension(value={"SMAP\nSpawnProtectModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnProtectModule.kt\nio/github/rothes/esu/bukkit/module/SpawnProtectModule$Listeners\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,184:1\n295#2,2:185\n295#2,2:190\n1761#2,3:203\n3919#3:187\n4434#3,2:188\n4225#3,11:192\n*S KotlinDebug\n*F\n+ 1 SpawnProtectModule.kt\nio/github/rothes/esu/bukkit/module/SpawnProtectModule$Listeners\n*L\n116#1:185,2\n128#1:190,2\n155#1:203,3\n118#1:187\n118#1:188,2\n130#1:192,11\n*E\n"})
    public static final class Listeners
    implements Listener {
        @NotNull
        public static final Listeners INSTANCE = new Listeners();

        private Listeners() {
        }

        /*
         * WARNING - void declaration
         */
        @EventHandler
        public final void onEntitySpawn(@NotNull EntitySpawnEvent e) {
            void $this$filterTo$iv$iv;
            Object v0;
            block5: {
                if (!(e.getEntity() instanceof Wither)) {
                    return;
                }
                Iterable $this$firstOrNull$iv = ((ModuleConfig)INSTANCE.getConfig()).getSpawnWitherNerf();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ModuleConfig.SpawnWitherNerf it = (ModuleConfig.SpawnWitherNerf)element$iv;
                    boolean bl = false;
                    if (!((double)it.getRadius() >= Math.max(Math.abs(e.getLocation().getX()), Math.abs(e.getLocation().getZ())))) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            ModuleConfig.SpawnWitherNerf spawnWitherNerf = v0;
            if (spawnWitherNerf == null) {
                return;
            }
            ModuleConfig.SpawnWitherNerf nerf = spawnWitherNerf;
            Entity[] $this$filter$iv = e.getEntity().getChunk().getEntities();
            boolean $i$f$filter = false;
            Entity[] entityArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(it instanceof Wither)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int amount = ((List)destination$iv$iv).size();
            if (amount >= nerf.getMaxAmount()) {
                e.setCancelled(true);
                return;
            }
            INSTANCE.handleEntity(e.getEntity());
        }

        /*
         * WARNING - void declaration
         */
        @EventHandler
        public final void onChunkLoad(@NotNull ChunkLoadEvent e) {
            void $this$filterIsInstanceTo$iv$iv;
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = ((ModuleConfig)INSTANCE.getConfig()).getSpawnWitherNerf();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ModuleConfig.SpawnWitherNerf it = (ModuleConfig.SpawnWitherNerf)element$iv;
                    boolean bl = false;
                    if (!(it.getRadius() >> 4 >= (long)Math.max(Math.abs(e.getChunk().getX()), Math.abs(e.getChunk().getZ())))) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            ModuleConfig.SpawnWitherNerf spawnWitherNerf = v0;
            if (spawnWitherNerf == null) {
                return;
            }
            ModuleConfig.SpawnWitherNerf nerf = spawnWitherNerf;
            Entity[] $this$filterIsInstance$iv = e.getChunk().getEntities();
            boolean $i$f$filterIsInstance = false;
            Entity[] entityArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Wither)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List withers = (List)destination$iv$iv;
            int max = nerf.getMaxAmount();
            int amount = withers.size();
            if (amount > max) {
                for (Wither entity : CollectionsKt.takeLast((List)withers, (int)(amount - max))) {
                    entity.remove();
                }
                for (Wither entity : CollectionsKt.dropLast((List)withers, (int)(amount - max))) {
                    INSTANCE.handleEntity((Entity)entity);
                }
                return;
            }
            for (Wither entity : withers) {
                INSTANCE.handleEntity((Entity)entity);
            }
        }

        @EventHandler
        public final void onPistonPushWaterlogged(@NotNull BlockPistonExtendEvent e) {
            this.handleWaterloggedPush(e.getBlocks(), (BlockPistonEvent)e);
        }

        @EventHandler
        public final void onPistonPushWaterlogged(@NotNull BlockPistonRetractEvent e) {
            this.handleWaterloggedPush(e.getBlocks(), (BlockPistonEvent)e);
        }

        private final void handleWaterloggedPush(List<Block> blocks, BlockPistonEvent e) {
            int dist;
            ModuleConfig.Waterlogged config = ((ModuleConfig)INSTANCE.getConfig()).getWaterlogged();
            if (config.getDisableSpawnPushRadius() > 0L && (long)(dist = Math.abs(e.getBlock().getX()) + Math.abs(e.getBlock().getZ())) <= config.getDisableSpawnPushRadius()) {
                boolean bl;
                block5: {
                    Iterable $this$any$iv = blocks;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Block it = (Block)element$iv;
                            boolean bl2 = false;
                            BlockData blockData = it.getBlockData();
                            Waterlogged waterlogged = blockData instanceof Waterlogged ? (Waterlogged)blockData : null;
                            boolean bl3 = waterlogged != null ? waterlogged.isWaterlogged() : false;
                            if (!bl3) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    e.setCancelled(true);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B!\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lio/github/rothes/esu/bukkit/module/SpawnProtectModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseModuleConfiguration;", "spawnWitherNerf", "", "Lio/github/rothes/esu/bukkit/module/SpawnProtectModule$ModuleConfig$SpawnWitherNerf;", "waterlogged", "Lio/github/rothes/esu/bukkit/module/SpawnProtectModule$ModuleConfig$Waterlogged;", "<init>", "(Ljava/util/List;Lio/github/rothes/esu/bukkit/module/SpawnProtectModule$ModuleConfig$Waterlogged;)V", "getSpawnWitherNerf", "()Ljava/util/List;", "getWaterlogged", "()Lio/github/rothes/esu/bukkit/module/SpawnProtectModule$ModuleConfig$Waterlogged;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "SpawnWitherNerf", "Waterlogged", "bukkit"})
    public static final class ModuleConfig
    extends BaseModuleConfiguration {
        @NotNull
        private final List<SpawnWitherNerf> spawnWitherNerf;
        @NotNull
        private final Waterlogged waterlogged;

        public ModuleConfig(@NotNull List<SpawnWitherNerf> spawnWitherNerf, @NotNull Waterlogged waterlogged) {
            super(false, 1, null);
            this.spawnWitherNerf = spawnWitherNerf;
            this.waterlogged = waterlogged;
        }

        public /* synthetic */ ModuleConfig(List list, Waterlogged waterlogged, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Object[] objectArray = new SpawnWitherNerf[]{new SpawnWitherNerf(256L, 0, 0.0, 0.0, 12, null), new SpawnWitherNerf(0L, 0, 0.0, 0.0, 15, null)};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
            if ((n & 2) != 0) {
                waterlogged = new Waterlogged(0L, 1, null);
            }
            this(list, waterlogged);
        }

        @NotNull
        public final List<SpawnWitherNerf> getSpawnWitherNerf() {
            return this.spawnWitherNerf;
        }

        @NotNull
        public final Waterlogged getWaterlogged() {
            return this.waterlogged;
        }

        @NotNull
        public final List<SpawnWitherNerf> component1() {
            return this.spawnWitherNerf;
        }

        @NotNull
        public final Waterlogged component2() {
            return this.waterlogged;
        }

        @NotNull
        public final ModuleConfig copy(@NotNull List<SpawnWitherNerf> spawnWitherNerf, @NotNull Waterlogged waterlogged) {
            return new ModuleConfig(spawnWitherNerf, waterlogged);
        }

        public static /* synthetic */ ModuleConfig copy$default(ModuleConfig moduleConfig, List list, Waterlogged waterlogged, int n, Object object) {
            if ((n & 1) != 0) {
                list = moduleConfig.spawnWitherNerf;
            }
            if ((n & 2) != 0) {
                waterlogged = moduleConfig.waterlogged;
            }
            return moduleConfig.copy(list, waterlogged);
        }

        @NotNull
        public String toString() {
            return "ModuleConfig(spawnWitherNerf=" + this.spawnWitherNerf + ", waterlogged=" + this.waterlogged + ")";
        }

        public int hashCode() {
            int result = ((Object)this.spawnWitherNerf).hashCode();
            result = result * 31 + this.waterlogged.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleConfig)) {
                return false;
            }
            ModuleConfig moduleConfig = (ModuleConfig)other;
            if (!Intrinsics.areEqual(this.spawnWitherNerf, moduleConfig.spawnWitherNerf)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.waterlogged, (Object)moduleConfig.waterlogged);
        }

        public ModuleConfig() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/github/rothes/esu/bukkit/module/SpawnProtectModule$ModuleConfig$SpawnWitherNerf;", "", "radius", "", "maxAmount", "", "speedModifier", "", "followRangeModifier", "<init>", "(JIDD)V", "getRadius", "()J", "getMaxAmount", "()I", "getSpeedModifier", "()D", "getFollowRangeModifier", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "bukkit"})
        public static final class SpawnWitherNerf {
            private final long radius;
            private final int maxAmount;
            private final double speedModifier;
            private final double followRangeModifier;

            public SpawnWitherNerf(long radius, int maxAmount, double speedModifier, double followRangeModifier) {
                this.radius = radius;
                this.maxAmount = maxAmount;
                this.speedModifier = speedModifier;
                this.followRangeModifier = followRangeModifier;
            }

            public /* synthetic */ SpawnWitherNerf(long l, int n, double d, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    l = 1024L;
                }
                if ((n2 & 2) != 0) {
                    n = 1;
                }
                if ((n2 & 4) != 0) {
                    d = 0.5;
                }
                if ((n2 & 8) != 0) {
                    d2 = 0.25;
                }
                this(l, n, d, d2);
            }

            public final long getRadius() {
                return this.radius;
            }

            public final int getMaxAmount() {
                return this.maxAmount;
            }

            public final double getSpeedModifier() {
                return this.speedModifier;
            }

            public final double getFollowRangeModifier() {
                return this.followRangeModifier;
            }

            public final long component1() {
                return this.radius;
            }

            public final int component2() {
                return this.maxAmount;
            }

            public final double component3() {
                return this.speedModifier;
            }

            public final double component4() {
                return this.followRangeModifier;
            }

            @NotNull
            public final SpawnWitherNerf copy(long radius, int maxAmount, double speedModifier, double followRangeModifier) {
                return new SpawnWitherNerf(radius, maxAmount, speedModifier, followRangeModifier);
            }

            public static /* synthetic */ SpawnWitherNerf copy$default(SpawnWitherNerf spawnWitherNerf, long l, int n, double d, double d2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    l = spawnWitherNerf.radius;
                }
                if ((n2 & 2) != 0) {
                    n = spawnWitherNerf.maxAmount;
                }
                if ((n2 & 4) != 0) {
                    d = spawnWitherNerf.speedModifier;
                }
                if ((n2 & 8) != 0) {
                    d2 = spawnWitherNerf.followRangeModifier;
                }
                return spawnWitherNerf.copy(l, n, d, d2);
            }

            @NotNull
            public String toString() {
                return "SpawnWitherNerf(radius=" + this.radius + ", maxAmount=" + this.maxAmount + ", speedModifier=" + this.speedModifier + ", followRangeModifier=" + this.followRangeModifier + ")";
            }

            public int hashCode() {
                int result = Long.hashCode(this.radius);
                result = result * 31 + Integer.hashCode(this.maxAmount);
                result = result * 31 + Double.hashCode(this.speedModifier);
                result = result * 31 + Double.hashCode(this.followRangeModifier);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SpawnWitherNerf)) {
                    return false;
                }
                SpawnWitherNerf spawnWitherNerf = (SpawnWitherNerf)other;
                if (this.radius != spawnWitherNerf.radius) {
                    return false;
                }
                if (this.maxAmount != spawnWitherNerf.maxAmount) {
                    return false;
                }
                if (Double.compare(this.speedModifier, spawnWitherNerf.speedModifier) != 0) {
                    return false;
                }
                return Double.compare(this.followRangeModifier, spawnWitherNerf.followRangeModifier) == 0;
            }

            public SpawnWitherNerf() {
                this(0L, 0, 0.0, 0.0, 15, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/bukkit/module/SpawnProtectModule$ModuleConfig$Waterlogged;", "", "disableSpawnPushRadius", "", "<init>", "(J)V", "getDisableSpawnPushRadius", "()J", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class Waterlogged {
            @Comment(value="\n                Disable pushing waterlogged blocks in spawn circle range.\n                set to -1 to disable the limit.\n                This is to prevent ocean maker machine.\n            ")
            private final long disableSpawnPushRadius;

            public Waterlogged(long disableSpawnPushRadius) {
                this.disableSpawnPushRadius = disableSpawnPushRadius;
            }

            public /* synthetic */ Waterlogged(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    l = -1L;
                }
                this(l);
            }

            public final long getDisableSpawnPushRadius() {
                return this.disableSpawnPushRadius;
            }

            public final long component1() {
                return this.disableSpawnPushRadius;
            }

            @NotNull
            public final Waterlogged copy(long disableSpawnPushRadius) {
                return new Waterlogged(disableSpawnPushRadius);
            }

            public static /* synthetic */ Waterlogged copy$default(Waterlogged waterlogged, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = waterlogged.disableSpawnPushRadius;
                }
                return waterlogged.copy(l);
            }

            @NotNull
            public String toString() {
                return "Waterlogged(disableSpawnPushRadius=" + this.disableSpawnPushRadius + ")";
            }

            public int hashCode() {
                return Long.hashCode(this.disableSpawnPushRadius);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Waterlogged)) {
                    return false;
                }
                Waterlogged waterlogged = (Waterlogged)other;
                return this.disableSpawnPushRadius == waterlogged.disableSpawnPushRadius;
            }

            public Waterlogged() {
                this(0L, 1, null);
            }
        }
    }
}

