/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.configuration.serializer;

import io.github.rothes.esu.core.EsuCore;
import io.github.rothes.esu.lib.org.spongepowered.configurate.serialize.ScalarSerializer;
import io.github.rothes.esu.lib.org.spongepowered.configurate.util.EnumLookup;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lio/github/rothes/esu/core/configuration/serializer/EnumValueSerializer;", "Lio/github/rothes/esu/lib/org/spongepowered/configurate/serialize/ScalarSerializer;", "", "<init>", "()V", "deserialize", "type", "Ljava/lang/reflect/Type;", "obj", "", "serialize", "item", "typeSupported", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "core"})
public final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    @NotNull
    public static final EnumValueSerializer INSTANCE = new EnumValueSerializer();

    private EnumValueSerializer() {
        super(TypeToken.get(Enum.class));
    }

    @Override
    @Nullable
    public Enum<?> deserialize(@NotNull Type type, @NotNull Object obj) {
        String string = obj.toString();
        Class<Enum> typeClass = GenericTypeReflector.erase(type).asSubclass(Enum.class);
        Enum enum_ = EnumLookup.lookupEnum(typeClass, string);
        if (enum_ == null && (enum_ = EnumLookup.lookupEnum(typeClass, StringsKt.replace$default((String)string, (String)"-", (String)"_", (boolean)false, (int)4, null))) == null) {
            EnumValueSerializer it = this;
            boolean bl = false;
            EsuCore.Companion.getInstance().warn("Invalid enum constant provided '" + string + "'. Using null.");
            enum_ = null;
        }
        return enum_;
    }

    @Override
    @NotNull
    public Object serialize(@NotNull Enum<?> item, @NotNull Predicate<Class<?>> typeSupported) {
        String string = item.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }
}

