/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.configuration.serializer;

import io.github.rothes.esu.lib.org.spongepowered.configurate.serialize.ScalarSerializer;
import io.github.rothes.esu.lib.org.spongepowered.configurate.serialize.SerializationException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00022\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012H\u0014R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/core/configuration/serializer/ServerTextColorSerializer;", "Lio/github/rothes/esu/lib/org/spongepowered/configurate/serialize/ScalarSerializer;", "Lnet/kyori/adventure/text/format/TextColor;", "<init>", "()V", "aliases", "", "", "Lnet/kyori/adventure/text/format/NamedTextColor;", "kotlin.jvm.PlatformType", "deserialize", "type", "Ljava/lang/reflect/Type;", "obj", "", "serialize", "textColor", "typeSupported", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "core"})
public final class ServerTextColorSerializer
extends ScalarSerializer<TextColor> {
    @NotNull
    public static final ServerTextColorSerializer INSTANCE = new ServerTextColorSerializer();
    @NotNull
    private static final Map<String, NamedTextColor> aliases;

    private ServerTextColorSerializer() {
        super(TextColor.class);
    }

    @Override
    @NotNull
    public TextColor deserialize(@NotNull Type type, @NotNull Object obj) throws SerializationException {
        TextColor textColor;
        String string = obj.toString();
        if (StringsKt.startsWith$default((String)string, (String)"#", (boolean)false, (int)2, null)) {
            textColor = TextColor.fromHexString((String)string);
        } else {
            NamedTextColor namedTextColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)string);
            if (namedTextColor == null) {
                namedTextColor = aliases.get(string);
            }
            textColor = (TextColor)namedTextColor;
        }
        if (textColor == null) {
            throw new SerializationException("Unable to parse a color from '" + string + "'. Please use named colors or hex (#RRGGBB) colors.");
        }
        return textColor;
    }

    @NotNull
    protected String serialize(@NotNull TextColor textColor, @NotNull Predicate<Class<?>> typeSupported) {
        return textColor.toString();
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair((Object)"dark_grey", (Object)NamedTextColor.DARK_GRAY), new Pair((Object)"grey", (Object)NamedTextColor.GRAY)};
        aliases = MapsKt.mapOf((Pair[])pairArray);
    }
}

