/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.util.artifact.relocator;

import io.github.rothes.esu.core.EsuCore;
import io.github.rothes.esu.core.util.artifact.local.FileHashes;
import io.github.rothes.esu.core.util.artifact.relocator.PackageRelocator;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/rothes/esu/core/util/artifact/relocator/CachedRelocator;", "", "<init>", "()V", "cacheFolder", "Ljava/io/File;", "cached", "Lio/github/rothes/esu/core/util/artifact/local/FileHashes;", "relocate", "relocator", "Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator;", "file", "core"})
public final class CachedRelocator {
    @NotNull
    public static final CachedRelocator INSTANCE = new CachedRelocator();
    @NotNull
    private static final File cacheFolder = FilesKt.resolve((File)EsuCore.Companion.getInstance().baseConfigPath().toFile(), (String)".cache/relocated");
    @NotNull
    private static final FileHashes cached = new FileHashes(cacheFolder);

    private CachedRelocator() {
    }

    @NotNull
    public final File relocate(@NotNull PackageRelocator relocator, @NotNull File file) {
        File output = FilesKt.resolve((File)cacheFolder, (String)file.getName());
        if (output.exists() && FileHashes.verify$default(cached, output, null, 2, null) && cached.verify(file, "original")) {
            return output;
        }
        output.getParentFile().mkdirs();
        relocator.relocate(file, output);
        FileHashes.store$default(cached, output, null, null, 6, null);
        FileHashes.store$default(cached, file, "original", null, 4, null);
        cached.save();
        return output;
    }
}

