/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.lib.org.spongepowered.configurate.objectmapping.meta;

import io.github.rothes.esu.lib.org.spongepowered.configurate.objectmapping.meta.PostProcess;
import io.github.rothes.esu.lib.org.spongepowered.configurate.serialize.SerializationException;
import io.github.rothes.esu.lib.org.spongepowered.configurate.util.Types;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface PostProcessor {
    public void postProcess(Object var1) throws SerializationException;

    public static Factory methodsAnnotated(Class<? extends Annotation> annotation) {
        return type -> {
            ArrayList<Method> methods = null;
            for (Method method : Types.allDeclaredMethods(GenericTypeReflector.erase(type))) {
                int modifiers;
                if (!method.isAnnotationPresent(annotation) || Modifier.isAbstract(modifiers = method.getModifiers())) continue;
                if (Modifier.isStatic(modifiers)) {
                    throw new SerializationException(type, "Post-processor method " + method.getName() + "() annotated @" + annotation.getSimpleName() + " must not be static.");
                }
                if (method.getParameterCount() != 0) {
                    throw new SerializationException(type, "Post-processor method " + method.getName() + "() annotated @" + annotation.getSimpleName() + " must not take any parameters.");
                }
                for (Class<?> exception : method.getExceptionTypes()) {
                    if (SerializationException.class.isAssignableFrom(exception)) continue;
                    throw new SerializationException(type, "Post-processor method " + method.getName() + "() annotated @" + annotation.getSimpleName() + " must only throw SerializationException or its subtypes, but is declared to throw " + exception.getSimpleName() + ".");
                }
                method.setAccessible(true);
                if (methods == null) {
                    methods = new ArrayList<Method>();
                }
                methods.add(method);
            }
            if (methods != null) {
                ArrayList<Method> finalMethods = methods;
                return instance -> {
                    SerializationException aggregateException = null;
                    for (Method postProcessorMethod : finalMethods) {
                        SerializationException exc = null;
                        try {
                            postProcessorMethod.invoke(instance, new Object[0]);
                        }
                        catch (InvocationTargetException ex) {
                            if (ex.getCause() instanceof SerializationException) {
                                exc = (SerializationException)ex.getCause();
                                exc.initType(type);
                            } else {
                                exc = ex.getCause() != null ? new SerializationException(type, "Failure occurred in post-processor method " + postProcessorMethod.getName() + "()", ex.getCause()) : new SerializationException(type, "Unknown error occurred attempting to invoke post-processor method " + postProcessorMethod.getName() + "()", (Throwable)ex);
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException ex) {
                            exc = new SerializationException(type, "Failed to invoke post-processor method " + postProcessorMethod.getName() + "()", (Throwable)ex);
                        }
                        if (exc == null) continue;
                        if (aggregateException == null) {
                            aggregateException = exc;
                            continue;
                        }
                        aggregateException.addSuppressed(exc);
                    }
                    if (aggregateException != null) {
                        throw aggregateException;
                    }
                };
            }
            return null;
        };
    }

    public static Factory methodsAnnotatedPostProcess() {
        return PostProcessor.methodsAnnotated(PostProcess.class);
    }

    @FunctionalInterface
    public static interface Factory {
        public @Nullable PostProcessor createProcessor(Type var1) throws SerializationException;
    }
}

