/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.util.artifact;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.rothes.esu.core.EsuBootstrap;
import io.github.rothes.esu.core.util.JvmUtils;
import io.github.rothes.esu.core.util.NetworkUtils;
import io.github.rothes.esu.core.util.artifact.MavenResolver;
import io.github.rothes.esu.core.util.artifact.injector.ReflectURLInjector;
import io.github.rothes.esu.core.util.artifact.injector.URLInjector;
import io.github.rothes.esu.core.util.artifact.injector.UnsafeURLInjector;
import io.github.rothes.esu.core.util.extension.CollectionsKt;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InaccessibleObjectException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.PatternExclusionsDependencyFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000201B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ>\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001c\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ8\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00062\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001e\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001c\u0010$\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150&J\u0006\u0010'\u001a\u00020(J \u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020(H\u0002J\b\u0010/\u001a\u00020(H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/github/rothes/esu/core/util/artifact/MavenResolver;", "", "<init>", "()V", "filter", "", "", "repository", "Lorg/eclipse/aether/RepositorySystem;", "session", "Lorg/eclipse/aether/RepositorySystemSession;", "repositories", "", "Lorg/eclipse/aether/repository/RemoteRepository;", "usingAliyun", "", "getUsingAliyun", "()Z", "injector", "Lio/github/rothes/esu/core/util/artifact/injector/URLInjector;", "loadKotlin", "", "loadUrl", "url", "Ljava/net/URL;", "loadDependencies", "libraries", "extraRepo", "loader", "Lkotlin/Function2;", "Ljava/io/File;", "Lorg/eclipse/aether/artifact/Artifact;", "loadDependency", "library", "resolveDependency", "Lorg/eclipse/aether/resolution/DependencyResult;", "testDependency", "scope", "Lkotlin/Function0;", "loadRepoConfiguration", "Lio/github/rothes/esu/core/util/artifact/MavenResolver$MavenRepo;", "saveRepoConfiguration", "gson", "Lcom/google/gson/Gson;", "file", "Ljava/nio/file/Path;", "repo", "findBestMavenRepo", "MavenRepos", "MavenRepo", "core"})
@SourceDebugExtension(value={"SMAP\nMavenResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenResolver.kt\nio/github/rothes/esu/core/util/artifact/MavenResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Collections.kt\nio/github/rothes/esu/core/util/extension/CollectionsKt\n*L\n1#1,241:1\n1#2:242\n20#3,4:243\n*S KotlinDebug\n*F\n+ 1 MavenResolver.kt\nio/github/rothes/esu/core/util/artifact/MavenResolver\n*L\n224#1:243,4\n*E\n"})
public final class MavenResolver {
    @NotNull
    public static final MavenResolver INSTANCE;
    @NotNull
    private static final Set<String> filter;
    @NotNull
    private static final RepositorySystem repository;
    @NotNull
    private static final RepositorySystemSession session;
    @NotNull
    private static final List<RemoteRepository> repositories;
    private static final boolean usingAliyun;
    @NotNull
    private static URLInjector injector;

    private MavenResolver() {
    }

    public final boolean getUsingAliyun() {
        return usingAliyun;
    }

    public final void loadKotlin() {
        this.loadDependency("org.jetbrains.kotlin:kotlin-reflect:2.2.20", CollectionsKt.listOfJvm(new RemoteRepository[0]));
        this.loadDependency("org.jetbrains.kotlinx:kotlinx-io-core-jvm:0.8.0", CollectionsKt.listOfJvm(new RemoteRepository[0]));
    }

    public final void loadUrl(@NotNull URL url) {
        try {
            injector.addURL(url);
        }
        catch (InaccessibleObjectException e) {
            if (Intrinsics.areEqual((Object)injector, (Object)UnsafeURLInjector.INSTANCE)) {
                injector = ReflectURLInjector.INSTANCE;
                injector.addURL(url);
            }
            throw e;
        }
    }

    public final void loadDependencies(@NotNull List<String> libraries, @NotNull List<RemoteRepository> extraRepo) {
        if (!(!((Collection)libraries).isEmpty())) {
            boolean $i$a$-require-MavenResolver$loadDependencies$22 = false;
            String $i$a$-require-MavenResolver$loadDependencies$22 = "Library must not be empty";
            throw new IllegalArgumentException($i$a$-require-MavenResolver$loadDependencies$22.toString());
        }
        for (String lib : libraries) {
            this.loadDependency(lib, extraRepo);
        }
    }

    public static /* synthetic */ void loadDependencies$default(MavenResolver mavenResolver, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        }
        mavenResolver.loadDependencies(list, list2);
    }

    public final void loadDependencies(@NotNull List<String> libraries, @NotNull List<RemoteRepository> extraRepo, @NotNull Function2<? super File, ? super Artifact, ? extends File> loader) {
        if (!(!((Collection)libraries).isEmpty())) {
            boolean $i$a$-require-MavenResolver$loadDependencies$32 = false;
            String $i$a$-require-MavenResolver$loadDependencies$32 = "Library must not be empty";
            throw new IllegalArgumentException($i$a$-require-MavenResolver$loadDependencies$32.toString());
        }
        for (String lib : libraries) {
            this.loadDependency(lib, extraRepo, loader);
        }
    }

    public static /* synthetic */ void loadDependencies$default(MavenResolver mavenResolver, List list, List list2, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        }
        mavenResolver.loadDependencies(list, list2, (Function2<? super File, ? super Artifact, ? extends File>)function2);
    }

    public final void loadDependency(@NotNull String library, @NotNull List<RemoteRepository> extraRepo) {
        DependencyResult result = this.resolveDependency(library, extraRepo);
        for (ArtifactResult it : result.getArtifactResults()) {
            Artifact artifact = it.getArtifact();
            File file = artifact.getFile();
            URL url = file.toURI().toURL();
            this.loadUrl(url);
            String str = artifact.getGroupId() + ":" + artifact.getArtifactId() + "::";
            filter.add(str);
        }
    }

    public final void loadDependency(@NotNull String library, @NotNull List<RemoteRepository> extraRepo, @NotNull Function2<? super File, ? super Artifact, ? extends File> loader) {
        DependencyResult result = this.resolveDependency(library, extraRepo);
        for (ArtifactResult it : result.getArtifactResults()) {
            Artifact artifact = it.getArtifact();
            File file = artifact.getFile();
            File toLoad = (File)loader.invoke((Object)file, (Object)artifact);
            URL url = toLoad.toURI().toURL();
            this.loadUrl(url);
            String str = artifact.getGroupId() + ":" + artifact.getArtifactId() + "::";
            filter.add(str);
        }
    }

    public static /* synthetic */ void loadDependency$default(MavenResolver mavenResolver, String string, List list, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        mavenResolver.loadDependency(string, list, (Function2<? super File, ? super Artifact, ? extends File>)function2);
    }

    private final DependencyResult resolveDependency(String library, List<RemoteRepository> extraRepo) {
        Dependency dependency = new Dependency((Artifact)new DefaultArtifact(library), null);
        DependencyResult result = null;
        int trys = 0;
        while (true) {
            try {
                ArrayList repo = new ArrayList(repositories);
                repo.addAll(extraRepo);
                result = repository.resolveDependencies(session, new DependencyRequest(new CollectRequest(null, CollectionsKt.listOfJvm(dependency), (List)repo), (DependencyFilter)new PatternExclusionsDependencyFilter((Collection)filter)));
            }
            catch (DependencyResolutionException e) {
                if (trys < 2) {
                    ++trys;
                    continue;
                }
                throw new RuntimeException("Error resolving libraries", e);
            }
            break;
        }
        return result;
    }

    public final void testDependency(@NotNull String library, @NotNull Function0<Unit> scope) {
        try {
            scope.invoke();
        }
        catch (Throwable throwable) {
            MavenResolver.loadDependencies$default(this, kotlin.collections.CollectionsKt.listOf((Object)library), null, 2, null);
        }
    }

    @NotNull
    public final MavenRepo loadRepoConfiguration() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path file = EsuBootstrap.Companion.getInstance().baseConfigPath().resolve("maven-repo.json");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return MavenResolver.loadRepoConfiguration$useBest(gson, file);
        }
        MavenRepo repo = (MavenRepo)gson.fromJson((Reader)new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), Charset.forName("UTF-8")), MavenRepo.class);
        MavenRepo mavenRepo = repo;
        if (mavenRepo == null) {
            mavenRepo = MavenResolver.loadRepoConfiguration$useBest(gson, file);
        }
        return mavenRepo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveRepoConfiguration(Gson gson, Path file, MavenRepo repo) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            File f = file.toFile();
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file, new OpenOption[0]), Charset.forName("UTF-8"));){
            void $this$saveRepoConfiguration_u24lambda_u240;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            OutputStreamWriter outputStreamWriter = writer;
            boolean bl = false;
            $this$saveRepoConfiguration_u24lambda_u240.append("// The Maven repository to download dependencies from. DO NOT change if you don't know about it.\n");
            $this$saveRepoConfiguration_u24lambda_u240.append("// Delete this file will re-run the latency test, and select the best automatically.\n");
            $this$saveRepoConfiguration_u24lambda_u240.append(gson.toJson((Object)repo));
            outputStreamWriter.append(stringBuilder.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final MavenRepo findBestMavenRepo() {
        EsuBootstrap.Companion.getInstance().info("Running latency test of maven repositories...");
        MavenRepo def = new MavenRepo("central", "https://maven-central.storage-download.googleapis.com/maven2/");
        MavenRepo[] mavenRepoArray = new MavenRepo[]{new MavenRepo("aliyun", "https://maven.aliyun.com/repository/public/"), def, new MavenRepo("central", "https://maven-central-eu.storage-download.googleapis.com/maven2/"), new MavenRepo("central", "https://maven-central-asia.storage-download.googleapis.com/maven2/")};
        List<MavenRepo> repos = CollectionsKt.listOfJvm(mavenRepoArray);
        Collection $this$mapJvm$iv = repos;
        boolean $i$f$mapJvm = false;
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"io/github/rothes/esu/core/util/artifact/MavenResolver$findBestMavenRepo$TestResult", "", "repo", "Lio/github/rothes/esu/core/util/artifact/MavenResolver$MavenRepo;", "latency", "", "<init>", "(Lio/github/rothes/esu/core/util/artifact/MavenResolver$MavenRepo;J)V", "getRepo", "()Lio/github/rothes/esu/core/util/artifact/MavenResolver$MavenRepo;", "getLatency", "()J", "component1", "component2", "copy", "(Lio/github/rothes/esu/core/util/artifact/MavenResolver$MavenRepo;J)Lio/github/rothes/esu/core/util/artifact/MavenResolver$findBestMavenRepo$TestResult;", "equals", "", "other", "hashCode", "", "toString", "", "core"})
        public final class TestResult {
            private final MavenRepo repo;
            private final long latency;

            public TestResult(MavenRepo repo, long latency) {
                this.repo = repo;
                this.latency = latency;
            }

            public final MavenRepo getRepo() {
                return this.repo;
            }

            public final long getLatency() {
                return this.latency;
            }

            public final MavenRepo component1() {
                return this.repo;
            }

            public final long component2() {
                return this.latency;
            }

            public final TestResult copy(MavenRepo repo, long latency) {
                return new TestResult(repo, latency);
            }

            public static /* synthetic */ TestResult copy$default(TestResult testResult, MavenRepo mavenRepo, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    mavenRepo = testResult.repo;
                }
                if ((n & 2) != 0) {
                    l = testResult.latency;
                }
                return testResult.copy(mavenRepo, l);
            }

            public String toString() {
                return "TestResult(repo=" + this.repo + ", latency=" + this.latency + ")";
            }

            public int hashCode() {
                int result = this.repo.hashCode();
                result = result * 31 + Long.hashCode(this.latency);
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TestResult)) {
                    return false;
                }
                TestResult testResult = (TestResult)other;
                if (!Intrinsics.areEqual((Object)this.repo, (Object)testResult.repo)) {
                    return false;
                }
                return this.latency == testResult.latency;
            }
        }
        ArrayList<TestResult> destination$iv = new ArrayList<TestResult>($this$mapJvm$iv.size());
        Iterator iterator = $this$mapJvm$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv = iterator.next();
            MavenRepo mavenRepo = (MavenRepo)item$iv;
            ArrayList<TestResult> arrayList = destination$iv;
            boolean bl = false;
            arrayList.add(new TestResult((MavenRepo)it, NetworkUtils.INSTANCE.getUriLatency(it.getUrl())));
        }
        List tested = destination$iv;
        Collections.sort(tested, MavenResolver::findBestMavenRepo$lambda$1);
        for (TestResult testResult : tested) {
            MavenRepo repo = testResult.component1();
            long latency = testResult.component2();
            EsuBootstrap.Companion.getInstance().info("'" + repo.getUrl() + "': " + latency + "ms");
        }
        TestResult best = (TestResult)tested.get(0);
        return best.getLatency() != Long.MAX_VALUE ? best.getRepo() : def;
    }

    private static final MavenRepo loadRepoConfiguration$useBest(Gson gson, Path file) {
        MavenRepo best = INSTANCE.findBestMavenRepo();
        INSTANCE.saveRepoConfiguration(gson, file, best);
        return best;
    }

    private static final long findBestMavenRepo$compareLatency(findBestMavenRepo.TestResult it) {
        return it.getLatency() >= 0L ? it.getLatency() : Long.MAX_VALUE;
    }

    private static final int findBestMavenRepo$lambda$1(findBestMavenRepo.TestResult a, findBestMavenRepo.TestResult b) {
        return JvmUtils.compareLong(MavenResolver.findBestMavenRepo$compareLatency(a), MavenResolver.findBestMavenRepo$compareLatency(b));
    }

    static {
        DefaultServiceLocator defaultServiceLocator;
        INSTANCE = new MavenResolver();
        filter = new LinkedHashSet();
        DefaultServiceLocator $this$repository_u24lambda_u240 = defaultServiceLocator = MavenRepositorySystemUtils.newServiceLocator();
        boolean bl = false;
        $this$repository_u24lambda_u240.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        $this$repository_u24lambda_u240.addService(TransporterFactory.class, HttpTransporterFactory.class);
        repository = (RepositorySystem)defaultServiceLocator.getService(RepositorySystem.class);
        DefaultServiceLocator $this$session_u24lambda_u240 = defaultServiceLocator = MavenRepositorySystemUtils.newSession();
        boolean bl2 = false;
        $this$session_u24lambda_u240.setSystemProperties((Map)System.getProperties());
        $this$session_u24lambda_u240.setChecksumPolicy("fail");
        $this$session_u24lambda_u240.setLocalRepositoryManager(repository.newLocalRepositoryManager((RepositorySystemSession)$this$session_u24lambda_u240, new LocalRepository("libraries")));
        $this$session_u24lambda_u240.setCache((RepositoryCache)new DefaultRepositoryCache());
        $this$session_u24lambda_u240.setUpdatePolicy("daily");
        $this$session_u24lambda_u240.setTransferListener((TransferListener)new AbstractTransferListener(){

            public void transferStarted(TransferEvent event) {
                EsuBootstrap.Companion.getInstance().info("Downloading " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
            }
        });
        $this$session_u24lambda_u240.setReadOnly();
        session = (RepositorySystemSession)defaultServiceLocator;
        injector = UnsafeURLInjector.INSTANCE;
        MavenRepo repo = INSTANCE.loadRepoConfiguration();
        repositories = repository.newResolutionRepositories(session, CollectionsKt.listOfJvm(new RemoteRepository.Builder(repo.getId(), "default", repo.getUrl()).build()));
        usingAliyun = repo.getId().equals("aliyun");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/github/rothes/esu/core/util/artifact/MavenResolver$MavenRepo;", "", "id", "", "url", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    public static final class MavenRepo {
        @NotNull
        private final String id;
        @NotNull
        private final String url;

        public MavenRepo(@NotNull String id, @NotNull String url) {
            this.id = id;
            this.url = url;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final MavenRepo copy(@NotNull String id, @NotNull String url) {
            return new MavenRepo(id, url);
        }

        public static /* synthetic */ MavenRepo copy$default(MavenRepo mavenRepo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = mavenRepo.id;
            }
            if ((n & 2) != 0) {
                string2 = mavenRepo.url;
            }
            return mavenRepo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MavenRepo(id=" + this.id + ", url=" + this.url + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.url.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MavenRepo)) {
                return false;
            }
            MavenRepo mavenRepo = (MavenRepo)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)mavenRepo.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.url, (Object)mavenRepo.url);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lio/github/rothes/esu/core/util/artifact/MavenResolver$MavenRepos;", "", "<init>", "()V", "NEO_FORGED", "Lorg/eclipse/aether/repository/RemoteRepository;", "getNEO_FORGED", "()Lorg/eclipse/aether/repository/RemoteRepository;", "CODEMC", "getCODEMC", "core"})
    public static final class MavenRepos {
        @NotNull
        public static final MavenRepos INSTANCE = new MavenRepos();
        @NotNull
        private static final RemoteRepository NEO_FORGED;
        @NotNull
        private static final RemoteRepository CODEMC;

        private MavenRepos() {
        }

        @NotNull
        public final RemoteRepository getNEO_FORGED() {
            return NEO_FORGED;
        }

        @NotNull
        public final RemoteRepository getCODEMC() {
            return CODEMC;
        }

        static {
            RemoteRepository remoteRepository = new RemoteRepository.Builder("NeoForged", "default", "https://maven.neoforged.net/releases/").build();
            Intrinsics.checkNotNull((Object)remoteRepository);
            NEO_FORGED = remoteRepository;
            RemoteRepository remoteRepository2 = new RemoteRepository.Builder("codemc", "default", "https://repo.codemc.org/repository/maven-public/").build();
            Intrinsics.checkNotNull((Object)remoteRepository2);
            CODEMC = remoteRepository2;
        }
    }
}

