/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.rothes.esu.bukkit.config.serializer.AttributeSerializer;
import io.github.rothes.esu.core.configuration.ConfigLoader;
import io.github.rothes.esu.core.util.DataSerializer;
import io.github.rothes.esu.lib.nbtapi.NBT;
import io.github.rothes.esu.lib.nbtapi.iface.ReadableNBT;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lio/github/rothes/esu/bukkit/util/BukkitDataSerializer;", "", "<init>", "()V", "BukkitLocationAdapter", "ItemStackAdapter", "bukkit"})
public final class BukkitDataSerializer {
    @NotNull
    public static final BukkitDataSerializer INSTANCE = new BukkitDataSerializer();

    private BukkitDataSerializer() {
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Location.class, (Object)BukkitLocationAdapter.INSTANCE), TuplesKt.to(ItemStack.class, (Object)ItemStackAdapter.INSTANCE)};
        DataSerializer.INSTANCE.registerTypeAdapter(pairArray);
        ConfigLoader.INSTANCE.registerSerializer(AttributeSerializer.INSTANCE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/bukkit/util/BukkitDataSerializer$BukkitLocationAdapter;", "Lcom/google/gson/JsonSerializer;", "Lorg/bukkit/Location;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "location", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "bukkit"})
    @SourceDebugExtension(value={"SMAP\nBukkitDataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BukkitDataSerializer.kt\nio/github/rothes/esu/bukkit/util/BukkitDataSerializer$BukkitLocationAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
    private static final class BukkitLocationAdapter
    implements JsonSerializer<Location>,
    JsonDeserializer<Location> {
        @NotNull
        public static final BukkitLocationAdapter INSTANCE = new BukkitLocationAdapter();

        private BukkitLocationAdapter() {
        }

        @NotNull
        public JsonElement serialize(@NotNull Location location, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            JsonObject jsonObject;
            JsonObject $this$serialize_u24lambda_u240 = jsonObject = new JsonObject();
            boolean bl = false;
            World world = location.getWorld();
            $this$serialize_u24lambda_u240.addProperty("world", world != null ? world.getName() : null);
            $this$serialize_u24lambda_u240.addProperty("x", (Number)location.getX());
            $this$serialize_u24lambda_u240.addProperty("y", (Number)location.getY());
            $this$serialize_u24lambda_u240.addProperty("z", (Number)location.getZ());
            $this$serialize_u24lambda_u240.addProperty("yaw", (Number)Float.valueOf(location.getYaw()));
            $this$serialize_u24lambda_u240.addProperty("pitch", (Number)Float.valueOf(location.getPitch()));
            return (JsonElement)jsonObject;
        }

        @NotNull
        public Location deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            World world;
            JsonObject obj = json.getAsJsonObject();
            Object object = obj.get("world");
            if (object != null && (object = object.getAsString()) != null) {
                Object it = object;
                boolean bl = false;
                world = Bukkit.getWorld((String)it);
            } else {
                world = null;
            }
            float f = obj.get("pitch").getAsFloat();
            float f2 = obj.get("yaw").getAsFloat();
            double d = obj.get("z").getAsDouble();
            double d2 = obj.get("y").getAsDouble();
            double d3 = obj.get("x").getAsDouble();
            World world2 = world;
            return new Location(world2, d3, d2, d, f2, f);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/bukkit/util/BukkitDataSerializer$ItemStackAdapter;", "Lcom/google/gson/JsonSerializer;", "Lorg/bukkit/inventory/ItemStack;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "item", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "bukkit"})
    private static final class ItemStackAdapter
    implements JsonSerializer<ItemStack>,
    JsonDeserializer<ItemStack> {
        @NotNull
        public static final ItemStackAdapter INSTANCE = new ItemStackAdapter();

        private ItemStackAdapter() {
        }

        @NotNull
        public JsonElement serialize(@NotNull ItemStack item, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            return (JsonElement)new JsonPrimitive(NBT.itemStackToNBT((ItemStack)item).toString());
        }

        @NotNull
        public ItemStack deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            String nbt = json.getAsJsonPrimitive().getAsString();
            ItemStack itemStack = NBT.itemStackFromNBT((ReadableNBT)((ReadableNBT)NBT.parseNBT((String)nbt)));
            if (itemStack == null) {
                throw new IllegalStateException(("Could not deserialize " + nbt).toString());
            }
            return itemStack;
        }
    }
}

