/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle.entityculling;

import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.module.networkthrottle.entityculling.CullDataManager;
import io.github.rothes.esu.bukkit.module.networkthrottle.entityculling.RaytraceHandler;
import io.github.rothes.esu.bukkit.util.scheduler.Scheduler;
import io.github.rothes.esu.bukkit.util.version.adapter.TickThreadAdapter;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0019J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0019J\b\u0010$\u001a\u00020\u0019H\u0002J\b\u0010%\u001a\u00020\u0019H\u0002J\b\u0010&\u001a\u00020\u0019H\u0002J \u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/UserCullData;", "", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "hiddenEntities", "Lit/unimi/dsi/fastutil/ints/Int2ReferenceOpenHashMap;", "Lorg/bukkit/entity/Entity;", "pendingChanges", "", "Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/UserCullData$CulledChange;", "tickedTime", "", "isRemoved", "", "terminated", "shouldCull", "getShouldCull", "()Z", "setShouldCull", "(Z)V", "setCulled", "", "entity", "entityId", "culled", "pend", "showAll", "tick", "onEntityRemove", "entities", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "markRemoved", "reset", "checkEntitiesValid", "updateChanges", "pendCulledChange", "CulledChange", "bukkit"})
public final class UserCullData {
    @NotNull
    private final Player player;
    @NotNull
    private final Int2ReferenceOpenHashMap<Entity> hiddenEntities;
    @NotNull
    private final List<CulledChange> pendingChanges;
    private int tickedTime;
    private boolean isRemoved;
    private boolean terminated;
    private boolean shouldCull;

    public UserCullData(@NotNull Player player) {
        this.player = player;
        this.hiddenEntities = new Int2ReferenceOpenHashMap(64, 0.5f);
        this.pendingChanges = new ArrayList();
        this.shouldCull = true;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final boolean getShouldCull() {
        return this.shouldCull;
    }

    public final void setShouldCull(boolean bl) {
        this.shouldCull = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCulled(@NotNull Entity entity, int entityId, boolean culled, boolean pend) {
        if (culled) {
            Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
            synchronized (int2ReferenceOpenHashMap) {
                boolean $i$a$-synchronized-UserCullData$setCulled$32 = false;
                if (this.hiddenEntities.put(entityId, (Object)entity) == null && pend) {
                    this.pendCulledChange(entity, entityId, true);
                }
                Unit $i$a$-synchronized-UserCullData$setCulled$32 = Unit.INSTANCE;
            }
        }
        Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
        synchronized (int2ReferenceOpenHashMap) {
            boolean bl = false;
            if (this.hiddenEntities.remove(entityId) != null && pend) {
                this.pendCulledChange(entity, entityId, false);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void setCulled$default(UserCullData userCullData, Entity entity, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        userCullData.setCulled(entity, n, bl, bl2);
    }

    public final void showAll() {
        this.reset();
        this.updateChanges();
    }

    public final void tick() {
        ++this.tickedTime;
        if (this.tickedTime >= 2400) {
            this.checkEntitiesValid();
        }
        this.updateChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onEntityRemove(@NotNull IntArrayList entities) {
        if (entities.isEmpty()) {
            return;
        }
        IntListIterator iterator = entities.listIterator();
        Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
        synchronized (int2ReferenceOpenHashMap) {
            boolean bl = false;
            while (iterator.hasNext()) {
                this.hiddenEntities.remove(iterator.nextInt());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void markRemoved() {
        this.isRemoved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reset() {
        Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
        synchronized (int2ReferenceOpenHashMap) {
            ObjectIterator iterator;
            boolean bl = false;
            ObjectIterator objectIterator = iterator = this.hiddenEntities.int2ReferenceEntrySet().iterator();
            while (((Iterator)objectIterator).hasNext()) {
                Int2ReferenceMap.Entry entry = (Int2ReferenceMap.Entry)objectIterator.next();
                int id = entry.getIntKey();
                Entity entity = (Entity)entry.getValue();
                iterator.remove();
                this.pendCulledChange(entity, id, false);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkEntitiesValid() {
        try {
            Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
            synchronized (int2ReferenceOpenHashMap) {
                ObjectIterator iterator;
                boolean bl = false;
                RaytraceHandler<?, ?> raytraceHandler = CullDataManager.INSTANCE.getRaytraceHandler();
                ObjectIterator objectIterator = iterator = this.hiddenEntities.int2ReferenceEntrySet().iterator();
                while (((Iterator)objectIterator).hasNext()) {
                    Int2ReferenceMap.Entry entry = (Int2ReferenceMap.Entry)objectIterator.next();
                    Entity entity = (Entity)entry.getValue();
                    if (raytraceHandler.isValid(entity)) continue;
                    iterator.remove();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Throwable e) {
            InternalsKt.getPlugin().err("[EntityCulling] Failed to check entities valid for player " + this.player.getName(), e);
        }
    }

    private final void updateChanges() {
        if (this.terminated) {
            return;
        }
        if (this.pendingChanges.isEmpty()) {
            return;
        }
        List list = CollectionsKt.toList((Iterable)this.pendingChanges);
        this.pendingChanges.clear();
        if (InternalsKt.getPlugin().isEnabled()) {
            Scheduler.schedule$default(Scheduler.INSTANCE, (Entity)this.player, null, () -> UserCullData.updateChanges$lambda$0(list, this), 2, null);
        }
    }

    private final void pendCulledChange(Entity entity, int entityId, boolean culled) {
        this.pendingChanges.add(new CulledChange(entity, entityId, culled));
    }

    private static final Unit updateChanges$lambda$0(List $list, UserCullData this$0) {
        RaytraceHandler<?, ?> raytraceHandler = CullDataManager.INSTANCE.getRaytraceHandler();
        for (CulledChange change : $list) {
            if (!raytraceHandler.isValid(change.getEntity())) continue;
            if (!TickThreadAdapter.Companion.checkTickThread(change.getEntity())) {
                if (change.getCulled()) continue;
                this$0.setCulled(change.getEntity(), change.getEntityId(), true, false);
                continue;
            }
            if (change.getCulled()) {
                this$0.player.hideEntity((Plugin)InternalsKt.getBootstrap(), change.getEntity());
                continue;
            }
            this$0.player.showEntity((Plugin)InternalsKt.getBootstrap(), change.getEntity());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/UserCullData$CulledChange;", "", "entity", "Lorg/bukkit/entity/Entity;", "entityId", "", "culled", "", "<init>", "(Lorg/bukkit/entity/Entity;IZ)V", "getEntity", "()Lorg/bukkit/entity/Entity;", "getEntityId", "()I", "getCulled", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "bukkit"})
    private static final class CulledChange {
        @NotNull
        private final Entity entity;
        private final int entityId;
        private final boolean culled;

        public CulledChange(@NotNull Entity entity, int entityId, boolean culled) {
            this.entity = entity;
            this.entityId = entityId;
            this.culled = culled;
        }

        @NotNull
        public final Entity getEntity() {
            return this.entity;
        }

        public final int getEntityId() {
            return this.entityId;
        }

        public final boolean getCulled() {
            return this.culled;
        }

        @NotNull
        public final Entity component1() {
            return this.entity;
        }

        public final int component2() {
            return this.entityId;
        }

        public final boolean component3() {
            return this.culled;
        }

        @NotNull
        public final CulledChange copy(@NotNull Entity entity, int entityId, boolean culled) {
            return new CulledChange(entity, entityId, culled);
        }

        public static /* synthetic */ CulledChange copy$default(CulledChange culledChange, Entity entity, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                entity = culledChange.entity;
            }
            if ((n2 & 2) != 0) {
                n = culledChange.entityId;
            }
            if ((n2 & 4) != 0) {
                bl = culledChange.culled;
            }
            return culledChange.copy(entity, n, bl);
        }

        @NotNull
        public String toString() {
            return "CulledChange(entity=" + this.entity + ", entityId=" + this.entityId + ", culled=" + this.culled + ")";
        }

        public int hashCode() {
            int result = this.entity.hashCode();
            result = result * 31 + Integer.hashCode(this.entityId);
            result = result * 31 + Boolean.hashCode(this.culled);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CulledChange)) {
                return false;
            }
            CulledChange culledChange = (CulledChange)other;
            if (!Intrinsics.areEqual((Object)this.entity, (Object)culledChange.entity)) {
                return false;
            }
            if (this.entityId != culledChange.entityId) {
                return false;
            }
            return this.culled == culledChange.culled;
        }
    }
}

