/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.util;

import io.github.rothes.esu.core.EsuCore;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\t\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0015\u0010\u000b\u001a\u00020\u0005*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/rothes/esu/core/util/NetworkUtils;", "", "<init>", "()V", "uriLatency", "", "", "getUriLatency", "(Ljava/lang/String;)J", "hostLatency", "getHostLatency", "latency", "Ljava/net/URL;", "getLatency", "(Ljava/net/URL;)J", "core"})
public final class NetworkUtils {
    @NotNull
    public static final NetworkUtils INSTANCE = new NetworkUtils();

    private NetworkUtils() {
    }

    public final long getUriLatency(@NotNull String $this$uriLatency) {
        return this.getLatency(URI.create($this$uriLatency).toURL());
    }

    public final long getHostLatency(@NotNull String $this$hostLatency) {
        try {
            InetAddress address = InetAddress.getByName($this$hostLatency);
            long start = System.currentTimeMillis();
            boolean reachable = address.isReachable(500);
            if (!reachable) {
                return -1L;
            }
            long latency = System.currentTimeMillis() - start;
            return latency;
        }
        catch (IOException e) {
            EsuCore.Companion.getInstance().err("Failed to test latency to " + $this$hostLatency + " : " + e);
            return -1L;
        }
    }

    public final long getLatency(@NotNull URL $this$latency) {
        return this.getHostLatency($this$latency.getHost());
    }
}

