/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.util;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import io.github.rothes.esu.core.EsuCore;
import io.github.rothes.esu.core.config.EsuLocale;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.user.LogUser;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.core.util.ComponentUtils;
import io.github.rothes.esu.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0007$%&'()*B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n\u0012\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\f\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0010J\u0006\u0010\u001d\u001a\u00020\rJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\b\b\u0002\u0010#\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/github/rothes/esu/core/util/UpdateChecker;", "", "versionId", "", "channel", "", "platform", "console", "Lio/github/rothes/esu/core/user/LogUser;", "actionScope", "Ljava/util/EnumMap;", "Lio/github/rothes/esu/core/util/UpdateChecker$VersionAction;", "Lkotlin/Function0;", "", "allUsers", "", "Lio/github/rothes/esu/core/user/User;", "premRoot", "<init>", "(ILjava/lang/String;Ljava/lang/String;Lio/github/rothes/esu/core/user/LogUser;Ljava/util/EnumMap;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "perm", "messageTimesMap", "", "messages", "", "Lio/github/rothes/esu/core/util/UpdateChecker$RemoteMessage;", "errorCount", "onJoin", "user", "run", "fetch", "Lio/github/rothes/esu/core/util/UpdateChecker$CheckedInfo;", "getResponse", "Lio/github/rothes/esu/core/util/UpdateChecker$FetchedResponse;", "domain", "tryTimes", "FetchedResponse", "Response", "CheckedInfo", "Notification", "VersionAction", "LocaledMessage", "RemoteMessage", "core"})
@SourceDebugExtension(value={"SMAP\nUpdateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateChecker.kt\nio/github/rothes/esu/core/util/UpdateChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n774#2:190\n865#2,2:191\n1869#2,2:193\n1563#2:196\n1634#2,3:197\n1#3:195\n*S KotlinDebug\n*F\n+ 1 UpdateChecker.kt\nio/github/rothes/esu/core/util/UpdateChecker\n*L\n71#1:190\n71#1:191,2\n72#1:193,2\n104#1:196\n104#1:197,3\n*E\n"})
public final class UpdateChecker {
    private final int versionId;
    @NotNull
    private final String channel;
    @NotNull
    private final String platform;
    @NotNull
    private final LogUser console;
    @NotNull
    private final EnumMap<VersionAction, Function0<Unit>> actionScope;
    @NotNull
    private final Function0<Iterable<User>> allUsers;
    @NotNull
    private final String perm;
    @NotNull
    private final Map<String, Integer> messageTimesMap;
    @NotNull
    private final List<RemoteMessage> messages;
    private int errorCount;

    public UpdateChecker(int versionId, @NotNull String channel, @NotNull String platform, @NotNull LogUser console, @NotNull EnumMap<VersionAction, Function0<Unit>> actionScope, @NotNull Function0<? extends Iterable<? extends User>> allUsers, @NotNull String premRoot) {
        this.versionId = versionId;
        this.channel = channel;
        this.platform = platform;
        this.console = console;
        this.actionScope = actionScope;
        this.allUsers = allUsers;
        this.perm = premRoot + ".updater.receive";
        this.messageTimesMap = new LinkedHashMap();
        this.messages = new ArrayList();
    }

    public final void onJoin(@NotNull User user) {
        if (user.hasPermission(this.perm)) {
            for (RemoteMessage msg : this.messages) {
                TagResolver[] tagResolverArray = msg.getArgs();
                user.message((MessageData)user.localed(msg.getLangMap(), UpdateChecker::onJoin$lambda$0), Arrays.copyOf(tagResolverArray, tagResolverArray.length));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void run() {
        CheckedInfo info = this.fetch();
        for (LocaledMessage message : info.getErrorMessage()) {
            TagResolver[] tagResolverArray = message.getArgs();
            this.console.log(EsuLocale.Companion.get(), message.getScope(), Arrays.copyOf(tagResolverArray, tagResolverArray.length));
        }
        if (info.getNotifications() == null) {
            return;
        }
        this.messages.clear();
        for (Notification notification : info.getNotifications()) {
            for (VersionAction action : notification.getActions()) {
                Function0<Unit> function0 = this.actionScope.get((Object)action);
                if (function0 != null) {
                    function0.invoke();
                    continue;
                }
                EsuCore.Companion.getInstance().warn("Unknown update checker action " + action);
            }
            if (notification.getMessageTimes() > 0) {
                String key = (String)CollectionsKt.first((Iterable)notification.getMessage().values());
                int curr = ((Number)this.messageTimesMap.getOrDefault(key, 0)).intValue();
                if (curr >= notification.getMessageTimes()) continue;
                this.messageTimesMap.put(key, curr + 1);
            }
            TagResolver.Single[] curr = new TagResolver.Single[]{ComponentUtils.INSTANCE.unparsed("latest_version", info.getLatestVersionName())};
            TagResolver.Single[] args = curr;
            RemoteMessage msg = new RemoteMessage(notification.getMessage(), (TagResolver[])Arrays.copyOf(args, args.length));
            Object object = msg.getArgs();
            this.console.log((MessageData)this.console.localed(msg.getLangMap(), UpdateChecker::run$lambda$0), Arrays.copyOf(object, ((TagResolver[])object).length));
            if (notification.getNotifyInGame()) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                object = (Iterable)this.allUsers.invoke();
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    User it = (User)element$iv$iv;
                    boolean bl = false;
                    if (!it.hasPermission(this.perm)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    User user = (User)element$iv;
                    boolean bl = false;
                    TagResolver[] tagResolverArray = msg.getArgs();
                    user.message((MessageData)user.localed(msg.getLangMap(), UpdateChecker::run$lambda$2$0), Arrays.copyOf(tagResolverArray, tagResolverArray.length));
                }
            }
            this.messages.add(msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckedInfo fetch() {
        Object[] objectArray;
        List list;
        FetchedResponse fetch = UpdateChecker.getResponse$default(this, "ghfast.top/https://raw.githubusercontent.com", 0, 2, null);
        List errors = new ArrayList();
        LocaledMessage localedMessage = fetch.getErrorMessage();
        if (localedMessage != null) {
            LocaledMessage it = localedMessage;
            boolean bl = false;
            errors.add(it);
        }
        Response response = fetch.getResponse();
        if (response == null) {
            return new CheckedInfo(null, "unknown", errors);
        }
        Response response2 = response;
        List $this$fetch_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.messages.clear();
        Map<String, Response.VersionInfo> map = response2.getVersionChannel().get(this.channel);
        if (map != null) {
            Map<String, Response.VersionInfo> channel = map;
            boolean bl2 = false;
            Response.VersionInfo versionInfo = channel.get(this.platform);
            if (versionInfo != null) {
                Response.VersionInfo info = versionInfo;
                boolean bl3 = false;
                if (this.versionId < info.getLatestVersionId()) {
                    $this$fetch_u24lambda_u241.add(info.getNotification());
                }
            } else {
                objectArray = new TagResolver[]{ComponentUtils.INSTANCE.unparsed("platform", this.platform)};
                UpdateChecker.fetch$err(errors, objectArray, (Function1<? super EsuLocale.BaseEsuLocaleData, String>)((Function1)UpdateChecker::fetch$lambda$1$0$1));
            }
        } else {
            TagResolver[] tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.unparsed("channel", this.channel)};
            UpdateChecker.fetch$err(errors, tagResolverArray, (Function1<? super EsuLocale.BaseEsuLocaleData, String>)((Function1)UpdateChecker::fetch$lambda$1$1));
        }
        Map<String, Notification> map2 = response2.getVersionAction().get(this.platform);
        if (map2 != null) {
            Map<String, Notification> map3 = map2;
            boolean bl4 = false;
            for (Map.Entry<String, Notification> entry : map3.entrySet()) {
                void $this$mapTo$iv$iv;
                String range = entry.getKey();
                Notification notification = entry.getValue();
                objectArray = new char[1];
                objectArray[0] = (TagResolver)45;
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)range, (char[])objectArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(Integer.parseInt((String)it));
                }
                List versions = (List)destination$iv$iv;
                int n = ((Number)versions.get(0)).intValue();
                int n2 = ((Number)versions.get(1)).intValue();
                int n3 = this.versionId;
                boolean bl6 = n <= n3 ? n3 <= n2 : false;
                if (!bl6) continue;
                $this$fetch_u24lambda_u241.add(notification);
            }
        }
        List list2 = CollectionsKt.build((List)list);
        Map<String, Response.VersionInfo> map4 = response2.getVersionChannel().get(this.channel);
        if (map4 == null || (map4 = (Response.VersionInfo)map4.get(this.platform)) == null || (map4 = ((Response.VersionInfo)((Object)map4)).getLatestVersionName()) == null) {
            map4 = "unknown";
        }
        List list3 = errors;
        Map<String, Response.VersionInfo> map5 = map4;
        List list4 = list2;
        return new CheckedInfo(list4, (String)((Object)map5), list3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FetchedResponse getResponse(String domain, int tryTimes) {
        try {
            Closeable closeable = new URI("https://" + domain + "/Rothes/ESU/master/Updater_Data.json").toURL().openStream();
            Object object = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
            object = null;
            try {
                FetchedResponse fetchedResponse;
                BufferedReader reader2 = (BufferedReader)closeable;
                boolean bl = false;
                String json = TextStreamsKt.readText((Reader)reader2);
                FetchedResponse it = fetchedResponse = new FetchedResponse((Response)new Gson().fromJson(json, Response.class), null, 2, null);
                boolean bl2 = false;
                this.errorCount = 0;
                FetchedResponse fetchedResponse2 = fetchedResponse;
                return fetchedResponse2;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        catch (Throwable e) {
            if (tryTimes == 0) {
                return this.getResponse("raw.githubusercontent.com", 1);
            }
            if (this.errorCount < 3) {
                int n = this.errorCount;
                this.errorCount = n + 1;
                TagResolver[] tagResolverArray = new TagResolver[]{ComponentUtils.INSTANCE.unparsed("message", e)};
                return new FetchedResponse(null, new LocaledMessage(tagResolverArray, (Function1<? super EsuLocale.BaseEsuLocaleData, String>)((Function1)UpdateChecker::getResponse$lambda$1)), 1, null);
            }
            return new FetchedResponse(null, null, 3, null);
        }
    }

    static /* synthetic */ FetchedResponse getResponse$default(UpdateChecker updateChecker, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return updateChecker.getResponse(string, n);
    }

    private static final MessageData onJoin$lambda$0(String it) {
        return MessageData.Companion.getMessage(it);
    }

    private static final MessageData run$lambda$0(String it) {
        return MessageData.Companion.getMessage(it);
    }

    private static final MessageData run$lambda$2$0(String it) {
        return MessageData.Companion.getMessage(it);
    }

    private static final void fetch$err(List<LocaledMessage> errors, TagResolver[] arg, Function1<? super EsuLocale.BaseEsuLocaleData, String> scope) {
        errors.add(new LocaledMessage(Arrays.copyOf(arg, arg.length), scope));
    }

    private static final String fetch$lambda$1$0$1(EsuLocale.BaseEsuLocaleData $this$err) {
        return $this$err.getUpdater().getChecker().getUnknownPlatform();
    }

    private static final String fetch$lambda$1$1(EsuLocale.BaseEsuLocaleData $this$err) {
        return $this$err.getUpdater().getChecker().getUnknownChannel();
    }

    private static final String getResponse$lambda$1(EsuLocale.BaseEsuLocaleData $this$LocaledMessage) {
        return $this$LocaledMessage.getUpdater().getChecker().getNetworkError();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u001a"}, d2={"Lio/github/rothes/esu/core/util/UpdateChecker$CheckedInfo;", "", "notifications", "", "Lio/github/rothes/esu/core/util/UpdateChecker$Notification;", "latestVersionName", "", "errorMessage", "Lio/github/rothes/esu/core/util/UpdateChecker$LocaledMessage;", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/util/List;)V", "getNotifications", "()Ljava/util/List;", "getLatestVersionName", "()Ljava/lang/String;", "getErrorMessage", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    public static final class CheckedInfo {
        @Nullable
        private final List<Notification> notifications;
        @NotNull
        private final String latestVersionName;
        @NotNull
        private final List<LocaledMessage> errorMessage;

        public CheckedInfo(@Nullable List<Notification> notifications, @NotNull String latestVersionName, @NotNull List<LocaledMessage> errorMessage) {
            this.notifications = notifications;
            this.latestVersionName = latestVersionName;
            this.errorMessage = errorMessage;
        }

        public /* synthetic */ CheckedInfo(List list, String string, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list, string, list2);
        }

        @Nullable
        public final List<Notification> getNotifications() {
            return this.notifications;
        }

        @NotNull
        public final String getLatestVersionName() {
            return this.latestVersionName;
        }

        @NotNull
        public final List<LocaledMessage> getErrorMessage() {
            return this.errorMessage;
        }

        @Nullable
        public final List<Notification> component1() {
            return this.notifications;
        }

        @NotNull
        public final String component2() {
            return this.latestVersionName;
        }

        @NotNull
        public final List<LocaledMessage> component3() {
            return this.errorMessage;
        }

        @NotNull
        public final CheckedInfo copy(@Nullable List<Notification> notifications, @NotNull String latestVersionName, @NotNull List<LocaledMessage> errorMessage) {
            return new CheckedInfo(notifications, latestVersionName, errorMessage);
        }

        public static /* synthetic */ CheckedInfo copy$default(CheckedInfo checkedInfo, List list, String string, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = checkedInfo.notifications;
            }
            if ((n & 2) != 0) {
                string = checkedInfo.latestVersionName;
            }
            if ((n & 4) != 0) {
                list2 = checkedInfo.errorMessage;
            }
            return checkedInfo.copy(list, string, list2);
        }

        @NotNull
        public String toString() {
            return "CheckedInfo(notifications=" + this.notifications + ", latestVersionName=" + this.latestVersionName + ", errorMessage=" + this.errorMessage + ")";
        }

        public int hashCode() {
            int result = this.notifications == null ? 0 : ((Object)this.notifications).hashCode();
            result = result * 31 + this.latestVersionName.hashCode();
            result = result * 31 + ((Object)this.errorMessage).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CheckedInfo)) {
                return false;
            }
            CheckedInfo checkedInfo = (CheckedInfo)other;
            if (!Intrinsics.areEqual(this.notifications, checkedInfo.notifications)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.latestVersionName, (Object)checkedInfo.latestVersionName)) {
                return false;
            }
            return Intrinsics.areEqual(this.errorMessage, checkedInfo.errorMessage);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/github/rothes/esu/core/util/UpdateChecker$FetchedResponse;", "", "response", "Lio/github/rothes/esu/core/util/UpdateChecker$Response;", "errorMessage", "Lio/github/rothes/esu/core/util/UpdateChecker$LocaledMessage;", "<init>", "(Lio/github/rothes/esu/core/util/UpdateChecker$Response;Lio/github/rothes/esu/core/util/UpdateChecker$LocaledMessage;)V", "getResponse", "()Lio/github/rothes/esu/core/util/UpdateChecker$Response;", "getErrorMessage", "()Lio/github/rothes/esu/core/util/UpdateChecker$LocaledMessage;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    private static final class FetchedResponse {
        @Nullable
        private final Response response;
        @Nullable
        private final LocaledMessage errorMessage;

        public FetchedResponse(@Nullable Response response, @Nullable LocaledMessage errorMessage) {
            this.response = response;
            this.errorMessage = errorMessage;
        }

        public /* synthetic */ FetchedResponse(Response response, LocaledMessage localedMessage, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                response = null;
            }
            if ((n & 2) != 0) {
                localedMessage = null;
            }
            this(response, localedMessage);
        }

        @Nullable
        public final Response getResponse() {
            return this.response;
        }

        @Nullable
        public final LocaledMessage getErrorMessage() {
            return this.errorMessage;
        }

        @Nullable
        public final Response component1() {
            return this.response;
        }

        @Nullable
        public final LocaledMessage component2() {
            return this.errorMessage;
        }

        @NotNull
        public final FetchedResponse copy(@Nullable Response response, @Nullable LocaledMessage errorMessage) {
            return new FetchedResponse(response, errorMessage);
        }

        public static /* synthetic */ FetchedResponse copy$default(FetchedResponse fetchedResponse, Response response, LocaledMessage localedMessage, int n, Object object) {
            if ((n & 1) != 0) {
                response = fetchedResponse.response;
            }
            if ((n & 2) != 0) {
                localedMessage = fetchedResponse.errorMessage;
            }
            return fetchedResponse.copy(response, localedMessage);
        }

        @NotNull
        public String toString() {
            return "FetchedResponse(response=" + this.response + ", errorMessage=" + this.errorMessage + ")";
        }

        public int hashCode() {
            int result = this.response == null ? 0 : this.response.hashCode();
            result = result * 31 + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FetchedResponse)) {
                return false;
            }
            FetchedResponse fetchedResponse = (FetchedResponse)other;
            if (!Intrinsics.areEqual((Object)this.response, (Object)fetchedResponse.response)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.errorMessage, (Object)fetchedResponse.errorMessage);
        }

        public FetchedResponse() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B6\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u0012\u0019\u0010\u0005\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR$\u0010\u0005\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/core/util/UpdateChecker$LocaledMessage;", "", "args", "", "Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;", "scope", "Lkotlin/Function1;", "Lio/github/rothes/esu/core/config/EsuLocale$BaseEsuLocaleData;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "([Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;Lkotlin/jvm/functions/Function1;)V", "getArgs", "()[Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;", "[Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;", "getScope", "()Lkotlin/jvm/functions/Function1;", "core"})
    public static final class LocaledMessage {
        @NotNull
        private final TagResolver[] args;
        @NotNull
        private final Function1<EsuLocale.BaseEsuLocaleData, String> scope;

        public LocaledMessage(@NotNull TagResolver[] args, @NotNull Function1<? super EsuLocale.BaseEsuLocaleData, String> scope) {
            this.args = args;
            this.scope = scope;
        }

        @NotNull
        public final TagResolver[] getArgs() {
            return this.args;
        }

        @NotNull
        public final Function1<EsuLocale.BaseEsuLocaleData, String> getScope() {
            return this.scope;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003JC\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u000bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lio/github/rothes/esu/core/util/UpdateChecker$Notification;", "", "actions", "", "Lio/github/rothes/esu/core/util/UpdateChecker$VersionAction;", "messageTimes", "", "notifyInGame", "", "message", "", "", "<init>", "(Ljava/util/List;IZLjava/util/Map;)V", "getActions", "()Ljava/util/List;", "getMessageTimes", "()I", "getNotifyInGame", "()Z", "getMessage", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "core"})
    public static final class Notification {
        @NotNull
        private final List<VersionAction> actions;
        @SerializedName(value="message_times")
        private final int messageTimes;
        @SerializedName(value="notify_in_game")
        private final boolean notifyInGame;
        @NotNull
        private final Map<String, String> message;

        public Notification(@NotNull List<? extends VersionAction> actions, int messageTimes, boolean notifyInGame, @NotNull Map<String, String> message) {
            this.actions = actions;
            this.messageTimes = messageTimes;
            this.notifyInGame = notifyInGame;
            this.message = message;
        }

        @NotNull
        public final List<VersionAction> getActions() {
            return this.actions;
        }

        public final int getMessageTimes() {
            return this.messageTimes;
        }

        public final boolean getNotifyInGame() {
            return this.notifyInGame;
        }

        @NotNull
        public final Map<String, String> getMessage() {
            return this.message;
        }

        @NotNull
        public final List<VersionAction> component1() {
            return this.actions;
        }

        public final int component2() {
            return this.messageTimes;
        }

        public final boolean component3() {
            return this.notifyInGame;
        }

        @NotNull
        public final Map<String, String> component4() {
            return this.message;
        }

        @NotNull
        public final Notification copy(@NotNull List<? extends VersionAction> actions, int messageTimes, boolean notifyInGame, @NotNull Map<String, String> message) {
            return new Notification(actions, messageTimes, notifyInGame, message);
        }

        public static /* synthetic */ Notification copy$default(Notification notification, List list, int n, boolean bl, Map map, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = notification.actions;
            }
            if ((n2 & 2) != 0) {
                n = notification.messageTimes;
            }
            if ((n2 & 4) != 0) {
                bl = notification.notifyInGame;
            }
            if ((n2 & 8) != 0) {
                map = notification.message;
            }
            return notification.copy(list, n, bl, map);
        }

        @NotNull
        public String toString() {
            return "Notification(actions=" + this.actions + ", messageTimes=" + this.messageTimes + ", notifyInGame=" + this.notifyInGame + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result = ((Object)this.actions).hashCode();
            result = result * 31 + Integer.hashCode(this.messageTimes);
            result = result * 31 + Boolean.hashCode(this.notifyInGame);
            result = result * 31 + ((Object)this.message).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Notification)) {
                return false;
            }
            Notification notification = (Notification)other;
            if (!Intrinsics.areEqual(this.actions, notification.actions)) {
                return false;
            }
            if (this.messageTimes != notification.messageTimes) {
                return false;
            }
            if (this.notifyInGame != notification.notifyInGame) {
                return false;
            }
            return Intrinsics.areEqual(this.message, notification.message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lio/github/rothes/esu/core/util/UpdateChecker$RemoteMessage;", "", "langMap", "", "", "args", "", "Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;", "<init>", "(Ljava/util/Map;[Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;)V", "getLangMap", "()Ljava/util/Map;", "getArgs", "()[Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;", "[Lio/github/rothes/esu/lib/adventure/text/minimessage/tag/resolver/TagResolver;", "core"})
    public static final class RemoteMessage {
        @NotNull
        private final Map<String, String> langMap;
        @NotNull
        private final TagResolver[] args;

        public RemoteMessage(@NotNull Map<String, String> langMap, TagResolver ... args) {
            this.langMap = langMap;
            this.args = args;
        }

        @NotNull
        public final Map<String, String> getLangMap() {
            return this.langMap;
        }

        @NotNull
        public final TagResolver[] getArgs() {
            return this.args;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0016BG\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0003\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00030\u0003\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0003H\u00c6\u0003J!\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00030\u0003H\u00c6\u0003JM\u0010\u000f\u001a\u00020\u00002 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u00032 \b\u0002\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00030\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R.\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR.\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00030\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/github/rothes/esu/core/util/UpdateChecker$Response;", "", "versionChannel", "", "", "Lio/github/rothes/esu/core/util/UpdateChecker$Response$VersionInfo;", "versionAction", "Lio/github/rothes/esu/core/util/UpdateChecker$Notification;", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getVersionChannel", "()Ljava/util/Map;", "getVersionAction", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "VersionInfo", "core"})
    private static final class Response {
        @SerializedName(value="version_channel")
        @NotNull
        private final Map<String, Map<String, VersionInfo>> versionChannel;
        @SerializedName(value="version_action")
        @NotNull
        private final Map<String, Map<String, Notification>> versionAction;

        public Response(@NotNull Map<String, ? extends Map<String, VersionInfo>> versionChannel, @NotNull Map<String, ? extends Map<String, Notification>> versionAction) {
            this.versionChannel = versionChannel;
            this.versionAction = versionAction;
        }

        @NotNull
        public final Map<String, Map<String, VersionInfo>> getVersionChannel() {
            return this.versionChannel;
        }

        @NotNull
        public final Map<String, Map<String, Notification>> getVersionAction() {
            return this.versionAction;
        }

        @NotNull
        public final Map<String, Map<String, VersionInfo>> component1() {
            return this.versionChannel;
        }

        @NotNull
        public final Map<String, Map<String, Notification>> component2() {
            return this.versionAction;
        }

        @NotNull
        public final Response copy(@NotNull Map<String, ? extends Map<String, VersionInfo>> versionChannel, @NotNull Map<String, ? extends Map<String, Notification>> versionAction) {
            return new Response(versionChannel, versionAction);
        }

        public static /* synthetic */ Response copy$default(Response response, Map map, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map = response.versionChannel;
            }
            if ((n & 2) != 0) {
                map2 = response.versionAction;
            }
            return response.copy(map, map2);
        }

        @NotNull
        public String toString() {
            return "Response(versionChannel=" + this.versionChannel + ", versionAction=" + this.versionAction + ")";
        }

        public int hashCode() {
            int result = ((Object)this.versionChannel).hashCode();
            result = result * 31 + ((Object)this.versionAction).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Response)) {
                return false;
            }
            Response response = (Response)other;
            if (!Intrinsics.areEqual(this.versionChannel, response.versionChannel)) {
                return false;
            }
            return Intrinsics.areEqual(this.versionAction, response.versionAction);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/core/util/UpdateChecker$Response$VersionInfo;", "", "latestVersionId", "", "latestVersionName", "", "notification", "Lio/github/rothes/esu/core/util/UpdateChecker$Notification;", "<init>", "(ILjava/lang/String;Lio/github/rothes/esu/core/util/UpdateChecker$Notification;)V", "getLatestVersionId", "()I", "getLatestVersionName", "()Ljava/lang/String;", "getNotification", "()Lio/github/rothes/esu/core/util/UpdateChecker$Notification;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "core"})
        public static final class VersionInfo {
            @SerializedName(value="latest_version_id")
            private final int latestVersionId;
            @SerializedName(value="latest_version_name")
            @NotNull
            private final String latestVersionName;
            @NotNull
            private final Notification notification;

            public VersionInfo(int latestVersionId, @NotNull String latestVersionName, @NotNull Notification notification) {
                this.latestVersionId = latestVersionId;
                this.latestVersionName = latestVersionName;
                this.notification = notification;
            }

            public final int getLatestVersionId() {
                return this.latestVersionId;
            }

            @NotNull
            public final String getLatestVersionName() {
                return this.latestVersionName;
            }

            @NotNull
            public final Notification getNotification() {
                return this.notification;
            }

            public final int component1() {
                return this.latestVersionId;
            }

            @NotNull
            public final String component2() {
                return this.latestVersionName;
            }

            @NotNull
            public final Notification component3() {
                return this.notification;
            }

            @NotNull
            public final VersionInfo copy(int latestVersionId, @NotNull String latestVersionName, @NotNull Notification notification) {
                return new VersionInfo(latestVersionId, latestVersionName, notification);
            }

            public static /* synthetic */ VersionInfo copy$default(VersionInfo versionInfo, int n, String string, Notification notification, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = versionInfo.latestVersionId;
                }
                if ((n2 & 2) != 0) {
                    string = versionInfo.latestVersionName;
                }
                if ((n2 & 4) != 0) {
                    notification = versionInfo.notification;
                }
                return versionInfo.copy(n, string, notification);
            }

            @NotNull
            public String toString() {
                return "VersionInfo(latestVersionId=" + this.latestVersionId + ", latestVersionName=" + this.latestVersionName + ", notification=" + this.notification + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.latestVersionId);
                result = result * 31 + this.latestVersionName.hashCode();
                result = result * 31 + this.notification.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VersionInfo)) {
                    return false;
                }
                VersionInfo versionInfo = (VersionInfo)other;
                if (this.latestVersionId != versionInfo.latestVersionId) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.latestVersionName, (Object)versionInfo.latestVersionName)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.notification, (Object)versionInfo.notification);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/github/rothes/esu/core/util/UpdateChecker$VersionAction;", "", "<init>", "(Ljava/lang/String;I)V", "PROHIBIT", "core"})
    public static final class VersionAction
    extends Enum<VersionAction> {
        public static final /* enum */ VersionAction PROHIBIT = new VersionAction();
        private static final /* synthetic */ VersionAction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VersionAction[] values() {
            return (VersionAction[])$VALUES.clone();
        }

        public static VersionAction valueOf(String value) {
            return Enum.valueOf(VersionAction.class, value);
        }

        @NotNull
        public static EnumEntries<VersionAction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = versionActionArray = new VersionAction[]{VersionAction.PROHIBIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

