/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.velocity.module.networkthrottle;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.scheduler.ScheduledTask;
import io.github.rothes.esu.core.command.annotation.ShortPerm;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.core.util.ComponentUtils;
import io.github.rothes.esu.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import io.github.rothes.esu.velocity.InternalsKt;
import io.github.rothes.esu.velocity.module.NetworkThrottleModule;
import io.github.rothes.esu.velocity.module.VelocityModule;
import io.github.rothes.esu.velocity.module.networkthrottle.TrafficMonitor;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.DecoderChannelHandler;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.EncoderChannelHandler;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.Injector;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.PacketData;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Commands;
import org.incendo.cloud.annotations.Flag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004&'()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\u001eJ\u0016\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0007J\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0006R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u001e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006*"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/TrafficMonitor;", "", "<init>", "()V", "viewers", "Ljava/util/LinkedHashMap;", "Lio/github/rothes/esu/core/user/User;", "Lio/github/rothes/esu/velocity/module/networkthrottle/TrafficMonitor$Unit;", "Lkotlin/collections/LinkedHashMap;", "task", "Lcom/velocitypowered/api/scheduler/ScheduledTask;", "forceRun", "Ljava/util/concurrent/atomic/AtomicInteger;", "outgoingBytes", "Ljava/util/concurrent/atomic/AtomicLong;", "outgoingPps", "incomingBytes", "incomingPps", "value", "", "lastOutgoingBytes", "getLastOutgoingBytes", "()J", "lastOutgoingPps", "getLastOutgoingPps", "lastIncomingBytes", "getLastIncomingBytes", "lastIncomingPps", "getLastIncomingPps", "enable", "", "disable", "forceRecord", "cancelForceRecord", "addViewer", "user", "unit", "removeViewer", "Listeners", "EncoderHandler", "DecoderHandler", "Unit", "velocity"})
public final class TrafficMonitor {
    @NotNull
    public static final TrafficMonitor INSTANCE = new TrafficMonitor();
    @NotNull
    private static LinkedHashMap<User, Unit> viewers = new LinkedHashMap();
    @Nullable
    private static ScheduledTask task;
    @NotNull
    private static AtomicInteger forceRun;
    @NotNull
    private static AtomicLong outgoingBytes;
    @NotNull
    private static AtomicLong outgoingPps;
    @NotNull
    private static AtomicLong incomingBytes;
    @NotNull
    private static AtomicLong incomingPps;
    private static long lastOutgoingBytes;
    private static long lastOutgoingPps;
    private static long lastIncomingBytes;
    private static long lastIncomingPps;

    private TrafficMonitor() {
    }

    public final long getLastOutgoingBytes() {
        return lastOutgoingBytes;
    }

    public final long getLastOutgoingPps() {
        return lastOutgoingPps;
    }

    public final long getLastIncomingBytes() {
        return lastIncomingBytes;
    }

    public final long getLastIncomingPps() {
        return lastIncomingPps;
    }

    public final void enable() {
        task = InternalsKt.getPlugin().getServer().getScheduler().buildTask((Object)InternalsKt.getPlugin().getBootstrap(), TrafficMonitor::enable$lambda$0).repeat(Duration.ofSeconds(1L)).schedule();
        VelocityModule.registerListener$default(NetworkThrottleModule.INSTANCE, Listeners.INSTANCE, null, 2, null);
        VelocityModule.registerCommands$default(NetworkThrottleModule.INSTANCE, new Object(){

            @Commands(value={@Command(value="vnetwork trafficMonitor"), @Command(value="vnetwork trafficMonitor toggle")})
            @ShortPerm(value="trafficMonitor")
            public final void toggle(User sender, @Flag(value="unit") Unit unit) {
                if (!((Map)TrafficMonitor.access$getViewers$p()).containsKey(sender)) {
                    this.enable(sender, unit);
                } else {
                    this.disable(sender);
                }
            }

            public static /* synthetic */ void toggle$default(enable.2 var0, User user, Unit unit, int n, Object object) {
                if ((n & 2) != 0) {
                    unit = Unit.BIT;
                }
                var0.toggle(user, unit);
            }

            @Command(value="vnetwork trafficMonitor enable")
            @ShortPerm(value="trafficMonitor")
            public final void enable(User sender, @Flag(value="unit") Unit unit) {
                TrafficMonitor.INSTANCE.addViewer(sender, unit);
                sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.2::enable$lambda$0, new TagResolver[0]);
            }

            public static /* synthetic */ void enable$default(enable.2 var0, User user, Unit unit, int n, Object object) {
                if ((n & 2) != 0) {
                    unit = Unit.BIT;
                }
                var0.enable(user, unit);
            }

            @Command(value="vnetwork trafficMonitor disable")
            @ShortPerm(value="trafficMonitor")
            public final void disable(User sender) {
                TrafficMonitor.INSTANCE.removeViewer(sender);
                sender.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), enable.2::disable$lambda$1, new TagResolver[0]);
            }

            private static final MessageData enable$lambda$0(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getTrafficMonitor().getEnabled();
            }

            private static final MessageData disable$lambda$1(NetworkThrottleModule.ModuleLang $this$message) {
                return $this$message.getTrafficMonitor().getDisabled();
            }
        }, null, 2, null);
    }

    public final void disable() {
        ScheduledTask scheduledTask = task;
        if (scheduledTask != null) {
            scheduledTask.cancel();
        }
        VelocityModule.unregisterListener$default(NetworkThrottleModule.INSTANCE, Listeners.INSTANCE, null, 2, null);
        if (!((Map)viewers).isEmpty()) {
            viewers.clear();
            Injector.INSTANCE.unregisterHandler(EncoderHandler.INSTANCE);
            Injector.INSTANCE.unregisterHandler(DecoderHandler.INSTANCE);
        }
    }

    public final void forceRecord() {
        if (forceRun.getAndAdd(1) == 0) {
            Injector.INSTANCE.registerHandler(EncoderHandler.INSTANCE);
            Injector.INSTANCE.registerHandler(DecoderHandler.INSTANCE);
        }
    }

    public final void cancelForceRecord() {
        if (forceRun.addAndGet(-1) == 0 && viewers.isEmpty()) {
            Injector.INSTANCE.unregisterHandler(EncoderHandler.INSTANCE);
            Injector.INSTANCE.unregisterHandler(DecoderHandler.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addViewer(@NotNull User user, @NotNull Unit unit) {
        LinkedHashMap<User, Unit> linkedHashMap = viewers;
        synchronized (linkedHashMap) {
            boolean bl = false;
            if (viewers.isEmpty()) {
                Injector.INSTANCE.registerHandler(EncoderHandler.INSTANCE);
                Injector.INSTANCE.registerHandler(DecoderHandler.INSTANCE);
            }
            ((Map)viewers).put(user, unit);
            kotlin.Unit unit2 = kotlin.Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeViewer(@NotNull User user) {
        LinkedHashMap<User, Unit> linkedHashMap = viewers;
        synchronized (linkedHashMap) {
            boolean bl = false;
            viewers.remove(user);
            if (viewers.isEmpty() && forceRun.get() == 0) {
                Injector.INSTANCE.unregisterHandler(EncoderHandler.INSTANCE);
                Injector.INSTANCE.unregisterHandler(DecoderHandler.INSTANCE);
            }
            kotlin.Unit unit = kotlin.Unit.INSTANCE;
        }
    }

    private static final void enable$lambda$0(ScheduledTask task) {
        long ppsO = (long)((double)outgoingPps.getAndSet(0L) * ((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getTrafficCalibration().getOutgoingPpsMultiplier());
        long bytesO = outgoingBytes.getAndSet(0L) + ppsO * (long)46;
        long ppsI = (long)((double)incomingPps.getAndSet(0L) * ((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getTrafficCalibration().getIncomingPpsMultiplier());
        long bytesI = incomingBytes.getAndSet(0L) + ppsI * (long)46;
        lastOutgoingPps = ppsO;
        lastOutgoingBytes = bytesO;
        lastIncomingPps = ppsI;
        lastIncomingBytes = bytesI;
        for (Map.Entry entry : ((Map)viewers).entrySet()) {
            User user = (User)entry.getKey();
            Unit unit = (Unit)((Object)entry.getValue());
            TagResolver[] tagResolverArray = new TagResolver[]{TrafficMonitor.enable$lambda$0$traffic(bytesO, "outgoing-traffic", unit), ComponentUtils.amount$default(ComponentUtils.INSTANCE, ppsO, "outgoing-pps", null, null, null, null, 60, null), TrafficMonitor.enable$lambda$0$traffic(bytesI, "incoming-traffic", unit), ComponentUtils.amount$default(ComponentUtils.INSTANCE, ppsI, "incoming-pps", null, null, null, null, 60, null)};
            user.sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), TrafficMonitor::enable$lambda$0$0, tagResolverArray);
        }
    }

    private static final TagResolver enable$lambda$0$traffic(long bytes, String key, Unit unit) {
        TagResolver tagResolver;
        switch (WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
            case 1: {
                tagResolver = ComponentUtils.INSTANCE.bytes(bytes * (long)8, key, " Gbps", " Mbps", " Kbps", " bps");
                break;
            }
            case 2: {
                tagResolver = ComponentUtils.INSTANCE.bytes(bytes, key, " GiB/s", " MiB/s", " KiB/s", " B/s");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return tagResolver;
    }

    private static final MessageData enable$lambda$0$0(NetworkThrottleModule.ModuleLang $this$message) {
        return $this$message.getTrafficMonitor().getMessage();
    }

    static {
        forceRun = new AtomicInteger(0);
        outgoingBytes = new AtomicLong(0L);
        outgoingPps = new AtomicLong(0L);
        incomingBytes = new AtomicLong(0L);
        incomingPps = new AtomicLong(0L);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/TrafficMonitor$DecoderHandler;", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/DecoderChannelHandler;", "<init>", "()V", "decode", "", "packetData", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/PacketData;", "velocity"})
    public static final class DecoderHandler
    implements DecoderChannelHandler {
        @NotNull
        public static final DecoderHandler INSTANCE = new DecoderHandler();

        private DecoderHandler() {
        }

        @Override
        public void decode(@NotNull PacketData packetData) {
            incomingBytes.addAndGet(packetData.getCompressedSize());
            incomingPps.incrementAndGet();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/TrafficMonitor$EncoderHandler;", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/EncoderChannelHandler;", "<init>", "()V", "encode", "", "packetData", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/PacketData;", "flush", "velocity"})
    public static final class EncoderHandler
    implements EncoderChannelHandler {
        @NotNull
        public static final EncoderHandler INSTANCE = new EncoderHandler();

        private EncoderHandler() {
        }

        @Override
        public void encode(@NotNull PacketData packetData) {
            outgoingBytes.addAndGet(packetData.getCompressedSize());
        }

        @Override
        public void flush() {
            outgoingPps.incrementAndGet();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/TrafficMonitor$Listeners;", "", "<init>", "()V", "onDisconnect", "", "e", "Lcom/velocitypowered/api/event/connection/DisconnectEvent;", "velocity"})
    public static final class Listeners {
        @NotNull
        public static final Listeners INSTANCE = new Listeners();

        private Listeners() {
        }

        @Subscribe
        public final void onDisconnect(@NotNull DisconnectEvent e) {
            viewers.remove(InternalsKt.getUser(e.getPlayer()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/TrafficMonitor$Unit;", "", "<init>", "(Ljava/lang/String;I)V", "BIT", "BYTE", "velocity"})
    public static final class Unit
    extends Enum<Unit> {
        public static final /* enum */ Unit BIT = new Unit();
        public static final /* enum */ Unit BYTE = new Unit();
        private static final /* synthetic */ Unit[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Unit[] values() {
            return (Unit[])$VALUES.clone();
        }

        public static Unit valueOf(String value) {
            return Enum.valueOf(Unit.class, value);
        }

        @NotNull
        public static EnumEntries<Unit> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = unitArray = new Unit[]{Unit.BIT, Unit.BYTE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Unit.values().length];
            try {
                nArray[Unit.BIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

