/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.storage;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.github.rothes.esu.core.EsuCore;
import io.github.rothes.esu.core.config.EsuConfig;
import io.github.rothes.esu.core.storage.StorageManager;
import io.github.rothes.esu.core.user.ConsoleConst;
import io.github.rothes.esu.core.user.User;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.ColumnSet;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.FieldSet;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.SqlExpressionBuilder;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.statements.BatchInsertStatement;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.core.statements.UpdateBuilder;
import org.jetbrains.exposed.v1.core.statements.UpdateStatement;
import org.jetbrains.exposed.v1.core.statements.UpsertStatement;
import org.jetbrains.exposed.v1.exceptions.ExposedSQLException;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.QueriesKt;
import org.jetbrains.exposed.v1.jdbc.SchemaUtils;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionManager;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionManagerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u001f !\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001e\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lio/github/rothes/esu/core/storage/StorageManager;", "", "<init>", "()V", "datasource", "Lcom/zaxxer/hikari/HikariDataSource;", "database", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "getDatabase", "()Lorg/jetbrains/exposed/v1/jdbc/Database;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "getUuid", "Ljava/util/UUID;", "userId", "", "getUserData", "Lio/github/rothes/esu/core/storage/StorageManager$UserData;", "where", "getUserDataByName", "", "getConsoleUserData", "updateUserNow", "", "user", "Lio/github/rothes/esu/core/user/User;", "updateUserAsync", "doUpdateUser", "shutdown", "MetaTable", "UsersTable", "UserData", "TableUpgrader", "core"})
public final class StorageManager {
    @NotNull
    public static final StorageManager INSTANCE;
    @NotNull
    private static final HikariDataSource datasource;
    @NotNull
    private static final Database database;
    @NotNull
    private static final CoroutineScope coroutineScope;

    private StorageManager() {
    }

    @NotNull
    public final Database getDatabase() {
        return database;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return coroutineScope;
    }

    @Nullable
    public final UUID getUuid(int userId) {
        UsersTable $this$getUuid_u24lambda_u248 = UsersTable.INSTANCE;
        boolean bl = false;
        return (UUID)TransactionManagerKt.transaction((Database)database, arg_0 -> StorageManager.getUuid$lambda$8$lambda$7($this$getUuid_u24lambda_u248, userId, arg_0));
    }

    @NotNull
    public final UserData getUserData(@NotNull UUID where) {
        UsersTable $this$getUserData_u24lambda_u2412 = UsersTable.INSTANCE;
        boolean bl = false;
        return (UserData)TransactionManagerKt.transaction((Database)database, arg_0 -> StorageManager.getUserData$lambda$12$lambda$11($this$getUserData_u24lambda_u2412, where, arg_0));
    }

    @Nullable
    public final UserData getUserDataByName(@NotNull String where) {
        UsersTable $this$getUserDataByName_u24lambda_u2415 = UsersTable.INSTANCE;
        boolean bl = false;
        return (UserData)TransactionManagerKt.transaction((Database)database, arg_0 -> StorageManager.getUserDataByName$lambda$15$lambda$14($this$getUserDataByName_u24lambda_u2415, where, arg_0));
    }

    @NotNull
    public final UserData getConsoleUserData() {
        UsersTable $this$getConsoleUserData_u24lambda_u2418 = UsersTable.INSTANCE;
        boolean bl = false;
        return (UserData)TransactionManagerKt.transaction((Database)database, arg_0 -> StorageManager.getConsoleUserData$lambda$18$lambda$17($this$getConsoleUserData_u24lambda_u2418, arg_0));
    }

    public final void updateUserNow(@NotNull User user) {
        TransactionManagerKt.transaction((Database)database, arg_0 -> StorageManager.updateUserNow$lambda$23(user, arg_0));
    }

    public final void updateUserAsync(@NotNull User user) {
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(user, null){
            int label;
            final /* synthetic */ User $user;
            {
                this.$user = $user;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        StorageManager.INSTANCE.updateUserNow(this.$user);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)3, null);
    }

    private final void doUpdateUser(User user) {
        UsersTable $this$doUpdateUser_u24lambda_u2426 = UsersTable.INSTANCE;
        boolean bl = false;
        QueriesKt.update$default((Table)$this$doUpdateUser_u24lambda_u2426, arg_0 -> StorageManager.doUpdateUser$lambda$26$lambda$24($this$doUpdateUser_u24lambda_u2426, user, arg_0), null, (arg_0, arg_1) -> StorageManager.doUpdateUser$lambda$26$lambda$25(user, arg_0, arg_1), (int)2, null);
    }

    public final void shutdown() {
        datasource.close();
        TransactionManager.Companion.closeAndUnregister(database);
    }

    private static final Unit database$lambda$2$lambda$1(JdbcTransaction $this$transaction) {
        JdbcTransaction.exec$default((JdbcTransaction)$this$transaction, (String)"SET MODE=MYSQL", null, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$lambda$4$lambda$3(1.1.oldTable.1 $oldTable, BatchInsertStatement $this$batchInsert, ResultRow data) {
        $this$batchInsert.set(UsersTable.INSTANCE.getDbId(), data.get((Expression)$oldTable.getDbId()));
        $this$batchInsert.set(UsersTable.INSTANCE.getUuid(), (Object)UUID.fromString((String)data.get((Expression)$oldTable.getUuid())));
        $this$batchInsert.set(UsersTable.INSTANCE.getName(), data.get((Expression)$oldTable.getName()));
        $this$batchInsert.set(UsersTable.INSTANCE.getLanguage(), data.get((Expression)$oldTable.getLanguage()));
        $this$batchInsert.set(UsersTable.INSTANCE.getColorScheme(), data.get((Expression)$oldTable.getColorScheme()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$lambda$4(JdbcTransaction $this_transaction) {
        System.out.println((Object)"Upgrading UsersTable");
        JdbcTransaction.exec$default((JdbcTransaction)$this_transaction, (String)("ALTER TABLE `" + UsersTable.INSTANCE.getTableName() + "` RENAME TO `" + UsersTable.INSTANCE.getTableName() + "_old`"), null, null, (int)6, null);
        Table oldTable2 = new Table(){
            private final Column<Integer> dbId;
            private final Column<String> uuid;
            private final Column<String> name;
            private final Column<String> language;
            private final Column<String> colorScheme;
            {
                this.dbId = Table.autoIncrement$default((Table)this, (Column)Table.integer$default((Table)this, (String)"id", null, (int)2, null), null, (int)1, null);
                this.uuid = Table.uniqueIndex$default((Table)this, (Column)Table.varchar$default((Table)this, (String)"uuid", (int)36, null, (int)4, null), null, (int)1, null);
                this.name = Table.uniqueIndex$default((Table)this, (Column)this.nullable(Table.varchar$default((Table)this, (String)"name", (int)16, null, (int)4, null)), null, (int)1, null);
                this.language = this.nullable(Table.varchar$default((Table)this, (String)"language", (int)12, null, (int)4, null));
                this.colorScheme = this.nullable(Table.varchar$default((Table)this, (String)"color_scheme", (int)32, null, (int)4, null));
            }

            public final Column<Integer> getDbId() {
                return this.dbId;
            }

            public final Column<String> getUuid() {
                return this.uuid;
            }

            public final Column<String> getName() {
                return this.name;
            }

            public final Column<String> getLanguage() {
                return this.language;
            }

            public final Column<String> getColorScheme() {
                return this.colorScheme;
            }
        };
        Table[] tableArray = new UsersTable[]{UsersTable.INSTANCE};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (int)2, null);
        QueriesKt.batchInsert$default((Table)UsersTable.INSTANCE, (Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)oldTable2))), (boolean)false, (boolean)false, (arg_0, arg_1) -> StorageManager.lambda$6$lambda$4$lambda$3(oldTable2, arg_0, arg_1), (int)6, null);
        tableArray = new Table[]{oldTable2};
        SchemaUtils.drop$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$lambda$5(UsersTable $this$insertIgnore, UpdateBuilder it) {
        it.set($this$insertIgnore.getDbId(), (Object)1);
        it.set($this$insertIgnore.getUuid(), (Object)ConsoleConst.INSTANCE.getUUID());
        it.set($this$insertIgnore.getName(), (Object)"[Console]");
        return Unit.INSTANCE;
    }

    private static final InsertStatement _init_$lambda$6(JdbcTransaction $this$transaction) {
        Object[] objectArray = new MetaTable[]{MetaTable.INSTANCE};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])objectArray, (boolean)false, (int)2, null);
        objectArray = new Function0[]{() -> StorageManager.lambda$6$lambda$4($this$transaction)};
        TableUpgrader tableUpgrader = new TableUpgrader(UsersTable.INSTANCE, 2, (Function0<Unit>[])objectArray);
        objectArray = new UsersTable[]{UsersTable.INSTANCE};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])objectArray, (boolean)false, (int)2, null);
        return QueriesKt.insertIgnore((Table)UsersTable.INSTANCE, StorageManager::lambda$6$lambda$5);
    }

    private static final UUID getUuid$lambda$8$lambda$7(UsersTable $this_with, int $userId, JdbcTransaction $this$transaction) {
        ResultRow resultRow = (ResultRow)CollectionsKt.singleOrNull((Iterable)QueriesKt.select((ColumnSet)((ColumnSet)$this_with), (Expression)((Expression)$this_with.getUuid()), (Expression[])new Expression[0]).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)$this_with.getDbId(), (Object)$userId)));
        return resultRow != null ? (UUID)resultRow.get((Expression)$this_with.getUuid()) : null;
    }

    private static final Unit getUserData$lambda$12$lambda$11$lambda$10(UUID $where, UsersTable $this$insert, InsertStatement it) {
        it.set($this$insert.getUuid(), (Object)$where);
        return Unit.INSTANCE;
    }

    private static final UserData getUserData$lambda$12$lambda$11(UsersTable $this_with, UUID $where, JdbcTransaction $this$transaction) {
        UserData userData;
        Expression[] expressionArray = new Expression[]{$this_with.getLanguage(), $this_with.getColorScheme()};
        ResultRow resultRow = (ResultRow)CollectionsKt.singleOrNull((Iterable)QueriesKt.select((ColumnSet)((ColumnSet)$this_with), (Expression)((Expression)$this_with.getDbId()), (Expression[])expressionArray).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)$this_with.getUuid(), (Object)$where)));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            userData = new UserData(((Number)it.get((Expression)$this_with.getDbId())).intValue(), $where, (String)it.get((Expression)$this_with.getLanguage()), (String)it.get((Expression)$this_with.getColorScheme()));
        } else {
            userData = new UserData(((Number)QueriesKt.insert((Table)$this_with, (arg_0, arg_1) -> StorageManager.getUserData$lambda$12$lambda$11$lambda$10($where, arg_0, arg_1)).get($this_with.getDbId())).intValue(), $where, null, null);
        }
        return userData;
    }

    private static final UserData getUserDataByName$lambda$15$lambda$14(UsersTable $this_with, String $where, JdbcTransaction $this$transaction) {
        UserData userData;
        Expression[] expressionArray = new Expression[]{$this_with.getDbId(), $this_with.getLanguage(), $this_with.getColorScheme()};
        ResultRow resultRow = (ResultRow)CollectionsKt.singleOrNull((Iterable)QueriesKt.select((ColumnSet)((ColumnSet)$this_with), (Expression)((Expression)$this_with.getUuid()), (Expression[])expressionArray).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)$this_with.getName(), (Object)$where)));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            userData = new UserData(((Number)it.get((Expression)$this_with.getDbId())).intValue(), (UUID)it.get((Expression)$this_with.getUuid()), (String)it.get((Expression)$this_with.getLanguage()), (String)it.get((Expression)$this_with.getColorScheme()));
        } else {
            userData = null;
        }
        return userData;
    }

    private static final UserData getConsoleUserData$lambda$18$lambda$17(UsersTable $this_with, JdbcTransaction $this$transaction) {
        Expression[] expressionArray = new Expression[]{$this_with.getColorScheme()};
        ResultRow it = (ResultRow)CollectionsKt.single((Iterable)QueriesKt.select((ColumnSet)((ColumnSet)$this_with), (Expression)((Expression)$this_with.getLanguage()), (Expression[])expressionArray).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)$this_with.getDbId(), (Object)1)));
        boolean bl = false;
        return new UserData(1, ConsoleConst.INSTANCE.getUUID(), (String)it.get((Expression)$this_with.getLanguage()), (String)it.get((Expression)$this_with.getColorScheme()));
    }

    private static final Op updateUserNow$lambda$23$lambda$22$lambda$21$lambda$19(UsersTable $this_with, UserData $get, SqlExpressionBuilder $this$update) {
        return $this$update.eq((ExpressionWithColumnType)$this_with.getDbId(), (Object)$get.getDbId());
    }

    private static final Unit updateUserNow$lambda$23$lambda$22$lambda$21$lambda$20(UsersTable $this$update, UpdateStatement it) {
        it.set($this$update.getName(), null);
        return Unit.INSTANCE;
    }

    private static final Unit updateUserNow$lambda$23(User $user, JdbcTransaction $this$transaction) {
        Unit unit;
        try {
            INSTANCE.doUpdateUser($user);
            unit = Unit.INSTANCE;
        }
        catch (ExposedSQLException e) {
            Unit unit2;
            if (e.getCause() instanceof SQLIntegrityConstraintViolationException) {
                EsuCore.Companion.getInstance().err("Failed to update user " + $user.getDbId() + " data " + $user.getNameUnsafe() + " (" + $user.getUuid() + "): " + e.getMessage());
                String string = $user.getNameUnsafe();
                if (string != null) {
                    String dbName = string;
                    boolean bl = false;
                    UserData get = INSTANCE.getUserDataByName(dbName);
                    if (get != null) {
                        EsuCore.Companion.getInstance().warn("Current in db user " + get.getDbId() + ": " + $user.getNameUnsafe() + " (" + get.getUuid() + ")");
                        if (get.getDbId() != $user.getDbId()) {
                            UsersTable $this$updateUserNow_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421 = UsersTable.INSTANCE;
                            boolean bl2 = false;
                            QueriesKt.update$default((Table)$this$updateUserNow_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421, arg_0 -> StorageManager.updateUserNow$lambda$23$lambda$22$lambda$21$lambda$19($this$updateUserNow_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421, get, arg_0), null, StorageManager::updateUserNow$lambda$23$lambda$22$lambda$21$lambda$20, (int)2, null);
                            INSTANCE.doUpdateUser($user);
                            EsuCore.Companion.getInstance().warn("Re-attached name " + $user.getNameUnsafe() + " to user " + $user.getDbId());
                        }
                    }
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
            } else {
                throw e;
            }
            unit = unit2;
        }
        return unit;
    }

    private static final Op doUpdateUser$lambda$26$lambda$24(UsersTable $this_with, User $user, SqlExpressionBuilder $this$update) {
        return $this$update.eq((ExpressionWithColumnType)$this_with.getDbId(), (Object)$user.getDbId());
    }

    private static final Unit doUpdateUser$lambda$26$lambda$25(User $user, UsersTable $this$update, UpdateStatement it) {
        it.set($this$update.getName(), (Object)$user.getNameUnsafe());
        it.set($this$update.getLanguage(), (Object)$user.getLanguageUnsafe());
        it.set($this$update.getColorScheme(), (Object)$user.getColorSchemeUnsafe());
        return Unit.INSTANCE;
    }

    static {
        HikariConfig hikariConfig;
        INSTANCE = new StorageManager();
        HikariConfig $this$datasource_u24lambda_u240 = hikariConfig = new HikariConfig();
        boolean bl = false;
        $this$datasource_u24lambda_u240.setPoolName("ESU-HikariPool");
        $this$datasource_u24lambda_u240.setDriverClassName(EsuConfig.INSTANCE.get().getDatabase().getDriverClassName());
        $this$datasource_u24lambda_u240.setJdbcUrl(EsuConfig.INSTANCE.get().getDatabase().getUrl());
        $this$datasource_u24lambda_u240.setUsername(EsuConfig.INSTANCE.get().getDatabase().getUsername());
        $this$datasource_u24lambda_u240.setPassword(EsuConfig.INSTANCE.get().getDatabase().getPassword());
        HikariConfig hikariConfig2 = hikariConfig;
        datasource = new HikariDataSource(hikariConfig2);
        try {
            HikariConfig it = hikariConfig = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)((DataSource)datasource), null, null, null, null, (int)30, null);
            boolean bl2 = false;
            if (StringsKt.startsWith$default(EsuConfig.INSTANCE.get().getDatabase().getUrl(), "jdbc:h2:", false, 2, null)) {
                TransactionManagerKt.transaction((Database)it, StorageManager::database$lambda$2$lambda$1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
        database = hikariConfig;
        coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        TransactionManagerKt.transaction((Database)database, StorageManager::_init_$lambda$6);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0018\u0010\u000b\u001a\u00060\fR\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/rothes/esu/core/storage/StorageManager$MetaTable;", "Lorg/jetbrains/exposed/v1/core/Table;", "<init>", "()V", "key", "Lorg/jetbrains/exposed/v1/core/Column;", "", "getKey", "()Lorg/jetbrains/exposed/v1/core/Column;", "value", "getValue", "primaryKey", "Lorg/jetbrains/exposed/v1/core/Table$PrimaryKey;", "getPrimaryKey", "()Lorg/jetbrains/exposed/v1/core/Table$PrimaryKey;", "core"})
    public static final class MetaTable
    extends Table {
        @NotNull
        public static final MetaTable INSTANCE = new MetaTable();
        @NotNull
        private static final Column<String> key = Table.varchar$default((Table)INSTANCE, (String)"key", (int)32, null, (int)4, null);
        @NotNull
        private static final Column<String> value = Table.text$default((Table)INSTANCE, (String)"value", null, (boolean)false, (int)6, null);
        @NotNull
        private static final Table.PrimaryKey primaryKey = new Table.PrimaryKey((Table)INSTANCE, key, new Column[0], null, 4, null);

        private MetaTable() {
            super("metadata");
        }

        @NotNull
        public final Column<String> getKey() {
            return key;
        }

        @NotNull
        public final Column<String> getValue() {
            return value;
        }

        @NotNull
        public Table.PrimaryKey getPrimaryKey() {
            return primaryKey;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001e\u0010\u0006\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\"\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/github/rothes/esu/core/storage/StorageManager$TableUpgrader;", "", "table", "Lorg/jetbrains/exposed/v1/core/Table;", "version", "", "upgradeHandlers", "", "Lkotlin/Function0;", "", "<init>", "(Lorg/jetbrains/exposed/v1/core/Table;I[Lkotlin/jvm/functions/Function0;)V", "core"})
    @SourceDebugExtension(value={"SMAP\nStorageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageManager.kt\nio/github/rothes/esu/core/storage/StorageManager$TableUpgrader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1563#2:219\n1634#2,3:220\n1#3:223\n*S KotlinDebug\n*F\n+ 1 StorageManager.kt\nio/github/rothes/esu/core/storage/StorageManager$TableUpgrader\n*L\n204#1:219\n204#1:220,3\n*E\n"})
    public static final class TableUpgrader {
        /*
         * WARNING - void declaration
         */
        public TableUpgrader(@NotNull Table table, int version, Function0<Unit> ... upgradeHandlers) {
            void $this$mapTo$iv$iv;
            String tableName = table.getTableName();
            String tbKey = "tbv_" + tableName;
            Iterable $this$map$iv = SchemaUtils.INSTANCE.listTables();
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.substringAfter$default((String)it, '.', null, 2, null));
            }
            if (((List)destination$iv$iv).contains(tableName)) {
                int schemaVer;
                int n;
                ResultRow $i$f$map2 = (ResultRow)CollectionsKt.singleOrNull((Iterable)QueriesKt.select((ColumnSet)((ColumnSet)MetaTable.INSTANCE), (Expression)((Expression)MetaTable.INSTANCE.getValue()), (Expression[])new Expression[0]).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)MetaTable.INSTANCE.getKey(), (Object)tbKey)));
                if ($i$f$map2 != null) {
                    ResultRow it = $i$f$map2;
                    boolean bl = false;
                    n = Integer.parseInt((String)it.get((Expression)MetaTable.INSTANCE.getValue()));
                } else {
                    n = 1;
                }
                for (int i = schemaVer = (v16957); i < version; ++i) {
                    upgradeHandlers[i - 1].invoke();
                }
            }
            QueriesKt.upsert$default((Table)MetaTable.INSTANCE, (Column[])new Column[0], null, null, null, (arg_0, arg_1) -> TableUpgrader._init_$lambda$2(tbKey, version, arg_0, arg_1), (int)14, null);
        }

        private static final Unit _init_$lambda$2(String $tbKey, int $version, MetaTable $this$upsert, UpsertStatement it) {
            it.set($this$upsert.getKey(), (Object)$tbKey);
            it.set($this$upsert.getValue(), (Object)String.valueOf($version));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J5\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lio/github/rothes/esu/core/storage/StorageManager$UserData;", "", "dbId", "", "uuid", "Ljava/util/UUID;", "language", "", "colorScheme", "<init>", "(ILjava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "getDbId", "()I", "getUuid", "()Ljava/util/UUID;", "getLanguage", "()Ljava/lang/String;", "getColorScheme", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    public static final class UserData {
        private final int dbId;
        @NotNull
        private final UUID uuid;
        @Nullable
        private final String language;
        @Nullable
        private final String colorScheme;

        public UserData(int dbId, @NotNull UUID uuid, @Nullable String language, @Nullable String colorScheme) {
            this.dbId = dbId;
            this.uuid = uuid;
            this.language = language;
            this.colorScheme = colorScheme;
        }

        public final int getDbId() {
            return this.dbId;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @Nullable
        public final String getLanguage() {
            return this.language;
        }

        @Nullable
        public final String getColorScheme() {
            return this.colorScheme;
        }

        public final int component1() {
            return this.dbId;
        }

        @NotNull
        public final UUID component2() {
            return this.uuid;
        }

        @Nullable
        public final String component3() {
            return this.language;
        }

        @Nullable
        public final String component4() {
            return this.colorScheme;
        }

        @NotNull
        public final UserData copy(int dbId, @NotNull UUID uuid, @Nullable String language, @Nullable String colorScheme) {
            return new UserData(dbId, uuid, language, colorScheme);
        }

        public static /* synthetic */ UserData copy$default(UserData userData, int n, UUID uUID, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = userData.dbId;
            }
            if ((n2 & 2) != 0) {
                uUID = userData.uuid;
            }
            if ((n2 & 4) != 0) {
                string = userData.language;
            }
            if ((n2 & 8) != 0) {
                string2 = userData.colorScheme;
            }
            return userData.copy(n, uUID, string, string2);
        }

        @NotNull
        public String toString() {
            return "UserData(dbId=" + this.dbId + ", uuid=" + this.uuid + ", language=" + this.language + ", colorScheme=" + this.colorScheme + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.dbId);
            result = result * 31 + this.uuid.hashCode();
            result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
            result = result * 31 + (this.colorScheme == null ? 0 : this.colorScheme.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserData)) {
                return false;
            }
            UserData userData = (UserData)other;
            if (this.dbId != userData.dbId) {
                return false;
            }
            if (!Intrinsics.areEqual(this.uuid, userData.uuid)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.language, userData.language)) {
                return false;
            }
            return Intrinsics.areEqual(this.colorScheme, userData.colorScheme);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0019\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0019\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0018\u0010\u0013\u001a\u00060\u0014R\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lio/github/rothes/esu/core/storage/StorageManager$UsersTable;", "Lorg/jetbrains/exposed/v1/core/Table;", "<init>", "()V", "dbId", "Lorg/jetbrains/exposed/v1/core/Column;", "", "getDbId", "()Lorg/jetbrains/exposed/v1/core/Column;", "uuid", "Ljava/util/UUID;", "getUuid", "name", "", "getName", "language", "getLanguage", "colorScheme", "getColorScheme", "primaryKey", "Lorg/jetbrains/exposed/v1/core/Table$PrimaryKey;", "getPrimaryKey", "()Lorg/jetbrains/exposed/v1/core/Table$PrimaryKey;", "core"})
    public static final class UsersTable
    extends Table {
        @NotNull
        public static final UsersTable INSTANCE = new UsersTable();
        @NotNull
        private static final Column<Integer> dbId = Table.autoIncrement$default((Table)INSTANCE, (Column)Table.integer$default((Table)INSTANCE, (String)"id", null, (int)2, null), null, (int)1, null);
        @NotNull
        private static final Column<UUID> uuid = Table.uniqueIndex$default((Table)INSTANCE, (Column)INSTANCE.uuid("uuid"), null, (int)1, null);
        @NotNull
        private static final Column<String> name = Table.uniqueIndex$default((Table)INSTANCE, (Column)INSTANCE.nullable(INSTANCE.varchar("name", 16, "utf8mb3_general_ci")), null, (int)1, null);
        @NotNull
        private static final Column<String> language = INSTANCE.nullable(INSTANCE.varchar("language", 12, "utf8mb3_general_ci"));
        @NotNull
        private static final Column<String> colorScheme = INSTANCE.nullable(INSTANCE.varchar("color_scheme", 32, "utf8mb3_general_ci"));
        @NotNull
        private static final Table.PrimaryKey primaryKey = new Table.PrimaryKey((Table)INSTANCE, dbId, new Column[0], null, 4, null);

        private UsersTable() {
            super("users");
        }

        @NotNull
        public final Column<Integer> getDbId() {
            return dbId;
        }

        @NotNull
        public final Column<UUID> getUuid() {
            return uuid;
        }

        @NotNull
        public final Column<String> getName() {
            return name;
        }

        @NotNull
        public final Column<String> getLanguage() {
            return language;
        }

        @NotNull
        public final Column<String> getColorScheme() {
            return colorScheme;
        }

        @NotNull
        public Table.PrimaryKey getPrimaryKey() {
            return primaryKey;
        }
    }
}

