/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.configuration.serializer;

import io.github.rothes.esu.core.EsuCore;
import io.github.rothes.esu.lib.org.spongepowered.configurate.ConfigurationNode;
import io.github.rothes.esu.lib.org.spongepowered.configurate.NodePath;
import io.github.rothes.esu.lib.org.spongepowered.configurate.serialize.SerializationException;
import io.github.rothes.esu.lib.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/rothes/esu/core/configuration/serializer/OptionalSerializer;", "Lio/github/rothes/esu/lib/org/spongepowered/configurate/serialize/TypeSerializer;", "Ljava/util/Optional;", "<init>", "()V", "DISABLED", "", "deserialize", "type", "Ljava/lang/reflect/Type;", "node", "Lio/github/rothes/esu/lib/org/spongepowered/configurate/ConfigurationNode;", "serialize", "", "obj", "core"})
public final class OptionalSerializer
implements TypeSerializer<Optional<?>> {
    @NotNull
    public static final OptionalSerializer INSTANCE = new OptionalSerializer();
    @NotNull
    public static final String DISABLED = "disabled";

    private OptionalSerializer() {
    }

    @Override
    @NotNull
    public Optional<?> deserialize(@NotNull Type type, @NotNull ConfigurationNode node) {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for optional");
        }
        if (((ParameterizedType)type).getActualTypeArguments().length != 1) {
            throw new SerializationException(type, "Optional expected a type argument!");
        }
        Type value = ((ParameterizedType)type).getActualTypeArguments()[0];
        TypeSerializer<?> typeSerializer = node.options().serializers().get(value);
        if (typeSerializer == null) {
            throw new SerializationException(type, "No type serializer available for optional type " + value);
        }
        TypeSerializer<?> serializer = typeSerializer;
        if (Intrinsics.areEqual((Object)node.raw(), (Object)DISABLED)) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(serializer.deserialize(type, node));
        }
        catch (SerializationException ex) {
            ex.initPath(() -> OptionalSerializer.deserialize$lambda$0(node));
            EsuCore.Companion.getInstance().err("Could not deserialize " + node.raw() + " into " + type + " at " + node.path() + ": " + ex.rawMessage());
            return Optional.empty();
        }
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Optional<?> obj, @NotNull ConfigurationNode node) {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for optional");
        }
        if (((ParameterizedType)type).getActualTypeArguments().length != 1) {
            throw new SerializationException(type, "Optional expected a type argument!");
        }
        if (obj == null || obj.isEmpty()) {
            node.set(DISABLED);
        } else {
            Type value = ((ParameterizedType)type).getActualTypeArguments()[0];
            TypeSerializer<?> typeSerializer = node.options().serializers().get(value);
            if (typeSerializer == null) {
                throw new SerializationException(type, "No type serializer available for optional type " + value);
            }
            TypeSerializer<?> serializer = typeSerializer;
            serializer.serialize(value, obj.get(), node);
        }
    }

    private static final NodePath deserialize$lambda$0(ConfigurationNode $node) {
        return $node.path();
    }
}

