/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module;

import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.module.BukkitModule;
import io.github.rothes.esu.bukkit.module.networkthrottle.ChunkDataThrottle;
import io.github.rothes.esu.bukkit.module.networkthrottle.DynamicChunkSendRate;
import io.github.rothes.esu.bukkit.module.networkthrottle.HighLatencyAdjust;
import io.github.rothes.esu.bukkit.util.ServerCompatibility;
import io.github.rothes.esu.core.configuration.ConfigLoader;
import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.configuration.meta.RemovedNode;
import io.github.rothes.esu.core.configuration.meta.RenamedFrom;
import io.github.rothes.esu.core.configuration.serializer.MapSerializer;
import io.github.rothes.esu.core.module.configuration.BaseModuleConfiguration;
import io.github.rothes.esu.core.util.version.Version;
import io.github.rothes.esu.lib.org.spongepowered.configurate.objectmapping.meta.PostProcess;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u0013\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule;", "Lio/github/rothes/esu/bukkit/module/BukkitModule;", "Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig;", "Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleLang;", "<init>", "()V", "data", "Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleData;", "getData", "()Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleData;", "setData", "(Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleData;)V", "dataPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "enable", "", "disable", "reloadConfig", "ModuleData", "ModuleConfig", "ModuleLang", "bukkit"})
@SourceDebugExtension(value={"SMAP\nNetworkThrottleModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkThrottleModule.kt\nio/github/rothes/esu/bukkit/module/NetworkThrottleModule\n+ 2 ConfigLoader.kt\nio/github/rothes/esu/core/configuration/ConfigLoader\n*L\n1#1,239:1\n157#2:240\n*S KotlinDebug\n*F\n+ 1 NetworkThrottleModule.kt\nio/github/rothes/esu/bukkit/module/NetworkThrottleModule\n*L\n33#1:240\n*E\n"})
public final class NetworkThrottleModule
extends BukkitModule<ModuleConfig, ModuleLang> {
    @NotNull
    public static final NetworkThrottleModule INSTANCE = new NetworkThrottleModule();
    public static ModuleData data;
    private static final Path dataPath;

    private NetworkThrottleModule() {
        super(ModuleConfig.class, ModuleLang.class);
    }

    @NotNull
    public final ModuleData getData() {
        ModuleData moduleData = data;
        if (moduleData != null) {
            return moduleData;
        }
        Intrinsics.throwUninitializedPropertyAccessException("data");
        return null;
    }

    public final void setData(@NotNull ModuleData moduleData) {
        data = moduleData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enable() {
        void this_$iv;
        ConfigLoader configLoader = ConfigLoader.INSTANCE;
        Path path$iv = dataPath;
        boolean $i$f$load = false;
        this.setData(this_$iv.loadSimple(path$iv, ModuleData.class));
        HighLatencyAdjust.INSTANCE.onEnable();
        ChunkDataThrottle.INSTANCE.onEnable();
        DynamicChunkSendRate.INSTANCE.enable();
    }

    @Override
    public void disable() {
        super.disable();
        ChunkDataThrottle.INSTANCE.onDisable();
        HighLatencyAdjust.INSTANCE.onDisable();
        DynamicChunkSendRate.INSTANCE.disable();
        ConfigLoader.save$default(ConfigLoader.INSTANCE, dataPath, this.getData(), null, 4, null);
    }

    @Override
    public void reloadConfig() {
        super.reloadConfig();
        if (this.getEnabled()) {
            if (((ModuleConfig)this.getConfig()).getDynamicChunkSendRate().getEnabled()) {
                DynamicChunkSendRate.INSTANCE.enable();
            } else {
                DynamicChunkSendRate.INSTANCE.disable();
            }
            if (((ModuleConfig)this.getConfig()).getChunkDataThrottle().getEnabled()) {
                ChunkDataThrottle.INSTANCE.onReload();
            }
        }
    }

    static {
        dataPath = INSTANCE.getModuleFolder().resolve("data.yml");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseModuleConfiguration;", "chunkDataThrottle", "Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$ChunkDataThrottle;", "dynamicChunkSendRate", "Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$DynamicChunkSendRate;", "highLatencyAdjust", "Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$HighLatencyAdjust;", "<init>", "(Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$ChunkDataThrottle;Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$DynamicChunkSendRate;Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$HighLatencyAdjust;)V", "getChunkDataThrottle", "()Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$ChunkDataThrottle;", "getDynamicChunkSendRate", "()Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$DynamicChunkSendRate;", "getHighLatencyAdjust", "()Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$HighLatencyAdjust;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ChunkDataThrottle", "DynamicChunkSendRate", "HighLatencyAdjust", "bukkit"})
    public static final class ModuleConfig
    extends BaseModuleConfiguration {
        @Comment(value="\n            Helps to reduce chunk upload bandwidth. Plugin will compress invisible blocks in chunk data packet.\n            If necessary, we send a full chunk data again.\n            This can save about 50% bandwidth usage in overworld and 30% in nether averagely.\n            Make sure you have enabled network-compression on proxy or this server.\n            ")
        @NotNull
        private final ChunkDataThrottle chunkDataThrottle;
        @Comment(value="Enable DynamicChunkSendRate. Make sure you have velocity mode on, and installed ESU on velocity.")
        @NotNull
        private final DynamicChunkSendRate dynamicChunkSendRate;
        @Comment(value="\n            Adjust the settings the players with high latency to lower value.\n            So they won't affect average quality of all players.\n            ")
        @NotNull
        private final HighLatencyAdjust highLatencyAdjust;

        public ModuleConfig(@NotNull ChunkDataThrottle chunkDataThrottle, @NotNull DynamicChunkSendRate dynamicChunkSendRate, @NotNull HighLatencyAdjust highLatencyAdjust) {
            super(false, 1, null);
            this.chunkDataThrottle = chunkDataThrottle;
            this.dynamicChunkSendRate = dynamicChunkSendRate;
            this.highLatencyAdjust = highLatencyAdjust;
        }

        public /* synthetic */ ModuleConfig(ChunkDataThrottle chunkDataThrottle, DynamicChunkSendRate dynamicChunkSendRate, HighLatencyAdjust highLatencyAdjust, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                chunkDataThrottle = new ChunkDataThrottle(false, 0, false, 0, false, false, false, false, null, false, null, 2047, null);
            }
            if ((n & 2) != 0) {
                dynamicChunkSendRate = new DynamicChunkSendRate(false, 1, null);
            }
            if ((n & 4) != 0) {
                highLatencyAdjust = new HighLatencyAdjust(false, 0, null, false, 0, 31, null);
            }
            this(chunkDataThrottle, dynamicChunkSendRate, highLatencyAdjust);
        }

        @NotNull
        public final ChunkDataThrottle getChunkDataThrottle() {
            return this.chunkDataThrottle;
        }

        @NotNull
        public final DynamicChunkSendRate getDynamicChunkSendRate() {
            return this.dynamicChunkSendRate;
        }

        @NotNull
        public final HighLatencyAdjust getHighLatencyAdjust() {
            return this.highLatencyAdjust;
        }

        @NotNull
        public final ChunkDataThrottle component1() {
            return this.chunkDataThrottle;
        }

        @NotNull
        public final DynamicChunkSendRate component2() {
            return this.dynamicChunkSendRate;
        }

        @NotNull
        public final HighLatencyAdjust component3() {
            return this.highLatencyAdjust;
        }

        @NotNull
        public final ModuleConfig copy(@NotNull ChunkDataThrottle chunkDataThrottle, @NotNull DynamicChunkSendRate dynamicChunkSendRate, @NotNull HighLatencyAdjust highLatencyAdjust) {
            return new ModuleConfig(chunkDataThrottle, dynamicChunkSendRate, highLatencyAdjust);
        }

        public static /* synthetic */ ModuleConfig copy$default(ModuleConfig moduleConfig, ChunkDataThrottle chunkDataThrottle, DynamicChunkSendRate dynamicChunkSendRate, HighLatencyAdjust highLatencyAdjust, int n, Object object) {
            if ((n & 1) != 0) {
                chunkDataThrottle = moduleConfig.chunkDataThrottle;
            }
            if ((n & 2) != 0) {
                dynamicChunkSendRate = moduleConfig.dynamicChunkSendRate;
            }
            if ((n & 4) != 0) {
                highLatencyAdjust = moduleConfig.highLatencyAdjust;
            }
            return moduleConfig.copy(chunkDataThrottle, dynamicChunkSendRate, highLatencyAdjust);
        }

        @NotNull
        public String toString() {
            return "ModuleConfig(chunkDataThrottle=" + this.chunkDataThrottle + ", dynamicChunkSendRate=" + this.dynamicChunkSendRate + ", highLatencyAdjust=" + this.highLatencyAdjust + ")";
        }

        public int hashCode() {
            int result = this.chunkDataThrottle.hashCode();
            result = result * 31 + this.dynamicChunkSendRate.hashCode();
            result = result * 31 + this.highLatencyAdjust.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleConfig)) {
                return false;
            }
            ModuleConfig moduleConfig = (ModuleConfig)other;
            if (!Intrinsics.areEqual(this.chunkDataThrottle, moduleConfig.chunkDataThrottle)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dynamicChunkSendRate, moduleConfig.dynamicChunkSendRate)) {
                return false;
            }
            return Intrinsics.areEqual(this.highLatencyAdjust, moduleConfig.highLatencyAdjust);
        }

        public ModuleConfig() {
            this(null, null, null, 7, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0016\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B\u008d\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\u001a\b\u0002\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\b\u00101\u001a\u000202H\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0005H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0005H\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rH\u00c6\u0003J\t\u0010<\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u00c6\u0003J\u008f\u0001\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\u001a\b\u0002\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r2\b\b\u0002\u0010\u0011\u001a\u00020\u00032\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u00c6\u0001J\u0013\u0010?\u001a\u00020\u00032\b\u0010@\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010A\u001a\u00020\u0005H\u00d6\u0001J\t\u0010B\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0016\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0016\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0016\u0010\n\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0017R\u0016\u0010\u000b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R(\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\u0011\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0017R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00138\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b&\u0010'R'\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020*0\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b+\u0010!R\u0018\u0010.\u001a\u00020\u0005*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006C"}, d2={"Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$ChunkDataThrottle;", "", "enabled", "", "thresholdToResentWholeChunk", "", "updateOnLegalInteractOnly", "updateDistance", "minimalHeightInvisibleCheck", "netherRoofInvisibleCheck", "detectInvisibleSingleBlock", "detectLavaPool", "antiXrayRandomBlockList", "Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$DefaultedLinkedHashMap;", "", "", "Lorg/bukkit/Material;", "enhancedAntiXray", "nonInvisibleBlocksOverrides", "", "<init>", "(ZIZIZZZZLio/github/rothes/esu/core/configuration/serializer/MapSerializer$DefaultedLinkedHashMap;ZLjava/util/Set;)V", "getEnabled", "()Z", "getThresholdToResentWholeChunk", "()I", "getUpdateOnLegalInteractOnly", "getUpdateDistance", "getMinimalHeightInvisibleCheck", "getNetherRoofInvisibleCheck", "getDetectInvisibleSingleBlock", "getDetectLavaPool", "getAntiXrayRandomBlockList", "()Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$DefaultedLinkedHashMap;", "getEnhancedAntiXray", "getNonInvisibleBlocksOverrides", "()Ljava/util/Set;", "rebuildPaletteMappings", "getRebuildPaletteMappings", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "antiXrayRandomBlockIds", "", "getAntiXrayRandomBlockIds", "antiXrayRandomBlockIds$delegate", "Lkotlin/Lazy;", "globalId", "getGlobalId", "(Lorg/bukkit/Material;)I", "postProcess", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "other", "hashCode", "toString", "bukkit"})
        @SourceDebugExtension(value={"SMAP\nNetworkThrottleModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkThrottleModule.kt\nio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$ChunkDataThrottle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1869#2,2:240\n1563#2:242\n1634#2,3:243\n1563#2:246\n1634#2,3:247\n*S KotlinDebug\n*F\n+ 1 NetworkThrottleModule.kt\nio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$ChunkDataThrottle\n*L\n198#1:240,2\n178#1:242\n178#1:243,3\n179#1:246\n179#1:247,3\n*E\n"})
        public static final class ChunkDataThrottle {
            private final boolean enabled;
            @Comment(value="\n                Plugin will resent whole chunk data if resent block amount exceeds this value.\n                Set it to -1 will never resent chunk but keep updating nearby blocks, \n                 0 to always resent chunks.\n                ")
            private final int thresholdToResentWholeChunk;
            @Comment(value="\n                We updates the nearby blocks when a player digs a block immediately.\n                If this is enabled, we will check if the block is in the interaction range\n                 of the player with a rough calculation.\n                ")
            private final boolean updateOnLegalInteractOnly;
            @Comment(value="How many distance of blocks to update from the center when necessary.")
            private final int updateDistance;
            @Comment(value="\n                The bedrock level(minimal height) is never visible unless you are in void.\n                We would skip the check, and if you don't like it you can enable it.\n                ")
            private final boolean minimalHeightInvisibleCheck;
            @Comment(value="\n                Same with minimal-height but it's for nether roof. For out-of-the-box, it's true by default.\n                It's highly recommend to set it to FALSE if you don't allow players to get above there.\n                ", overrideOld={"Same with minimal-height but it's for nether roof."})
            private final boolean netherRoofInvisibleCheck;
            @Comment(value="\n                If a non-occluding block is surrounded by occluding blocks, the center block is invisible.\n                But should we consider all surrounded blocks invisible to this block face?\n                Unless the player joins the game with their eye in the non-occluding block,\n                 they will never naturally see those surrounded blocks.\n                This step takes extra ~0.02ms, so it's not enabled by default.\n                Enable this could help with saving bandwidth in nether, as there's many single-block lava.\n            ")
            private final boolean detectInvisibleSingleBlock;
            @Comment(value="\n                Detect lava pool, and consider lava blocks which being covered invisible.\n                This step takes extra ~0.03ms, so it's not enabled by default.\n                It also makes the plugin detect nearby blocks everytime player moves.\n                Enable this could help with saving bandwidth, especially in nether.\n            ")
            private final boolean detectLavaPool;
            @RenamedFrom(oldName="single-valued-section-block-list")
            @Comment(value="\n                    This feature doesn't support running along with any other anti-xray plugins.\n                    You must use the anti-xray here we provide.\n                    \n                    We will send non-visible blocks to one of the random block in this list.\n                    If you don't like to anti-xray, you can set the list to 'bedrock'.\n                ", overrideOld={"Plugin will convert chunks with all non-visible blocks to single-valued palette format,\nThis could save a lot of bandwidth. And since we are conflicting with anti-xray things,\nyou can use this for some kind of substitution.\nWe choose a random block from the list and make it of a 16*16*16 chunk section."})
            @NotNull
            private final MapSerializer.DefaultedLinkedHashMap<String, List<Material>> antiXrayRandomBlockList;
            @Comment(value="\n                If enabled, we add a extra block type to chunk section palettes for the random block.\n                This will greatly enhance anti-xray capabilities while giving only few bytes of additional bandwidth.\n            ")
            private final boolean enhancedAntiXray;
            @Comment(value="\n                Put any blocks you don't want to hide, so they are ignored while processing.\n                For example, you can add any ores to it, so there's no anti-xray effect.\n                WARNING: This significantly reduces compression badly. Please make sure you really have to do this.\n            ")
            @NotNull
            private final Set<Material> nonInvisibleBlocksOverrides;
            @RemovedNode
            @Nullable
            private final Boolean rebuildPaletteMappings;
            @NotNull
            private final Lazy antiXrayRandomBlockIds$delegate;

            public ChunkDataThrottle(boolean enabled, int thresholdToResentWholeChunk, boolean updateOnLegalInteractOnly, int updateDistance, boolean minimalHeightInvisibleCheck, boolean netherRoofInvisibleCheck, boolean detectInvisibleSingleBlock, boolean detectLavaPool, @NotNull MapSerializer.DefaultedLinkedHashMap<String, List<Material>> antiXrayRandomBlockList, boolean enhancedAntiXray, @NotNull Set<? extends Material> nonInvisibleBlocksOverrides) {
                this.enabled = enabled;
                this.thresholdToResentWholeChunk = thresholdToResentWholeChunk;
                this.updateOnLegalInteractOnly = updateOnLegalInteractOnly;
                this.updateDistance = updateDistance;
                this.minimalHeightInvisibleCheck = minimalHeightInvisibleCheck;
                this.netherRoofInvisibleCheck = netherRoofInvisibleCheck;
                this.detectInvisibleSingleBlock = detectInvisibleSingleBlock;
                this.detectLavaPool = detectLavaPool;
                this.antiXrayRandomBlockList = antiXrayRandomBlockList;
                this.enhancedAntiXray = enhancedAntiXray;
                this.nonInvisibleBlocksOverrides = nonInvisibleBlocksOverrides;
                this.antiXrayRandomBlockIds$delegate = LazyKt.lazy(() -> ChunkDataThrottle.antiXrayRandomBlockIds_delegate$lambda$8(this));
            }

            /*
             * WARNING - void declaration
             */
            public /* synthetic */ ChunkDataThrottle(boolean bl, int n, boolean bl2, int n2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, MapSerializer.DefaultedLinkedHashMap object, boolean bl7, Set set, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    bl = true;
                }
                if ((n3 & 2) != 0) {
                    n = 448;
                }
                if ((n3 & 4) != 0) {
                    bl2 = true;
                }
                if ((n3 & 8) != 0) {
                    n2 = 2;
                }
                if ((n3 & 0x10) != 0) {
                    bl3 = false;
                }
                if ((n3 & 0x20) != 0) {
                    bl4 = true;
                }
                if ((n3 & 0x40) != 0) {
                    bl5 = false;
                }
                if ((n3 & 0x80) != 0) {
                    bl6 = false;
                }
                if ((n3 & 0x100) != 0) {
                    void $this$_init__u24lambda_u242_u24lambda_u241;
                    Material[] $this$_init__u24lambda_u242_u24lambda_u240;
                    Material[] materialArray;
                    Object object2 = new Material[]{Material.BEDROCK};
                    Object $this$_init__u24lambda_u242 = object2 = new MapSerializer.DefaultedLinkedHashMap(CollectionsKt.mutableListOf(object2));
                    boolean bl8 = false;
                    Material[] materialArray2 = materialArray = CollectionsKt.createListBuilder();
                    String string = "world";
                    Object object3 = $this$_init__u24lambda_u242;
                    boolean bl9 = false;
                    boolean cavesUpdate = ServerCompatibility.INSTANCE.getServerVersion().compareTo(Version.Companion.fromString("1.17")) >= 0;
                    $this$_init__u24lambda_u242_u24lambda_u240.add(Material.COAL_ORE);
                    if (cavesUpdate) {
                        $this$_init__u24lambda_u242_u24lambda_u240.add(Material.COPPER_ORE);
                    }
                    Material[] materialArray3 = new Material[]{Material.IRON_ORE, Material.GOLD_ORE, Material.EMERALD_ORE, Material.DIAMOND_ORE, Material.REDSTONE_ORE, Material.LAPIS_ORE};
                    $this$_init__u24lambda_u242_u24lambda_u240.addAll((Collection)CollectionsKt.listOf(materialArray3));
                    if (cavesUpdate) {
                        materialArray3 = new Material[]{Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_LAPIS_ORE};
                        $this$_init__u24lambda_u242_u24lambda_u240.addAll((Collection)CollectionsKt.listOf(materialArray3));
                    }
                    Unit unit = Unit.INSTANCE;
                    ((HashMap)object3).put(string, CollectionsKt.toMutableList(CollectionsKt.build(materialArray)));
                    $this$_init__u24lambda_u242_u24lambda_u240 = materialArray = CollectionsKt.createListBuilder();
                    string = "world_nether";
                    object3 = $this$_init__u24lambda_u242;
                    boolean bl10 = false;
                    $this$_init__u24lambda_u242_u24lambda_u241.add(Material.NETHER_QUARTZ_ORE);
                    if (ServerCompatibility.INSTANCE.getServerVersion().compareTo(Version.Companion.fromString("1.16")) >= 0) {
                        $this$_init__u24lambda_u242_u24lambda_u241.add(Material.NETHER_GOLD_ORE);
                        $this$_init__u24lambda_u242_u24lambda_u241.add(Material.ANCIENT_DEBRIS);
                    }
                    unit = Unit.INSTANCE;
                    ((HashMap)object3).put(string, CollectionsKt.toMutableList(CollectionsKt.build(materialArray)));
                    materialArray = new Material[]{Material.END_STONE};
                    ((HashMap)$this$_init__u24lambda_u242).put("world_the_end", CollectionsKt.mutableListOf(materialArray));
                    object = object2;
                }
                if ((n3 & 0x200) != 0) {
                    bl7 = true;
                }
                if ((n3 & 0x400) != 0) {
                    set = SetsKt.emptySet();
                }
                this(bl, n, bl2, n2, bl3, bl4, bl5, bl6, (MapSerializer.DefaultedLinkedHashMap<String, List<Material>>)object, bl7, set);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            public final int getThresholdToResentWholeChunk() {
                return this.thresholdToResentWholeChunk;
            }

            public final boolean getUpdateOnLegalInteractOnly() {
                return this.updateOnLegalInteractOnly;
            }

            public final int getUpdateDistance() {
                return this.updateDistance;
            }

            public final boolean getMinimalHeightInvisibleCheck() {
                return this.minimalHeightInvisibleCheck;
            }

            public final boolean getNetherRoofInvisibleCheck() {
                return this.netherRoofInvisibleCheck;
            }

            public final boolean getDetectInvisibleSingleBlock() {
                return this.detectInvisibleSingleBlock;
            }

            public final boolean getDetectLavaPool() {
                return this.detectLavaPool;
            }

            @NotNull
            public final MapSerializer.DefaultedLinkedHashMap<String, List<Material>> getAntiXrayRandomBlockList() {
                return this.antiXrayRandomBlockList;
            }

            public final boolean getEnhancedAntiXray() {
                return this.enhancedAntiXray;
            }

            @NotNull
            public final Set<Material> getNonInvisibleBlocksOverrides() {
                return this.nonInvisibleBlocksOverrides;
            }

            @Nullable
            public final Boolean getRebuildPaletteMappings() {
                return this.rebuildPaletteMappings;
            }

            @NotNull
            public final MapSerializer.DefaultedLinkedHashMap<String, int[]> getAntiXrayRandomBlockIds() {
                Lazy lazy = this.antiXrayRandomBlockIds$delegate;
                return (MapSerializer.DefaultedLinkedHashMap)lazy.getValue();
            }

            private final int getGlobalId(Material $this$globalId) {
                if (!$this$globalId.isBlock()) {
                    throw new IllegalStateException(("Material " + $this$globalId + " is not a block type!").toString());
                }
                return SpigotConversionUtil.fromBukkitBlockData((BlockData)$this$globalId.createBlockData()).getGlobalId();
            }

            @PostProcess
            private final void postProcess() {
                List<Material> list = this.antiXrayRandomBlockList.getDefault();
                if (list != null) {
                    List<Material> it = list;
                    boolean bl = false;
                    ChunkDataThrottle.postProcess$checkEmptyBlockList("default", it);
                }
                Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.antiXrayRandomBlockList.entrySet());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    ChunkDataThrottle.postProcess$checkEmptyBlockList((String)it.getKey(), (List)it.getValue());
                }
            }

            public final boolean component1() {
                return this.enabled;
            }

            public final int component2() {
                return this.thresholdToResentWholeChunk;
            }

            public final boolean component3() {
                return this.updateOnLegalInteractOnly;
            }

            public final int component4() {
                return this.updateDistance;
            }

            public final boolean component5() {
                return this.minimalHeightInvisibleCheck;
            }

            public final boolean component6() {
                return this.netherRoofInvisibleCheck;
            }

            public final boolean component7() {
                return this.detectInvisibleSingleBlock;
            }

            public final boolean component8() {
                return this.detectLavaPool;
            }

            @NotNull
            public final MapSerializer.DefaultedLinkedHashMap<String, List<Material>> component9() {
                return this.antiXrayRandomBlockList;
            }

            public final boolean component10() {
                return this.enhancedAntiXray;
            }

            @NotNull
            public final Set<Material> component11() {
                return this.nonInvisibleBlocksOverrides;
            }

            @NotNull
            public final ChunkDataThrottle copy(boolean enabled, int thresholdToResentWholeChunk, boolean updateOnLegalInteractOnly, int updateDistance, boolean minimalHeightInvisibleCheck, boolean netherRoofInvisibleCheck, boolean detectInvisibleSingleBlock, boolean detectLavaPool, @NotNull MapSerializer.DefaultedLinkedHashMap<String, List<Material>> antiXrayRandomBlockList, boolean enhancedAntiXray, @NotNull Set<? extends Material> nonInvisibleBlocksOverrides) {
                return new ChunkDataThrottle(enabled, thresholdToResentWholeChunk, updateOnLegalInteractOnly, updateDistance, minimalHeightInvisibleCheck, netherRoofInvisibleCheck, detectInvisibleSingleBlock, detectLavaPool, antiXrayRandomBlockList, enhancedAntiXray, nonInvisibleBlocksOverrides);
            }

            public static /* synthetic */ ChunkDataThrottle copy$default(ChunkDataThrottle chunkDataThrottle, boolean bl, int n, boolean bl2, int n2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, MapSerializer.DefaultedLinkedHashMap defaultedLinkedHashMap, boolean bl7, Set set, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    bl = chunkDataThrottle.enabled;
                }
                if ((n3 & 2) != 0) {
                    n = chunkDataThrottle.thresholdToResentWholeChunk;
                }
                if ((n3 & 4) != 0) {
                    bl2 = chunkDataThrottle.updateOnLegalInteractOnly;
                }
                if ((n3 & 8) != 0) {
                    n2 = chunkDataThrottle.updateDistance;
                }
                if ((n3 & 0x10) != 0) {
                    bl3 = chunkDataThrottle.minimalHeightInvisibleCheck;
                }
                if ((n3 & 0x20) != 0) {
                    bl4 = chunkDataThrottle.netherRoofInvisibleCheck;
                }
                if ((n3 & 0x40) != 0) {
                    bl5 = chunkDataThrottle.detectInvisibleSingleBlock;
                }
                if ((n3 & 0x80) != 0) {
                    bl6 = chunkDataThrottle.detectLavaPool;
                }
                if ((n3 & 0x100) != 0) {
                    defaultedLinkedHashMap = chunkDataThrottle.antiXrayRandomBlockList;
                }
                if ((n3 & 0x200) != 0) {
                    bl7 = chunkDataThrottle.enhancedAntiXray;
                }
                if ((n3 & 0x400) != 0) {
                    set = chunkDataThrottle.nonInvisibleBlocksOverrides;
                }
                return chunkDataThrottle.copy(bl, n, bl2, n2, bl3, bl4, bl5, bl6, defaultedLinkedHashMap, bl7, set);
            }

            @NotNull
            public String toString() {
                return "ChunkDataThrottle(enabled=" + this.enabled + ", thresholdToResentWholeChunk=" + this.thresholdToResentWholeChunk + ", updateOnLegalInteractOnly=" + this.updateOnLegalInteractOnly + ", updateDistance=" + this.updateDistance + ", minimalHeightInvisibleCheck=" + this.minimalHeightInvisibleCheck + ", netherRoofInvisibleCheck=" + this.netherRoofInvisibleCheck + ", detectInvisibleSingleBlock=" + this.detectInvisibleSingleBlock + ", detectLavaPool=" + this.detectLavaPool + ", antiXrayRandomBlockList=" + this.antiXrayRandomBlockList + ", enhancedAntiXray=" + this.enhancedAntiXray + ", nonInvisibleBlocksOverrides=" + this.nonInvisibleBlocksOverrides + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.enabled);
                result = result * 31 + Integer.hashCode(this.thresholdToResentWholeChunk);
                result = result * 31 + Boolean.hashCode(this.updateOnLegalInteractOnly);
                result = result * 31 + Integer.hashCode(this.updateDistance);
                result = result * 31 + Boolean.hashCode(this.minimalHeightInvisibleCheck);
                result = result * 31 + Boolean.hashCode(this.netherRoofInvisibleCheck);
                result = result * 31 + Boolean.hashCode(this.detectInvisibleSingleBlock);
                result = result * 31 + Boolean.hashCode(this.detectLavaPool);
                result = result * 31 + this.antiXrayRandomBlockList.hashCode();
                result = result * 31 + Boolean.hashCode(this.enhancedAntiXray);
                result = result * 31 + ((Object)this.nonInvisibleBlocksOverrides).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ChunkDataThrottle)) {
                    return false;
                }
                ChunkDataThrottle chunkDataThrottle = (ChunkDataThrottle)other;
                if (this.enabled != chunkDataThrottle.enabled) {
                    return false;
                }
                if (this.thresholdToResentWholeChunk != chunkDataThrottle.thresholdToResentWholeChunk) {
                    return false;
                }
                if (this.updateOnLegalInteractOnly != chunkDataThrottle.updateOnLegalInteractOnly) {
                    return false;
                }
                if (this.updateDistance != chunkDataThrottle.updateDistance) {
                    return false;
                }
                if (this.minimalHeightInvisibleCheck != chunkDataThrottle.minimalHeightInvisibleCheck) {
                    return false;
                }
                if (this.netherRoofInvisibleCheck != chunkDataThrottle.netherRoofInvisibleCheck) {
                    return false;
                }
                if (this.detectInvisibleSingleBlock != chunkDataThrottle.detectInvisibleSingleBlock) {
                    return false;
                }
                if (this.detectLavaPool != chunkDataThrottle.detectLavaPool) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.antiXrayRandomBlockList, chunkDataThrottle.antiXrayRandomBlockList)) {
                    return false;
                }
                if (this.enhancedAntiXray != chunkDataThrottle.enhancedAntiXray) {
                    return false;
                }
                return Intrinsics.areEqual(this.nonInvisibleBlocksOverrides, chunkDataThrottle.nonInvisibleBlocksOverrides);
            }

            /*
             * WARNING - void declaration
             */
            private static final MapSerializer.DefaultedLinkedHashMap antiXrayRandomBlockIds_delegate$lambda$8(ChunkDataThrottle this$0) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                MapSerializer.DefaultedLinkedHashMap defaultedLinkedHashMap;
                Object item$iv$iv2;
                void $this$mapTo$iv$iv2;
                MapSerializer.DefaultedLinkedHashMap<String, List<Material>> $this$antiXrayRandomBlockIds_delegate_u24lambda_u248_u24lambda_u247 = this$0.antiXrayRandomBlockList;
                boolean bl = false;
                List<Material> list = $this$antiXrayRandomBlockIds_delegate_u24lambda_u248_u24lambda_u247.getDefault();
                if (list == null) {
                    list = CollectionsKt.listOf(Material.BEDROCK);
                }
                Iterable $this$map$iv2 = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv2;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    Material material = (Material)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this$0.getGlobalId((Material)it));
                }
                int[] nArray = CollectionsKt.toIntArray((List)destination$iv$iv);
                MapSerializer.DefaultedLinkedHashMap it = defaultedLinkedHashMap = new MapSerializer.DefaultedLinkedHashMap(nArray);
                boolean bl3 = false;
                destination$iv$iv = $this$antiXrayRandomBlockIds_delegate_u24lambda_u248_u24lambda_u247.entrySet();
                Map map = it;
                boolean $i$f$map2 = false;
                item$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv3;
                    void $this$map$iv3;
                    void it2;
                    Map.Entry entry = (Map.Entry)item$iv$iv3;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    Iterable iterable2 = (Iterable)it2.getValue();
                    Object k = it2.getKey();
                    boolean $i$f$map3 = false;
                    void var21_26 = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                        void it3;
                        Material material = (Material)item$iv$iv4;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl5 = false;
                        collection2.add(this$0.getGlobalId((Material)it3));
                    }
                    collection.add(TuplesKt.to(k, CollectionsKt.toIntArray((List)destination$iv$iv3)));
                }
                MapsKt.putAll(map, (List)destination$iv$iv2);
                return defaultedLinkedHashMap;
            }

            private static final void postProcess$checkEmptyBlockList(String key, List<Material> list) {
                if (list.isEmpty()) {
                    list.add(Material.BEDROCK);
                    InternalsKt.getPlugin().warn("[ChunkDataThrottle] Anti-xray random block list of '" + key + "' is empty! We have added bedrock to it.");
                }
            }

            public ChunkDataThrottle() {
                this(false, 0, false, 0, false, false, false, false, null, false, null, 2047, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$DynamicChunkSendRate;", "", "enabled", "", "<init>", "(Z)V", "getEnabled", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class DynamicChunkSendRate {
            private final boolean enabled;

            public DynamicChunkSendRate(boolean enabled) {
                this.enabled = enabled;
            }

            public /* synthetic */ DynamicChunkSendRate(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = ServerCompatibility.INSTANCE.isProxyMode();
                }
                this(bl);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            public final boolean component1() {
                return this.enabled;
            }

            @NotNull
            public final DynamicChunkSendRate copy(boolean enabled) {
                return new DynamicChunkSendRate(enabled);
            }

            public static /* synthetic */ DynamicChunkSendRate copy$default(DynamicChunkSendRate dynamicChunkSendRate, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = dynamicChunkSendRate.enabled;
                }
                return dynamicChunkSendRate.copy(bl);
            }

            @NotNull
            public String toString() {
                return "DynamicChunkSendRate(enabled=" + this.enabled + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.enabled);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DynamicChunkSendRate)) {
                    return false;
                }
                DynamicChunkSendRate dynamicChunkSendRate = (DynamicChunkSendRate)other;
                return this.enabled == dynamicChunkSendRate.enabled;
            }

            public DynamicChunkSendRate() {
                this(false, 1, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleConfig$HighLatencyAdjust;", "", "enabled", "", "latencyThreshold", "", "duration", "Ljava/time/Duration;", "newViewDistanceToReset", "minViewDistance", "<init>", "(ZILjava/time/Duration;ZI)V", "getEnabled", "()Z", "getLatencyThreshold", "()I", "getDuration", "()Ljava/time/Duration;", "getNewViewDistanceToReset", "getMinViewDistance", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "bukkit"})
        public static final class HighLatencyAdjust {
            private final boolean enabled;
            @Comment(value="Trigger a adjust when player's ping is greater than or equal this.")
            private final int latencyThreshold;
            @Comment(value="The high ping must keep for the duration to trigger a adjust finally.")
            @NotNull
            private final java.time.Duration duration;
            @Comment(value="Plugin detects CLIENT_SETTINGS packets to reset the view distance for players.\nIf true, player must change the client view distance for a reset;\nIf false, any new settings could reset the view distance for the player.")
            private final boolean newViewDistanceToReset;
            private final int minViewDistance;

            public HighLatencyAdjust(boolean enabled, int latencyThreshold, @NotNull java.time.Duration duration2, boolean newViewDistanceToReset, int minViewDistance) {
                this.enabled = enabled;
                this.latencyThreshold = latencyThreshold;
                this.duration = duration2;
                this.newViewDistanceToReset = newViewDistanceToReset;
                this.minViewDistance = minViewDistance;
            }

            public /* synthetic */ HighLatencyAdjust(boolean bl, int n, java.time.Duration duration2, boolean bl2, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    bl = false;
                }
                if ((n3 & 2) != 0) {
                    n = 150;
                }
                if ((n3 & 4) != 0) {
                    long l = Duration.Companion.parse-UwyO8pc("1m");
                    int n4 = Duration.getNanosecondsComponent-impl(l);
                    long l2 = Duration.getInWholeSeconds-impl(l);
                    java.time.Duration duration3 = java.time.Duration.ofSeconds(l2, n4);
                    Intrinsics.checkNotNullExpressionValue(duration3, "toComponents-impl(...)");
                    duration2 = duration3;
                }
                if ((n3 & 8) != 0) {
                    bl2 = false;
                }
                if ((n3 & 0x10) != 0) {
                    n2 = 5;
                }
                this(bl, n, duration2, bl2, n2);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            public final int getLatencyThreshold() {
                return this.latencyThreshold;
            }

            @NotNull
            public final java.time.Duration getDuration() {
                return this.duration;
            }

            public final boolean getNewViewDistanceToReset() {
                return this.newViewDistanceToReset;
            }

            public final int getMinViewDistance() {
                return this.minViewDistance;
            }

            public final boolean component1() {
                return this.enabled;
            }

            public final int component2() {
                return this.latencyThreshold;
            }

            @NotNull
            public final java.time.Duration component3() {
                return this.duration;
            }

            public final boolean component4() {
                return this.newViewDistanceToReset;
            }

            public final int component5() {
                return this.minViewDistance;
            }

            @NotNull
            public final HighLatencyAdjust copy(boolean enabled, int latencyThreshold, @NotNull java.time.Duration duration2, boolean newViewDistanceToReset, int minViewDistance) {
                return new HighLatencyAdjust(enabled, latencyThreshold, duration2, newViewDistanceToReset, minViewDistance);
            }

            public static /* synthetic */ HighLatencyAdjust copy$default(HighLatencyAdjust highLatencyAdjust, boolean bl, int n, java.time.Duration duration2, boolean bl2, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    bl = highLatencyAdjust.enabled;
                }
                if ((n3 & 2) != 0) {
                    n = highLatencyAdjust.latencyThreshold;
                }
                if ((n3 & 4) != 0) {
                    duration2 = highLatencyAdjust.duration;
                }
                if ((n3 & 8) != 0) {
                    bl2 = highLatencyAdjust.newViewDistanceToReset;
                }
                if ((n3 & 0x10) != 0) {
                    n2 = highLatencyAdjust.minViewDistance;
                }
                return highLatencyAdjust.copy(bl, n, duration2, bl2, n2);
            }

            @NotNull
            public String toString() {
                return "HighLatencyAdjust(enabled=" + this.enabled + ", latencyThreshold=" + this.latencyThreshold + ", duration=" + this.duration + ", newViewDistanceToReset=" + this.newViewDistanceToReset + ", minViewDistance=" + this.minViewDistance + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.enabled);
                result = result * 31 + Integer.hashCode(this.latencyThreshold);
                result = result * 31 + this.duration.hashCode();
                result = result * 31 + Boolean.hashCode(this.newViewDistanceToReset);
                result = result * 31 + Integer.hashCode(this.minViewDistance);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof HighLatencyAdjust)) {
                    return false;
                }
                HighLatencyAdjust highLatencyAdjust = (HighLatencyAdjust)other;
                if (this.enabled != highLatencyAdjust.enabled) {
                    return false;
                }
                if (this.latencyThreshold != highLatencyAdjust.latencyThreshold) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.duration, highLatencyAdjust.duration)) {
                    return false;
                }
                if (this.newViewDistanceToReset != highLatencyAdjust.newViewDistanceToReset) {
                    return false;
                }
                return this.minViewDistance == highLatencyAdjust.minViewDistance;
            }

            public HighLatencyAdjust() {
                this(false, 0, null, false, 0, 31, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleData;", "", "originalViewDistance", "", "Ljava/util/UUID;", "", "<init>", "(Ljava/util/Map;)V", "getOriginalViewDistance", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "bukkit"})
    public static final class ModuleData {
        @NotNull
        private final Map<UUID, Integer> originalViewDistance;

        public ModuleData(@NotNull Map<UUID, Integer> originalViewDistance) {
            this.originalViewDistance = originalViewDistance;
        }

        public /* synthetic */ ModuleData(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(map);
        }

        @NotNull
        public final Map<UUID, Integer> getOriginalViewDistance() {
            return this.originalViewDistance;
        }

        @NotNull
        public final Map<UUID, Integer> component1() {
            return this.originalViewDistance;
        }

        @NotNull
        public final ModuleData copy(@NotNull Map<UUID, Integer> originalViewDistance) {
            return new ModuleData(originalViewDistance);
        }

        public static /* synthetic */ ModuleData copy$default(ModuleData moduleData, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = moduleData.originalViewDistance;
            }
            return moduleData.copy(map);
        }

        @NotNull
        public String toString() {
            return "ModuleData(originalViewDistance=" + this.originalViewDistance + ")";
        }

        public int hashCode() {
            return ((Object)this.originalViewDistance).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleData)) {
                return false;
            }
            ModuleData moduleData = (ModuleData)other;
            return Intrinsics.areEqual(this.originalViewDistance, moduleData.originalViewDistance);
        }

        public ModuleData() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0017B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u0004\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleLang;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "highLatencyAdjust", "Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleLang$HighLatencyAdjust;", "<init>", "(Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleLang$HighLatencyAdjust;)V", "getHighLatencyAdjust", "()Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleLang$HighLatencyAdjust;", "analyser", "", "getAnalyser", "()Lkotlin/Unit;", "Lkotlin/Unit;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "HighLatencyAdjust", "bukkit"})
    public static final class ModuleLang
    implements ConfigurationPart {
        @NotNull
        private final HighLatencyAdjust highLatencyAdjust;
        @RemovedNode
        @Nullable
        private final Unit analyser;

        public ModuleLang(@NotNull HighLatencyAdjust highLatencyAdjust) {
            this.highLatencyAdjust = highLatencyAdjust;
        }

        public /* synthetic */ ModuleLang(HighLatencyAdjust highLatencyAdjust, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                highLatencyAdjust = new HighLatencyAdjust(null, 1, null);
            }
            this(highLatencyAdjust);
        }

        @NotNull
        public final HighLatencyAdjust getHighLatencyAdjust() {
            return this.highLatencyAdjust;
        }

        @Nullable
        public final Unit getAnalyser() {
            return this.analyser;
        }

        @NotNull
        public final HighLatencyAdjust component1() {
            return this.highLatencyAdjust;
        }

        @NotNull
        public final ModuleLang copy(@NotNull HighLatencyAdjust highLatencyAdjust) {
            return new ModuleLang(highLatencyAdjust);
        }

        public static /* synthetic */ ModuleLang copy$default(ModuleLang moduleLang, HighLatencyAdjust highLatencyAdjust, int n, Object object) {
            if ((n & 1) != 0) {
                highLatencyAdjust = moduleLang.highLatencyAdjust;
            }
            return moduleLang.copy(highLatencyAdjust);
        }

        @NotNull
        public String toString() {
            return "ModuleLang(highLatencyAdjust=" + this.highLatencyAdjust + ")";
        }

        public int hashCode() {
            return this.highLatencyAdjust.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleLang)) {
                return false;
            }
            ModuleLang moduleLang = (ModuleLang)other;
            return Intrinsics.areEqual(this.highLatencyAdjust, moduleLang.highLatencyAdjust);
        }

        public ModuleLang() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/bukkit/module/NetworkThrottleModule$ModuleLang$HighLatencyAdjust;", "", "adjustedWarning", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getAdjustedWarning", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class HighLatencyAdjust {
            @NotNull
            private final MessageData adjustedWarning;

            public HighLatencyAdjust(@NotNull MessageData adjustedWarning) {
                this.adjustedWarning = adjustedWarning;
            }

            public /* synthetic */ HighLatencyAdjust(MessageData messageData, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    messageData = MessageData.Companion.getMessage("<ec><b>Warning: </b><pc>Your network latency seems to be high. \nTo enhance your experience, we have adjusted your view distance. You can always adjust it yourself in the game options.");
                }
                this(messageData);
            }

            @NotNull
            public final MessageData getAdjustedWarning() {
                return this.adjustedWarning;
            }

            @NotNull
            public final MessageData component1() {
                return this.adjustedWarning;
            }

            @NotNull
            public final HighLatencyAdjust copy(@NotNull MessageData adjustedWarning) {
                return new HighLatencyAdjust(adjustedWarning);
            }

            public static /* synthetic */ HighLatencyAdjust copy$default(HighLatencyAdjust highLatencyAdjust, MessageData messageData, int n, Object object) {
                if ((n & 1) != 0) {
                    messageData = highLatencyAdjust.adjustedWarning;
                }
                return highLatencyAdjust.copy(messageData);
            }

            @NotNull
            public String toString() {
                return "HighLatencyAdjust(adjustedWarning=" + this.adjustedWarning + ")";
            }

            public int hashCode() {
                return this.adjustedWarning.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof HighLatencyAdjust)) {
                    return false;
                }
                HighLatencyAdjust highLatencyAdjust = (HighLatencyAdjust)other;
                return Intrinsics.areEqual(this.adjustedWarning, highLatencyAdjust.adjustedWarning);
            }

            public HighLatencyAdjust() {
                this(null, 1, null);
            }
        }
    }
}

