/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.common;

import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import io.github.rothes.esu.core.EsuBootstrap;
import io.github.rothes.esu.core.util.extension.KotlinxIoKt;
import io.github.rothes.esu.lib.configurate.yaml.internal.snakeyaml.emitter.Emitter;
import io.github.rothes.esu.lib.packetevents.PacketEvents;
import io.github.rothes.esu.lib.packetevents.manager.protocol.ProtocolManager;
import io.github.rothes.esu.lib.packetevents.protocol.ConnectionState;
import io.github.rothes.esu.lib.packetevents.protocol.player.ClientVersion;
import io.github.rothes.esu.lib.packetevents.protocol.player.User;
import io.github.rothes.esu.lib.packetevents.protocol.player.UserProfile;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.io.Buffer;
import kotlinx.io.BuffersJvmKt;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import org.incendo.cloud.parser.flag.FlagContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.statements.UpdateStatement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u001e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0011H\u0002J\u0014\u0010\u001f\u001a\u00020\u0011*\u00020 2\u0006\u0010!\u001a\u00020\u000fH\u0002J\f\u0010\"\u001a\u00020\u000f*\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/github/rothes/esu/common/HotLoadSupport;", "", "isHot", "", "hasPacketEventsPlugin", "<init>", "(ZZ)V", "()Z", "getHasPacketEventsPlugin", "dataFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "peUserData", "", "Ljava/util/UUID;", "Lio/github/rothes/esu/common/HotLoadSupport$PEUserData;", "onEnable", "", "onDisable", "loadPEUser", "channel", "uuid", "name", "", "loadPacketEventsData", "source", "Lkotlinx/io/Source;", "savePacketEventsData", "buffer", "Lkotlinx/io/Buffer;", "loadCriticalClasses", "writeUser", "Lkotlinx/io/Sink;", "data", "readUser", "PEUserData", "common"})
@SourceDebugExtension(value={"SMAP\nHotLoadSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotLoadSupport.kt\nio/github/rothes/esu/common/HotLoadSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n1563#2:189\n1634#2,3:190\n*S KotlinDebug\n*F\n+ 1 HotLoadSupport.kt\nio/github/rothes/esu/common/HotLoadSupport\n*L\n75#1:189\n75#1:190,3\n*E\n"})
public class HotLoadSupport {
    private final boolean isHot;
    private final boolean hasPacketEventsPlugin;
    private final Path dataFile;
    private Map<UUID, PEUserData> peUserData;

    public HotLoadSupport(boolean isHot, boolean hasPacketEventsPlugin) {
        this.isHot = isHot;
        this.hasPacketEventsPlugin = hasPacketEventsPlugin;
        this.dataFile = EsuBootstrap.Companion.getInstance().baseConfigPath().resolve("hot-data.tmp");
    }

    public final boolean isHot() {
        return this.isHot;
    }

    public final boolean getHasPacketEventsPlugin() {
        return this.hasPacketEventsPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onEnable() {
        this.loadCriticalClasses();
        if (this.isHot) {
            try {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(this.dataFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return;
                }
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(this.dataFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                AutoCloseable autoCloseable = CoreKt.buffered(JvmCoreKt.asSource(inputStream));
                Throwable throwable = null;
                try {
                    Source it = (Source)autoCloseable;
                    boolean bl = false;
                    if (!this.hasPacketEventsPlugin) {
                        this.loadPacketEventsData(it);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Files.deleteIfExists(this.dataFile);
            }
            catch (Throwable e) {
                this.peUserData = new LinkedHashMap();
                EsuBootstrap.Companion.getInstance().err("Failed to read hot-data", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onDisable() {
        if (this.isHot) {
            try {
                Buffer buffer = new Buffer();
                if (!this.hasPacketEventsPlugin) {
                    this.savePacketEventsData(buffer);
                }
                Object object = this.dataFile;
                Object object2 = new OpenOption[]{StandardOpenOption.CREATE};
                OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                object = outputStream;
                object2 = null;
                try {
                    OutputStream it = (OutputStream)object;
                    boolean bl = false;
                    BuffersJvmKt.copyTo$default(buffer, it, 0L, 0L, 6, null);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                this.dataFile.toFile().deleteOnExit();
            }
            catch (Throwable e) {
                EsuBootstrap.Companion.getInstance().err("Failed to save hot-data", e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void loadPEUser(@NotNull Object channel, @NotNull UUID uuid, @NotNull String name) {
        if (this.hasPacketEventsPlugin) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            User user = PacketEvents.getAPI().getProtocolManager().getUser(channel);
            com.github.retrooper.packetevents.protocol.player.User user2 = com.github.retrooper.packetevents.PacketEvents.getAPI().getProtocolManager().getUser(channel);
            if (user2 == null) {
                return;
            }
            com.github.retrooper.packetevents.protocol.player.User server = user2;
            user.setClientVersion(ClientVersion.valueOf((String)server.getClientVersion().name()));
            user.setDecoderState(ConnectionState.valueOf((String)server.getDecoderState().name()));
            user.setEncoderState(ConnectionState.valueOf((String)server.getEncoderState().name()));
            user.setEntityId(server.getEntityId());
            user.getProfile().setUUID(uuid);
            user.getProfile().setName(name);
            Iterable iterable = server.getProfile().getTextureProperties();
            UserProfile userProfile = user.getProfile();
            boolean $i$f$map = false;
            void var8_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextureProperty textureProperty = (TextureProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty(it.getName(), it.getValue(), it.getSignature()));
            }
            userProfile.setTextureProperties((List)destination$iv$iv);
            return;
        }
        if (!this.isHot) {
            return;
        }
        Map<UUID, PEUserData> map = this.peUserData;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"peUserData");
            map = null;
        }
        PEUserData data = map.get(uuid);
        User user = PacketEvents.getAPI().getProtocolManager().getUser(channel);
        user.getProfile().setUUID(uuid);
        user.getProfile().setName(name);
        if (data == null) {
            user.setConnectionState(ConnectionState.PLAY);
            user.setClientVersion(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
            EsuBootstrap.Companion.getInstance().warn("No hot packetevents user data for player '" + name + "', this may cause issues.");
            return;
        }
        PEUserData pEUserData = data;
        ClientVersion clientVersion = pEUserData.component2();
        ConnectionState decoderState = pEUserData.component3();
        ConnectionState encoderState = pEUserData.component4();
        int entityId = pEUserData.component5();
        List<io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty> texture = pEUserData.component6();
        user.setClientVersion(clientVersion);
        user.setDecoderState(decoderState);
        user.setEncoderState(encoderState);
        user.setEntityId(entityId);
        user.getProfile().setTextureProperties(texture);
    }

    private final void loadPacketEventsData(Source source) {
        this.peUserData = new LinkedHashMap();
        Source $this$loadPacketEventsData_u24lambda_u240 = source;
        boolean bl = false;
        int n = $this$loadPacketEventsData_u24lambda_u240.readInt();
        for (int i = 0; i < n; ++i) {
            PEUserData user = this.readUser($this$loadPacketEventsData_u24lambda_u240);
            Map<UUID, PEUserData> map = this.peUserData;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"peUserData");
                map = null;
            }
            Map<UUID, PEUserData> map2 = map;
            map2.put(user.getUuid(), user);
        }
    }

    private final void savePacketEventsData(Buffer buffer) {
        ProtocolManager protocolManager = PacketEvents.getAPI().getProtocolManager();
        Collection users = protocolManager.getUsers();
        buffer.writeInt(users.size());
        for (User user : users) {
            if (user.getUUID() == null) {
                return;
            }
            this.writeUser(buffer, new PEUserData(user));
        }
    }

    private final void loadCriticalClasses() {
        Buffer buffer;
        Emitter.class.getDeclaredClasses();
        FlagContext.class.toString();
        Charsets.class.toString();
        UpdateStatement.class.toString();
        Buffer $this$loadCriticalClasses_u24lambda_u240 = buffer = new Buffer();
        boolean bl = false;
        KotlinxIoKt.writeAscii($this$loadCriticalClasses_u24lambda_u240, "Load classes");
        BuffersJvmKt.copyTo$default($this$loadCriticalClasses_u24lambda_u240, new ByteArrayOutputStream(), 0L, 0L, 6, null);
        PEUserData.class.toString();
    }

    private final void writeUser(Sink $this$writeUser, PEUserData data) {
        KotlinxIoKt.writeUuid($this$writeUser, data.getUuid());
        KotlinxIoKt.writeShortFromInt($this$writeUser, data.getClientVersion().ordinal());
        KotlinxIoKt.writeByteFromInt($this$writeUser, data.getDecoderState().ordinal());
        KotlinxIoKt.writeByteFromInt($this$writeUser, data.getEncoderState().ordinal());
        $this$writeUser.writeInt(data.getEntityId());
        $this$writeUser.writeInt(data.getTexture().size());
        for (io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty property : data.getTexture()) {
            KotlinxIoKt.writeUtf($this$writeUser, property.getName());
            KotlinxIoKt.writeUtf($this$writeUser, property.getValue());
            String signature = property.getSignature();
            KotlinxIoKt.writeBool($this$writeUser, signature != null);
            if (signature == null) continue;
            KotlinxIoKt.writeAscii($this$writeUser, signature);
        }
    }

    private final PEUserData readUser(Source $this$readUser) {
        UUID uuid = KotlinxIoKt.readUuid($this$readUser);
        ClientVersion clientVersion = (ClientVersion)EntriesMappings.entries$0.get(KotlinxIoKt.readIntFromShort($this$readUser));
        ConnectionState decoderState = (ConnectionState)EntriesMappings.entries$1.get(KotlinxIoKt.readIntFromByte($this$readUser));
        ConnectionState encoderState = (ConnectionState)EntriesMappings.entries$1.get(KotlinxIoKt.readIntFromByte($this$readUser));
        int entityId = $this$readUser.readInt();
        ArrayList<io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty> texture = new ArrayList<io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty>($this$readUser.readInt());
        int n = texture.size();
        for (int i = 0; i < n; ++i) {
            String name = KotlinxIoKt.readUtf($this$readUser);
            String value = KotlinxIoKt.readUtf($this$readUser);
            String signature = KotlinxIoKt.readBool($this$readUser) ? KotlinxIoKt.readAscii($this$readUser) : null;
            texture.add(new io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty(name, value, signature));
        }
        return new PEUserData(uuid, clientVersion, decoderState, encoderState, entityId, (List<? extends io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty>)texture);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ClientVersion> entries$0;
        public static final /* synthetic */ EnumEntries<ConnectionState> entries$1;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ClientVersion.values()));
            entries$1 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ConnectionState.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0012J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003JK\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\nH\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lio/github/rothes/esu/common/HotLoadSupport$PEUserData;", "", "uuid", "Ljava/util/UUID;", "clientVersion", "Lio/github/rothes/esu/lib/packetevents/protocol/player/ClientVersion;", "decoderState", "Lio/github/rothes/esu/lib/packetevents/protocol/ConnectionState;", "encoderState", "entityId", "", "texture", "", "Lio/github/rothes/esu/lib/packetevents/protocol/player/TextureProperty;", "<init>", "(Ljava/util/UUID;Lio/github/rothes/esu/lib/packetevents/protocol/player/ClientVersion;Lio/github/rothes/esu/lib/packetevents/protocol/ConnectionState;Lio/github/rothes/esu/lib/packetevents/protocol/ConnectionState;ILjava/util/List;)V", "user", "Lio/github/rothes/esu/lib/packetevents/protocol/player/User;", "(Lio/github/rothes/esu/lib/packetevents/protocol/player/User;)V", "getUuid", "()Ljava/util/UUID;", "getClientVersion", "()Lio/github/rothes/esu/lib/packetevents/protocol/player/ClientVersion;", "getDecoderState", "()Lio/github/rothes/esu/lib/packetevents/protocol/ConnectionState;", "getEncoderState", "getEntityId", "()I", "getTexture", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "common"})
    public static final class PEUserData {
        @NotNull
        private final UUID uuid;
        @NotNull
        private final ClientVersion clientVersion;
        @NotNull
        private final ConnectionState decoderState;
        @NotNull
        private final ConnectionState encoderState;
        private final int entityId;
        @NotNull
        private final List<io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty> texture;

        public PEUserData(@NotNull UUID uuid, @NotNull ClientVersion clientVersion, @NotNull ConnectionState decoderState, @NotNull ConnectionState encoderState, int entityId, @NotNull List<? extends io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty> texture) {
            this.uuid = uuid;
            this.clientVersion = clientVersion;
            this.decoderState = decoderState;
            this.encoderState = encoderState;
            this.entityId = entityId;
            this.texture = texture;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final ClientVersion getClientVersion() {
            return this.clientVersion;
        }

        @NotNull
        public final ConnectionState getDecoderState() {
            return this.decoderState;
        }

        @NotNull
        public final ConnectionState getEncoderState() {
            return this.encoderState;
        }

        public final int getEntityId() {
            return this.entityId;
        }

        @NotNull
        public final List<io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty> getTexture() {
            return this.texture;
        }

        public PEUserData(@NotNull User user) {
            this(user.getUUID(), user.getClientVersion(), user.getDecoderState(), user.getEncoderState(), user.getEntityId(), user.getProfile().getTextureProperties());
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final ClientVersion component2() {
            return this.clientVersion;
        }

        @NotNull
        public final ConnectionState component3() {
            return this.decoderState;
        }

        @NotNull
        public final ConnectionState component4() {
            return this.encoderState;
        }

        public final int component5() {
            return this.entityId;
        }

        @NotNull
        public final List<io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty> component6() {
            return this.texture;
        }

        @NotNull
        public final PEUserData copy(@NotNull UUID uuid, @NotNull ClientVersion clientVersion, @NotNull ConnectionState decoderState, @NotNull ConnectionState encoderState, int entityId, @NotNull List<? extends io.github.rothes.esu.lib.packetevents.protocol.player.TextureProperty> texture) {
            return new PEUserData(uuid, clientVersion, decoderState, encoderState, entityId, texture);
        }

        public static /* synthetic */ PEUserData copy$default(PEUserData pEUserData, UUID uUID, ClientVersion clientVersion, ConnectionState connectionState, ConnectionState connectionState2, int n, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                uUID = pEUserData.uuid;
            }
            if ((n2 & 2) != 0) {
                clientVersion = pEUserData.clientVersion;
            }
            if ((n2 & 4) != 0) {
                connectionState = pEUserData.decoderState;
            }
            if ((n2 & 8) != 0) {
                connectionState2 = pEUserData.encoderState;
            }
            if ((n2 & 0x10) != 0) {
                n = pEUserData.entityId;
            }
            if ((n2 & 0x20) != 0) {
                list = pEUserData.texture;
            }
            return pEUserData.copy(uUID, clientVersion, connectionState, connectionState2, n, list);
        }

        @NotNull
        public String toString() {
            return "PEUserData(uuid=" + this.uuid + ", clientVersion=" + this.clientVersion + ", decoderState=" + this.decoderState + ", encoderState=" + this.encoderState + ", entityId=" + this.entityId + ", texture=" + this.texture + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + this.clientVersion.hashCode();
            result = result * 31 + this.decoderState.hashCode();
            result = result * 31 + this.encoderState.hashCode();
            result = result * 31 + Integer.hashCode(this.entityId);
            result = result * 31 + ((Object)this.texture).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PEUserData)) {
                return false;
            }
            PEUserData pEUserData = (PEUserData)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)pEUserData.uuid)) {
                return false;
            }
            if (this.clientVersion != pEUserData.clientVersion) {
                return false;
            }
            if (this.decoderState != pEUserData.decoderState) {
                return false;
            }
            if (this.encoderState != pEUserData.encoderState) {
                return false;
            }
            if (this.entityId != pEUserData.entityId) {
                return false;
            }
            return Intrinsics.areEqual(this.texture, pEUserData.texture);
        }
    }
}

