/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.velocity.module;

import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.configuration.BaseModuleConfiguration;
import io.github.rothes.esu.velocity.module.VelocityModule;
import io.github.rothes.esu.velocity.module.networkthrottle.Analyser;
import io.github.rothes.esu.velocity.module.networkthrottle.DynamicChunkSendRate;
import io.github.rothes.esu.velocity.module.networkthrottle.TrafficMonitor;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.Injector;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\n\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lio/github/rothes/esu/velocity/module/NetworkThrottleModule;", "Lio/github/rothes/esu/velocity/module/VelocityModule;", "Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig;", "Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang;", "<init>", "()V", "onEnable", "", "onDisable", "onReload", "ModuleConfig", "ModuleLang", "velocity"})
public final class NetworkThrottleModule
extends VelocityModule<ModuleConfig, ModuleLang> {
    @NotNull
    public static final NetworkThrottleModule INSTANCE = new NetworkThrottleModule();

    private NetworkThrottleModule() {
    }

    @Override
    public void onEnable() {
        Injector.INSTANCE.enable();
        TrafficMonitor.INSTANCE.enable();
        Analyser.INSTANCE.enable();
        DynamicChunkSendRate.INSTANCE.enable();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        Injector.INSTANCE.disable();
        TrafficMonitor.INSTANCE.disable();
        Analyser.INSTANCE.disable();
        Analyser.INSTANCE.reset();
        DynamicChunkSendRate.INSTANCE.disable();
    }

    @Override
    public void onReload() {
        super.onReload();
        if (((ModuleConfig)this.getConfig()).getDynamicChunkSendRate().getEnabled()) {
            DynamicChunkSendRate.INSTANCE.enable();
        } else {
            DynamicChunkSendRate.INSTANCE.disable();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseModuleConfiguration;", "dynamicChunkSendRate", "Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig$DynamicChunkSendRate;", "trafficCalibration", "Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig$TrafficCalibration;", "<init>", "(Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig$DynamicChunkSendRate;Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig$TrafficCalibration;)V", "getDynamicChunkSendRate", "()Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig$DynamicChunkSendRate;", "getTrafficCalibration", "()Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig$TrafficCalibration;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "DynamicChunkSendRate", "TrafficCalibration", "velocity"})
    public static final class ModuleConfig
    extends BaseModuleConfiguration {
        @Comment(value="Dynamic manage chunk send rate with outgoing traffic.\nNetworkThrottleModule at backend servers enabled is required.")
        @NotNull
        private final DynamicChunkSendRate dynamicChunkSendRate;
        @Comment(value="We can't know exactly what the actual bandwidth rate and packet rate are at netty level.\nYou can modify the calibration parameters here, for advanced users.")
        @NotNull
        private final TrafficCalibration trafficCalibration;

        public ModuleConfig(@NotNull DynamicChunkSendRate dynamicChunkSendRate, @NotNull TrafficCalibration trafficCalibration) {
            super(false, 1, null);
            this.dynamicChunkSendRate = dynamicChunkSendRate;
            this.trafficCalibration = trafficCalibration;
        }

        public /* synthetic */ ModuleConfig(DynamicChunkSendRate dynamicChunkSendRate, TrafficCalibration trafficCalibration, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                dynamicChunkSendRate = new DynamicChunkSendRate(false, 0L, 0L, 7, null);
            }
            if ((n & 2) != 0) {
                trafficCalibration = new TrafficCalibration(0.0, 0.0, 3, null);
            }
            this(dynamicChunkSendRate, trafficCalibration);
        }

        @NotNull
        public final DynamicChunkSendRate getDynamicChunkSendRate() {
            return this.dynamicChunkSendRate;
        }

        @NotNull
        public final TrafficCalibration getTrafficCalibration() {
            return this.trafficCalibration;
        }

        @NotNull
        public final DynamicChunkSendRate component1() {
            return this.dynamicChunkSendRate;
        }

        @NotNull
        public final TrafficCalibration component2() {
            return this.trafficCalibration;
        }

        @NotNull
        public final ModuleConfig copy(@NotNull DynamicChunkSendRate dynamicChunkSendRate, @NotNull TrafficCalibration trafficCalibration) {
            return new ModuleConfig(dynamicChunkSendRate, trafficCalibration);
        }

        public static /* synthetic */ ModuleConfig copy$default(ModuleConfig moduleConfig, DynamicChunkSendRate dynamicChunkSendRate, TrafficCalibration trafficCalibration, int n, Object object) {
            if ((n & 1) != 0) {
                dynamicChunkSendRate = moduleConfig.dynamicChunkSendRate;
            }
            if ((n & 2) != 0) {
                trafficCalibration = moduleConfig.trafficCalibration;
            }
            return moduleConfig.copy(dynamicChunkSendRate, trafficCalibration);
        }

        @NotNull
        public String toString() {
            return "ModuleConfig(dynamicChunkSendRate=" + this.dynamicChunkSendRate + ", trafficCalibration=" + this.trafficCalibration + ")";
        }

        public int hashCode() {
            int result = this.dynamicChunkSendRate.hashCode();
            result = result * 31 + this.trafficCalibration.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleConfig)) {
                return false;
            }
            ModuleConfig moduleConfig = (ModuleConfig)other;
            if (!Intrinsics.areEqual((Object)this.dynamicChunkSendRate, (Object)moduleConfig.dynamicChunkSendRate)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trafficCalibration, (Object)moduleConfig.trafficCalibration);
        }

        public ModuleConfig() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig$DynamicChunkSendRate;", "", "enabled", "", "limitUploadBandwidth", "", "guaranteedBandwidth", "<init>", "(ZJJ)V", "getEnabled", "()Z", "getLimitUploadBandwidth", "()J", "getGuaranteedBandwidth", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "velocity"})
        public static final class DynamicChunkSendRate {
            private final boolean enabled;
            @Comment(value="The upload bandwidth threshold to start the throttle. Unit is Kbps.\nWe will use the data from traffic monitor, so you may have done the\n traffic-calibration settings.")
            private final long limitUploadBandwidth;
            @Comment(value="Minimum guaranteed rate per player. If server bandwidth hits limitUploadBandwidth,\nplayer with outgoing rates above this will be limit chunk sending by one second immediately.\nThis helps reduce the probability of spikes, and distributes the bandwidth evenly.\nIt's not easy to hit the default value, you may set it lower like 1520 if you have\n many players.")
            private final long guaranteedBandwidth;

            public DynamicChunkSendRate(boolean enabled, long limitUploadBandwidth, long guaranteedBandwidth) {
                this.enabled = enabled;
                this.limitUploadBandwidth = limitUploadBandwidth;
                this.guaranteedBandwidth = guaranteedBandwidth;
            }

            public /* synthetic */ DynamicChunkSendRate(boolean bl, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                if ((n & 2) != 0) {
                    l = 51200L;
                }
                if ((n & 4) != 0) {
                    l2 = 2048L;
                }
                this(bl, l, l2);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            public final long getLimitUploadBandwidth() {
                return this.limitUploadBandwidth;
            }

            public final long getGuaranteedBandwidth() {
                return this.guaranteedBandwidth;
            }

            public final boolean component1() {
                return this.enabled;
            }

            public final long component2() {
                return this.limitUploadBandwidth;
            }

            public final long component3() {
                return this.guaranteedBandwidth;
            }

            @NotNull
            public final DynamicChunkSendRate copy(boolean enabled, long limitUploadBandwidth, long guaranteedBandwidth) {
                return new DynamicChunkSendRate(enabled, limitUploadBandwidth, guaranteedBandwidth);
            }

            public static /* synthetic */ DynamicChunkSendRate copy$default(DynamicChunkSendRate dynamicChunkSendRate, boolean bl, long l, long l2, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = dynamicChunkSendRate.enabled;
                }
                if ((n & 2) != 0) {
                    l = dynamicChunkSendRate.limitUploadBandwidth;
                }
                if ((n & 4) != 0) {
                    l2 = dynamicChunkSendRate.guaranteedBandwidth;
                }
                return dynamicChunkSendRate.copy(bl, l, l2);
            }

            @NotNull
            public String toString() {
                return "DynamicChunkSendRate(enabled=" + this.enabled + ", limitUploadBandwidth=" + this.limitUploadBandwidth + ", guaranteedBandwidth=" + this.guaranteedBandwidth + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.enabled);
                result = result * 31 + Long.hashCode(this.limitUploadBandwidth);
                result = result * 31 + Long.hashCode(this.guaranteedBandwidth);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DynamicChunkSendRate)) {
                    return false;
                }
                DynamicChunkSendRate dynamicChunkSendRate = (DynamicChunkSendRate)other;
                if (this.enabled != dynamicChunkSendRate.enabled) {
                    return false;
                }
                if (this.limitUploadBandwidth != dynamicChunkSendRate.limitUploadBandwidth) {
                    return false;
                }
                return this.guaranteedBandwidth == dynamicChunkSendRate.guaranteedBandwidth;
            }

            public DynamicChunkSendRate() {
                this(false, 0L, 0L, 7, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleConfig$TrafficCalibration;", "", "outgoingPpsMultiplier", "", "incomingPpsMultiplier", "<init>", "(DD)V", "getOutgoingPpsMultiplier", "()D", "getIncomingPpsMultiplier", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "velocity"})
        public static final class TrafficCalibration {
            private final double outgoingPpsMultiplier;
            private final double incomingPpsMultiplier;

            public TrafficCalibration(double outgoingPpsMultiplier, double incomingPpsMultiplier) {
                this.outgoingPpsMultiplier = outgoingPpsMultiplier;
                this.incomingPpsMultiplier = incomingPpsMultiplier;
            }

            public /* synthetic */ TrafficCalibration(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    d = 1.0;
                }
                if ((n & 2) != 0) {
                    d2 = 1.0;
                }
                this(d, d2);
            }

            public final double getOutgoingPpsMultiplier() {
                return this.outgoingPpsMultiplier;
            }

            public final double getIncomingPpsMultiplier() {
                return this.incomingPpsMultiplier;
            }

            public final double component1() {
                return this.outgoingPpsMultiplier;
            }

            public final double component2() {
                return this.incomingPpsMultiplier;
            }

            @NotNull
            public final TrafficCalibration copy(double outgoingPpsMultiplier, double incomingPpsMultiplier) {
                return new TrafficCalibration(outgoingPpsMultiplier, incomingPpsMultiplier);
            }

            public static /* synthetic */ TrafficCalibration copy$default(TrafficCalibration trafficCalibration, double d, double d2, int n, Object object) {
                if ((n & 1) != 0) {
                    d = trafficCalibration.outgoingPpsMultiplier;
                }
                if ((n & 2) != 0) {
                    d2 = trafficCalibration.incomingPpsMultiplier;
                }
                return trafficCalibration.copy(d, d2);
            }

            @NotNull
            public String toString() {
                return "TrafficCalibration(outgoingPpsMultiplier=" + this.outgoingPpsMultiplier + ", incomingPpsMultiplier=" + this.incomingPpsMultiplier + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.outgoingPpsMultiplier);
                result = result * 31 + Double.hashCode(this.incomingPpsMultiplier);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TrafficCalibration)) {
                    return false;
                }
                TrafficCalibration trafficCalibration = (TrafficCalibration)other;
                if (Double.compare(this.outgoingPpsMultiplier, trafficCalibration.outgoingPpsMultiplier) != 0) {
                    return false;
                }
                return Double.compare(this.incomingPpsMultiplier, trafficCalibration.incomingPpsMultiplier) == 0;
            }

            public TrafficCalibration() {
                this(0.0, 0.0, 3, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "analyser", "Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$Analyser;", "trafficMonitor", "Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$TrafficMonitor;", "<init>", "(Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$Analyser;Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$TrafficMonitor;)V", "getAnalyser", "()Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$Analyser;", "getTrafficMonitor", "()Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$TrafficMonitor;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Analyser", "TrafficMonitor", "velocity"})
    public static final class ModuleLang
    implements ConfigurationPart {
        @NotNull
        private final Analyser analyser;
        @NotNull
        private final TrafficMonitor trafficMonitor;

        public ModuleLang(@NotNull Analyser analyser, @NotNull TrafficMonitor trafficMonitor) {
            this.analyser = analyser;
            this.trafficMonitor = trafficMonitor;
        }

        public /* synthetic */ ModuleLang(Analyser analyser, TrafficMonitor trafficMonitor, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                analyser = new Analyser(null, null, null, null, null, null, 63, null);
            }
            if ((n & 2) != 0) {
                trafficMonitor = new TrafficMonitor(null, null, null, 7, null);
            }
            this(analyser, trafficMonitor);
        }

        @NotNull
        public final Analyser getAnalyser() {
            return this.analyser;
        }

        @NotNull
        public final TrafficMonitor getTrafficMonitor() {
            return this.trafficMonitor;
        }

        @NotNull
        public final Analyser component1() {
            return this.analyser;
        }

        @NotNull
        public final TrafficMonitor component2() {
            return this.trafficMonitor;
        }

        @NotNull
        public final ModuleLang copy(@NotNull Analyser analyser, @NotNull TrafficMonitor trafficMonitor) {
            return new ModuleLang(analyser, trafficMonitor);
        }

        public static /* synthetic */ ModuleLang copy$default(ModuleLang moduleLang, Analyser analyser, TrafficMonitor trafficMonitor, int n, Object object) {
            if ((n & 1) != 0) {
                analyser = moduleLang.analyser;
            }
            if ((n & 2) != 0) {
                trafficMonitor = moduleLang.trafficMonitor;
            }
            return moduleLang.copy(analyser, trafficMonitor);
        }

        @NotNull
        public String toString() {
            return "ModuleLang(analyser=" + this.analyser + ", trafficMonitor=" + this.trafficMonitor + ")";
        }

        public int hashCode() {
            int result = this.analyser.hashCode();
            result = result * 31 + this.trafficMonitor.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleLang)) {
                return false;
            }
            ModuleLang moduleLang = (ModuleLang)other;
            if (!Intrinsics.areEqual((Object)this.analyser, (Object)moduleLang.analyser)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trafficMonitor, (Object)moduleLang.trafficMonitor);
        }

        public ModuleLang() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\"BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$Analyser;", "", "started", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "stopped", "reset", "alreadyStarted", "alreadyStopped", "view", "Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$Analyser$View;", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$Analyser$View;)V", "getStarted", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getStopped", "getReset", "getAlreadyStarted", "getAlreadyStopped", "getView", "()Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$Analyser$View;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "View", "velocity"})
        public static final class Analyser {
            @NotNull
            private final MessageData started;
            @NotNull
            private final MessageData stopped;
            @NotNull
            private final MessageData reset;
            @NotNull
            private final MessageData alreadyStarted;
            @NotNull
            private final MessageData alreadyStopped;
            @NotNull
            private final View view;

            public Analyser(@NotNull MessageData started, @NotNull MessageData stopped, @NotNull MessageData reset, @NotNull MessageData alreadyStarted, @NotNull MessageData alreadyStopped, @NotNull View view) {
                this.started = started;
                this.stopped = stopped;
                this.reset = reset;
                this.alreadyStarted = alreadyStarted;
                this.alreadyStopped = alreadyStopped;
                this.view = view;
            }

            public /* synthetic */ Analyser(MessageData messageData, MessageData messageData2, MessageData messageData3, MessageData messageData4, MessageData messageData5, View view, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    messageData = MessageData.Companion.getMessage("<pc>Started the analyser.");
                }
                if ((n & 2) != 0) {
                    messageData2 = MessageData.Companion.getMessage("<pc>Stopped the analyser.");
                }
                if ((n & 4) != 0) {
                    messageData3 = MessageData.Companion.getMessage("<pc>Reset the analyser.");
                }
                if ((n & 8) != 0) {
                    messageData4 = MessageData.Companion.getMessage("<ec>The analyser is already running.");
                }
                if ((n & 0x10) != 0) {
                    messageData5 = MessageData.Companion.getMessage("<ec>The analyser is already stopped.");
                }
                if ((n & 0x20) != 0) {
                    view = new View(null, null, null, null, 15, null);
                }
                this(messageData, messageData2, messageData3, messageData4, messageData5, view);
            }

            @NotNull
            public final MessageData getStarted() {
                return this.started;
            }

            @NotNull
            public final MessageData getStopped() {
                return this.stopped;
            }

            @NotNull
            public final MessageData getReset() {
                return this.reset;
            }

            @NotNull
            public final MessageData getAlreadyStarted() {
                return this.alreadyStarted;
            }

            @NotNull
            public final MessageData getAlreadyStopped() {
                return this.alreadyStopped;
            }

            @NotNull
            public final View getView() {
                return this.view;
            }

            @NotNull
            public final MessageData component1() {
                return this.started;
            }

            @NotNull
            public final MessageData component2() {
                return this.stopped;
            }

            @NotNull
            public final MessageData component3() {
                return this.reset;
            }

            @NotNull
            public final MessageData component4() {
                return this.alreadyStarted;
            }

            @NotNull
            public final MessageData component5() {
                return this.alreadyStopped;
            }

            @NotNull
            public final View component6() {
                return this.view;
            }

            @NotNull
            public final Analyser copy(@NotNull MessageData started, @NotNull MessageData stopped, @NotNull MessageData reset, @NotNull MessageData alreadyStarted, @NotNull MessageData alreadyStopped, @NotNull View view) {
                return new Analyser(started, stopped, reset, alreadyStarted, alreadyStopped, view);
            }

            public static /* synthetic */ Analyser copy$default(Analyser analyser, MessageData messageData, MessageData messageData2, MessageData messageData3, MessageData messageData4, MessageData messageData5, View view, int n, Object object) {
                if ((n & 1) != 0) {
                    messageData = analyser.started;
                }
                if ((n & 2) != 0) {
                    messageData2 = analyser.stopped;
                }
                if ((n & 4) != 0) {
                    messageData3 = analyser.reset;
                }
                if ((n & 8) != 0) {
                    messageData4 = analyser.alreadyStarted;
                }
                if ((n & 0x10) != 0) {
                    messageData5 = analyser.alreadyStopped;
                }
                if ((n & 0x20) != 0) {
                    view = analyser.view;
                }
                return analyser.copy(messageData, messageData2, messageData3, messageData4, messageData5, view);
            }

            @NotNull
            public String toString() {
                return "Analyser(started=" + this.started + ", stopped=" + this.stopped + ", reset=" + this.reset + ", alreadyStarted=" + this.alreadyStarted + ", alreadyStopped=" + this.alreadyStopped + ", view=" + this.view + ")";
            }

            public int hashCode() {
                int result = this.started.hashCode();
                result = result * 31 + this.stopped.hashCode();
                result = result * 31 + this.reset.hashCode();
                result = result * 31 + this.alreadyStarted.hashCode();
                result = result * 31 + this.alreadyStopped.hashCode();
                result = result * 31 + this.view.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Analyser)) {
                    return false;
                }
                Analyser analyser = (Analyser)other;
                if (!Intrinsics.areEqual((Object)this.started, (Object)analyser.started)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stopped, (Object)analyser.stopped)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.reset, (Object)analyser.reset)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.alreadyStarted, (Object)analyser.alreadyStarted)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.alreadyStopped, (Object)analyser.alreadyStopped)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.view, (Object)analyser.view);
            }

            public Analyser() {
                this(null, null, null, null, null, null, 63, null);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$Analyser$View;", "", "noData", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "header", "entry", "footer", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getNoData", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getHeader", "getEntry", "getFooter", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "velocity"})
            public static final class View {
                @NotNull
                private final MessageData noData;
                @NotNull
                private final MessageData header;
                @NotNull
                private final MessageData entry;
                @NotNull
                private final MessageData footer;

                public View(@NotNull MessageData noData, @NotNull MessageData header, @NotNull MessageData entry, @NotNull MessageData footer) {
                    this.noData = noData;
                    this.header = header;
                    this.entry = entry;
                    this.footer = footer;
                }

                public /* synthetic */ View(MessageData messageData, MessageData messageData2, MessageData messageData3, MessageData messageData4, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 1) != 0) {
                        messageData = MessageData.Companion.getMessage("<pc>There's no data for view.");
                    }
                    if ((n & 2) != 0) {
                        messageData2 = MessageData.Companion.getMessage("<pdc>[Packet Type]<pc> <pc>[count]</pc>: <sc>[size] <tc>/ [raw-size]</tc>");
                    }
                    if ((n & 4) != 0) {
                        messageData3 = MessageData.Companion.getMessage("<tdc><packet-type> <pc>x<pdc><counts></pc><tc>: <sdc><compressed-size> <tc>/ <tdc><uncompressed-size>");
                    }
                    if ((n & 8) != 0) {
                        messageData4 = MessageData.Companion.getMessage("<pc>The analyser has been running for <duration>");
                    }
                    this(messageData, messageData2, messageData3, messageData4);
                }

                @NotNull
                public final MessageData getNoData() {
                    return this.noData;
                }

                @NotNull
                public final MessageData getHeader() {
                    return this.header;
                }

                @NotNull
                public final MessageData getEntry() {
                    return this.entry;
                }

                @NotNull
                public final MessageData getFooter() {
                    return this.footer;
                }

                @NotNull
                public final MessageData component1() {
                    return this.noData;
                }

                @NotNull
                public final MessageData component2() {
                    return this.header;
                }

                @NotNull
                public final MessageData component3() {
                    return this.entry;
                }

                @NotNull
                public final MessageData component4() {
                    return this.footer;
                }

                @NotNull
                public final View copy(@NotNull MessageData noData, @NotNull MessageData header, @NotNull MessageData entry, @NotNull MessageData footer) {
                    return new View(noData, header, entry, footer);
                }

                public static /* synthetic */ View copy$default(View view, MessageData messageData, MessageData messageData2, MessageData messageData3, MessageData messageData4, int n, Object object) {
                    if ((n & 1) != 0) {
                        messageData = view.noData;
                    }
                    if ((n & 2) != 0) {
                        messageData2 = view.header;
                    }
                    if ((n & 4) != 0) {
                        messageData3 = view.entry;
                    }
                    if ((n & 8) != 0) {
                        messageData4 = view.footer;
                    }
                    return view.copy(messageData, messageData2, messageData3, messageData4);
                }

                @NotNull
                public String toString() {
                    return "View(noData=" + this.noData + ", header=" + this.header + ", entry=" + this.entry + ", footer=" + this.footer + ")";
                }

                public int hashCode() {
                    int result = this.noData.hashCode();
                    result = result * 31 + this.header.hashCode();
                    result = result * 31 + this.entry.hashCode();
                    result = result * 31 + this.footer.hashCode();
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof View)) {
                        return false;
                    }
                    View view = (View)other;
                    if (!Intrinsics.areEqual((Object)this.noData, (Object)view.noData)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.header, (Object)view.header)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.entry, (Object)view.entry)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.footer, (Object)view.footer);
                }

                public View() {
                    this(null, null, null, null, 15, null);
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/github/rothes/esu/velocity/module/NetworkThrottleModule$ModuleLang$TrafficMonitor;", "", "message", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "enabled", "disabled", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getMessage", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getEnabled", "getDisabled", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "velocity"})
        public static final class TrafficMonitor {
            @NotNull
            private final MessageData message;
            @NotNull
            private final MessageData enabled;
            @NotNull
            private final MessageData disabled;

            public TrafficMonitor(@NotNull MessageData message, @NotNull MessageData enabled, @NotNull MessageData disabled) {
                this.message = message;
                this.enabled = enabled;
                this.disabled = disabled;
            }

            public /* synthetic */ TrafficMonitor(MessageData messageData, MessageData messageData2, MessageData messageData3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    messageData = MessageData.Companion.getMessage("<actionbar><pdc><b>ESU</b> Monitor <tc>-  <#BF71FF>\u2b06 <pc><outgoing-traffic>  <outgoing-pps>pps  <tc>|  <#6AFFF3>\u2b07 <pc><incoming-traffic>  <incoming-pps>pps");
                }
                if ((n & 2) != 0) {
                    messageData2 = MessageData.Companion.getMessage("<pc>You are now viewing traffic monitor.");
                }
                if ((n & 4) != 0) {
                    messageData3 = MessageData.Companion.getMessage("<pc>You are no longer viewing traffic monitor.<actionbar>");
                }
                this(messageData, messageData2, messageData3);
            }

            @NotNull
            public final MessageData getMessage() {
                return this.message;
            }

            @NotNull
            public final MessageData getEnabled() {
                return this.enabled;
            }

            @NotNull
            public final MessageData getDisabled() {
                return this.disabled;
            }

            @NotNull
            public final MessageData component1() {
                return this.message;
            }

            @NotNull
            public final MessageData component2() {
                return this.enabled;
            }

            @NotNull
            public final MessageData component3() {
                return this.disabled;
            }

            @NotNull
            public final TrafficMonitor copy(@NotNull MessageData message, @NotNull MessageData enabled, @NotNull MessageData disabled) {
                return new TrafficMonitor(message, enabled, disabled);
            }

            public static /* synthetic */ TrafficMonitor copy$default(TrafficMonitor trafficMonitor, MessageData messageData, MessageData messageData2, MessageData messageData3, int n, Object object) {
                if ((n & 1) != 0) {
                    messageData = trafficMonitor.message;
                }
                if ((n & 2) != 0) {
                    messageData2 = trafficMonitor.enabled;
                }
                if ((n & 4) != 0) {
                    messageData3 = trafficMonitor.disabled;
                }
                return trafficMonitor.copy(messageData, messageData2, messageData3);
            }

            @NotNull
            public String toString() {
                return "TrafficMonitor(message=" + this.message + ", enabled=" + this.enabled + ", disabled=" + this.disabled + ")";
            }

            public int hashCode() {
                int result = this.message.hashCode();
                result = result * 31 + this.enabled.hashCode();
                result = result * 31 + this.disabled.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TrafficMonitor)) {
                    return false;
                }
                TrafficMonitor trafficMonitor = (TrafficMonitor)other;
                if (!Intrinsics.areEqual((Object)this.message, (Object)trafficMonitor.message)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.enabled, (Object)trafficMonitor.enabled)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.disabled, (Object)trafficMonitor.disabled);
            }

            public TrafficMonitor() {
                this(null, null, null, 7, null);
            }
        }
    }
}

