/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.velocity.module.networkthrottle;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.scheduler.ScheduledTask;
import io.github.rothes.esu.velocity.InternalsKt;
import io.github.rothes.esu.velocity.module.NetworkThrottleModule;
import io.github.rothes.esu.velocity.module.VelocityModule;
import io.github.rothes.esu.velocity.module.networkthrottle.TrafficMonitor;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.EncoderChannelHandler;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.Injector;
import io.github.rothes.esu.velocity.module.networkthrottle.channel.PacketData;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/DynamicChunkSendRate;", "", "<init>", "()V", "CHANNEL_IDENTIFIER", "Lcom/velocitypowered/api/proxy/messages/MinecraftChannelIdentifier;", "kotlin.jvm.PlatformType", "traffic", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/velocitypowered/api/proxy/Player;", "Ljava/util/concurrent/atomic/AtomicLong;", "task", "Lcom/velocitypowered/api/scheduler/ScheduledTask;", "running", "", "getRunning", "()Z", "enable", "", "disable", "Listeners", "EncoderHandler", "velocity"})
public final class DynamicChunkSendRate {
    @NotNull
    public static final DynamicChunkSendRate INSTANCE = new DynamicChunkSendRate();
    private static final MinecraftChannelIdentifier CHANNEL_IDENTIFIER = MinecraftChannelIdentifier.create((String)"esu", (String)"dynamic_chunk_send_rate_limit");
    @NotNull
    private static final ConcurrentHashMap<Player, AtomicLong> traffic = new ConcurrentHashMap();
    @Nullable
    private static ScheduledTask task;

    private DynamicChunkSendRate() {
    }

    public final boolean getRunning() {
        return task != null;
    }

    public final void enable() {
        VelocityModule.registerListener$default(NetworkThrottleModule.INSTANCE, Listeners.INSTANCE, null, 2, null);
        if (((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getDynamicChunkSendRate().getEnabled() && !this.getRunning()) {
            task = InternalsKt.getPlugin().getServer().getScheduler().buildTask((Object)InternalsKt.getPlugin().getBootstrap(), DynamicChunkSendRate::enable$lambda$0).repeat(Duration.ofSeconds(1L)).schedule();
            TrafficMonitor.INSTANCE.forceRecord();
            Injector.INSTANCE.registerHandler(EncoderHandler.INSTANCE);
        }
    }

    public final void disable() {
        if (this.getRunning()) {
            ScheduledTask scheduledTask = task;
            if (scheduledTask != null) {
                scheduledTask.cancel();
            }
            task = null;
            TrafficMonitor.INSTANCE.cancelForceRecord();
            Injector.INSTANCE.unregisterHandler(EncoderHandler.INSTANCE);
            traffic.clear();
        }
    }

    private static final void enable$lambda$0(ScheduledTask task) {
        Iterator iterator2 = ((Map)traffic).entrySet().iterator();
        while (iterator2.hasNext()) {
            AtomicLong atomicLong = (AtomicLong)iterator2.next().getValue();
            atomicLong.set(0L);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/DynamicChunkSendRate$EncoderHandler;", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/EncoderChannelHandler;", "<init>", "()V", "encode", "", "packetData", "Lio/github/rothes/esu/velocity/module/networkthrottle/channel/PacketData;", "velocity"})
    public static final class EncoderHandler
    implements EncoderChannelHandler {
        @NotNull
        public static final EncoderHandler INSTANCE = new EncoderHandler();

        private EncoderHandler() {
        }

        @Override
        public void encode(@NotNull PacketData packetData) {
            Player player = packetData.getPlayer();
            if (player == null) {
                return;
            }
            Player player2 = player;
            AtomicLong atomicLong = traffic.computeIfAbsent(player2, arg_0 -> EncoderHandler.encode$lambda$1(EncoderHandler::encode$lambda$0, arg_0));
            long outgoing = atomicLong.addAndGet((long)packetData.getCompressedSize() + 15L) >> 7;
            long total = TrafficMonitor.INSTANCE.getLastOutgoingBytes() >> 7;
            if (total >= ((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getDynamicChunkSendRate().getLimitUploadBandwidth() && outgoing >= ((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getDynamicChunkSendRate().getGuaranteedBandwidth()) {
                Optional optional = player2.getCurrentServer();
                if (optional != null && (optional = (ServerConnection)OptionalsKt.getOrNull(optional)) != null) {
                    optional.sendPluginMessage((ChannelIdentifier)CHANNEL_IDENTIFIER, new byte[0]);
                }
                atomicLong.set(0L);
            }
        }

        @Override
        public void flush() {
            EncoderChannelHandler.super.flush();
        }

        private static final AtomicLong encode$lambda$0(Player it) {
            return new AtomicLong(0L);
        }

        private static final AtomicLong encode$lambda$1(Function1 $tmp0, Object p0) {
            return (AtomicLong)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lio/github/rothes/esu/velocity/module/networkthrottle/DynamicChunkSendRate$Listeners;", "", "<init>", "()V", "onMessage", "", "e", "Lcom/velocitypowered/api/event/connection/PluginMessageEvent;", "onDisconnect", "Lcom/velocitypowered/api/event/connection/DisconnectEvent;", "velocity"})
    public static final class Listeners {
        @NotNull
        public static final Listeners INSTANCE = new Listeners();

        private Listeners() {
        }

        @Subscribe
        public final void onMessage(@NotNull PluginMessageEvent e) {
            if (Intrinsics.areEqual(e.getIdentifier(), CHANNEL_IDENTIFIER) && e.getSource() instanceof Player) {
                e.setResult(PluginMessageEvent.ForwardResult.handled());
            }
        }

        @Subscribe
        public final void onDisconnect(@NotNull DisconnectEvent e) {
            traffic.remove(e.getPlayer());
        }
    }
}

