/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module;

import io.github.rothes.esu.bukkit.module.BukkitModule;
import io.github.rothes.esu.bukkit.module.exploitfix.VaultUnlocking;
import io.github.rothes.esu.bukkit.util.extension.ListenerExt;
import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.configuration.BaseModuleConfiguration;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\n\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixesModule;", "Lio/github/rothes/esu/bukkit/module/BukkitModule;", "Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig;", "Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleLang;", "<init>", "()V", "onEnable", "", "onDisable", "onReload", "Listeners", "ModuleConfig", "ModuleLang", "bukkit"})
public final class ExploitFixesModule
extends BukkitModule<ModuleConfig, ModuleLang> {
    @NotNull
    public static final ExploitFixesModule INSTANCE = new ExploitFixesModule();

    private ExploitFixesModule() {
    }

    @Override
    public void onEnable() {
        ListenerExt.register$default(ListenerExt.INSTANCE, Listeners.INSTANCE, null, 1, null);
        VaultUnlocking.INSTANCE.onEnable();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        ListenerExt.INSTANCE.unregister(Listeners.INSTANCE);
        VaultUnlocking.INSTANCE.onDisable();
    }

    @Override
    public void onReload() {
        super.onReload();
        VaultUnlocking.INSTANCE.onReload();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$Listeners;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onInvClick", "", "e", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "bukkit"})
    private static final class Listeners
    implements Listener {
        @NotNull
        public static final Listeners INSTANCE = new Listeners();

        private Listeners() {
        }

        @EventHandler
        public final void onInvClick(@NotNull InventoryClickEvent e) {
            ModuleConfig config = (ModuleConfig)INSTANCE.getConfig();
            if (!config.getConsumerItem().getEnabled()) {
                return;
            }
            HumanEntity humanEntity = (HumanEntity)CollectionsKt.firstOrNull((List)e.getViewers());
            if (humanEntity == null) {
                return;
            }
            HumanEntity player = humanEntity;
            if (player.isHandRaised()) {
                if (config.getConsumerItem().getOnlyBlockConsumerItems()) {
                    if (e.getHotbarButton() == -1) {
                        return;
                    }
                    ItemStack itemStack = player.getInventory().getItem(e.getHotbarButton());
                    if (itemStack == null) {
                        return;
                    }
                    ItemStack item = itemStack;
                    Material type = item.getType();
                    if (type != Material.BOW && type != Material.TRIDENT) {
                        return;
                    }
                }
                e.setCancelled(true);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseModuleConfiguration;", "consumerItem", "Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig$ConsumerItem;", "vaultUnlocking", "Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig$VaultUnlocking;", "<init>", "(Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig$ConsumerItem;Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig$VaultUnlocking;)V", "getConsumerItem", "()Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig$ConsumerItem;", "getVaultUnlocking", "()Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig$VaultUnlocking;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ConsumerItem", "VaultUnlocking", "bukkit"})
    public static final class ModuleConfig
    extends BaseModuleConfiguration {
        @NotNull
        private final ConsumerItem consumerItem;
        @NotNull
        private final VaultUnlocking vaultUnlocking;

        public ModuleConfig(@NotNull ConsumerItem consumerItem, @NotNull VaultUnlocking vaultUnlocking) {
            super(false, 1, null);
            this.consumerItem = consumerItem;
            this.vaultUnlocking = vaultUnlocking;
        }

        public /* synthetic */ ModuleConfig(ConsumerItem consumerItem, VaultUnlocking vaultUnlocking, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                consumerItem = new ConsumerItem(false, false, 3, null);
            }
            if ((n & 2) != 0) {
                vaultUnlocking = new VaultUnlocking(false, null, 0, 7, null);
            }
            this(consumerItem, vaultUnlocking);
        }

        @NotNull
        public final ConsumerItem getConsumerItem() {
            return this.consumerItem;
        }

        @NotNull
        public final VaultUnlocking getVaultUnlocking() {
            return this.vaultUnlocking;
        }

        @NotNull
        public final ConsumerItem component1() {
            return this.consumerItem;
        }

        @NotNull
        public final VaultUnlocking component2() {
            return this.vaultUnlocking;
        }

        @NotNull
        public final ModuleConfig copy(@NotNull ConsumerItem consumerItem, @NotNull VaultUnlocking vaultUnlocking) {
            return new ModuleConfig(consumerItem, vaultUnlocking);
        }

        public static /* synthetic */ ModuleConfig copy$default(ModuleConfig moduleConfig, ConsumerItem consumerItem, VaultUnlocking vaultUnlocking, int n, Object object) {
            if ((n & 1) != 0) {
                consumerItem = moduleConfig.consumerItem;
            }
            if ((n & 2) != 0) {
                vaultUnlocking = moduleConfig.vaultUnlocking;
            }
            return moduleConfig.copy(consumerItem, vaultUnlocking);
        }

        @NotNull
        public String toString() {
            return "ModuleConfig(consumerItem=" + this.consumerItem + ", vaultUnlocking=" + this.vaultUnlocking + ")";
        }

        public int hashCode() {
            int result = this.consumerItem.hashCode();
            result = result * 31 + this.vaultUnlocking.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleConfig)) {
                return false;
            }
            ModuleConfig moduleConfig = (ModuleConfig)other;
            if (!Intrinsics.areEqual((Object)this.consumerItem, (Object)moduleConfig.consumerItem)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.vaultUnlocking, (Object)moduleConfig.vaultUnlocking);
        }

        public ModuleConfig() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig$ConsumerItem;", "", "enabled", "", "onlyBlockConsumerItems", "<init>", "(ZZ)V", "getEnabled", "()Z", "getOnlyBlockConsumerItems", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class ConsumerItem {
            @Comment(value="\n                Blocks moving or clicking items in inventory while player is using item.\n                This is for fixing trident/bow duplication exploit.\n                If you are running Minecraft 1.21.5 or above, duplication is already fixed, and you don't need this.\n            ")
            private final boolean enabled;
            @Comment(value="\n                More detailed detect to block trident/bow duplication only.\n                If you want to allow more cheats, enable this.\n            ")
            private final boolean onlyBlockConsumerItems;

            public ConsumerItem(boolean enabled, boolean onlyBlockConsumerItems) {
                this.enabled = enabled;
                this.onlyBlockConsumerItems = onlyBlockConsumerItems;
            }

            public /* synthetic */ ConsumerItem(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    bl2 = false;
                }
                this(bl, bl2);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            public final boolean getOnlyBlockConsumerItems() {
                return this.onlyBlockConsumerItems;
            }

            public final boolean component1() {
                return this.enabled;
            }

            public final boolean component2() {
                return this.onlyBlockConsumerItems;
            }

            @NotNull
            public final ConsumerItem copy(boolean enabled, boolean onlyBlockConsumerItems) {
                return new ConsumerItem(enabled, onlyBlockConsumerItems);
            }

            public static /* synthetic */ ConsumerItem copy$default(ConsumerItem consumerItem, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = consumerItem.enabled;
                }
                if ((n & 2) != 0) {
                    bl2 = consumerItem.onlyBlockConsumerItems;
                }
                return consumerItem.copy(bl, bl2);
            }

            @NotNull
            public String toString() {
                return "ConsumerItem(enabled=" + this.enabled + ", onlyBlockConsumerItems=" + this.onlyBlockConsumerItems + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.enabled);
                result = result * 31 + Boolean.hashCode(this.onlyBlockConsumerItems);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConsumerItem)) {
                    return false;
                }
                ConsumerItem consumerItem = (ConsumerItem)other;
                if (this.enabled != consumerItem.enabled) {
                    return false;
                }
                return this.onlyBlockConsumerItems == consumerItem.onlyBlockConsumerItems;
            }

            public ConsumerItem() {
                this(false, false, 3, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleConfig$VaultUnlocking;", "", "enabled", "", "unlockExpiry", "Ljava/time/Duration;", "maxUnlocksPerVault", "", "<init>", "(ZLjava/time/Duration;I)V", "getEnabled", "()Z", "getUnlockExpiry", "()Ljava/time/Duration;", "getMaxUnlocksPerVault", "()I", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "bukkit"})
        public static final class VaultUnlocking {
            @Comment(value="\n                Each vault keeps track of up to 128 latest unique players that have unlocked it. Which means, if a player\n                 owns more than 128 accounts, they can unlock the vault sequentially and indefinitely.\n                To solve this, we added a restriction that a vault can only be opened a specified number of times\n                 within a period of time, so they cannot easily abuse it.\n            ")
            private final boolean enabled;
            @Comment(value="Each vault unlock expiry time")
            @NotNull
            private final Duration unlockExpiry;
            @Comment(value="\n                Max allowed recorded unlocks per vault.\n                Once exceeded, this vault cannot be unlocked until one record expires.\n            ")
            private final int maxUnlocksPerVault;

            public VaultUnlocking(boolean enabled, @NotNull Duration unlockExpiry, int maxUnlocksPerVault) {
                this.enabled = enabled;
                this.unlockExpiry = unlockExpiry;
                this.maxUnlocksPerVault = maxUnlocksPerVault;
            }

            public /* synthetic */ VaultUnlocking(boolean bl, Duration duration, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    bl = false;
                }
                if ((n2 & 2) != 0) {
                    duration = Duration.ofMinutes(30L);
                }
                if ((n2 & 4) != 0) {
                    n = 10;
                }
                this(bl, duration, n);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            @NotNull
            public final Duration getUnlockExpiry() {
                return this.unlockExpiry;
            }

            public final int getMaxUnlocksPerVault() {
                return this.maxUnlocksPerVault;
            }

            public final boolean component1() {
                return this.enabled;
            }

            @NotNull
            public final Duration component2() {
                return this.unlockExpiry;
            }

            public final int component3() {
                return this.maxUnlocksPerVault;
            }

            @NotNull
            public final VaultUnlocking copy(boolean enabled, @NotNull Duration unlockExpiry, int maxUnlocksPerVault) {
                return new VaultUnlocking(enabled, unlockExpiry, maxUnlocksPerVault);
            }

            public static /* synthetic */ VaultUnlocking copy$default(VaultUnlocking vaultUnlocking, boolean bl, Duration duration, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    bl = vaultUnlocking.enabled;
                }
                if ((n2 & 2) != 0) {
                    duration = vaultUnlocking.unlockExpiry;
                }
                if ((n2 & 4) != 0) {
                    n = vaultUnlocking.maxUnlocksPerVault;
                }
                return vaultUnlocking.copy(bl, duration, n);
            }

            @NotNull
            public String toString() {
                return "VaultUnlocking(enabled=" + this.enabled + ", unlockExpiry=" + this.unlockExpiry + ", maxUnlocksPerVault=" + this.maxUnlocksPerVault + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.enabled);
                result = result * 31 + this.unlockExpiry.hashCode();
                result = result * 31 + Integer.hashCode(this.maxUnlocksPerVault);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VaultUnlocking)) {
                    return false;
                }
                VaultUnlocking vaultUnlocking = (VaultUnlocking)other;
                if (this.enabled != vaultUnlocking.enabled) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.unlockExpiry, (Object)vaultUnlocking.unlockExpiry)) {
                    return false;
                }
                return this.maxUnlocksPerVault == vaultUnlocking.maxUnlocksPerVault;
            }

            public VaultUnlocking() {
                this(false, null, 0, 7, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0012B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleLang;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "vaultUnlocking", "Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleLang$VaultUnlocking;", "<init>", "(Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleLang$VaultUnlocking;)V", "getVaultUnlocking", "()Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleLang$VaultUnlocking;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "VaultUnlocking", "bukkit"})
    public static final class ModuleLang
    implements ConfigurationPart {
        @NotNull
        private final VaultUnlocking vaultUnlocking;

        public ModuleLang(@NotNull VaultUnlocking vaultUnlocking) {
            this.vaultUnlocking = vaultUnlocking;
        }

        public /* synthetic */ ModuleLang(VaultUnlocking vaultUnlocking, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                vaultUnlocking = new VaultUnlocking(null, 1, null);
            }
            this(vaultUnlocking);
        }

        @NotNull
        public final VaultUnlocking getVaultUnlocking() {
            return this.vaultUnlocking;
        }

        @NotNull
        public final VaultUnlocking component1() {
            return this.vaultUnlocking;
        }

        @NotNull
        public final ModuleLang copy(@NotNull VaultUnlocking vaultUnlocking) {
            return new ModuleLang(vaultUnlocking);
        }

        public static /* synthetic */ ModuleLang copy$default(ModuleLang moduleLang, VaultUnlocking vaultUnlocking, int n, Object object) {
            if ((n & 1) != 0) {
                vaultUnlocking = moduleLang.vaultUnlocking;
            }
            return moduleLang.copy(vaultUnlocking);
        }

        @NotNull
        public String toString() {
            return "ModuleLang(vaultUnlocking=" + this.vaultUnlocking + ")";
        }

        public int hashCode() {
            return this.vaultUnlocking.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleLang)) {
                return false;
            }
            ModuleLang moduleLang = (ModuleLang)other;
            return Intrinsics.areEqual((Object)this.vaultUnlocking, (Object)moduleLang.vaultUnlocking);
        }

        public ModuleLang() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixesModule$ModuleLang$VaultUnlocking;", "", "tooManyUnlocks", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getTooManyUnlocks", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class VaultUnlocking {
            @NotNull
            private final MessageData tooManyUnlocks;

            public VaultUnlocking(@NotNull MessageData tooManyUnlocks) {
                this.tooManyUnlocks = tooManyUnlocks;
            }

            public /* synthetic */ VaultUnlocking(MessageData messageData, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    messageData = MessageData.Companion.getMessage("<actionbar><ec>Please wait <duration> before unlocking this vault");
                }
                this(messageData);
            }

            @NotNull
            public final MessageData getTooManyUnlocks() {
                return this.tooManyUnlocks;
            }

            @NotNull
            public final MessageData component1() {
                return this.tooManyUnlocks;
            }

            @NotNull
            public final VaultUnlocking copy(@NotNull MessageData tooManyUnlocks) {
                return new VaultUnlocking(tooManyUnlocks);
            }

            public static /* synthetic */ VaultUnlocking copy$default(VaultUnlocking vaultUnlocking, MessageData messageData, int n, Object object) {
                if ((n & 1) != 0) {
                    messageData = vaultUnlocking.tooManyUnlocks;
                }
                return vaultUnlocking.copy(messageData);
            }

            @NotNull
            public String toString() {
                return "VaultUnlocking(tooManyUnlocks=" + this.tooManyUnlocks + ")";
            }

            public int hashCode() {
                return this.tooManyUnlocks.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VaultUnlocking)) {
                    return false;
                }
                VaultUnlocking vaultUnlocking = (VaultUnlocking)other;
                return Intrinsics.areEqual((Object)this.tooManyUnlocks, (Object)vaultUnlocking.tooManyUnlocks);
            }

            public VaultUnlocking() {
                this(null, 1, null);
            }
        }
    }
}

