/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.lib.org.spongepowered.configurate.serialize;

import io.github.rothes.esu.lib.org.spongepowered.configurate.serialize.PatternFlags;
import io.github.rothes.esu.lib.org.spongepowered.configurate.serialize.ScalarSerializer;
import io.github.rothes.esu.lib.org.spongepowered.configurate.serialize.SerializationException;
import java.lang.reflect.AnnotatedType;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PatternSerializer
extends ScalarSerializer.Annotated<Pattern> {
    PatternSerializer() {
        super(Pattern.class);
    }

    @Override
    public Pattern deserialize(AnnotatedType type, Object obj) throws SerializationException {
        try {
            @Nullable PatternFlags flags = type.getAnnotation(PatternFlags.class);
            if (flags != null) {
                return Pattern.compile(obj.toString(), flags.value());
            }
            return Pattern.compile(obj.toString());
        }
        catch (PatternSyntaxException ex) {
            throw new SerializationException(ex);
        }
    }

    @Override
    public Object serialize(AnnotatedType type, Pattern item, Predicate<Class<?>> typeSupported) {
        return item.pattern();
    }
}

