/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module;

import io.github.rothes.esu.bukkit.module.BukkitModule;
import io.github.rothes.esu.bukkit.module.OptimizationsModule;
import io.github.rothes.esu.bukkit.module.optimizations.TicketTypeHandler;
import io.github.rothes.esu.bukkit.util.scheduler.Scheduler;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.configuration.BaseModuleConfiguration;
import io.github.rothes.esu.core.module.configuration.EmptyConfiguration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lio/github/rothes/esu/bukkit/module/OptimizationsModule;", "Lio/github/rothes/esu/bukkit/module/BukkitModule;", "Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/EmptyConfiguration;", "<init>", "()V", "enable", "", "reloadConfig", "applyTicketType", "ModuleConfig", "bukkit"})
public final class OptimizationsModule
extends BukkitModule<ModuleConfig, EmptyConfiguration> {
    @NotNull
    public static final OptimizationsModule INSTANCE = new OptimizationsModule();

    private OptimizationsModule() {
    }

    @Override
    public void enable() {
        BukkitModule.registerListener$default(this, new Listener(){

            @EventHandler
            public final void onLiquidSpread(BlockFromToEvent e) {
                ModuleConfig.Waterlogged config;
                if (e.getBlock().getBlockData() instanceof Waterlogged && (config = ((ModuleConfig)OptimizationsModule.INSTANCE.getConfig()).getWaterlogged()).getDisableWaterSpread()) {
                    e.setCancelled(true);
                }
            }

            @EventHandler
            public final void onPistonPushWaterlogged(BlockPistonExtendEvent e) {
                this.handleWaterloggedPush(e.getBlocks(), (BlockPistonEvent)e);
            }

            @EventHandler
            public final void onPistonPushWaterlogged(BlockPistonRetractEvent e) {
                this.handleWaterloggedPush(e.getBlocks(), (BlockPistonEvent)e);
            }

            private final void handleWaterloggedPush(List<Block> blocks, BlockPistonEvent e) {
                ModuleConfig.Waterlogged config = ((ModuleConfig)OptimizationsModule.INSTANCE.getConfig()).getWaterlogged();
                if (config.getDisableWaterloggedBlockPush()) {
                    boolean bl;
                    block7: {
                        Iterable $this$any$iv = blocks;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Block it = (Block)element$iv;
                                boolean bl2 = false;
                                BlockData blockData = it.getBlockData();
                                Waterlogged waterlogged = blockData instanceof Waterlogged ? (Waterlogged)blockData : null;
                                boolean bl3 = waterlogged != null ? waterlogged.isWaterlogged() : false;
                                if (!bl3) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        e.setCancelled(true);
                        return;
                    }
                }
                if (!config.getDisableWaterSpread() || !config.getKeepWaterAfterPistonPush()) {
                    return;
                }
                BlockFace face = e.getDirection();
                for (Block block : blocks) {
                    Waterlogged waterlogged;
                    BlockData blockData = block.getBlockData();
                    Waterlogged waterlogged2 = blockData instanceof Waterlogged ? (Waterlogged)blockData : null;
                    if (waterlogged2 == null || !(waterlogged = waterlogged2).isWaterlogged()) continue;
                    Scheduler.schedule$default(Scheduler.INSTANCE, block.getLocation(), 3L, null, () -> enable.1.handleWaterloggedPush$lambda$1(block, face), 4, null);
                }
            }

            private static final Unit handleWaterloggedPush$lambda$1(Block $block, BlockFace $face) {
                Block moved = $block.getRelative($face);
                BlockData blockData = moved.getBlockData();
                Intrinsics.checkNotNull((Object)blockData, (String)"null cannot be cast to non-null type org.bukkit.block.data.Waterlogged");
                Waterlogged blockData2 = (Waterlogged)blockData;
                blockData2.setWaterlogged(true);
                moved.setBlockData((BlockData)blockData2);
                return Unit.INSTANCE;
            }
        }, null, 2, null);
        this.applyTicketType();
    }

    @Override
    public void reloadConfig() {
        super.reloadConfig();
        if (this.getEnabled()) {
            this.applyTicketType();
        }
    }

    private final void applyTicketType() {
        for (Map.Entry<String, Long> entry : ((ModuleConfig)this.getConfig()).getTicketType().getStartupSettings().entrySet()) {
            String key = entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            TicketTypeHandler.TicketType ticketType = TicketTypeHandler.Companion.getHandler().getTicketTypeMap().get(key);
            if (ticketType == null) {
                this.log(key + " ticket type not found");
                continue;
            }
            ticketType.setExpiryTicks(value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseModuleConfiguration;", "ticketType", "Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$TicketType;", "waterlogged", "Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$Waterlogged;", "<init>", "(Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$TicketType;Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$Waterlogged;)V", "getTicketType", "()Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$TicketType;", "getWaterlogged", "()Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$Waterlogged;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "TicketType", "Waterlogged", "bukkit"})
    public static final class ModuleConfig
    extends BaseModuleConfiguration {
        @Comment(value="\n            Change server ticket type settings.\n            Tickets control chunk loading. For details, check https://minecraft.wiki/w/Chunk#Tickets\n            Setting expiry-ticks to 0 or negative value makes the chunk load forever until the ticket\n             is manually removed.\n        ")
        @NotNull
        private final TicketType ticketType;
        @NotNull
        private final Waterlogged waterlogged;

        public ModuleConfig(@NotNull TicketType ticketType, @NotNull Waterlogged waterlogged) {
            super(false, 1, null);
            this.ticketType = ticketType;
            this.waterlogged = waterlogged;
        }

        public /* synthetic */ ModuleConfig(TicketType ticketType, Waterlogged waterlogged, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                ticketType = new TicketType(null, 1, null);
            }
            if ((n & 2) != 0) {
                waterlogged = new Waterlogged(false, false, false, 7, null);
            }
            this(ticketType, waterlogged);
        }

        @NotNull
        public final TicketType getTicketType() {
            return this.ticketType;
        }

        @NotNull
        public final Waterlogged getWaterlogged() {
            return this.waterlogged;
        }

        @NotNull
        public final TicketType component1() {
            return this.ticketType;
        }

        @NotNull
        public final Waterlogged component2() {
            return this.waterlogged;
        }

        @NotNull
        public final ModuleConfig copy(@NotNull TicketType ticketType, @NotNull Waterlogged waterlogged) {
            return new ModuleConfig(ticketType, waterlogged);
        }

        public static /* synthetic */ ModuleConfig copy$default(ModuleConfig moduleConfig, TicketType ticketType, Waterlogged waterlogged, int n, Object object) {
            if ((n & 1) != 0) {
                ticketType = moduleConfig.ticketType;
            }
            if ((n & 2) != 0) {
                waterlogged = moduleConfig.waterlogged;
            }
            return moduleConfig.copy(ticketType, waterlogged);
        }

        @NotNull
        public String toString() {
            return "ModuleConfig(ticketType=" + this.ticketType + ", waterlogged=" + this.waterlogged + ")";
        }

        public int hashCode() {
            int result = this.ticketType.hashCode();
            result = result * 31 + this.waterlogged.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleConfig)) {
                return false;
            }
            ModuleConfig moduleConfig = (ModuleConfig)other;
            if (!Intrinsics.areEqual((Object)this.ticketType, (Object)moduleConfig.ticketType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.waterlogged, (Object)moduleConfig.waterlogged);
        }

        public ModuleConfig() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R\"\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$TicketType;", "", "startupSettings", "", "", "", "<init>", "(Ljava/util/Map;)V", "getStartupSettings", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "bukkit"})
        @SourceDebugExtension(value={"SMAP\nOptimizationsModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimizationsModule.kt\nio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$TicketType\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n463#2:118\n413#2:119\n1252#3,4:120\n*S KotlinDebug\n*F\n+ 1 OptimizationsModule.kt\nio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$TicketType\n*L\n101#1:118\n101#1:119\n101#1:120,4\n*E\n"})
        public static final class TicketType {
            @Comment(value="\n                Change the expiry ticks value once the module is enabled or reloaded.\n                For example, if you set `portal: 1`, chunk loaded by portal teleport will be removed\n                 right after 1 game tick, so that \"chunk loader\" will not be working any more.\n            ")
            @NotNull
            private final Map<String, Long> startupSettings;

            public TicketType(@NotNull Map<String, Long> startupSettings) {
                this.startupSettings = startupSettings;
            }

            /*
             * WARNING - void declaration
             */
            public /* synthetic */ TicketType(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    void $this$associateByTo$iv$iv$iv;
                    void $this$mapValuesTo$iv$iv;
                    Map<String, TicketTypeHandler.TicketType> $this$mapValues$iv = TicketTypeHandler.Companion.getHandler().getTicketTypeMap();
                    boolean $i$f$mapValues = false;
                    Map<String, TicketTypeHandler.TicketType> map2 = $this$mapValues$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
                    Map destination$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it;
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv$iv;
                        boolean bl = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        Map map4 = map3;
                        boolean bl2 = false;
                        Long l = ((TicketTypeHandler.TicketType)it.getValue()).getExpiryTicks();
                        map4.put(k, l);
                    }
                    map = destination$iv$iv$iv;
                }
                this(map);
            }

            @NotNull
            public final Map<String, Long> getStartupSettings() {
                return this.startupSettings;
            }

            @NotNull
            public final Map<String, Long> component1() {
                return this.startupSettings;
            }

            @NotNull
            public final TicketType copy(@NotNull Map<String, Long> startupSettings) {
                return new TicketType(startupSettings);
            }

            public static /* synthetic */ TicketType copy$default(TicketType ticketType, Map map, int n, Object object) {
                if ((n & 1) != 0) {
                    map = ticketType.startupSettings;
                }
                return ticketType.copy(map);
            }

            @NotNull
            public String toString() {
                return "TicketType(startupSettings=" + this.startupSettings + ")";
            }

            public int hashCode() {
                return ((Object)this.startupSettings).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TicketType)) {
                    return false;
                }
                TicketType ticketType = (TicketType)other;
                return Intrinsics.areEqual(this.startupSettings, ticketType.startupSettings);
            }

            public TicketType() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lio/github/rothes/esu/bukkit/module/OptimizationsModule$ModuleConfig$Waterlogged;", "", "disableWaterSpread", "", "keepWaterAfterPistonPush", "disableWaterloggedBlockPush", "<init>", "(ZZZ)V", "getDisableWaterSpread", "()Z", "getKeepWaterAfterPistonPush", "getDisableWaterloggedBlockPush", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class Waterlogged {
            @Comment(value="Enable this will disable water spread from waterlogged blocks.")
            private final boolean disableWaterSpread;
            @Comment(value="If enabled, water in waterlogged blocks will always be refilled after a piston push.")
            private final boolean keepWaterAfterPistonPush;
            @Comment(value="\n                If enabled, waterlogged blocks cannot be pushed by pistons.\n                This can block any ocean maker flying machine.\n            ")
            private final boolean disableWaterloggedBlockPush;

            public Waterlogged(boolean disableWaterSpread, boolean keepWaterAfterPistonPush, boolean disableWaterloggedBlockPush) {
                this.disableWaterSpread = disableWaterSpread;
                this.keepWaterAfterPistonPush = keepWaterAfterPistonPush;
                this.disableWaterloggedBlockPush = disableWaterloggedBlockPush;
            }

            public /* synthetic */ Waterlogged(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    bl2 = false;
                }
                if ((n & 4) != 0) {
                    bl3 = false;
                }
                this(bl, bl2, bl3);
            }

            public final boolean getDisableWaterSpread() {
                return this.disableWaterSpread;
            }

            public final boolean getKeepWaterAfterPistonPush() {
                return this.keepWaterAfterPistonPush;
            }

            public final boolean getDisableWaterloggedBlockPush() {
                return this.disableWaterloggedBlockPush;
            }

            public final boolean component1() {
                return this.disableWaterSpread;
            }

            public final boolean component2() {
                return this.keepWaterAfterPistonPush;
            }

            public final boolean component3() {
                return this.disableWaterloggedBlockPush;
            }

            @NotNull
            public final Waterlogged copy(boolean disableWaterSpread, boolean keepWaterAfterPistonPush, boolean disableWaterloggedBlockPush) {
                return new Waterlogged(disableWaterSpread, keepWaterAfterPistonPush, disableWaterloggedBlockPush);
            }

            public static /* synthetic */ Waterlogged copy$default(Waterlogged waterlogged, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = waterlogged.disableWaterSpread;
                }
                if ((n & 2) != 0) {
                    bl2 = waterlogged.keepWaterAfterPistonPush;
                }
                if ((n & 4) != 0) {
                    bl3 = waterlogged.disableWaterloggedBlockPush;
                }
                return waterlogged.copy(bl, bl2, bl3);
            }

            @NotNull
            public String toString() {
                return "Waterlogged(disableWaterSpread=" + this.disableWaterSpread + ", keepWaterAfterPistonPush=" + this.keepWaterAfterPistonPush + ", disableWaterloggedBlockPush=" + this.disableWaterloggedBlockPush + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.disableWaterSpread);
                result = result * 31 + Boolean.hashCode(this.keepWaterAfterPistonPush);
                result = result * 31 + Boolean.hashCode(this.disableWaterloggedBlockPush);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Waterlogged)) {
                    return false;
                }
                Waterlogged waterlogged = (Waterlogged)other;
                if (this.disableWaterSpread != waterlogged.disableWaterSpread) {
                    return false;
                }
                if (this.keepWaterAfterPistonPush != waterlogged.keepWaterAfterPistonPush) {
                    return false;
                }
                return this.disableWaterloggedBlockPush == waterlogged.disableWaterloggedBlockPush;
            }

            public Waterlogged() {
                this(false, false, false, 7, null);
            }
        }
    }
}

