/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.configuration;

import io.github.rothes.esu.core.module.configuration.EmptyConfiguration;
import io.github.rothes.esu.lib.configurate.ConfigurationNode;
import io.github.rothes.esu.lib.configurate.yaml.YamlConfigurationLoader;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001'B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u001f\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0006\u001a\u00020\u00002\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0019\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J3\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006("}, d2={"Lio/github/rothes/esu/core/configuration/LoadedConfiguration;", "", "context", "Lio/github/rothes/esu/core/configuration/LoadedConfiguration$LoaderContext;", "path", "Ljava/nio/file/Path;", "node", "Lio/github/rothes/esu/lib/configurate/ConfigurationNode;", "resourceNode", "<init>", "(Lio/github/rothes/esu/core/configuration/LoadedConfiguration$LoaderContext;Ljava/nio/file/Path;Lio/github/rothes/esu/lib/configurate/ConfigurationNode;Lio/github/rothes/esu/lib/configurate/ConfigurationNode;)V", "getContext", "()Lio/github/rothes/esu/core/configuration/LoadedConfiguration$LoaderContext;", "getPath", "()Ljava/nio/file/Path;", "getNode", "()Lio/github/rothes/esu/lib/configurate/ConfigurationNode;", "getResourceNode", "save", "", "getAs", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "", "([Ljava/lang/Object;)Lio/github/rothes/esu/core/configuration/LoadedConfiguration;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "LoaderContext", "core"})
public final class LoadedConfiguration {
    @NotNull
    private final LoaderContext context;
    @NotNull
    private final Path path;
    @NotNull
    private final ConfigurationNode node;
    @Nullable
    private final ConfigurationNode resourceNode;

    public LoadedConfiguration(@NotNull LoaderContext context, @NotNull Path path, @NotNull ConfigurationNode node, @Nullable ConfigurationNode resourceNode) {
        this.context = context;
        this.path = path;
        this.node = node;
        this.resourceNode = resourceNode;
    }

    @NotNull
    public final LoaderContext getContext() {
        return this.context;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final ConfigurationNode getNode() {
        return this.node;
    }

    @Nullable
    public final ConfigurationNode getResourceNode() {
        return this.resourceNode;
    }

    public final void save() {
        ConfigurationNode root = this.node;
        while (this.node.parent() != null) {
            Intrinsics.checkNotNull((Object)root.parent());
        }
        this.context.getLoader().save(root);
    }

    public final <T> T getAs(@NotNull Class<T> clazz) {
        if (this.context.getMergeResources() && this.resourceNode != null) {
            this.node.mergeFrom(this.resourceNode);
        }
        if (clazz.isInstance(EmptyConfiguration.INSTANCE)) {
            return clazz.cast(EmptyConfiguration.INSTANCE);
        }
        if (clazz.isInstance(Unit.INSTANCE)) {
            return clazz.cast(Unit.INSTANCE);
        }
        T instance = this.node.require(clazz);
        this.node.set(instance);
        return instance;
    }

    @NotNull
    public final LoadedConfiguration node(Object ... path) {
        ConfigurationNode configurationNode = this.resourceNode;
        return new LoadedConfiguration(this.context, this.path, this.node.node(Arrays.copyOf(path, path.length)), configurationNode != null ? configurationNode.node(Arrays.copyOf(path, path.length)) : null);
    }

    @NotNull
    public final LoaderContext component1() {
        return this.context;
    }

    @NotNull
    public final Path component2() {
        return this.path;
    }

    @NotNull
    public final ConfigurationNode component3() {
        return this.node;
    }

    @Nullable
    public final ConfigurationNode component4() {
        return this.resourceNode;
    }

    @NotNull
    public final LoadedConfiguration copy(@NotNull LoaderContext context, @NotNull Path path, @NotNull ConfigurationNode node, @Nullable ConfigurationNode resourceNode) {
        return new LoadedConfiguration(context, path, node, resourceNode);
    }

    public static /* synthetic */ LoadedConfiguration copy$default(LoadedConfiguration loadedConfiguration, LoaderContext loaderContext, Path path, ConfigurationNode configurationNode, ConfigurationNode configurationNode2, int n, Object object) {
        if ((n & 1) != 0) {
            loaderContext = loadedConfiguration.context;
        }
        if ((n & 2) != 0) {
            path = loadedConfiguration.path;
        }
        if ((n & 4) != 0) {
            configurationNode = loadedConfiguration.node;
        }
        if ((n & 8) != 0) {
            configurationNode2 = loadedConfiguration.resourceNode;
        }
        return loadedConfiguration.copy(loaderContext, path, configurationNode, configurationNode2);
    }

    @NotNull
    public String toString() {
        return "LoadedConfiguration(context=" + this.context + ", path=" + this.path + ", node=" + this.node + ", resourceNode=" + this.resourceNode + ")";
    }

    public int hashCode() {
        int result = this.context.hashCode();
        result = result * 31 + ((Object)this.path).hashCode();
        result = result * 31 + this.node.hashCode();
        result = result * 31 + (this.resourceNode == null ? 0 : this.resourceNode.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LoadedConfiguration)) {
            return false;
        }
        LoadedConfiguration loadedConfiguration = (LoadedConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.context, (Object)loadedConfiguration.context)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)loadedConfiguration.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.node, (Object)loadedConfiguration.node)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.resourceNode, (Object)loadedConfiguration.resourceNode);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/github/rothes/esu/core/configuration/LoadedConfiguration$LoaderContext;", "", "loader", "Lio/github/rothes/esu/lib/configurate/yaml/YamlConfigurationLoader;", "mergeResources", "", "<init>", "(Lio/github/rothes/esu/lib/configurate/yaml/YamlConfigurationLoader;Z)V", "getLoader", "()Lio/github/rothes/esu/lib/configurate/yaml/YamlConfigurationLoader;", "getMergeResources", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "core"})
    public static final class LoaderContext {
        @NotNull
        private final YamlConfigurationLoader loader;
        private final boolean mergeResources;

        public LoaderContext(@NotNull YamlConfigurationLoader loader, boolean mergeResources) {
            this.loader = loader;
            this.mergeResources = mergeResources;
        }

        @NotNull
        public final YamlConfigurationLoader getLoader() {
            return this.loader;
        }

        public final boolean getMergeResources() {
            return this.mergeResources;
        }

        @NotNull
        public final YamlConfigurationLoader component1() {
            return this.loader;
        }

        public final boolean component2() {
            return this.mergeResources;
        }

        @NotNull
        public final LoaderContext copy(@NotNull YamlConfigurationLoader loader, boolean mergeResources) {
            return new LoaderContext(loader, mergeResources);
        }

        public static /* synthetic */ LoaderContext copy$default(LoaderContext loaderContext, YamlConfigurationLoader yamlConfigurationLoader, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                yamlConfigurationLoader = loaderContext.loader;
            }
            if ((n & 2) != 0) {
                bl = loaderContext.mergeResources;
            }
            return loaderContext.copy(yamlConfigurationLoader, bl);
        }

        @NotNull
        public String toString() {
            return "LoaderContext(loader=" + this.loader + ", mergeResources=" + this.mergeResources + ")";
        }

        public int hashCode() {
            int result = this.loader.hashCode();
            result = result * 31 + Boolean.hashCode(this.mergeResources);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoaderContext)) {
                return false;
            }
            LoaderContext loaderContext = (LoaderContext)other;
            if (!Intrinsics.areEqual((Object)this.loader, (Object)loaderContext.loader)) {
                return false;
            }
            return this.mergeResources == loaderContext.mergeResources;
        }
    }
}

