/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle.entityculling;

import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.module.networkthrottle.entityculling.CullDataManager;
import io.github.rothes.esu.bukkit.module.networkthrottle.entityculling.PlayerEntityVisibilityHandler;
import io.github.rothes.esu.bukkit.module.networkthrottle.entityculling.RaytraceHandler;
import io.github.rothes.esu.bukkit.util.scheduler.ScheduledTask;
import io.github.rothes.esu.bukkit.util.scheduler.Scheduler;
import io.github.rothes.esu.bukkit.util.version.Versioned;
import io.github.rothes.esu.bukkit.util.version.adapter.PlayerAdapter;
import io.github.rothes.esu.bukkit.util.version.adapter.TickThreadAdapter;
import io.github.rothes.esu.core.util.extension.math.ExtensionsKt;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 )2\u00020\u0001:\u0002)*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00122\b\b\u0002\u0010\u001e\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u001aJ\u0006\u0010 \u001a\u00020\u001aJ\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u001aJ\b\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u001aH\u0002J\b\u0010'\u001a\u00020\u001aH\u0002J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/UserCullData;", "", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "setPlayer", "hiddenEntities", "Lit/unimi/dsi/fastutil/ints/Int2ReferenceOpenHashMap;", "Lorg/bukkit/entity/Entity;", "pendingChanges", "", "Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/UserCullData$CulledChange;", "tickedTime", "", "isRemoved", "", "terminated", "shouldCull", "getShouldCull", "()Z", "setShouldCull", "(Z)V", "setCulled", "", "entity", "entityId", "culled", "pend", "showAll", "tick", "onEntityRemove", "entities", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "markRemoved", "reset", "checkEntitiesValid", "updateChanges", "pendCulledChange", "Companion", "CulledChange", "bukkit"})
@SourceDebugExtension(value={"SMAP\nUserCullData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserCullData.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/UserCullData\n+ 2 Collections.kt\nio/github/rothes/esu/core/util/extension/CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n27#2,3:145\n1#3:148\n*S KotlinDebug\n*F\n+ 1 UserCullData.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/UserCullData\n*L\n64#1:145,3\n*E\n"})
public final class UserCullData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Player player;
    @NotNull
    private final Int2ReferenceOpenHashMap<Entity> hiddenEntities;
    @NotNull
    private final List<CulledChange> pendingChanges;
    private int tickedTime;
    private boolean isRemoved;
    private boolean terminated;
    private boolean shouldCull;
    @NotNull
    private static final Versioned<Companion, PlayerEntityVisibilityHandler> playerEntityVisibilityHandler$delegate = new Versioned(PlayerEntityVisibilityHandler.class, null, null, 6, null);

    public UserCullData(@NotNull Player player) {
        this.player = player;
        this.hiddenEntities = new Int2ReferenceOpenHashMap(64, 0.25f);
        this.pendingChanges = new ArrayList();
        this.shouldCull = true;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final void setPlayer(@NotNull Player player) {
        this.player = player;
    }

    public final boolean getShouldCull() {
        return this.shouldCull;
    }

    public final void setShouldCull(boolean bl) {
        this.shouldCull = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCulled(@NotNull Entity entity, int entityId, boolean culled, boolean pend) {
        if (culled) {
            Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
            synchronized (int2ReferenceOpenHashMap) {
                boolean $i$a$-synchronized-UserCullData$setCulled$32 = false;
                if (this.hiddenEntities.put(entityId, (Object)entity) == null && pend) {
                    this.pendCulledChange(entity, true);
                }
                Unit $i$a$-synchronized-UserCullData$setCulled$32 = Unit.INSTANCE;
            }
        }
        Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
        synchronized (int2ReferenceOpenHashMap) {
            boolean bl = false;
            if (this.hiddenEntities.remove(entityId) != null && pend) {
                this.pendCulledChange(entity, false);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void setCulled$default(UserCullData userCullData, Entity entity, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        userCullData.setCulled(entity, n, bl, bl2);
    }

    public final void showAll() {
        this.reset();
        this.updateChanges();
    }

    public final void tick() {
        ++this.tickedTime;
        if (this.tickedTime >= 2400) {
            this.checkEntitiesValid();
        }
        this.updateChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onEntityRemove(@NotNull IntArrayList entities) {
        if (entities.isEmpty()) {
            return;
        }
        Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
        synchronized (int2ReferenceOpenHashMap) {
            boolean bl = false;
            IntList $this$forEachInt$iv = (IntList)entities;
            boolean $i$f$forEachInt = false;
            int n = $this$forEachInt$iv.size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                int i = $this$forEachInt$iv.getInt(i$iv);
                boolean bl2 = false;
                this.hiddenEntities.remove(i);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void markRemoved() {
        this.isRemoved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reset() {
        Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
        synchronized (int2ReferenceOpenHashMap) {
            boolean bl = false;
            ReferenceCollection values = (ReferenceCollection)this.hiddenEntities.values();
            this.hiddenEntities.clear();
            for (Entity entity : values) {
                this.pendCulledChange(entity, false);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkEntitiesValid() {
        try {
            Int2ReferenceOpenHashMap<Entity> int2ReferenceOpenHashMap = this.hiddenEntities;
            synchronized (int2ReferenceOpenHashMap) {
                boolean bl = false;
                RaytraceHandler<?, ?> raytraceHandler = CullDataManager.INSTANCE.getRaytraceHandler();
                ObjectIterator iterator = this.hiddenEntities.int2ReferenceEntrySet().iterator();
                Location playerLoc = this.player.getLocation();
                ObjectIterator objectIterator = iterator;
                while (((Iterator)objectIterator).hasNext()) {
                    Int2ReferenceMap.Entry entry = (Int2ReferenceMap.Entry)objectIterator.next();
                    Entity entity = (Entity)entry.getValue();
                    boolean flag = !raytraceHandler.isValid(entity);
                    Location loc = entity.getLocation();
                    if (!Intrinsics.areEqual((Object)loc.getWorld(), (Object)playerLoc.getWorld()) || ExtensionsKt.square(playerLoc.getX() - loc.getX()) + ExtensionsKt.square(playerLoc.getZ() - loc.getZ()) > 1048576.0) {
                        Companion.getPlayerEntityVisibilityHandler().forceShowEntity(this.player, entity);
                        flag = true;
                    }
                    if (!flag) continue;
                    iterator.remove();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Throwable e) {
            InternalsKt.getPlugin().err("[EntityCulling] Failed to check entities valid for player " + this.player.getName(), e);
        }
    }

    private final void updateChanges() {
        if (this.terminated) {
            return;
        }
        if (this.pendingChanges.isEmpty()) {
            return;
        }
        List list = CollectionsKt.toList((Iterable)this.pendingChanges);
        this.pendingChanges.clear();
        if (InternalsKt.getPlugin().isEnabled()) {
            ScheduledTask scheduledTask;
            Object it;
            if (!PlayerAdapter.Companion.getConnected((OfflinePlayer)this.player)) {
                Player player = Bukkit.getPlayer((UUID)this.player.getUniqueId());
                if (player != null) {
                    it = player;
                    boolean bl = false;
                    this.player = it;
                }
            }
            if ((scheduledTask = Scheduler.schedule$default(Scheduler.INSTANCE, (Entity)this.player, null, () -> UserCullData.updateChanges$lambda$1(list, this), 2, null)) == null) {
                it = this;
                boolean bl = false;
                InternalsKt.getPlugin().warn("[EntityCulling] Failed to schedule changes " + this.player.getName() + ", not online?");
                scheduledTask = Unit.INSTANCE;
            }
        }
    }

    private final void pendCulledChange(Entity entity, boolean culled) {
        this.pendingChanges.add(new CulledChange(entity, culled));
    }

    private static final Unit updateChanges$lambda$1(List $list, UserCullData this$0) {
        RaytraceHandler<?, ?> raytraceHandler = CullDataManager.INSTANCE.getRaytraceHandler();
        for (CulledChange change : $list) {
            if (!raytraceHandler.isValid(change.getEntity())) continue;
            if (!TickThreadAdapter.Companion.checkTickThread(change.getEntity())) {
                if (change.getCulled()) continue;
                Companion.getPlayerEntityVisibilityHandler().forceShowEntity(this$0.player, change.getEntity());
                continue;
            }
            if (change.getCulled()) {
                this$0.player.hideEntity((Plugin)InternalsKt.getBootstrap(), change.getEntity());
                continue;
            }
            this$0.player.showEntity((Plugin)InternalsKt.getBootstrap(), change.getEntity());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/UserCullData$Companion;", "", "<init>", "()V", "playerEntityVisibilityHandler", "Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/PlayerEntityVisibilityHandler;", "getPlayerEntityVisibilityHandler", "()Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/PlayerEntityVisibilityHandler;", "playerEntityVisibilityHandler$delegate", "Lio/github/rothes/esu/bukkit/util/version/Versioned;", "bukkit"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final PlayerEntityVisibilityHandler getPlayerEntityVisibilityHandler() {
            return (PlayerEntityVisibilityHandler)playerEntityVisibilityHandler$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "playerEntityVisibilityHandler", "getPlayerEntityVisibilityHandler()Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/PlayerEntityVisibilityHandler;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/UserCullData$CulledChange;", "", "entity", "Lorg/bukkit/entity/Entity;", "culled", "", "<init>", "(Lorg/bukkit/entity/Entity;Z)V", "getEntity", "()Lorg/bukkit/entity/Entity;", "getCulled", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "bukkit"})
    private static final class CulledChange {
        @NotNull
        private final Entity entity;
        private final boolean culled;

        public CulledChange(@NotNull Entity entity, boolean culled) {
            this.entity = entity;
            this.culled = culled;
        }

        @NotNull
        public final Entity getEntity() {
            return this.entity;
        }

        public final boolean getCulled() {
            return this.culled;
        }

        @NotNull
        public final Entity component1() {
            return this.entity;
        }

        public final boolean component2() {
            return this.culled;
        }

        @NotNull
        public final CulledChange copy(@NotNull Entity entity, boolean culled) {
            return new CulledChange(entity, culled);
        }

        public static /* synthetic */ CulledChange copy$default(CulledChange culledChange, Entity entity, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                entity = culledChange.entity;
            }
            if ((n & 2) != 0) {
                bl = culledChange.culled;
            }
            return culledChange.copy(entity, bl);
        }

        @NotNull
        public String toString() {
            return "CulledChange(entity=" + this.entity + ", culled=" + this.culled + ")";
        }

        public int hashCode() {
            int result = this.entity.hashCode();
            result = result * 31 + Boolean.hashCode(this.culled);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CulledChange)) {
                return false;
            }
            CulledChange culledChange = (CulledChange)other;
            if (!Intrinsics.areEqual((Object)this.entity, (Object)culledChange.entity)) {
                return false;
            }
            return this.culled == culledChange.culled;
        }
    }
}

