/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0005R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR#\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/Analyser;", "", "<init>", "()V", "value", "", "running", "getRunning", "()Z", "", "startTime", "getStartTime", "()J", "stopTime", "getStopTime", "records", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/github/retrooper/packetevents/protocol/packettype/PacketTypeCommon;", "", "Lio/github/rothes/esu/bukkit/module/networkthrottle/Analyser$PacketRecord;", "getRecords", "()Ljava/util/concurrent/ConcurrentHashMap;", "start", "stop", "PacketRecord", "AnalyserPacketListener", "bukkit"})
public final class Analyser {
    @NotNull
    public static final Analyser INSTANCE = new Analyser();
    private static boolean running;
    private static long startTime;
    private static long stopTime;
    @NotNull
    private static final ConcurrentHashMap<PacketTypeCommon, List<PacketRecord>> records;

    private Analyser() {
    }

    public final boolean getRunning() {
        return running;
    }

    public final long getStartTime() {
        return startTime;
    }

    public final long getStopTime() {
        return stopTime;
    }

    @NotNull
    public final ConcurrentHashMap<PacketTypeCommon, List<PacketRecord>> getRecords() {
        return records;
    }

    public final boolean start() {
        if (running) {
            return false;
        }
        running = true;
        startTime = System.currentTimeMillis();
        records.clear();
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)AnalyserPacketListener.INSTANCE);
        return true;
    }

    public final boolean stop() {
        if (!running) {
            return false;
        }
        running = false;
        stopTime = System.currentTimeMillis();
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)AnalyserPacketListener.INSTANCE);
        return true;
    }

    static {
        records = new ConcurrentHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/Analyser$AnalyserPacketListener;", "Lcom/github/retrooper/packetevents/event/PacketListenerAbstract;", "<init>", "()V", "onPacketSend", "", "event", "Lcom/github/retrooper/packetevents/event/PacketSendEvent;", "bukkit"})
    public static final class AnalyserPacketListener
    extends PacketListenerAbstract {
        @NotNull
        public static final AnalyserPacketListener INSTANCE = new AnalyserPacketListener();

        private AnalyserPacketListener() {
            super(PacketListenerPriority.MONITOR);
        }

        public void onPacketSend(@NotNull PacketSendEvent event) {
            int n;
            List records = INSTANCE.getRecords().computeIfAbsent(event.getPacketType(), arg_0 -> AnalyserPacketListener.onPacketSend$lambda$1(AnalyserPacketListener::onPacketSend$lambda$0, arg_0));
            PacketWrapper wrapper = event.getLastUsedWrapper();
            if (wrapper != null) {
                Object object = wrapper.buffer;
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.netty.buffer.ByteBuf");
                ByteBuf buffer = (ByteBuf)object;
                buffer.clear();
                wrapper.write();
                n = buffer.writerIndex();
            } else {
                Object object = event.getByteBuf();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.netty.buffer.ByteBuf");
                n = ((ByteBuf)object).writerIndex();
            }
            int size = n;
            records.add(new PacketRecord(size));
        }

        private static final List onPacketSend$lambda$0(PacketTypeCommon it) {
            return Collections.synchronizedList(new ArrayList());
        }

        private static final List onPacketSend$lambda$1(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/Analyser$PacketRecord;", "", "size", "", "<init>", "(I)V", "getSize", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "bukkit"})
    public static final class PacketRecord {
        private final int size;

        public PacketRecord(int size) {
            this.size = size;
        }

        public final int getSize() {
            return this.size;
        }

        public final int component1() {
            return this.size;
        }

        @NotNull
        public final PacketRecord copy(int size) {
            return new PacketRecord(size);
        }

        public static /* synthetic */ PacketRecord copy$default(PacketRecord packetRecord, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = packetRecord.size;
            }
            return packetRecord.copy(n);
        }

        @NotNull
        public String toString() {
            return "PacketRecord(size=" + this.size + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.size);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PacketRecord)) {
                return false;
            }
            PacketRecord packetRecord = (PacketRecord)other;
            return this.size == packetRecord.size;
        }
    }
}

