/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.lib.org.spongepowered.configurate.yaml;

import io.github.rothes.esu.lib.org.spongepowered.configurate.CommentedConfigurationNodeIntermediary;
import io.github.rothes.esu.lib.org.spongepowered.configurate.ConfigurationNode;
import io.github.rothes.esu.lib.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.NodeStyle;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.ScalarStyle;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.DumperOptions;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.comments.CommentLine;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.comments.CommentType;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.nodes.MappingNode;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.nodes.Node;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.nodes.NodeTuple;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.nodes.ScalarNode;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.nodes.SequenceNode;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.nodes.Tag;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.representer.Represent;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.representer.Representer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

final class YamlRepresenter
extends Representer {
    private static final CommentLine BLANK_LINE = new CommentLine(null, null, "", CommentType.BLANK_LINE);
    private final boolean padComments;

    YamlRepresenter(boolean padComments, DumperOptions options) {
        super(options);
        this.padComments = padComments;
        this.multiRepresenters.put(ConfigurationNode.class, new ConfigurationNodeRepresent());
        this.nullRepresenter = new EmptyNullRepresenter();
    }

    private final class ConfigurationNodeRepresent
    implements Represent {
        private ConfigurationNodeRepresent() {
        }

        @Override
        public Node representData(Object nodeObject) {
            String nodeComment;
            Node yamlNode;
            ArrayList<NodeTuple> children;
            ConfigurationNode node = (ConfigurationNode)nodeObject;
            if (node.isMap()) {
                children = new ArrayList<NodeTuple>();
                boolean first = true;
                for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.childrenMap().entrySet()) {
                    Node value = YamlRepresenter.this.represent(ent.getValue());
                    Node key = YamlRepresenter.this.represent(ent.getKey());
                    key.setBlockComments(value.getBlockComments());
                    value.setBlockComments(Collections.emptyList());
                    if (!(first || node.parent() != null && node.parent().isList() || key.getBlockComments() == null || key.getBlockComments().isEmpty())) {
                        key.getBlockComments().add(0, BLANK_LINE);
                    }
                    first = false;
                    children.add(new NodeTuple(key, value));
                }
                yamlNode = new MappingNode(Tag.MAP, children, this.flowStyle(node));
            } else if (node.isList()) {
                children = new ArrayList();
                for (ConfigurationNode configurationNode : node.childrenList()) {
                    children.add((NodeTuple)((Object)YamlRepresenter.this.represent(configurationNode)));
                }
                yamlNode = new SequenceNode(Tag.SEQ, children, this.flowStyle(node));
            } else {
                Node optionNode = YamlRepresenter.this.represent(node.rawScalar());
                @Nullable ScalarStyle requestedStyle = node.ownHint(YamlConfigurationLoader.SCALAR_STYLE);
                if (optionNode instanceof ScalarNode && requestedStyle != null) {
                    ScalarNode scalarNode = (ScalarNode)optionNode;
                    yamlNode = new ScalarNode(scalarNode.getTag(), scalarNode.getValue(), scalarNode.getStartMark(), scalarNode.getEndMark(), ScalarStyle.asSnakeYaml(requestedStyle, scalarNode.getScalarStyle()));
                } else {
                    yamlNode = optionNode;
                }
            }
            if (node instanceof CommentedConfigurationNodeIntermediary && (nodeComment = ((CommentedConfigurationNodeIntermediary)node).comment()) != null) {
                yamlNode.setBlockComments(Arrays.stream(AbstractConfigurationLoader.CONFIGURATE_LINE_PATTERN.split(nodeComment)).map(this::commentLineFor).collect(Collectors.toList()));
            }
            return yamlNode;
        }

        private DumperOptions.FlowStyle flowStyle(ConfigurationNode node) {
            @Nullable NodeStyle requested = node.ownHint(YamlConfigurationLoader.NODE_STYLE);
            return NodeStyle.asSnakeYaml(requested);
        }

        private CommentLine commentLineFor(String comment) {
            if (comment.isEmpty()) {
                return BLANK_LINE;
            }
            if (!YamlRepresenter.this.padComments || comment.charAt(0) == '#') {
                return new CommentLine(null, null, comment, CommentType.BLOCK);
            }
            return new CommentLine(null, null, " " + comment, CommentType.BLOCK);
        }
    }

    private static final class EmptyNullRepresenter
    implements Represent {
        private EmptyNullRepresenter() {
        }

        @Override
        public Node representData(Object data) {
            return new ScalarNode(Tag.NULL, "", null, null, DumperOptions.ScalarStyle.PLAIN);
        }
    }
}

