/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientSettings;
import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.module.NetworkThrottleModule;
import io.github.rothes.esu.bukkit.util.ServerCompatibility;
import io.github.rothes.esu.bukkit.util.scheduler.ScheduledTask;
import io.github.rothes.esu.bukkit.util.scheduler.Scheduler;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.lib.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0019J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/HighLatencyAdjust;", "Lcom/github/retrooper/packetevents/event/PacketListenerAbstract;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "NO_TIME", "", "adjusted", "Ljava/util/HashMap;", "Lorg/bukkit/entity/Player;", "", "Lkotlin/collections/HashMap;", "getAdjusted", "()Ljava/util/HashMap;", "startTime", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "getStartTime", "()Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "task", "Lio/github/rothes/esu/bukkit/util/scheduler/ScheduledTask;", "getTask", "()Lio/github/rothes/esu/bukkit/util/scheduler/ScheduledTask;", "setTask", "(Lio/github/rothes/esu/bukkit/util/scheduler/ScheduledTask;)V", "onQuit", "", "e", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onEnable", "onDisable", "onPacketReceive", "event", "Lcom/github/retrooper/packetevents/event/PacketReceiveEvent;", "bukkit"})
@SourceDebugExtension(value={"SMAP\nHighLatencyAdjust.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighLatencyAdjust.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/HighLatencyAdjust\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class HighLatencyAdjust
extends PacketListenerAbstract
implements Listener {
    @NotNull
    public static final HighLatencyAdjust INSTANCE;
    private static final long NO_TIME = -1L;
    @NotNull
    private static final HashMap<Player, Integer> adjusted;
    @NotNull
    private static final Object2LongOpenHashMap<Player> startTime;
    @Nullable
    private static ScheduledTask task;

    private HighLatencyAdjust() {
        super(PacketListenerPriority.HIGHEST);
    }

    @NotNull
    public final HashMap<Player, Integer> getAdjusted() {
        return adjusted;
    }

    @NotNull
    public final Object2LongOpenHashMap<Player> getStartTime() {
        return startTime;
    }

    @Nullable
    public final ScheduledTask getTask() {
        return task;
    }

    public final void setTask(@Nullable ScheduledTask scheduledTask) {
        task = scheduledTask;
    }

    @EventHandler
    public final void onQuit(@NotNull PlayerQuitEvent e) {
        adjusted.remove(e.getPlayer());
        startTime.removeLong((Object)e.getPlayer());
    }

    public final void onEnable() {
        if (!ServerCompatibility.INSTANCE.isPaper()) {
            InternalsKt.getPlugin().err("[HighLatencyAdjust] This feature requires Paper server");
            return;
        }
        for (Map.Entry<UUID, Integer> entry : NetworkThrottleModule.INSTANCE.getData().getOriginalViewDistance().entrySet()) {
            UUID uuid = entry.getKey();
            int v = ((Number)entry.getValue()).intValue();
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            ((Map)adjusted).put(player, v);
        }
        NetworkThrottleModule.INSTANCE.getData().getOriginalViewDistance().clear();
        if (((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getHighLatencyAdjust().getEnabled()) {
            task = Scheduler.asyncTicks$default(Scheduler.INSTANCE, 0L, 300L, null, HighLatencyAdjust::onEnable$lambda$2, 4, null);
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this);
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)InternalsKt.getPlugin());
        }
    }

    public final void onDisable() {
        if (InternalsKt.getPlugin().isEnabled() || InternalsKt.getPlugin().getDisabledHot()) {
            for (Map.Entry<Player, Integer> entry : adjusted.entrySet()) {
                Player player = entry.getKey();
                Integer v = entry.getValue();
                NetworkThrottleModule.INSTANCE.getData().getOriginalViewDistance().put(player.getUniqueId(), v);
            }
        }
        ScheduledTask scheduledTask = task;
        if (scheduledTask != null) {
            scheduledTask.cancel();
        }
        task = null;
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this);
        HandlerList.unregisterAll((Listener)this);
        adjusted.clear();
        startTime.clear();
    }

    public void onPacketReceive(@NotNull PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.CLIENT_SETTINGS) {
            WrapperPlayClientSettings wrapper = new WrapperPlayClientSettings(event);
            Player player = (Player)event.getPlayer();
            Integer n = adjusted.get(player);
            if (n == null) {
                return;
            }
            int old = n;
            int viewDistance = wrapper.getViewDistance();
            if (!((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getHighLatencyAdjust().getNewViewDistanceToReset() || old != viewDistance) {
                adjusted.remove(player);
                startTime.removeLong((Object)player);
                player.setSendViewDistance(-1);
            }
        }
    }

    private static final MessageData onEnable$lambda$2$lambda$1(NetworkThrottleModule.ModuleLang $this$message) {
        return $this$message.getHighLatencyAdjust().getAdjustedWarning();
    }

    private static final Unit onEnable$lambda$2() {
        long now = System.currentTimeMillis();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getPing() >= ((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getHighLatencyAdjust().getLatencyThreshold()) {
                long last = startTime.getLong((Object)player);
                if (last == -1L) {
                    ((Map)startTime).put(player, now);
                    continue;
                }
                if (now - last < ((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getHighLatencyAdjust().getDuration().toMillis()) continue;
                startTime.removeLong((Object)player);
                if (!adjusted.containsKey(player)) {
                    ((Map)adjusted).put(player, player.getClientViewDistance());
                    player.setSendViewDistance(Math.min(player.getClientViewDistance(), player.getViewDistance()) - 1);
                } else {
                    if (player.getSendViewDistance() <= ((NetworkThrottleModule.ModuleConfig)NetworkThrottleModule.INSTANCE.getConfig()).getHighLatencyAdjust().getMinViewDistance()) continue;
                    int n = player.getSendViewDistance();
                    player.setSendViewDistance(n + -1);
                }
                InternalsKt.getUser(player).sendMessage(NetworkThrottleModule.INSTANCE.getLocale(), HighLatencyAdjust::onEnable$lambda$2$lambda$1, new TagResolver[0]);
                continue;
            }
            startTime.removeLong((Object)player);
        }
        return Unit.INSTANCE;
    }

    static {
        Object2LongOpenHashMap object2LongOpenHashMap;
        INSTANCE = new HighLatencyAdjust();
        adjusted = new HashMap();
        Object2LongOpenHashMap it = object2LongOpenHashMap = new Object2LongOpenHashMap();
        boolean bl = false;
        it.defaultReturnValue(-1L);
        startTime = object2LongOpenHashMap;
    }
}

