/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMoveAndRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import io.github.rothes.esu.bukkit.util.extension.FeatureKt;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.CommonFeature;
import io.github.rothes.esu.core.module.Feature;
import io.github.rothes.esu.core.module.configuration.BaseFeatureConfiguration;
import io.github.rothes.esu.core.module.configuration.EmptyConfiguration;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/SkipUnnecessaryPackets;", "Lio/github/rothes/esu/core/module/CommonFeature;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/SkipUnnecessaryPackets$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/EmptyConfiguration;", "<init>", "()V", "checkUnavailable", "Lio/github/rothes/esu/core/module/Feature$AvailableCheck;", "onEnable", "", "onDisable", "PacketListeners", "FeatureConfig", "bukkit"})
public final class SkipUnnecessaryPackets
extends CommonFeature<FeatureConfig, EmptyConfiguration> {
    @NotNull
    public static final SkipUnnecessaryPackets INSTANCE = new SkipUnnecessaryPackets();

    private SkipUnnecessaryPackets() {
    }

    @Override
    @Nullable
    public Feature.AvailableCheck checkUnavailable() {
        Feature.AvailableCheck availableCheck = super.checkUnavailable();
        if (availableCheck == null) {
            availableCheck = FeatureKt.checkPacketEvents(this);
        }
        return availableCheck;
    }

    @Override
    public void onEnable() {
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)PacketListeners.INSTANCE);
    }

    @Override
    public void onDisable() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)PacketListeners.INSTANCE);
    }

    @Comment(value="\n        This feature is to skip unnecessary packets, that doesn't bring any changes to client.\n        Currently, it cancel entity movement packets whose entity actually not moved.\n    ")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/SkipUnnecessaryPackets$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseFeatureConfiguration;", "<init>", "()V", "bukkit"})
    public static final class FeatureConfig
    extends BaseFeatureConfiguration {
        public FeatureConfig() {
            super(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/SkipUnnecessaryPackets$PacketListeners;", "Lcom/github/retrooper/packetevents/event/PacketListenerAbstract;", "<init>", "()V", "onPacketSend", "", "event", "Lcom/github/retrooper/packetevents/event/PacketSendEvent;", "bukkit"})
    private static final class PacketListeners
    extends PacketListenerAbstract {
        @NotNull
        public static final PacketListeners INSTANCE = new PacketListeners();

        private PacketListeners() {
            super(PacketListenerPriority.LOWEST);
        }

        public void onPacketSend(@NotNull PacketSendEvent event) {
            WrapperPlayServerEntityRotation wrapper;
            PacketTypeCommon packetTypeCommon = event.getPacketType();
            if (packetTypeCommon == PacketType.Play.Server.ENTITY_RELATIVE_MOVE) {
                WrapperPlayServerEntityRelativeMove wrapper2 = new WrapperPlayServerEntityRelativeMove(event);
                if (wrapper2.getDeltaX() == 0.0 && wrapper2.getDeltaY() == 0.0 && wrapper2.getDeltaZ() == 0.0) {
                    event.setCancelled(true);
                }
            } else if (packetTypeCommon == PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION) {
                WrapperPlayServerEntityRelativeMoveAndRotation wrapper3 = new WrapperPlayServerEntityRelativeMoveAndRotation(event);
                if (wrapper3.getDeltaX() == 0.0 && wrapper3.getDeltaY() == 0.0 && wrapper3.getDeltaZ() == 0.0 && wrapper3.getPitch() == 0.0f && wrapper3.getYaw() == 0.0f) {
                    event.setCancelled(true);
                }
            } else if (packetTypeCommon == PacketType.Play.Server.ENTITY_ROTATION && (wrapper = new WrapperPlayServerEntityRotation(event)).getPitch() == 0.0f && wrapper.getYaw() == 0.0f) {
                event.setCancelled(true);
            }
        }
    }
}

