/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle;

import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.module.networkthrottle.chunkdatathrottle.ChunkDataThrottleHandler;
import io.github.rothes.esu.bukkit.util.ServerCompatibility;
import io.github.rothes.esu.bukkit.util.extension.FeatureKt;
import io.github.rothes.esu.bukkit.util.version.VersionedKt;
import io.github.rothes.esu.core.command.annotation.ShortPerm;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.configuration.meta.RenamedFrom;
import io.github.rothes.esu.core.configuration.serializer.MapSerializer;
import io.github.rothes.esu.core.module.CommonFeature;
import io.github.rothes.esu.core.module.Feature;
import io.github.rothes.esu.core.module.configuration.BaseFeatureConfiguration;
import io.github.rothes.esu.core.module.configuration.EmptyConfiguration;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.lib.configurate.objectmapping.meta.PostProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.incendo.cloud.annotations.Command;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/ChunkDataThrottle;", "Lio/github/rothes/esu/core/module/CommonFeature;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/ChunkDataThrottle$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/EmptyConfiguration;", "<init>", "()V", "versioned", "Lio/github/rothes/esu/bukkit/module/networkthrottle/chunkdatathrottle/ChunkDataThrottleHandler;", "getVersioned", "()Lio/github/rothes/esu/bukkit/module/networkthrottle/chunkdatathrottle/ChunkDataThrottleHandler;", "versioned$delegate", "Lkotlin/Lazy;", "counter", "Lio/github/rothes/esu/bukkit/module/networkthrottle/chunkdatathrottle/ChunkDataThrottleHandler$Counter;", "getCounter", "()Lio/github/rothes/esu/bukkit/module/networkthrottle/chunkdatathrottle/ChunkDataThrottleHandler$Counter;", "wasEnabled", "", "checkUnavailable", "Lio/github/rothes/esu/core/module/Feature$AvailableCheck;", "onReload", "", "onEnable", "onTerminate", "FeatureConfig", "bukkit"})
public final class ChunkDataThrottle
extends CommonFeature<FeatureConfig, EmptyConfiguration> {
    @NotNull
    public static final ChunkDataThrottle INSTANCE = new ChunkDataThrottle();
    @NotNull
    private static final Lazy versioned$delegate = LazyKt.lazy(ChunkDataThrottle::versioned_delegate$lambda$0);
    private static boolean wasEnabled;

    private ChunkDataThrottle() {
    }

    @NotNull
    public final ChunkDataThrottleHandler getVersioned() {
        Lazy lazy = versioned$delegate;
        return (ChunkDataThrottleHandler)lazy.getValue();
    }

    @NotNull
    public final ChunkDataThrottleHandler.Counter getCounter() {
        return this.getVersioned().getCounter();
    }

    @Override
    @Nullable
    public Feature.AvailableCheck checkUnavailable() {
        Feature.AvailableCheck availableCheck = super.checkUnavailable();
        if (availableCheck == null && (availableCheck = FeatureKt.checkPacketEvents(this)) == null) {
            ChunkDataThrottle it = this;
            boolean bl = false;
            if (ServerCompatibility.INSTANCE.getServerVersion().compareTo("1.18") < 0) {
                InternalsKt.getPlugin().err("[ChunkDataThrottle] This feature requires Minecraft 1.18+");
                return Feature.AvailableCheck.Companion.fail((Function1<? super User, MessageData>)((Function1)ChunkDataThrottle::checkUnavailable$lambda$0$0));
            }
            availableCheck = null;
        }
        return availableCheck;
    }

    @Override
    public void onReload() {
        super.onReload();
        if (this.getEnabled()) {
            this.getVersioned().onReload();
        }
    }

    @Override
    public void onEnable() {
        wasEnabled = true;
        this.getVersioned().onEnable();
        CommonFeature.registerCommands$default(this, new Object(){

            @Command(value="esu networkThrottle chunkDataThrottle stats")
            @ShortPerm(value="chunkDataThrottle")
            public final void chunkDataThrottleView(User sender) {
                ChunkDataThrottleHandler.Counter counter = ChunkDataThrottle.INSTANCE.getCounter();
                long minimalChunks = counter.component1();
                long resentChunks = counter.component2();
                long resentBlocks = counter.component3();
                sender.message("minimalChunks: " + minimalChunks + " ; resentChunks: " + resentChunks + " ; resentBlocks: " + resentBlocks);
            }
        }, null, 2, null);
    }

    @Override
    public void onTerminate() {
        super.onTerminate();
        if (wasEnabled) {
            this.getVersioned().onTerminate();
        }
    }

    private static final ChunkDataThrottleHandler versioned_delegate$lambda$0() {
        return VersionedKt.versioned(ChunkDataThrottleHandler.class);
    }

    private static final MessageData checkUnavailable$lambda$0$0(User it) {
        return MessageData.Companion.getMessage("This feature requires Minecraft 1.18+");
    }

    @Comment(value="\n            Helps to reduce chunk upload bandwidth. Plugin will compress invisible blocks in chunk data packet.\n            If necessary, we send a full chunk data again.\n            This can save about 50% bandwidth usage in overworld and 30% in nether averagely.\n            Make sure you have enabled network-compression on proxy or this server.\n            ")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0011\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010+\u001a\u00020,H\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003J\t\u00102\u001a\u00020\u0005H\u00c6\u0003J\t\u00103\u001a\u00020\u0005H\u00c6\u0003J\u001b\u00104\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fH\u00c6\u0003J\t\u00105\u001a\u00020\u0005H\u00c6\u0003J\u000f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u00c6\u0003J\u0085\u0001\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00052\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u00c6\u0001J\u0013\u00108\u001a\u00020\u00052\b\u00109\u001a\u0004\u0018\u00010:H\u00d6\u0003J\t\u0010;\u001a\u00020\u0003H\u00d6\u0001J\t\u0010<\u001a\u00020\rH\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0016\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0016\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R(\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0010\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R'\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020$0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b%\u0010\u001fR\u0018\u0010(\u001a\u00020\u0003*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006="}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/ChunkDataThrottle$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseFeatureConfiguration;", "thresholdToResentWholeChunk", "", "updateOnLegalInteractOnly", "", "updateDistance", "minimalHeightInvisibleCheck", "netherRoofInvisibleCheck", "detectInvisibleSingleBlock", "detectLavaPool", "antiXrayRandomBlockList", "Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$DefaultedLinkedHashMap;", "", "", "Lorg/bukkit/Material;", "enhancedAntiXray", "nonInvisibleBlocksOverrides", "", "<init>", "(IZIZZZZLio/github/rothes/esu/core/configuration/serializer/MapSerializer$DefaultedLinkedHashMap;ZLjava/util/Set;)V", "getThresholdToResentWholeChunk", "()I", "getUpdateOnLegalInteractOnly", "()Z", "getUpdateDistance", "getMinimalHeightInvisibleCheck", "getNetherRoofInvisibleCheck", "getDetectInvisibleSingleBlock", "getDetectLavaPool", "getAntiXrayRandomBlockList", "()Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$DefaultedLinkedHashMap;", "getEnhancedAntiXray", "getNonInvisibleBlocksOverrides", "()Ljava/util/Set;", "antiXrayRandomBlockIds", "", "getAntiXrayRandomBlockIds", "antiXrayRandomBlockIds$delegate", "Lkotlin/Lazy;", "globalId", "getGlobalId", "(Lorg/bukkit/Material;)I", "postProcess", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "other", "", "hashCode", "toString", "bukkit"})
    @SourceDebugExtension(value={"SMAP\nChunkDataThrottle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkDataThrottle.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/ChunkDataThrottle$FeatureConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n1869#2,2:198\n1563#2:200\n1634#2,3:201\n1563#2:204\n1634#2,3:205\n*S KotlinDebug\n*F\n+ 1 ChunkDataThrottle.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/ChunkDataThrottle$FeatureConfig\n*L\n191#1:198,2\n171#1:200\n171#1:201,3\n172#1:204\n172#1:205,3\n*E\n"})
    public static final class FeatureConfig
    extends BaseFeatureConfiguration {
        @Comment(value="\n                Plugin will resent complete original chunk data if resent block amount exceeds this value.\n                Set it to -1 will never resent chunk but keep updating nearby blocks, \n                 0 to always resent original chunks.\n                Set this to a large value can prevent constantly sending block update packets.\n                Original chunk is not with anti-xray functionality. It is recommended to leave this value -1 .\n                ", overrideOld={"\n                    Plugin will resent whole chunk data if resent block amount exceeds this value.\n                    Set it to -1 will never resent chunk but keep updating nearby blocks, \n                     0 to always resent chunks.\n                    "})
        private final int thresholdToResentWholeChunk;
        @Comment(value="\n                We updates the nearby blocks when a player digs a block immediately.\n                If this is enabled, we will check if the block is in the interaction range\n                 of the player with a rough calculation.\n                ")
        private final boolean updateOnLegalInteractOnly;
        @Comment(value="How many distance of blocks to update from the center when necessary.")
        private final int updateDistance;
        @Comment(value="\n                The bedrock level(minimal height) is never visible unless you are in void.\n                We would skip the check, and if you don't like it you can enable it.\n                ")
        private final boolean minimalHeightInvisibleCheck;
        @Comment(value="\n                Same with minimal-height but it's for nether roof. For out-of-the-box, it's true by default.\n                It's highly recommend to set it to FALSE if you don't allow players to get above there.\n                ", overrideOld={"Same with minimal-height but it's for nether roof."})
        private final boolean netherRoofInvisibleCheck;
        @Comment(value="\n                If a non-occluding block is surrounded by occluding blocks, the center block is invisible.\n                But should we consider all surrounded blocks invisible to this block face?\n                Unless the player joins the game with their eye in the non-occluding block,\n                 they will never naturally see those surrounded blocks.\n                This step takes extra ~0.02ms, so it's not enabled by default.\n                Enable this could help with saving bandwidth in nether, as there's many single-block lava.\n            ")
        private final boolean detectInvisibleSingleBlock;
        @Comment(value="\n                Detect lava pool, and consider lava blocks which being covered invisible.\n                This step takes extra ~0.03ms, so it's not enabled by default.\n                It also makes the plugin detect nearby blocks everytime player moves.\n                Enable this could help with saving bandwidth, especially in nether.\n            ")
        private final boolean detectLavaPool;
        @RenamedFrom(oldName="single-valued-section-block-list")
        @Comment(value="\n                    This feature doesn't support running along with any other anti-xray plugins.\n                    You must use the anti-xray here we provide.\n                    \n                    We will send non-visible blocks to one of the random block in this list.\n                    If you don't like to anti-xray, you can set the list to 'bedrock'.\n                ", overrideOld={"Plugin will convert chunks with all non-visible blocks to single-valued palette format,\nThis could save a lot of bandwidth. And since we are conflicting with anti-xray things,\nyou can use this for some kind of substitution.\nWe choose a random block from the list and make it of a 16*16*16 chunk section."})
        @NotNull
        private final MapSerializer.DefaultedLinkedHashMap<String, List<Material>> antiXrayRandomBlockList;
        @Comment(value="\n                If enabled, we add a extra block type to chunk section palettes for the random block.\n                This will greatly enhance anti-xray capabilities while giving only few bytes of additional bandwidth.\n            ")
        private final boolean enhancedAntiXray;
        @Comment(value="\n                Put any blocks you don't want to hide, so they are ignored while processing.\n                For example, you can add any ores to it, so there's no anti-xray effect.\n                WARNING: This significantly reduces compression badly. Please make sure you really have to do this.\n            ")
        @NotNull
        private final Set<Material> nonInvisibleBlocksOverrides;
        @NotNull
        private final Lazy antiXrayRandomBlockIds$delegate;

        public FeatureConfig(int thresholdToResentWholeChunk, boolean updateOnLegalInteractOnly, int updateDistance, boolean minimalHeightInvisibleCheck, boolean netherRoofInvisibleCheck, boolean detectInvisibleSingleBlock, boolean detectLavaPool, @NotNull MapSerializer.DefaultedLinkedHashMap<String, List<Material>> antiXrayRandomBlockList, boolean enhancedAntiXray, @NotNull Set<? extends Material> nonInvisibleBlocksOverrides) {
            super(true);
            this.thresholdToResentWholeChunk = thresholdToResentWholeChunk;
            this.updateOnLegalInteractOnly = updateOnLegalInteractOnly;
            this.updateDistance = updateDistance;
            this.minimalHeightInvisibleCheck = minimalHeightInvisibleCheck;
            this.netherRoofInvisibleCheck = netherRoofInvisibleCheck;
            this.detectInvisibleSingleBlock = detectInvisibleSingleBlock;
            this.detectLavaPool = detectLavaPool;
            this.antiXrayRandomBlockList = antiXrayRandomBlockList;
            this.enhancedAntiXray = enhancedAntiXray;
            this.nonInvisibleBlocksOverrides = nonInvisibleBlocksOverrides;
            this.antiXrayRandomBlockIds$delegate = LazyKt.lazy(() -> FeatureConfig.antiXrayRandomBlockIds_delegate$lambda$0(this));
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ FeatureConfig(int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, MapSerializer.DefaultedLinkedHashMap object, boolean bl6, Set set, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = -1;
            }
            if ((n3 & 2) != 0) {
                bl = true;
            }
            if ((n3 & 4) != 0) {
                n2 = 2;
            }
            if ((n3 & 8) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x10) != 0) {
                bl3 = true;
            }
            if ((n3 & 0x20) != 0) {
                bl4 = false;
            }
            if ((n3 & 0x40) != 0) {
                bl5 = false;
            }
            if ((n3 & 0x80) != 0) {
                void $this$_init__u24lambda_u240_u241;
                Object[] $this$_init__u24lambda_u240_u240;
                Object[] objectArray;
                Object object2 = new Material[]{Material.BEDROCK};
                Object $this$_init__u24lambda_u240 = object2 = new MapSerializer.DefaultedLinkedHashMap(CollectionsKt.mutableListOf((Object[])object2));
                boolean bl7 = false;
                Object[] objectArray2 = objectArray = CollectionsKt.createListBuilder();
                String string = "world";
                Object object3 = $this$_init__u24lambda_u240;
                boolean bl8 = false;
                boolean cavesUpdate = ServerCompatibility.INSTANCE.getServerVersion().compareTo("1.17") >= 0;
                $this$_init__u24lambda_u240_u240.add(Material.COAL_ORE);
                if (cavesUpdate) {
                    $this$_init__u24lambda_u240_u240.add(Material.COPPER_ORE);
                }
                Object[] objectArray3 = new Material[]{Material.IRON_ORE, Material.GOLD_ORE, Material.EMERALD_ORE, Material.DIAMOND_ORE, Material.REDSTONE_ORE, Material.LAPIS_ORE};
                $this$_init__u24lambda_u240_u240.addAll(CollectionsKt.listOf((Object[])objectArray3));
                if (cavesUpdate) {
                    objectArray3 = new Material[]{Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_LAPIS_ORE};
                    $this$_init__u24lambda_u240_u240.addAll(CollectionsKt.listOf((Object[])objectArray3));
                }
                Unit unit = Unit.INSTANCE;
                ((HashMap)object3).put(string, CollectionsKt.toMutableList((Collection)CollectionsKt.build((List)objectArray)));
                $this$_init__u24lambda_u240_u240 = objectArray = CollectionsKt.createListBuilder();
                string = "world_nether";
                object3 = $this$_init__u24lambda_u240;
                boolean bl9 = false;
                $this$_init__u24lambda_u240_u241.add(Material.NETHER_QUARTZ_ORE);
                if (ServerCompatibility.INSTANCE.getServerVersion().compareTo("1.16") >= 0) {
                    $this$_init__u24lambda_u240_u241.add(Material.NETHER_GOLD_ORE);
                    $this$_init__u24lambda_u240_u241.add(Material.ANCIENT_DEBRIS);
                }
                unit = Unit.INSTANCE;
                ((HashMap)object3).put(string, CollectionsKt.toMutableList((Collection)CollectionsKt.build((List)objectArray)));
                objectArray = new Material[]{Material.END_STONE};
                ((HashMap)$this$_init__u24lambda_u240).put("world_the_end", CollectionsKt.mutableListOf((Object[])objectArray));
                object = object2;
            }
            if ((n3 & 0x100) != 0) {
                bl6 = true;
            }
            if ((n3 & 0x200) != 0) {
                set = SetsKt.emptySet();
            }
            this(n, bl, n2, bl2, bl3, bl4, bl5, (MapSerializer.DefaultedLinkedHashMap<String, List<Material>>)object, bl6, set);
        }

        public final int getThresholdToResentWholeChunk() {
            return this.thresholdToResentWholeChunk;
        }

        public final boolean getUpdateOnLegalInteractOnly() {
            return this.updateOnLegalInteractOnly;
        }

        public final int getUpdateDistance() {
            return this.updateDistance;
        }

        public final boolean getMinimalHeightInvisibleCheck() {
            return this.minimalHeightInvisibleCheck;
        }

        public final boolean getNetherRoofInvisibleCheck() {
            return this.netherRoofInvisibleCheck;
        }

        public final boolean getDetectInvisibleSingleBlock() {
            return this.detectInvisibleSingleBlock;
        }

        public final boolean getDetectLavaPool() {
            return this.detectLavaPool;
        }

        @NotNull
        public final MapSerializer.DefaultedLinkedHashMap<String, List<Material>> getAntiXrayRandomBlockList() {
            return this.antiXrayRandomBlockList;
        }

        public final boolean getEnhancedAntiXray() {
            return this.enhancedAntiXray;
        }

        @NotNull
        public final Set<Material> getNonInvisibleBlocksOverrides() {
            return this.nonInvisibleBlocksOverrides;
        }

        @NotNull
        public final MapSerializer.DefaultedLinkedHashMap<String, int[]> getAntiXrayRandomBlockIds() {
            Lazy lazy = this.antiXrayRandomBlockIds$delegate;
            return (MapSerializer.DefaultedLinkedHashMap)lazy.getValue();
        }

        private final int getGlobalId(Material $this$globalId) {
            if (!$this$globalId.isBlock()) {
                throw new IllegalStateException(("Material " + $this$globalId + " is not a block type!").toString());
            }
            return SpigotConversionUtil.fromBukkitBlockData((BlockData)$this$globalId.createBlockData()).getGlobalId();
        }

        @PostProcess
        private final void postProcess() {
            List<Material> list = this.antiXrayRandomBlockList.getDefault();
            if (list != null) {
                List<Material> it = list;
                boolean bl = false;
                FeatureConfig.postProcess$checkEmptyBlockList("default", it);
            }
            Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.antiXrayRandomBlockList.entrySet());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                FeatureConfig.postProcess$checkEmptyBlockList((String)it.getKey(), (List)it.getValue());
            }
        }

        public final int component1() {
            return this.thresholdToResentWholeChunk;
        }

        public final boolean component2() {
            return this.updateOnLegalInteractOnly;
        }

        public final int component3() {
            return this.updateDistance;
        }

        public final boolean component4() {
            return this.minimalHeightInvisibleCheck;
        }

        public final boolean component5() {
            return this.netherRoofInvisibleCheck;
        }

        public final boolean component6() {
            return this.detectInvisibleSingleBlock;
        }

        public final boolean component7() {
            return this.detectLavaPool;
        }

        @NotNull
        public final MapSerializer.DefaultedLinkedHashMap<String, List<Material>> component8() {
            return this.antiXrayRandomBlockList;
        }

        public final boolean component9() {
            return this.enhancedAntiXray;
        }

        @NotNull
        public final Set<Material> component10() {
            return this.nonInvisibleBlocksOverrides;
        }

        @NotNull
        public final FeatureConfig copy(int thresholdToResentWholeChunk, boolean updateOnLegalInteractOnly, int updateDistance, boolean minimalHeightInvisibleCheck, boolean netherRoofInvisibleCheck, boolean detectInvisibleSingleBlock, boolean detectLavaPool, @NotNull MapSerializer.DefaultedLinkedHashMap<String, List<Material>> antiXrayRandomBlockList, boolean enhancedAntiXray, @NotNull Set<? extends Material> nonInvisibleBlocksOverrides) {
            return new FeatureConfig(thresholdToResentWholeChunk, updateOnLegalInteractOnly, updateDistance, minimalHeightInvisibleCheck, netherRoofInvisibleCheck, detectInvisibleSingleBlock, detectLavaPool, antiXrayRandomBlockList, enhancedAntiXray, nonInvisibleBlocksOverrides);
        }

        public static /* synthetic */ FeatureConfig copy$default(FeatureConfig featureConfig, int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, MapSerializer.DefaultedLinkedHashMap defaultedLinkedHashMap, boolean bl6, Set set, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = featureConfig.thresholdToResentWholeChunk;
            }
            if ((n3 & 2) != 0) {
                bl = featureConfig.updateOnLegalInteractOnly;
            }
            if ((n3 & 4) != 0) {
                n2 = featureConfig.updateDistance;
            }
            if ((n3 & 8) != 0) {
                bl2 = featureConfig.minimalHeightInvisibleCheck;
            }
            if ((n3 & 0x10) != 0) {
                bl3 = featureConfig.netherRoofInvisibleCheck;
            }
            if ((n3 & 0x20) != 0) {
                bl4 = featureConfig.detectInvisibleSingleBlock;
            }
            if ((n3 & 0x40) != 0) {
                bl5 = featureConfig.detectLavaPool;
            }
            if ((n3 & 0x80) != 0) {
                defaultedLinkedHashMap = featureConfig.antiXrayRandomBlockList;
            }
            if ((n3 & 0x100) != 0) {
                bl6 = featureConfig.enhancedAntiXray;
            }
            if ((n3 & 0x200) != 0) {
                set = featureConfig.nonInvisibleBlocksOverrides;
            }
            return featureConfig.copy(n, bl, n2, bl2, bl3, bl4, bl5, defaultedLinkedHashMap, bl6, set);
        }

        @NotNull
        public String toString() {
            return "FeatureConfig(thresholdToResentWholeChunk=" + this.thresholdToResentWholeChunk + ", updateOnLegalInteractOnly=" + this.updateOnLegalInteractOnly + ", updateDistance=" + this.updateDistance + ", minimalHeightInvisibleCheck=" + this.minimalHeightInvisibleCheck + ", netherRoofInvisibleCheck=" + this.netherRoofInvisibleCheck + ", detectInvisibleSingleBlock=" + this.detectInvisibleSingleBlock + ", detectLavaPool=" + this.detectLavaPool + ", antiXrayRandomBlockList=" + this.antiXrayRandomBlockList + ", enhancedAntiXray=" + this.enhancedAntiXray + ", nonInvisibleBlocksOverrides=" + this.nonInvisibleBlocksOverrides + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.thresholdToResentWholeChunk);
            result = result * 31 + Boolean.hashCode(this.updateOnLegalInteractOnly);
            result = result * 31 + Integer.hashCode(this.updateDistance);
            result = result * 31 + Boolean.hashCode(this.minimalHeightInvisibleCheck);
            result = result * 31 + Boolean.hashCode(this.netherRoofInvisibleCheck);
            result = result * 31 + Boolean.hashCode(this.detectInvisibleSingleBlock);
            result = result * 31 + Boolean.hashCode(this.detectLavaPool);
            result = result * 31 + this.antiXrayRandomBlockList.hashCode();
            result = result * 31 + Boolean.hashCode(this.enhancedAntiXray);
            result = result * 31 + ((Object)this.nonInvisibleBlocksOverrides).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig featureConfig = (FeatureConfig)other;
            if (this.thresholdToResentWholeChunk != featureConfig.thresholdToResentWholeChunk) {
                return false;
            }
            if (this.updateOnLegalInteractOnly != featureConfig.updateOnLegalInteractOnly) {
                return false;
            }
            if (this.updateDistance != featureConfig.updateDistance) {
                return false;
            }
            if (this.minimalHeightInvisibleCheck != featureConfig.minimalHeightInvisibleCheck) {
                return false;
            }
            if (this.netherRoofInvisibleCheck != featureConfig.netherRoofInvisibleCheck) {
                return false;
            }
            if (this.detectInvisibleSingleBlock != featureConfig.detectInvisibleSingleBlock) {
                return false;
            }
            if (this.detectLavaPool != featureConfig.detectLavaPool) {
                return false;
            }
            if (!Intrinsics.areEqual(this.antiXrayRandomBlockList, featureConfig.antiXrayRandomBlockList)) {
                return false;
            }
            if (this.enhancedAntiXray != featureConfig.enhancedAntiXray) {
                return false;
            }
            return Intrinsics.areEqual(this.nonInvisibleBlocksOverrides, featureConfig.nonInvisibleBlocksOverrides);
        }

        /*
         * WARNING - void declaration
         */
        private static final MapSerializer.DefaultedLinkedHashMap antiXrayRandomBlockIds_delegate$lambda$0(FeatureConfig this$0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            MapSerializer.DefaultedLinkedHashMap defaultedLinkedHashMap;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv2;
            MapSerializer.DefaultedLinkedHashMap<String, List<Material>> $this$antiXrayRandomBlockIds_delegate_u24lambda_u240_u240 = this$0.antiXrayRandomBlockList;
            boolean bl = false;
            List list = $this$antiXrayRandomBlockIds_delegate_u24lambda_u240_u240.getDefault();
            if (list == null) {
                list = CollectionsKt.listOf((Object)Material.BEDROCK);
            }
            Iterable $this$map$iv2 = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Material material = (Material)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this$0.getGlobalId((Material)it));
            }
            int[] nArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
            MapSerializer.DefaultedLinkedHashMap it = defaultedLinkedHashMap = new MapSerializer.DefaultedLinkedHashMap(nArray);
            boolean bl3 = false;
            destination$iv$iv = $this$antiXrayRandomBlockIds_delegate_u24lambda_u240_u240.entrySet();
            Map map = it;
            boolean $i$f$map2 = false;
            item$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv3;
                void $this$map$iv3;
                void it2;
                Map.Entry entry = (Map.Entry)item$iv$iv3;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                Iterable iterable2 = (Iterable)it2.getValue();
                Object k = it2.getKey();
                boolean $i$f$map3 = false;
                void var21_26 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                    void it3;
                    Material material = (Material)item$iv$iv4;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl5 = false;
                    collection2.add(this$0.getGlobalId((Material)it3));
                }
                collection.add(TuplesKt.to(k, (Object)CollectionsKt.toIntArray((Collection)((List)destination$iv$iv3))));
            }
            MapsKt.putAll((Map)map, (Iterable)((List)destination$iv$iv2));
            return defaultedLinkedHashMap;
        }

        private static final void postProcess$checkEmptyBlockList(String key, List<Material> list) {
            if (list.isEmpty()) {
                list.add(Material.BEDROCK);
                InternalsKt.getPlugin().warn("[ChunkDataThrottle] Anti-xray random block list of '" + key + "' is empty! We have added bedrock to it.");
            }
        }

        public FeatureConfig() {
            this(0, false, 0, false, false, false, false, null, false, null, 1023, null);
        }
    }
}

