/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.util.version.remapper;

import com.google.gson.reflect.TypeToken;
import io.github.rothes.esu.bukkit.util.ServerCompatibility;
import io.github.rothes.esu.core.EsuBootstrap;
import io.github.rothes.esu.core.util.DataSerializer;
import io.github.rothes.esu.core.util.artifact.local.FileHashes;
import io.github.rothes.esu.core.util.version.Version;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.neoforged.art.api.Renamer;
import net.neoforged.art.api.SignatureStripperConfig;
import net.neoforged.art.api.Transformer;
import net.neoforged.srgutils.IMappingFile;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004./01B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0019\u001a\u00020\u0010J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010#\u001a\u00020\u000bH\u0002J\b\u0010$\u001a\u00020\"H\u0002J\b\u0010%\u001a\u00020\u0010H\u0002J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020*H\u0002J\f\u0010-\u001a\u00020\u0010*\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00062"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader;", "", "<init>", "()V", "version", "Lio/github/rothes/esu/core/util/version/Version;", "hasSpigotMembers", "", "getHasSpigotMembers", "()Z", "cacheFolder", "Ljava/io/File;", "kotlin.jvm.PlatformType", "fileHashes", "Lio/github/rothes/esu/core/util/artifact/local/FileHashes;", "SERVER_CL", "", "SERVER_MOJMAP", "craftBukkitPackage", "getCraftBukkitPackage", "()Ljava/lang/String;", "loadedFiles", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles;", "getLoadedFiles", "()Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles;", "mappingsHash", "loadMappings", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Mappings;", "loadMappingsFromCache", "loadServers", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Servers;", "mappings", "loadServersFromCache", "remapServers", "", "getActualServerJar", "downloadFiles", "getSpigotCommit", "getMinecraftVersion", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest$Version;", "getServerMappingsUrl", "pkg", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionPackage;", "getServerJarUrl", "response", "readUrl", "CachedFiles", "StashCommits", "McVersionManifest", "McVersionPackage", "bukkit"})
@SourceDebugExtension(value={"SMAP\nMappingsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingsLoader.kt\nio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 DataSerializer.kt\nio/github/rothes/esu/core/util/DataSerializer\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,325:1\n1869#2,2:326\n1869#2,2:328\n295#2,2:333\n230#2,2:338\n29#3:330\n24#3,2:331\n29#3:335\n24#3,2:336\n1#4:340\n*S KotlinDebug\n*F\n+ 1 MappingsLoader.kt\nio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader\n*L\n158#1:326,2\n224#1:328,2\n236#1:333,2\n244#1:338,2\n235#1:330\n235#1:331,2\n243#1:335\n243#1:336,2\n*E\n"})
public final class MappingsLoader {
    @NotNull
    public static final MappingsLoader INSTANCE = new MappingsLoader();
    @NotNull
    private static final Version version = ServerCompatibility.INSTANCE.getServerVersion();
    private static final boolean hasSpigotMembers = version.compareTo("1.18") < 0;
    private static final File cacheFolder = EsuBootstrap.Companion.getInstance().baseConfigPath().resolve(".cache/mappings/" + version).toFile();
    @NotNull
    private static final FileHashes fileHashes = new FileHashes(cacheFolder);
    @NotNull
    private static final String SERVER_CL = "serverCl.jar";
    @NotNull
    private static final String SERVER_MOJMAP = "serverMojmap.jar";
    @Nullable
    private static final String craftBukkitPackage;
    @NotNull
    private static final CachedFiles loadedFiles;

    private MappingsLoader() {
    }

    public final boolean getHasSpigotMembers() {
        return hasSpigotMembers;
    }

    @Nullable
    public final String getCraftBukkitPackage() {
        return craftBukkitPackage;
    }

    @NotNull
    public final CachedFiles getLoadedFiles() {
        return loadedFiles;
    }

    @NotNull
    public final String mappingsHash() {
        return FileHashes.Companion.getSha1(fileHashes.getDataFile());
    }

    private final CachedFiles.Mappings loadMappings() {
        CachedFiles.Mappings mappings = this.loadMappingsFromCache();
        if (mappings == null) {
            MappingsLoader it = this;
            boolean bl = false;
            INSTANCE.downloadFiles();
            mappings = INSTANCE.loadMappingsFromCache();
            if (mappings == null) {
                throw new IllegalStateException("Failed to load mappings, cache corrupted".toString());
            }
        }
        return mappings;
    }

    private final CachedFiles.Mappings loadMappingsFromCache() {
        IMappingFile iMappingFile;
        if (!cacheFolder.isDirectory()) {
            return null;
        }
        IMappingFile iMappingFile2 = MappingsLoader.loadMappingsFromCache$getMapping("mojang.txt");
        if (iMappingFile2 == null) {
            return null;
        }
        IMappingFile iMappingFile3 = MappingsLoader.loadMappingsFromCache$getMapping("bukkit-cl.csrg");
        if (iMappingFile3 == null) {
            return null;
        }
        if (hasSpigotMembers) {
            iMappingFile = MappingsLoader.loadMappingsFromCache$getMapping("bukkit-members.csrg");
            if (iMappingFile == null) {
                return null;
            }
        } else {
            iMappingFile = null;
        }
        return new CachedFiles.Mappings(iMappingFile2, iMappingFile3, iMappingFile);
    }

    private final CachedFiles.Servers loadServers(CachedFiles.Mappings mappings) {
        CachedFiles.Servers servers = this.loadServersFromCache();
        if (servers == null) {
            MappingsLoader it = this;
            boolean bl = false;
            INSTANCE.remapServers(mappings);
            servers = INSTANCE.loadServersFromCache();
            if (servers == null) {
                throw new IllegalStateException("Failed to load servers, cache corrupted".toString());
            }
        }
        return servers;
    }

    private final CachedFiles.Servers loadServersFromCache() {
        File server = this.getActualServerJar();
        File serverCl = hasSpigotMembers ? FilesKt.resolve((File)cacheFolder, (String)SERVER_CL) : null;
        File serverMojmap = FilesKt.resolve((File)cacheFolder, (String)SERVER_MOJMAP);
        if (!FileHashes.verify$default(fileHashes, server, null, 2, null) || !FileHashes.verify$default(fileHashes, serverMojmap, null, 2, null) || serverCl != null && !FileHashes.verify$default(fileHashes, serverCl, null, 2, null)) {
            return null;
        }
        return new CachedFiles.Servers(server, serverCl, serverMojmap);
    }

    private final void remapServers(CachedFiles.Mappings mappings) {
        Renamer.Builder builder;
        File server = this.getActualServerJar();
        FileHashes.store$default(fileHashes, server, null, null, 6, null);
        EsuBootstrap.Companion.getInstance().info("Remapping server jars");
        File serverMojmap = FilesKt.resolve((File)cacheFolder, (String)SERVER_MOJMAP);
        Renamer.Builder $this$remapServers_u24lambda_u240 = builder = Renamer.builder();
        boolean bl = false;
        $this$remapServers_u24lambda_u240.add(Transformer.renamerFactory((IMappingFile)mappings.getMojmap().reverse(), (boolean)false));
        $this$remapServers_u24lambda_u240.add(Transformer.signatureStripperFactory((SignatureStripperConfig)SignatureStripperConfig.ALL));
        $this$remapServers_u24lambda_u240.threads(1);
        $this$remapServers_u24lambda_u240.logger(MappingsLoader::remapServers$lambda$0$0);
        builder.build().run(server, serverMojmap);
        FileHashes.store$default(fileHashes, serverMojmap, null, null, 6, null);
        if (hasSpigotMembers) {
            Renamer.Builder builder2;
            File serverCl = FilesKt.resolve((File)cacheFolder, (String)SERVER_CL);
            Renamer.Builder $this$remapServers_u24lambda_u241 = builder2 = Renamer.builder();
            boolean bl2 = false;
            $this$remapServers_u24lambda_u241.add(Transformer.renamerFactory((IMappingFile)mappings.getCbCl(), (boolean)false));
            $this$remapServers_u24lambda_u241.add(Transformer.signatureStripperFactory((SignatureStripperConfig)SignatureStripperConfig.ALL));
            $this$remapServers_u24lambda_u241.threads(1);
            $this$remapServers_u24lambda_u241.logger(MappingsLoader::remapServers$lambda$1$0);
            builder2.build().run(server, serverCl);
            FileHashes.store$default(fileHashes, serverCl, null, null, 6, null);
        }
        fileHashes.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File getActualServerJar() {
        File serverJar = FilesKt.resolve((File)cacheFolder, (String)"server.jar");
        JarFile jarFile = new JarFile(serverJar);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!StringsKt.startsWith$default((String)entry.getName(), (String)"META-INF/versions/", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)entry.getName(), (String)".jar", (boolean)false, (int)2, null)) continue;
            File embedded = FilesKt.resolve((File)cacheFolder, (String)"serverEmbedded.jar");
            Closeable closeable = jarFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                embedded.createNewFile();
                Closeable closeable2 = new FileOutputStream(embedded);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return embedded;
        }
        return serverJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadFiles() {
        Pair it;
        List list;
        EsuBootstrap.Companion.getInstance().info("Downloading mappings, this might take a while as it's the first run");
        String commit = this.getSpigotCommit();
        McVersionManifest.Version version = this.getMinecraftVersion();
        McVersionPackage pkg = version.getPackageObject();
        List $this$downloadFiles_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$downloadFiles_u24lambda_u240.add(TuplesKt.to((Object)"server.jar", (Object)INSTANCE.getServerJarUrl(pkg)));
        $this$downloadFiles_u24lambda_u240.add(TuplesKt.to((Object)"mojang.txt", (Object)INSTANCE.getServerMappingsUrl(pkg)));
        $this$downloadFiles_u24lambda_u240.add(TuplesKt.to((Object)"bukkit-cl.csrg", (Object)("https://hub.spigotmc.org/stash/projects/SPIGOT/repos/builddata/raw/mappings/bukkit-" + MappingsLoader.version + "-cl.csrg?at=" + commit)));
        if (hasSpigotMembers) {
            $this$downloadFiles_u24lambda_u240.add(TuplesKt.to((Object)"bukkit-members.csrg", (Object)("https://hub.spigotmc.org/stash/projects/SPIGOT/repos/builddata/raw/mappings/bukkit-" + MappingsLoader.version + "-members.csrg?at=" + commit)));
        }
        List files = CollectionsKt.build((List)list);
        cacheFolder.mkdirs();
        fileHashes.clear();
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        block12: for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl2 = false;
            File file = FilesKt.resolve((File)cacheFolder, (String)((String)it.getFirst()));
            int trys = 0;
            while (true) {
                try {
                    Closeable closeable = URI.create((String)it.getSecond()).toURL().openStream();
                    Throwable throwable = null;
                    try {
                        long l;
                        InputStream input = (InputStream)closeable;
                        boolean bl3 = false;
                        Closeable closeable2 = new FileOutputStream(file);
                        Throwable throwable2 = null;
                        try {
                            FileOutputStream output = (FileOutputStream)closeable2;
                            boolean bl4 = false;
                            l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        long l2 = l;
                        continue block12;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    if (trys < 2) {
                        EsuBootstrap.Companion.getInstance().info("Failed to download, retrying: " + e);
                        ++trys;
                        continue;
                    }
                    throw new IOException("Failed to download " + it.getSecond() + " to " + file, e);
                }
                break;
            }
        }
        if (MappingsLoader.version.getMinor() <= 16) {
            String prefix = "net/minecraft/server/" + craftBukkitPackage + "/";
            File $this$downloadFiles_u24lambda_u242 = FilesKt.resolve((File)cacheFolder, (String)"bukkit-cl.csrg");
            boolean bl5 = false;
            FilesKt.writeText$default((File)$this$downloadFiles_u24lambda_u242, (String)(CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)$this$downloadFiles_u24lambda_u242, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> MappingsLoader.downloadFiles$lambda$2$0(prefix, arg_0), (int)30, null) + "\nnet/minecraft/server/MinecraftServer net/minecraft/server/" + craftBukkitPackage + "/MinecraftServer"), null, (int)2, null);
            File $this$downloadFiles_u24lambda_u243 = FilesKt.resolve((File)cacheFolder, (String)"bukkit-members.csrg");
            boolean bl6 = false;
            Regex regex = new Regex("L([^;)]+)");
            FilesKt.writeText$default((File)$this$downloadFiles_u24lambda_u243, (String)CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)$this$downloadFiles_u24lambda_u243, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> MappingsLoader.downloadFiles$lambda$3$1(prefix, regex, arg_0), (int)30, null), null, (int)2, null);
        }
        $this$forEach$iv = files;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl7 = false;
            FileHashes.store$default(fileHashes, FilesKt.resolve((File)cacheFolder, (String)((String)it.getFirst())), null, null, 6, null);
        }
        fileHashes.save();
    }

    /*
     * WARNING - void declaration
     */
    private final String getSpigotCommit() {
        Object v0;
        block2: {
            void $this$iv$iv;
            void this_$iv;
            HttpClient client = HttpClient.newBuilder().build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://hub.spigotmc.org/stash/rest/api/1.0/projects/SPIGOT/repos/builddata/commits?withCounts=true&limit=1000")).build();
            DataSerializer dataSerializer = DataSerializer.INSTANCE;
            String $this$deserialize$iv = client.send(request, HttpResponse.BodyHandlers.ofString()).body();
            boolean $i$f$deserialize = false;
            void var7_7 = this_$iv;
            String str$iv$iv = $this$deserialize$iv;
            TypeToken typeToken$iv$iv = TypeToken.get(StashCommits.class);
            boolean $i$f$deserializeObj = false;
            StashCommits response = (StashCommits)$this$iv$iv.getGson().fromJson(str$iv$iv, typeToken$iv$iv.getType());
            Iterable $this$firstOrNull$iv = response.getValues();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                StashCommits.Value commit = (StashCommits.Value)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)commit.getMessage(), (Object)("Update to Minecraft " + version))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        StashCommits.Value value = v0;
        if (value == null) {
            throw new IllegalStateException("Failed to find spigot mapping commit".toString());
        }
        StashCommits.Value commit = value;
        return commit.getId();
    }

    /*
     * WARNING - void declaration
     */
    private final McVersionManifest.Version getMinecraftVersion() {
        Object element$iv2;
        block1: {
            void $this$iv$iv;
            void this_$iv;
            DataSerializer dataSerializer = DataSerializer.INSTANCE;
            String $this$deserialize$iv = this.readUrl("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json");
            boolean $i$f$deserialize = false;
            Iterator iterator = this_$iv;
            String str$iv$iv = $this$deserialize$iv;
            TypeToken typeToken$iv$iv = TypeToken.get(McVersionManifest.class);
            boolean $i$f$deserializeObj = false;
            McVersionManifest response = (McVersionManifest)$this$iv$iv.getGson().fromJson(str$iv$iv, typeToken$iv$iv.getType());
            Iterable $this$first$iv = response.getVersions();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                McVersionManifest.Version it = (McVersionManifest.Version)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)version.toString())) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        McVersionManifest.Version version = (McVersionManifest.Version)element$iv2;
        return version;
    }

    private final String getServerMappingsUrl(McVersionPackage pkg) {
        McVersionPackage.DownloadObject downloadObject = pkg.getDownloads().get("server_mappings");
        if (downloadObject == null) {
            throw new IllegalStateException("Mojang server mappings is not provided".toString());
        }
        McVersionPackage.DownloadObject artifact = downloadObject;
        return artifact.getUrl();
    }

    private final String getServerJarUrl(McVersionPackage response) {
        McVersionPackage.DownloadObject downloadObject = response.getDownloads().get("server");
        if (downloadObject == null) {
            throw new IllegalStateException("Server jar is not provided".toString());
        }
        McVersionPackage.DownloadObject artifact = downloadObject;
        return artifact.getUrl();
    }

    private final String readUrl(String $this$readUrl) {
        URL uRL = URI.create($this$readUrl).toURL();
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        return new String(byArray, charset);
    }

    private static final IMappingFile loadMappingsFromCache$getMapping(String fileName) {
        File file = FilesKt.resolve((File)cacheFolder, (String)fileName);
        if (!file.isFile() || !FileHashes.verify$default(fileHashes, file, null, 2, null)) {
            return null;
        }
        return IMappingFile.load((File)file);
    }

    private static final void remapServers$lambda$0$0(String it) {
        EsuBootstrap.Companion.getInstance().info("[Remapper] " + it);
    }

    private static final void remapServers$lambda$1$0(String it) {
        EsuBootstrap.Companion.getInstance().info("[Remapper] " + it);
    }

    private static final String downloadFiles$prefixed(String $this$downloadFiles_u24prefixed, String prefix) {
        return prefix + StringsKt.substringAfterLast$default((String)$this$downloadFiles_u24prefixed, (char)'/', null, (int)2, null);
    }

    private static final CharSequence downloadFiles$lambda$2$0(String $prefix, String line) {
        CharSequence charSequence;
        if (!StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{' '};
            List split = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (!(split.size() == 2)) {
                boolean bl = false;
                String string = "Invalid line format: " + line;
                throw new IllegalArgumentException(string.toString());
            }
            charSequence = split.get(0) + " " + MappingsLoader.downloadFiles$prefixed((String)split.get(1), $prefix);
        } else {
            charSequence = line;
        }
        return charSequence;
    }

    private static final String downloadFiles$lambda$3$handleArgs(String $this$downloadFiles_u24lambda_u243_u24handleArgs, Regex regex, String prefix) {
        CharSequence charSequence = $this$downloadFiles_u24lambda_u243_u24handleArgs;
        Function1 function1 = arg_0 -> MappingsLoader.downloadFiles$lambda$3$handleArgs$0(prefix, arg_0);
        return regex.replace(charSequence, function1);
    }

    private static final CharSequence downloadFiles$lambda$3$handleArgs$0(String $prefix, MatchResult it) {
        return StringsKt.contains$default((CharSequence)((CharSequence)it.getGroupValues().get(1)), (char)'/', (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)((String)it.getGroupValues().get(1)), (String)"net/minecraft/server/", (boolean)false, (int)2, null) ? (CharSequence)it.getValue() : (CharSequence)("L" + MappingsLoader.downloadFiles$prefixed((String)it.getGroupValues().get(1), $prefix));
    }

    private static final CharSequence downloadFiles$lambda$3$1(String $prefix, Regex $regex, String line) {
        CharSequence charSequence;
        if (!StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) {
            String string;
            char[] cArray = new char[]{' '};
            List split = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            int n = split.size();
            if (!(3 <= n ? n < 5 : false)) {
                boolean bl = false;
                String string2 = "Invalid line format: " + line;
                throw new IllegalArgumentException(string2.toString());
            }
            switch (split.size()) {
                case 3: {
                    string = MappingsLoader.downloadFiles$prefixed((String)split.get(0), $prefix) + " " + MappingsLoader.downloadFiles$lambda$3$handleArgs((String)split.get(1), $regex, $prefix) + " " + split.get(2);
                    break;
                }
                case 4: {
                    string = MappingsLoader.downloadFiles$prefixed((String)split.get(0), $prefix) + " " + split.get(1) + " " + MappingsLoader.downloadFiles$lambda$3$handleArgs((String)split.get(2), $regex, $prefix) + " " + split.get(3);
                    break;
                }
                default: {
                    throw new IllegalStateException("?".toString());
                }
            }
            charSequence = string;
        } else {
            charSequence = line;
        }
        return charSequence;
    }

    static {
        MatchResult matchResult = new Regex("org\\.bukkit\\.craftbukkit\\.([^.]+)\\.CraftServer").matchEntire((CharSequence)Bukkit.getServer().getClass().getCanonicalName());
        craftBukkitPackage = matchResult != null ? (String)matchResult.getGroupValues().get(1) : null;
        CachedFiles.Mappings mappings = INSTANCE.loadMappings();
        CachedFiles.Servers servers = INSTANCE.loadServers(mappings);
        loadedFiles = new CachedFiles(mappings, servers);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles;", "", "mappings", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Mappings;", "servers", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Servers;", "<init>", "(Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Mappings;Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Servers;)V", "getMappings", "()Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Mappings;", "getServers", "()Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Servers;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Mappings", "Servers", "bukkit"})
    public static final class CachedFiles {
        @NotNull
        private final Mappings mappings;
        @NotNull
        private final Servers servers;

        public CachedFiles(@NotNull Mappings mappings, @NotNull Servers servers) {
            this.mappings = mappings;
            this.servers = servers;
        }

        @NotNull
        public final Mappings getMappings() {
            return this.mappings;
        }

        @NotNull
        public final Servers getServers() {
            return this.servers;
        }

        @NotNull
        public final Mappings component1() {
            return this.mappings;
        }

        @NotNull
        public final Servers component2() {
            return this.servers;
        }

        @NotNull
        public final CachedFiles copy(@NotNull Mappings mappings, @NotNull Servers servers) {
            return new CachedFiles(mappings, servers);
        }

        public static /* synthetic */ CachedFiles copy$default(CachedFiles cachedFiles, Mappings mappings, Servers servers, int n, Object object) {
            if ((n & 1) != 0) {
                mappings = cachedFiles.mappings;
            }
            if ((n & 2) != 0) {
                servers = cachedFiles.servers;
            }
            return cachedFiles.copy(mappings, servers);
        }

        @NotNull
        public String toString() {
            return "CachedFiles(mappings=" + this.mappings + ", servers=" + this.servers + ")";
        }

        public int hashCode() {
            int result = this.mappings.hashCode();
            result = result * 31 + this.servers.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedFiles)) {
                return false;
            }
            CachedFiles cachedFiles = (CachedFiles)other;
            if (!Intrinsics.areEqual((Object)this.mappings, (Object)cachedFiles.mappings)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.servers, (Object)cachedFiles.servers);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Mappings;", "", "mojmap", "Lnet/neoforged/srgutils/IMappingFile;", "cbCl", "cbMembers", "<init>", "(Lnet/neoforged/srgutils/IMappingFile;Lnet/neoforged/srgutils/IMappingFile;Lnet/neoforged/srgutils/IMappingFile;)V", "getMojmap", "()Lnet/neoforged/srgutils/IMappingFile;", "getCbCl", "getCbMembers", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class Mappings {
            @NotNull
            private final IMappingFile mojmap;
            @NotNull
            private final IMappingFile cbCl;
            @Nullable
            private final IMappingFile cbMembers;

            public Mappings(@NotNull IMappingFile mojmap, @NotNull IMappingFile cbCl, @Nullable IMappingFile cbMembers) {
                this.mojmap = mojmap;
                this.cbCl = cbCl;
                this.cbMembers = cbMembers;
            }

            @NotNull
            public final IMappingFile getMojmap() {
                return this.mojmap;
            }

            @NotNull
            public final IMappingFile getCbCl() {
                return this.cbCl;
            }

            @Nullable
            public final IMappingFile getCbMembers() {
                return this.cbMembers;
            }

            @NotNull
            public final IMappingFile component1() {
                return this.mojmap;
            }

            @NotNull
            public final IMappingFile component2() {
                return this.cbCl;
            }

            @Nullable
            public final IMappingFile component3() {
                return this.cbMembers;
            }

            @NotNull
            public final Mappings copy(@NotNull IMappingFile mojmap, @NotNull IMappingFile cbCl, @Nullable IMappingFile cbMembers) {
                return new Mappings(mojmap, cbCl, cbMembers);
            }

            public static /* synthetic */ Mappings copy$default(Mappings mappings, IMappingFile iMappingFile, IMappingFile iMappingFile2, IMappingFile iMappingFile3, int n, Object object) {
                if ((n & 1) != 0) {
                    iMappingFile = mappings.mojmap;
                }
                if ((n & 2) != 0) {
                    iMappingFile2 = mappings.cbCl;
                }
                if ((n & 4) != 0) {
                    iMappingFile3 = mappings.cbMembers;
                }
                return mappings.copy(iMappingFile, iMappingFile2, iMappingFile3);
            }

            @NotNull
            public String toString() {
                return "Mappings(mojmap=" + this.mojmap + ", cbCl=" + this.cbCl + ", cbMembers=" + this.cbMembers + ")";
            }

            public int hashCode() {
                int result = this.mojmap.hashCode();
                result = result * 31 + this.cbCl.hashCode();
                result = result * 31 + (this.cbMembers == null ? 0 : this.cbMembers.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Mappings)) {
                    return false;
                }
                Mappings mappings = (Mappings)other;
                if (!Intrinsics.areEqual((Object)this.mojmap, (Object)mappings.mojmap)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.cbCl, (Object)mappings.cbCl)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.cbMembers, (Object)mappings.cbMembers);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$CachedFiles$Servers;", "", "server", "Ljava/io/File;", "serverCl", "serverMojmap", "<init>", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getServer", "()Ljava/io/File;", "getServerCl", "getServerMojmap", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class Servers {
            @NotNull
            private final File server;
            @Nullable
            private final File serverCl;
            @NotNull
            private final File serverMojmap;

            public Servers(@NotNull File server, @Nullable File serverCl, @NotNull File serverMojmap) {
                this.server = server;
                this.serverCl = serverCl;
                this.serverMojmap = serverMojmap;
            }

            @NotNull
            public final File getServer() {
                return this.server;
            }

            @Nullable
            public final File getServerCl() {
                return this.serverCl;
            }

            @NotNull
            public final File getServerMojmap() {
                return this.serverMojmap;
            }

            @NotNull
            public final File component1() {
                return this.server;
            }

            @Nullable
            public final File component2() {
                return this.serverCl;
            }

            @NotNull
            public final File component3() {
                return this.serverMojmap;
            }

            @NotNull
            public final Servers copy(@NotNull File server, @Nullable File serverCl, @NotNull File serverMojmap) {
                return new Servers(server, serverCl, serverMojmap);
            }

            public static /* synthetic */ Servers copy$default(Servers servers, File file, File file2, File file3, int n, Object object) {
                if ((n & 1) != 0) {
                    file = servers.server;
                }
                if ((n & 2) != 0) {
                    file2 = servers.serverCl;
                }
                if ((n & 4) != 0) {
                    file3 = servers.serverMojmap;
                }
                return servers.copy(file, file2, file3);
            }

            @NotNull
            public String toString() {
                return "Servers(server=" + this.server + ", serverCl=" + this.serverCl + ", serverMojmap=" + this.serverMojmap + ")";
            }

            public int hashCode() {
                int result = this.server.hashCode();
                result = result * 31 + (this.serverCl == null ? 0 : this.serverCl.hashCode());
                result = result * 31 + this.serverMojmap.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Servers)) {
                    return false;
                }
                Servers servers = (Servers)other;
                if (!Intrinsics.areEqual((Object)this.server, (Object)servers.server)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.serverCl, (Object)servers.serverCl)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.serverMojmap, (Object)servers.serverMojmap);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest;", "", "latest", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest$Latest;", "versions", "", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest$Version;", "<init>", "(Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest$Latest;Ljava/util/List;)V", "getLatest", "()Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest$Latest;", "getVersions", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Latest", "Version", "bukkit"})
    private static final class McVersionManifest {
        @NotNull
        private final Latest latest;
        @NotNull
        private final List<Version> versions;

        public McVersionManifest(@NotNull Latest latest, @NotNull List<Version> versions) {
            this.latest = latest;
            this.versions = versions;
        }

        @NotNull
        public final Latest getLatest() {
            return this.latest;
        }

        @NotNull
        public final List<Version> getVersions() {
            return this.versions;
        }

        @NotNull
        public final Latest component1() {
            return this.latest;
        }

        @NotNull
        public final List<Version> component2() {
            return this.versions;
        }

        @NotNull
        public final McVersionManifest copy(@NotNull Latest latest, @NotNull List<Version> versions) {
            return new McVersionManifest(latest, versions);
        }

        public static /* synthetic */ McVersionManifest copy$default(McVersionManifest mcVersionManifest, Latest latest, List list, int n, Object object) {
            if ((n & 1) != 0) {
                latest = mcVersionManifest.latest;
            }
            if ((n & 2) != 0) {
                list = mcVersionManifest.versions;
            }
            return mcVersionManifest.copy(latest, list);
        }

        @NotNull
        public String toString() {
            return "McVersionManifest(latest=" + this.latest + ", versions=" + this.versions + ")";
        }

        public int hashCode() {
            int result = this.latest.hashCode();
            result = result * 31 + ((Object)this.versions).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof McVersionManifest)) {
                return false;
            }
            McVersionManifest mcVersionManifest = (McVersionManifest)other;
            if (!Intrinsics.areEqual((Object)this.latest, (Object)mcVersionManifest.latest)) {
                return false;
            }
            return Intrinsics.areEqual(this.versions, mcVersionManifest.versions);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest$Latest;", "", "release", "", "snapshot", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getRelease", "()Ljava/lang/String;", "getSnapshot", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "bukkit"})
        public static final class Latest {
            @NotNull
            private final String release;
            @NotNull
            private final String snapshot;

            public Latest(@NotNull String release, @NotNull String snapshot) {
                this.release = release;
                this.snapshot = snapshot;
            }

            @NotNull
            public final String getRelease() {
                return this.release;
            }

            @NotNull
            public final String getSnapshot() {
                return this.snapshot;
            }

            @NotNull
            public final String component1() {
                return this.release;
            }

            @NotNull
            public final String component2() {
                return this.snapshot;
            }

            @NotNull
            public final Latest copy(@NotNull String release, @NotNull String snapshot) {
                return new Latest(release, snapshot);
            }

            public static /* synthetic */ Latest copy$default(Latest latest, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = latest.release;
                }
                if ((n & 2) != 0) {
                    string2 = latest.snapshot;
                }
                return latest.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Latest(release=" + this.release + ", snapshot=" + this.snapshot + ")";
            }

            public int hashCode() {
                int result = this.release.hashCode();
                result = result * 31 + this.snapshot.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Latest)) {
                    return false;
                }
                Latest latest = (Latest)other;
                if (!Intrinsics.areEqual((Object)this.release, (Object)latest.release)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.snapshot, (Object)latest.snapshot);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest$Version;", "", "id", "", "type", "url", "sha1", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getType", "getUrl", "getSha1", "packageObject", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionPackage;", "getPackageObject", "()Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionPackage;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "bukkit"})
        @SourceDebugExtension(value={"SMAP\nMappingsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingsLoader.kt\nio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest$Version\n+ 2 DataSerializer.kt\nio/github/rothes/esu/core/util/DataSerializer\n*L\n1#1,325:1\n29#2:326\n24#2,2:327\n*S KotlinDebug\n*F\n+ 1 MappingsLoader.kt\nio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionManifest$Version\n*L\n311#1:326\n311#1:327,2\n*E\n"})
        public static final class Version {
            @NotNull
            private final String id;
            @NotNull
            private final String type;
            @NotNull
            private final String url;
            @NotNull
            private final String sha1;

            public Version(@NotNull String id, @NotNull String type, @NotNull String url, @NotNull String sha1) {
                this.id = id;
                this.type = type;
                this.url = url;
                this.sha1 = sha1;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final String getType() {
                return this.type;
            }

            @NotNull
            public final String getUrl() {
                return this.url;
            }

            @NotNull
            public final String getSha1() {
                return this.sha1;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final McVersionPackage getPackageObject() {
                void $this$iv$iv;
                void this_$iv;
                DataSerializer dataSerializer = DataSerializer.INSTANCE;
                String $this$deserialize$iv = INSTANCE.readUrl(this.url);
                boolean $i$f$deserialize = false;
                void var4_4 = this_$iv;
                String str$iv$iv = $this$deserialize$iv;
                TypeToken typeToken$iv$iv = TypeToken.get(McVersionPackage.class);
                boolean $i$f$deserializeObj = false;
                return (McVersionPackage)$this$iv$iv.getGson().fromJson(str$iv$iv, typeToken$iv$iv.getType());
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            @NotNull
            public final String component2() {
                return this.type;
            }

            @NotNull
            public final String component3() {
                return this.url;
            }

            @NotNull
            public final String component4() {
                return this.sha1;
            }

            @NotNull
            public final Version copy(@NotNull String id, @NotNull String type, @NotNull String url, @NotNull String sha1) {
                return new Version(id, type, url, sha1);
            }

            public static /* synthetic */ Version copy$default(Version version, String string, String string2, String string3, String string4, int n, Object object) {
                if ((n & 1) != 0) {
                    string = version.id;
                }
                if ((n & 2) != 0) {
                    string2 = version.type;
                }
                if ((n & 4) != 0) {
                    string3 = version.url;
                }
                if ((n & 8) != 0) {
                    string4 = version.sha1;
                }
                return version.copy(string, string2, string3, string4);
            }

            @NotNull
            public String toString() {
                return "Version(id=" + this.id + ", type=" + this.type + ", url=" + this.url + ", sha1=" + this.sha1 + ")";
            }

            public int hashCode() {
                int result = this.id.hashCode();
                result = result * 31 + this.type.hashCode();
                result = result * 31 + this.url.hashCode();
                result = result * 31 + this.sha1.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Version)) {
                    return false;
                }
                Version version = (Version)other;
                if (!Intrinsics.areEqual((Object)this.id, (Object)version.id)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.type, (Object)version.type)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.url, (Object)version.url)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.sha1, (Object)version.sha1);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0012B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionPackage;", "", "downloads", "", "", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionPackage$DownloadObject;", "<init>", "(Ljava/util/Map;)V", "getDownloads", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "DownloadObject", "bukkit"})
    private static final class McVersionPackage {
        @NotNull
        private final Map<String, DownloadObject> downloads;

        public McVersionPackage(@NotNull Map<String, DownloadObject> downloads) {
            this.downloads = downloads;
        }

        @NotNull
        public final Map<String, DownloadObject> getDownloads() {
            return this.downloads;
        }

        @NotNull
        public final Map<String, DownloadObject> component1() {
            return this.downloads;
        }

        @NotNull
        public final McVersionPackage copy(@NotNull Map<String, DownloadObject> downloads) {
            return new McVersionPackage(downloads);
        }

        public static /* synthetic */ McVersionPackage copy$default(McVersionPackage mcVersionPackage, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = mcVersionPackage.downloads;
            }
            return mcVersionPackage.copy(map);
        }

        @NotNull
        public String toString() {
            return "McVersionPackage(downloads=" + this.downloads + ")";
        }

        public int hashCode() {
            return ((Object)this.downloads).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof McVersionPackage)) {
                return false;
            }
            McVersionPackage mcVersionPackage = (McVersionPackage)other;
            return Intrinsics.areEqual(this.downloads, mcVersionPackage.downloads);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0017"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$McVersionPackage$DownloadObject;", "", "sha1", "", "size", "", "url", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getSha1", "()Ljava/lang/String;", "getSize", "()I", "getUrl", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "bukkit"})
        public static final class DownloadObject {
            @NotNull
            private final String sha1;
            private final int size;
            @NotNull
            private final String url;

            public DownloadObject(@NotNull String sha1, int size, @NotNull String url) {
                this.sha1 = sha1;
                this.size = size;
                this.url = url;
            }

            @NotNull
            public final String getSha1() {
                return this.sha1;
            }

            public final int getSize() {
                return this.size;
            }

            @NotNull
            public final String getUrl() {
                return this.url;
            }

            @NotNull
            public final String component1() {
                return this.sha1;
            }

            public final int component2() {
                return this.size;
            }

            @NotNull
            public final String component3() {
                return this.url;
            }

            @NotNull
            public final DownloadObject copy(@NotNull String sha1, int size, @NotNull String url) {
                return new DownloadObject(sha1, size, url);
            }

            public static /* synthetic */ DownloadObject copy$default(DownloadObject downloadObject, String string, int n, String string2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = downloadObject.sha1;
                }
                if ((n2 & 2) != 0) {
                    n = downloadObject.size;
                }
                if ((n2 & 4) != 0) {
                    string2 = downloadObject.url;
                }
                return downloadObject.copy(string, n, string2);
            }

            @NotNull
            public String toString() {
                return "DownloadObject(sha1=" + this.sha1 + ", size=" + this.size + ", url=" + this.url + ")";
            }

            public int hashCode() {
                int result = this.sha1.hashCode();
                result = result * 31 + Integer.hashCode(this.size);
                result = result * 31 + this.url.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DownloadObject)) {
                    return false;
                }
                DownloadObject downloadObject = (DownloadObject)other;
                if (!Intrinsics.areEqual((Object)this.sha1, (Object)downloadObject.sha1)) {
                    return false;
                }
                if (this.size != downloadObject.size) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.url, (Object)downloadObject.url);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001(BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J_\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001J\u0013\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$StashCommits;", "", "authorCount", "", "isLastPage", "", "limit", "nextPageStart", "size", "start", "totalCount", "values", "", "Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$StashCommits$Value;", "<init>", "(IZIIIIILjava/util/List;)V", "getAuthorCount", "()I", "()Z", "getLimit", "getNextPageStart", "getSize", "getStart", "getTotalCount", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "", "Value", "bukkit"})
    private static final class StashCommits {
        private final int authorCount;
        private final boolean isLastPage;
        private final int limit;
        private final int nextPageStart;
        private final int size;
        private final int start;
        private final int totalCount;
        @NotNull
        private final List<Value> values;

        public StashCommits(int authorCount, boolean isLastPage, int limit, int nextPageStart, int size, int start2, int totalCount, @NotNull List<Value> values) {
            this.authorCount = authorCount;
            this.isLastPage = isLastPage;
            this.limit = limit;
            this.nextPageStart = nextPageStart;
            this.size = size;
            this.start = start2;
            this.totalCount = totalCount;
            this.values = values;
        }

        public final int getAuthorCount() {
            return this.authorCount;
        }

        public final boolean isLastPage() {
            return this.isLastPage;
        }

        public final int getLimit() {
            return this.limit;
        }

        public final int getNextPageStart() {
            return this.nextPageStart;
        }

        public final int getSize() {
            return this.size;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getTotalCount() {
            return this.totalCount;
        }

        @NotNull
        public final List<Value> getValues() {
            return this.values;
        }

        public final int component1() {
            return this.authorCount;
        }

        public final boolean component2() {
            return this.isLastPage;
        }

        public final int component3() {
            return this.limit;
        }

        public final int component4() {
            return this.nextPageStart;
        }

        public final int component5() {
            return this.size;
        }

        public final int component6() {
            return this.start;
        }

        public final int component7() {
            return this.totalCount;
        }

        @NotNull
        public final List<Value> component8() {
            return this.values;
        }

        @NotNull
        public final StashCommits copy(int authorCount, boolean isLastPage, int limit, int nextPageStart, int size, int start2, int totalCount, @NotNull List<Value> values) {
            return new StashCommits(authorCount, isLastPage, limit, nextPageStart, size, start2, totalCount, values);
        }

        public static /* synthetic */ StashCommits copy$default(StashCommits stashCommits, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, List list, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = stashCommits.authorCount;
            }
            if ((n7 & 2) != 0) {
                bl = stashCommits.isLastPage;
            }
            if ((n7 & 4) != 0) {
                n2 = stashCommits.limit;
            }
            if ((n7 & 8) != 0) {
                n3 = stashCommits.nextPageStart;
            }
            if ((n7 & 0x10) != 0) {
                n4 = stashCommits.size;
            }
            if ((n7 & 0x20) != 0) {
                n5 = stashCommits.start;
            }
            if ((n7 & 0x40) != 0) {
                n6 = stashCommits.totalCount;
            }
            if ((n7 & 0x80) != 0) {
                list = stashCommits.values;
            }
            return stashCommits.copy(n, bl, n2, n3, n4, n5, n6, list);
        }

        @NotNull
        public String toString() {
            return "StashCommits(authorCount=" + this.authorCount + ", isLastPage=" + this.isLastPage + ", limit=" + this.limit + ", nextPageStart=" + this.nextPageStart + ", size=" + this.size + ", start=" + this.start + ", totalCount=" + this.totalCount + ", values=" + this.values + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.authorCount);
            result = result * 31 + Boolean.hashCode(this.isLastPage);
            result = result * 31 + Integer.hashCode(this.limit);
            result = result * 31 + Integer.hashCode(this.nextPageStart);
            result = result * 31 + Integer.hashCode(this.size);
            result = result * 31 + Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.totalCount);
            result = result * 31 + ((Object)this.values).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StashCommits)) {
                return false;
            }
            StashCommits stashCommits = (StashCommits)other;
            if (this.authorCount != stashCommits.authorCount) {
                return false;
            }
            if (this.isLastPage != stashCommits.isLastPage) {
                return false;
            }
            if (this.limit != stashCommits.limit) {
                return false;
            }
            if (this.nextPageStart != stashCommits.nextPageStart) {
                return false;
            }
            if (this.size != stashCommits.size) {
                return false;
            }
            if (this.start != stashCommits.start) {
                return false;
            }
            if (this.totalCount != stashCommits.totalCount) {
                return false;
            }
            return Intrinsics.areEqual(this.values, stashCommits.values);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/github/rothes/esu/bukkit/util/version/remapper/MappingsLoader$StashCommits$Value;", "", "id", "", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getMessage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "bukkit"})
        public static final class Value {
            @NotNull
            private final String id;
            @NotNull
            private final String message;

            public Value(@NotNull String id, @NotNull String message) {
                this.id = id;
                this.message = message;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            @NotNull
            public final String component2() {
                return this.message;
            }

            @NotNull
            public final Value copy(@NotNull String id, @NotNull String message) {
                return new Value(id, message);
            }

            public static /* synthetic */ Value copy$default(Value value, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = value.id;
                }
                if ((n & 2) != 0) {
                    string2 = value.message;
                }
                return value.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Value(id=" + this.id + ", message=" + this.message + ")";
            }

            public int hashCode() {
                int result = this.id.hashCode();
                result = result * 31 + this.message.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Value)) {
                    return false;
                }
                Value value = (Value)other;
                if (!Intrinsics.areEqual((Object)this.id, (Object)value.id)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.message, (Object)value.message);
            }
        }
    }
}

