/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.util.artifact;

import io.github.rothes.esu.core.EsuCore;
import io.github.rothes.esu.core.config.EsuConfig;
import io.github.rothes.esu.core.util.artifact.injector.ReflectURLInjector;
import io.github.rothes.esu.core.util.artifact.injector.URLInjector;
import io.github.rothes.esu.core.util.artifact.injector.UnsafeURLInjector;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.InaccessibleObjectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.PatternExclusionsDependencyFilter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J0\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u001a\b\u0002\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00190\u0018J\u001c\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/github/rothes/esu/core/util/artifact/MavenResolver;", "", "<init>", "()V", "blockedGroupIds", "", "", "repository", "Lorg/eclipse/aether/RepositorySystem;", "session", "Lorg/eclipse/aether/RepositorySystemSession;", "repositories", "", "Lorg/eclipse/aether/repository/RemoteRepository;", "injecter", "Lio/github/rothes/esu/core/util/artifact/injector/URLInjector;", "createRepositories", "loadUrl", "", "url", "Ljava/net/URL;", "loadDependencies", "libraries", "loader", "Lkotlin/Function2;", "Ljava/io/File;", "Lorg/eclipse/aether/artifact/Artifact;", "testDependency", "library", "scope", "Lkotlin/Function0;", "core"})
@SourceDebugExtension(value={"SMAP\nMavenResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenResolver.kt\nio/github/rothes/esu/core/util/artifact/MavenResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1#2:121\n1563#3:122\n1634#3,3:123\n1563#3:126\n1634#3,3:127\n*S KotlinDebug\n*F\n+ 1 MavenResolver.kt\nio/github/rothes/esu/core/util/artifact/MavenResolver\n*L\n81#1:122\n81#1:123,3\n89#1:126\n89#1:127,3\n*E\n"})
public final class MavenResolver {
    @NotNull
    public static final MavenResolver INSTANCE;
    @NotNull
    private static final Set<String> blockedGroupIds;
    @NotNull
    private static final RepositorySystem repository;
    @NotNull
    private static final RepositorySystemSession session;
    @NotNull
    private static final List<RemoteRepository> repositories;
    @NotNull
    private static URLInjector injecter;

    private MavenResolver() {
    }

    private final List<RemoteRepository> createRepositories() {
        List<RemoteRepository> list;
        EsuConfig.ConfigData.MavenRepo repo = EsuConfig.INSTANCE.get().getMavenRepo();
        List<RemoteRepository> $this$createRepositories_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$createRepositories_u24lambda_u242.add(new RemoteRepository.Builder(repo.getId(), "default", repo.getUrl()).build());
        if (Intrinsics.areEqual(repo.getId(), "central")) {
            $this$createRepositories_u24lambda_u242.add(new RemoteRepository.Builder("NeoForged", "default", "https://maven.neoforged.net/releases/").build());
        }
        return CollectionsKt.build(list);
    }

    public final void loadUrl(@NotNull URL url) {
        try {
            injecter.addURL(url);
        }
        catch (InaccessibleObjectException e) {
            if (Intrinsics.areEqual(injecter, UnsafeURLInjector.INSTANCE)) {
                injecter = ReflectURLInjector.INSTANCE;
                injecter.addURL(url);
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void loadDependencies(@NotNull List<String> libraries, @NotNull Function2<? super File, ? super Artifact, ? extends File> loader) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        if (!(!((Collection)libraries).isEmpty())) {
            boolean $i$a$-require-MavenResolver$loadDependencies$32 = false;
            String $i$a$-require-MavenResolver$loadDependencies$32 = "Library must not be empty";
            throw new IllegalArgumentException($i$a$-require-MavenResolver$loadDependencies$32.toString());
        }
        Iterable $this$map$iv = libraries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Dependency((Artifact)new DefaultArtifact((String)((Object)it)), null));
        }
        List dependencies = (List)destination$iv$iv;
        DependencyResult result = null;
        int trys = 0;
        while (true) {
            try {
                Collection<CallSite> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                $this$mapTo$iv$iv = blockedGroupIds;
                CollectRequest collectRequest = new CollectRequest(null, dependencies, repositories);
                RepositorySystemSession repositorySystemSession = session;
                collection = repository;
                boolean $i$f$map2 = false;
                void $i$f$mapTo2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String string = (String)item$iv$iv;
                    collection2 = destination$iv$iv2;
                    boolean bl = false;
                    collection2.add((CallSite)((Object)((String)it + ":::")));
                }
                collection2 = (List)destination$iv$iv2;
                Collection collection3 = collection2;
                DependencyFilter dependencyFilter = (DependencyFilter)new PatternExclusionsDependencyFilter(collection3);
                CollectRequest collectRequest2 = collectRequest;
                result = collection.resolveDependencies(repositorySystemSession, new DependencyRequest(collectRequest2, dependencyFilter));
            }
            catch (DependencyResolutionException e) {
                if (trys < 2) {
                    ++trys;
                    continue;
                }
                throw new RuntimeException("Error resolving libraries", e);
            }
            break;
        }
        for (ArtifactResult it : result.getArtifactResults()) {
            Artifact artifact = it.getArtifact();
            if (blockedGroupIds.contains(artifact.getGroupId())) continue;
            File file = artifact.getFile();
            File toLoad = loader.invoke(file, (Artifact)artifact);
            URL url = toLoad.toURI().toURL();
            this.loadUrl(url);
        }
    }

    public static /* synthetic */ void loadDependencies$default(MavenResolver mavenResolver, List list, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = MavenResolver::loadDependencies$lambda$3;
        }
        mavenResolver.loadDependencies(list, function2);
    }

    public final void testDependency(@NotNull String library, @NotNull Function0<Unit> scope) {
        try {
            scope.invoke();
        }
        catch (Throwable throwable) {
            MavenResolver.loadDependencies$default(this, CollectionsKt.listOf(library), null, 2, null);
        }
    }

    private static final File loadDependencies$lambda$3(File f, Artifact artifact) {
        return f;
    }

    static {
        DefaultServiceLocator defaultServiceLocator;
        INSTANCE = new MavenResolver();
        blockedGroupIds = SetsKt.setOf("org.jetbrains.kotlin");
        DefaultServiceLocator $this$repository_u24lambda_u240 = defaultServiceLocator = MavenRepositorySystemUtils.newServiceLocator();
        boolean bl = false;
        $this$repository_u24lambda_u240.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        $this$repository_u24lambda_u240.addService(TransporterFactory.class, HttpTransporterFactory.class);
        repository = (RepositorySystem)defaultServiceLocator.getService(RepositorySystem.class);
        DefaultServiceLocator $this$session_u24lambda_u241 = defaultServiceLocator = MavenRepositorySystemUtils.newSession();
        boolean bl2 = false;
        $this$session_u24lambda_u241.setSystemProperties((Map)System.getProperties());
        $this$session_u24lambda_u241.setChecksumPolicy("fail");
        $this$session_u24lambda_u241.setLocalRepositoryManager(repository.newLocalRepositoryManager((RepositorySystemSession)$this$session_u24lambda_u241, new LocalRepository("libraries")));
        $this$session_u24lambda_u241.setTransferListener((TransferListener)new AbstractTransferListener(){

            public void transferStarted(TransferEvent event) {
                EsuCore.Companion.getInstance().info("Downloading " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
            }
        });
        $this$session_u24lambda_u241.setReadOnly();
        session = (RepositorySystemSession)defaultServiceLocator;
        repositories = repository.newResolutionRepositories(session, INSTANCE.createRepositories());
        injecter = UnsafeURLInjector.INSTANCE;
    }
}

