/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle;

import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.module.networkthrottle.entityculling.CullDataManager;
import io.github.rothes.esu.bukkit.module.networkthrottle.entityculling.RaytraceHandler;
import io.github.rothes.esu.bukkit.util.ServerCompatibility;
import io.github.rothes.esu.bukkit.util.extension.FeatureKt;
import io.github.rothes.esu.bukkit.util.extension.ListenerExt;
import io.github.rothes.esu.bukkit.util.version.VersionUtils;
import io.github.rothes.esu.bukkit.util.version.adapter.nms.RegistryValueSerializers;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.CommonFeature;
import io.github.rothes.esu.core.module.Feature;
import io.github.rothes.esu.core.module.configuration.BaseFeatureConfiguration;
import io.github.rothes.esu.core.module.configuration.EmptyConfiguration;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.core.util.extension.ClassUtils;
import io.github.rothes.esu.core.util.version.Version;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u0010\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0018\u0010\u0006\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/EntityCulling;", "Lio/github/rothes/esu/core/module/CommonFeature;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/EntityCulling$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/EmptyConfiguration;", "<init>", "()V", "raytraceHandler", "Lio/github/rothes/esu/bukkit/module/networkthrottle/entityculling/RaytraceHandler;", "checkUnavailable", "Lio/github/rothes/esu/core/module/Feature$AvailableCheck;", "onEnable", "", "onDisable", "broadcastRemoved", "entity", "Lorg/bukkit/entity/Entity;", "Listeners", "EntityRemoveListeners", "FeatureConfig", "bukkit"})
@SourceDebugExtension(value={"SMAP\nEntityCulling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityCulling.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/EntityCulling\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class EntityCulling
extends CommonFeature<FeatureConfig, EmptyConfiguration> {
    @NotNull
    public static final EntityCulling INSTANCE;
    @Nullable
    private static final RaytraceHandler<?, ?> raytraceHandler;

    private EntityCulling() {
    }

    @Override
    @Nullable
    public Feature.AvailableCheck checkUnavailable() {
        Feature.AvailableCheck availableCheck = super.checkUnavailable();
        if (availableCheck == null && (availableCheck = FeatureKt.checkPacketEvents(this)) == null) {
            EntityCulling it = this;
            boolean bl = false;
            if (ServerCompatibility.INSTANCE.getServerVersion().compareTo(Version.Companion.toVersion("1.18")) < 0) {
                InternalsKt.getPlugin().err("[EntityCulling] This feature requires Spigot 1.18 .");
                return Feature.AvailableCheck.Companion.fail((Function1<? super User, MessageData>)((Function1)EntityCulling::checkUnavailable$lambda$0$0));
            }
            RaytraceHandler<?, ?> raytraceHandler = EntityCulling.raytraceHandler;
            availableCheck = raytraceHandler != null ? raytraceHandler.checkConfig() : null;
        }
        return availableCheck;
    }

    @Override
    public void onEnable() {
        ListenerExt.register$default(ListenerExt.INSTANCE, Listeners.INSTANCE, null, 1, null);
        if (EntityRemoveListeners.INSTANCE.isSupported()) {
            ListenerExt.register$default(ListenerExt.INSTANCE, EntityRemoveListeners.INSTANCE, null, 1, null);
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        ListenerExt.INSTANCE.unregister(Listeners.INSTANCE);
        if (EntityRemoveListeners.INSTANCE.isSupported()) {
            ListenerExt.INSTANCE.unregister(EntityRemoveListeners.INSTANCE);
        }
        CullDataManager.INSTANCE.shutdown();
    }

    private final void broadcastRemoved(Entity entity) {
        RaytraceHandler<?, ?> raytraceHandler = EntityCulling.raytraceHandler;
        Intrinsics.checkNotNull(raytraceHandler);
        raytraceHandler.onEntityRemove(entity);
    }

    private static final MessageData checkUnavailable$lambda$0$0(User it) {
        return MessageData.Companion.getMessage("Server is not supported");
    }

    static {
        RaytraceHandler raytraceHandler;
        INSTANCE = new EntityCulling();
        if (RegistryValueSerializers.Companion.isSupported() && ServerCompatibility.INSTANCE.getServerVersion().compareTo(Version.Companion.toVersion("1.18")) >= 0) {
            RaytraceHandler raytraceHandler2;
            RaytraceHandler it = raytraceHandler2 = VersionUtils.INSTANCE.versioned(RaytraceHandler.class);
            boolean bl = false;
            INSTANCE.registerFeature(it);
            raytraceHandler = raytraceHandler2;
        } else {
            raytraceHandler = null;
        }
        EntityCulling.raytraceHandler = raytraceHandler;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/EntityCulling$EntityRemoveListeners;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "isSupported", "", "()Z", "onEntityRemove", "", "event", "Lorg/bukkit/event/entity/EntityRemoveEvent;", "bukkit"})
    private static final class EntityRemoveListeners
    implements Listener {
        @NotNull
        public static final EntityRemoveListeners INSTANCE = new EntityRemoveListeners();
        private static final boolean isSupported = ClassUtils.INSTANCE.existsClass("org.bukkit.event.entity.EntityRemoveEvent");

        private EntityRemoveListeners() {
        }

        public final boolean isSupported() {
            return isSupported;
        }

        @EventHandler
        public final void onEntityRemove(@NotNull EntityRemoveEvent event) {
            INSTANCE.broadcastRemoved(event.getEntity());
        }
    }

    @Comment(value="\n        [ EXPERIMENTAL ]\n        Smart Occlusion Culling to save upload bandwidth.\n        Plugin will hide invisible entities to players.\n    ")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/EntityCulling$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseFeatureConfiguration;", "<init>", "()V", "bukkit"})
    public static final class FeatureConfig
    extends BaseFeatureConfiguration {
        public FeatureConfig() {
            super(false, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/EntityCulling$Listeners;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onPlayerQuit", "", "event", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onChangeWorld", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "bukkit"})
    private static final class Listeners
    implements Listener {
        @NotNull
        public static final Listeners INSTANCE = new Listeners();

        private Listeners() {
        }

        @EventHandler
        public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
            CullDataManager.INSTANCE.remove(event.getPlayer());
            INSTANCE.broadcastRemoved((Entity)event.getPlayer());
        }

        @EventHandler
        public final void onChangeWorld(@NotNull PlayerChangedWorldEvent event) {
            CullDataManager.INSTANCE.get(event.getPlayer()).showAll();
        }

        @EventHandler
        public final void onTeleport(@NotNull PlayerTeleportEvent event) {
            CullDataManager.INSTANCE.get(event.getPlayer()).showAll();
        }
    }
}

