/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module;

import io.github.rothes.esu.bukkit.InternalsKt;
import io.github.rothes.esu.bukkit.module.BukkitModule;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.configuration.BaseModuleConfiguration;
import io.github.rothes.esu.core.module.configuration.EmptyConfiguration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixModule;", "Lio/github/rothes/esu/bukkit/module/BukkitModule;", "Lio/github/rothes/esu/bukkit/module/ExploitFixModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/EmptyConfiguration;", "<init>", "()V", "enable", "", "disable", "Listeners", "ModuleConfig", "bukkit"})
public final class ExploitFixModule
extends BukkitModule<ModuleConfig, EmptyConfiguration> {
    @NotNull
    public static final ExploitFixModule INSTANCE = new ExploitFixModule();

    private ExploitFixModule() {
        super(ModuleConfig.class, EmptyConfiguration.class);
    }

    @Override
    public void enable() {
        Bukkit.getPluginManager().registerEvents((Listener)Listeners.INSTANCE, (Plugin)InternalsKt.getPlugin());
    }

    @Override
    public void disable() {
        super.disable();
        HandlerList.unregisterAll((Listener)Listeners.INSTANCE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixModule$Listeners;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onInvClick", "", "e", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "bukkit"})
    private static final class Listeners
    implements Listener {
        @NotNull
        public static final Listeners INSTANCE = new Listeners();

        private Listeners() {
        }

        @EventHandler
        public final void onInvClick(@NotNull InventoryClickEvent e) {
            ModuleConfig config = (ModuleConfig)INSTANCE.getConfig();
            if (!config.getBlockInventoryClickWhileUsingItems()) {
                return;
            }
            HumanEntity humanEntity = (HumanEntity)CollectionsKt.firstOrNull(e.getViewers());
            if (humanEntity == null) {
                return;
            }
            HumanEntity player = humanEntity;
            if (player.isHandRaised()) {
                if (config.getOnlyBlockConsumerItems()) {
                    if (e.getHotbarButton() == -1) {
                        return;
                    }
                    ItemStack itemStack = player.getInventory().getItem(e.getHotbarButton());
                    if (itemStack == null) {
                        return;
                    }
                    ItemStack item = itemStack;
                    Material type = item.getType();
                    if (type != Material.BOW && type != Material.TRIDENT) {
                        return;
                    }
                }
                e.setCancelled(true);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/bukkit/module/ExploitFixModule$ModuleConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseModuleConfiguration;", "blockInventoryClickWhileUsingItems", "", "onlyBlockConsumerItems", "<init>", "(ZZ)V", "getBlockInventoryClickWhileUsingItems", "()Z", "getOnlyBlockConsumerItems", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "bukkit"})
    public static final class ModuleConfig
    extends BaseModuleConfiguration {
        @Comment(value="Blocking moving or clicking items in inventory while player is using item.\nThis is for fixing trident/bow duplication exploit.\nIf you are running Paper 1.21.4+, this is already fixed, and you don't need this.")
        private final boolean blockInventoryClickWhileUsingItems;
        @Comment(value="More detailed detect to block trident/bow duplication only.\nIf you allow more cheats, enable this.")
        private final boolean onlyBlockConsumerItems;

        public ModuleConfig(boolean blockInventoryClickWhileUsingItems, boolean onlyBlockConsumerItems) {
            super(false, 1, null);
            this.blockInventoryClickWhileUsingItems = blockInventoryClickWhileUsingItems;
            this.onlyBlockConsumerItems = onlyBlockConsumerItems;
        }

        public /* synthetic */ ModuleConfig(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getBlockInventoryClickWhileUsingItems() {
            return this.blockInventoryClickWhileUsingItems;
        }

        public final boolean getOnlyBlockConsumerItems() {
            return this.onlyBlockConsumerItems;
        }

        public final boolean component1() {
            return this.blockInventoryClickWhileUsingItems;
        }

        public final boolean component2() {
            return this.onlyBlockConsumerItems;
        }

        @NotNull
        public final ModuleConfig copy(boolean blockInventoryClickWhileUsingItems, boolean onlyBlockConsumerItems) {
            return new ModuleConfig(blockInventoryClickWhileUsingItems, onlyBlockConsumerItems);
        }

        public static /* synthetic */ ModuleConfig copy$default(ModuleConfig moduleConfig, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = moduleConfig.blockInventoryClickWhileUsingItems;
            }
            if ((n & 2) != 0) {
                bl2 = moduleConfig.onlyBlockConsumerItems;
            }
            return moduleConfig.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ModuleConfig(blockInventoryClickWhileUsingItems=" + this.blockInventoryClickWhileUsingItems + ", onlyBlockConsumerItems=" + this.onlyBlockConsumerItems + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.blockInventoryClickWhileUsingItems);
            result = result * 31 + Boolean.hashCode(this.onlyBlockConsumerItems);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleConfig)) {
                return false;
            }
            ModuleConfig moduleConfig = (ModuleConfig)other;
            if (this.blockInventoryClickWhileUsingItems != moduleConfig.blockInventoryClickWhileUsingItems) {
                return false;
            }
            return this.onlyBlockConsumerItems == moduleConfig.onlyBlockConsumerItems;
        }

        public ModuleConfig() {
            this(false, false, 3, null);
        }
    }
}

