/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.util.artifact;

import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    private HashUtils() {
    }

    public static String calculateSha1(File file) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            try (FileInputStream input = new FileInputStream(file);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = input.read(buffer)) != -1) {
                    messageDigest.update(buffer, 0, read);
                }
            }
            byte[] hash = messageDigest.digest();
            return BaseEncoding.base16().lowerCase().encode(hash);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

