/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.lib.org.spongepowered.configurate.yaml;

import io.github.rothes.esu.lib.net.kyori.option.Option;
import io.github.rothes.esu.lib.net.kyori.option.OptionSchema;
import io.github.rothes.esu.lib.org.spongepowered.configurate.CommentedConfigurationNode;
import io.github.rothes.esu.lib.org.spongepowered.configurate.ConfigurationNode;
import io.github.rothes.esu.lib.org.spongepowered.configurate.ConfigurationOptions;
import io.github.rothes.esu.lib.org.spongepowered.configurate.RepresentationHint;
import io.github.rothes.esu.lib.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import io.github.rothes.esu.lib.org.spongepowered.configurate.loader.CommentHandler;
import io.github.rothes.esu.lib.org.spongepowered.configurate.loader.CommentHandlers;
import io.github.rothes.esu.lib.org.spongepowered.configurate.util.UnmodifiableCollections;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.NodeStyle;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.ScalarStyle;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.YamlConstructor;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.YamlRepresenter;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.DumperOptions;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.LoaderOptions;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.Yaml;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.constructor.BaseConstructor;
import io.github.rothes.esu.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.representer.Representer;
import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class);
    public static final RepresentationHint<ScalarStyle> SCALAR_STYLE = RepresentationHint.of("configurate:yaml/scalarstyle", ScalarStyle.class);
    public static final RepresentationHint<NodeStyle> NODE_STYLE = RepresentationHint.of("configurate:yaml/nodestyle", NodeStyle.class);
    private final LoaderOptions loaderOpts;
    private final DumperOptions dumperOpts;
    private final ThreadLocal<YamlConstructor> constructor;
    private final ThreadLocal<Yaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.HASH});
        this.loaderOpts = new LoaderOptions().setAcceptTabs(true).setProcessComments(builder.commentsEnabled());
        this.loaderOpts.setCodePointLimit(Integer.MAX_VALUE);
        DumperOptions opts = builder.options;
        opts.setDefaultFlowStyle(NodeStyle.asSnakeYaml(builder.style));
        opts.setProcessComments(builder.commentsEnabled());
        opts.setWidth(builder.lineLength());
        opts.setIndicatorIndent(builder.indent());
        opts.setIndentWithIndicator(true);
        this.dumperOpts = builder.options;
        this.dumperOpts.setDefaultFlowStyle(NodeStyle.asSnakeYaml(builder.optionState().value(Builder.NODE_STYLE)));
        this.dumperOpts.setIndent(builder.optionState().value(Builder.INDENT));
        this.constructor = ThreadLocal.withInitial(() -> new YamlConstructor(this.loaderOpts));
        this.yaml = ThreadLocal.withInitial(() -> new Yaml((BaseConstructor)this.constructor.get(), (Representer)new YamlRepresenter(true, this.dumperOpts), this.dumperOpts, this.loaderOpts));
    }

    @Override
    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) {
        this.constructor.get().options = node.options();
        node.from((ConfigurationNode)this.yaml.get().load(reader));
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) {
        this.yaml.get().dump(node, writer);
    }

    @Override
    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root(options);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private static final OptionSchema.Mutable UNSAFE_SCHEMA = OptionSchema.childSchema(AbstractConfigurationLoader.Builder.SCHEMA);
        public static final OptionSchema SCHEMA = UNSAFE_SCHEMA.frozenView();
        public static final Option<NodeStyle> NODE_STYLE = UNSAFE_SCHEMA.enumOption("yaml:node_style", NodeStyle.class, null);
        public static final Option<Integer> INDENT = UNSAFE_SCHEMA.intOption("yaml:indent", 4);
        private final DumperOptions options = new DumperOptions();
        private @Nullable NodeStyle style;
        private boolean enableComments;
        private int lineLength;

        Builder() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
        }

        @Override
        protected OptionSchema optionSchema() {
            return SCHEMA;
        }

        public Builder indent(int indent) {
            this.optionStateBuilder().value(INDENT, indent);
            return this;
        }

        public int indent() {
            return this.optionState().value(INDENT);
        }

        public Builder width(int width) {
            this.options.setWidth(width);
            return this;
        }

        public int width() {
            return this.options.getWidth();
        }

        public Builder nodeStyle(@Nullable NodeStyle style) {
            this.optionStateBuilder().value(NODE_STYLE, style);
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return this.optionState().value(NODE_STYLE);
        }

        public Builder commentsEnabled(boolean enableComments) {
            this.enableComments = enableComments;
            return this;
        }

        public boolean commentsEnabled() {
            return this.enableComments;
        }

        public Builder lineLength(int lineLength) {
            this.lineLength = lineLength;
            return this;
        }

        public int lineLength() {
            return this.lineLength;
        }

        @Override
        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

