/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.config.data;

import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.meta.NoDeserializeIf;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.bukkit.NamespacedKey;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003JE\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010#\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u0007H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0016\u0010\u000b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u0018"}, d2={"Lio/github/rothes/esu/bukkit/config/data/PotionEffectData;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "type", "", "duration", "Ljava/time/Duration;", "level", "", "ambient", "", "particles", "icon", "<init>", "(Ljava/lang/String;Ljava/time/Duration;IZZZ)V", "getType", "()Ljava/lang/String;", "getDuration", "()Ljava/time/Duration;", "getLevel", "()I", "getAmbient", "()Z", "getParticles", "getIcon", "bukkit", "Lorg/bukkit/potion/PotionEffect;", "getBukkit", "()Lorg/bukkit/potion/PotionEffect;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "toString"})
public final class PotionEffectData
implements ConfigurationPart {
    @NotNull
    private final String type;
    @NotNull
    private final Duration duration;
    @NoDeserializeIf(value="1")
    private final int level;
    @NoDeserializeIf(value="true")
    private final boolean ambient;
    @NoDeserializeIf(value="true")
    private final boolean particles;
    @NoDeserializeIf(value="true")
    private final boolean icon;

    public PotionEffectData(@NotNull String type, @NotNull Duration duration2, int level, boolean ambient, boolean particles, boolean icon) {
        this.type = type;
        this.duration = duration2;
        this.level = level;
        this.ambient = ambient;
        this.particles = particles;
        this.icon = icon;
    }

    public /* synthetic */ PotionEffectData(String string, Duration duration2, int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "speed";
        }
        if ((n2 & 2) != 0) {
            long l = DurationKt.toDuration(1, DurationUnit.SECONDS);
            int n3 = kotlin.time.Duration.getNanosecondsComponent-impl(l);
            long l2 = kotlin.time.Duration.getInWholeSeconds-impl(l);
            Duration duration3 = Duration.ofSeconds(l2, n3);
            Intrinsics.checkNotNullExpressionValue(duration3, "toComponents-impl(...)");
            duration2 = duration3;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = true;
        }
        this(string, duration2, n, bl, bl2, bl3);
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    public final int getLevel() {
        return this.level;
    }

    public final boolean getAmbient() {
        return this.ambient;
    }

    public final boolean getParticles() {
        return this.particles;
    }

    public final boolean getIcon() {
        return this.icon;
    }

    @NotNull
    public final PotionEffect getBukkit() {
        PotionEffectType potionEffectType = PotionEffectType.getByKey((NamespacedKey)NamespacedKey.fromString((String)this.type));
        if (potionEffectType == null) {
            throw new IllegalStateException(("Unknown potion type: " + this.type).toString());
        }
        return new PotionEffect(potionEffectType, (int)(this.duration.toMillis() / (long)50), this.level - 1, this.ambient, this.particles, this.icon);
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final Duration component2() {
        return this.duration;
    }

    public final int component3() {
        return this.level;
    }

    public final boolean component4() {
        return this.ambient;
    }

    public final boolean component5() {
        return this.particles;
    }

    public final boolean component6() {
        return this.icon;
    }

    @NotNull
    public final PotionEffectData copy(@NotNull String type, @NotNull Duration duration2, int level, boolean ambient, boolean particles, boolean icon) {
        return new PotionEffectData(type, duration2, level, ambient, particles, icon);
    }

    public static /* synthetic */ PotionEffectData copy$default(PotionEffectData potionEffectData, String string, Duration duration2, int n, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = potionEffectData.type;
        }
        if ((n2 & 2) != 0) {
            duration2 = potionEffectData.duration;
        }
        if ((n2 & 4) != 0) {
            n = potionEffectData.level;
        }
        if ((n2 & 8) != 0) {
            bl = potionEffectData.ambient;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = potionEffectData.particles;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = potionEffectData.icon;
        }
        return potionEffectData.copy(string, duration2, n, bl, bl2, bl3);
    }

    @NotNull
    public String toString() {
        return "PotionEffectData(type=" + this.type + ", duration=" + this.duration + ", level=" + this.level + ", ambient=" + this.ambient + ", particles=" + this.particles + ", icon=" + this.icon + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.duration.hashCode();
        result = result * 31 + Integer.hashCode(this.level);
        result = result * 31 + Boolean.hashCode(this.ambient);
        result = result * 31 + Boolean.hashCode(this.particles);
        result = result * 31 + Boolean.hashCode(this.icon);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PotionEffectData)) {
            return false;
        }
        PotionEffectData potionEffectData = (PotionEffectData)other;
        if (!Intrinsics.areEqual(this.type, potionEffectData.type)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.duration, potionEffectData.duration)) {
            return false;
        }
        if (this.level != potionEffectData.level) {
            return false;
        }
        if (this.ambient != potionEffectData.ambient) {
            return false;
        }
        if (this.particles != potionEffectData.particles) {
            return false;
        }
        return this.icon == potionEffectData.icon;
    }

    public PotionEffectData() {
        this(null, null, 0, false, false, false, 63, null);
    }
}

