/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf;

import com.mojang.realmsclient.RealmsMainScreen;
import dev.terminalmc.autoreconnectrf.config.Config;
import dev.terminalmc.autoreconnectrf.reconnect.ReconnectStrategy;
import dev.terminalmc.autoreconnectrf.reconnect.SingleplayerReconnectStrategy;
import dev.terminalmc.autoreconnectrf.util.ModLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntConsumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoReconnect {
    public static final String MOD_ID = "autoreconnectrf";
    public static final String MOD_NAME = "AutoReconnect";
    public static final ModLogger LOG = new ModLogger("AutoReconnect");
    public static final List<Pattern> conditionPatterns = new ArrayList<Pattern>();
    @Nullable
    public static String lastDcReasonStr = null;
    @Nullable
    public static String lastDcReasonKey = null;
    private static final ScheduledThreadPoolExecutor EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(1);
    private static final AtomicReference<ScheduledFuture<?>> countdown;
    @Nullable
    private static ReconnectStrategy reconnectStrategy;

    public static void init() {
        Config.getAndSave();
    }

    public static void onEndTick(Minecraft mc) {
    }

    public static void onConfigSaved(Config config) {
        conditionPatterns.clear();
        for (String s : config.options.conditionPatterns) {
            try {
                conditionPatterns.add(Pattern.compile(s));
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
    }

    public static void cancelAutoReconnect() {
        AutoReconnect.cancelActiveReconnect();
        reconnectStrategy = null;
    }

    public static ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit timeUnit) {
        return EXECUTOR_SERVICE.schedule(command, delay, timeUnit);
    }

    public static void setReconnectStrategy(@NotNull ReconnectStrategy pReconnectStrategy) {
        if (reconnectStrategy == null) {
            reconnectStrategy = pReconnectStrategy;
        }
    }

    public static boolean canReconnect() {
        return reconnectStrategy != null;
    }

    public static void reconnect() {
        AutoReconnect.cancelCountdown();
        AutoReconnect.checkStrategy().reconnect();
    }

    public static void startCountdown(IntConsumer callback) {
        int delay = Config.get().getDelayForAttempt(AutoReconnect.checkStrategy().nextAttempt());
        if (delay >= 0) {
            AutoReconnect.countdown(delay, callback);
        } else {
            callback.accept(-1);
        }
    }

    public static void cancelActiveReconnect() {
        if (reconnectStrategy != null) {
            reconnectStrategy.resetAttempts();
        }
        AutoReconnect.cancelCountdown();
    }

    public static void manualReconnect() {
        AutoReconnect.cancelActiveReconnect();
        AutoReconnect.reconnect();
    }

    public static void onScreenChanged(Screen current, Screen next) {
        if (AutoReconnect.sameType(current, next)) {
            return;
        }
        if (!AutoReconnect.isMainScreen(current) && AutoReconnect.isMainScreen(next) || AutoReconnect.isReAuthenticating(current, next)) {
            AutoReconnect.cancelAutoReconnect();
        }
    }

    public static void onGameJoined() {
        if (reconnectStrategy == null) {
            return;
        }
        if (!reconnectStrategy.isAttempting()) {
            return;
        }
        reconnectStrategy.resetAttempts();
        Config.get().getAutoMessagesForName(reconnectStrategy.getName()).ifPresent(autoMessages -> AutoReconnect.sendAutomatedMessages(Minecraft.getInstance().player, autoMessages.getMessages(), autoMessages.getDelay()));
    }

    public static boolean isPlayingSingleplayer() {
        return reconnectStrategy instanceof SingleplayerReconnectStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelCountdown() {
        AtomicReference<ScheduledFuture<?>> atomicReference = countdown;
        synchronized (atomicReference) {
            if (countdown.get() == null) {
                return;
            }
            ((ScheduledFuture)countdown.getAndSet(null)).cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void countdown(int seconds, IntConsumer callback) {
        if (reconnectStrategy == null) {
            return;
        }
        if (seconds == 0) {
            Minecraft.getInstance().execute(AutoReconnect::reconnect);
            return;
        }
        callback.accept(seconds);
        AtomicReference<ScheduledFuture<?>> atomicReference = countdown;
        synchronized (atomicReference) {
            countdown.set(AutoReconnect.schedule(() -> AutoReconnect.countdown(seconds - 1, callback), 1L, TimeUnit.SECONDS));
        }
    }

    private static void sendAutomatedMessages(LocalPlayer player, Iterator<String> messages, int delay) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleWithFixedDelay(() -> {
            if (!messages.hasNext()) {
                executorService.shutdown();
                return;
            }
            AutoReconnect.sendMessage(player, (String)messages.next());
        }, delay, delay, TimeUnit.MILLISECONDS);
    }

    private static void sendMessage(LocalPlayer player, String message) {
        if (message.startsWith("/")) {
            player.connection.sendUnsignedCommand(message.substring(1));
        } else {
            player.connection.sendChat(message);
        }
    }

    private static boolean sameType(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.getClass().equals(b.getClass());
        }
        return false;
    }

    private static boolean isMainScreen(Screen screen) {
        return screen instanceof TitleScreen || screen instanceof SelectWorldScreen || screen instanceof JoinMultiplayerScreen || screen instanceof RealmsMainScreen;
    }

    private static boolean isReAuthenticating(Screen current, Screen next) {
        return current instanceof DisconnectedScreen && next != null && next.getClass().getName().startsWith("me.axieum.mcmod.authme");
    }

    @NotNull
    private static ReconnectStrategy checkStrategy() {
        if (reconnectStrategy == null) {
            throw new IllegalStateException("Reconnect strategy failed null check");
        }
        return reconnectStrategy;
    }

    static {
        EXECUTOR_SERVICE.setRemoveOnCancelPolicy(true);
        countdown = new AtomicReference<Object>(null);
        reconnectStrategy = null;
    }
}

