/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.autoreconnectrf.AutoReconnect;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Path DIR_PATH = Path.of("config", new String[0]);
    private static final String FILE_NAME = "autoreconnectrf.json";
    private static final String BACKUP_FILE_NAME = "autoreconnectrf.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Options options = new Options();
    private static Config instance = null;

    public static Options options() {
        return Config.get().options;
    }

    public int getDelayForAttempt(int attempt) {
        if (attempt < this.options.delays.size()) {
            return this.options.delays.get(attempt);
        }
        if (this.options.infinite) {
            return this.options.delays.getLast();
        }
        return -1;
    }

    public boolean hasAttempts() {
        return !this.options.delays.isEmpty();
    }

    public Optional<AutoMessage> getAutoMessagesForName(String name) {
        return this.options.autoMessages.stream().filter(autoMessage -> name.equals(autoMessage.name)).findFirst();
    }

    private void validate() {
        if (this.options.delays == null) {
            this.options.delays = Options.defaultDelays;
        } else if (!this.options.delays.isEmpty()) {
            this.options.delays = this.options.delays.stream().filter(i -> i > 0).toList();
        }
        if (this.options.autoMessages == null) {
            this.options.autoMessages = Options.defaultAutoMessages;
        } else if (!this.options.autoMessages.isEmpty()) {
            for (AutoMessage autoMessage : this.options.autoMessages) {
                if (autoMessage.name == null) {
                    autoMessage.name = "";
                }
                if (autoMessage.messages == null) {
                    autoMessage.messages = AutoMessage.defaultMessages;
                } else if (!autoMessage.messages.isEmpty()) {
                    autoMessage.messages = autoMessage.messages.stream().filter(Objects::nonNull).toList();
                }
                if (autoMessage.delay > 0) continue;
                autoMessage.delay = 1000;
            }
        }
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    @NotNull
    public static Config load() {
        Path file = DIR_PATH.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0]) && (config = Config.load(file, GSON)) == null) {
            Config.backup();
            AutoReconnect.LOG.warn("Resetting config", new Object[0]);
        }
        return config != null ? config : new Config();
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                AutoReconnect.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup() {
        try {
            AutoReconnect.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            AutoReconnect.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        try {
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            AutoReconnect.onConfigSaved(instance);
        }
        catch (IOException e) {
            AutoReconnect.LOG.error("Unable to save config", e);
        }
    }

    public static class Options {
        public static final List<Integer> defaultDelays = List.of(Integer.valueOf(3), Integer.valueOf(10), Integer.valueOf(30), Integer.valueOf(60));
        public List<Integer> delays = defaultDelays;
        public static final boolean defaultInfinite = false;
        public boolean infinite = false;
        public static final boolean defaultConditionType = false;
        public boolean conditionType = false;
        public static final List<String> defaultConditionKeys = new ArrayList<String>(List.of("multiplayer.disconnect.banned"));
        public List<String> conditionKeys = defaultConditionKeys;
        public static final List<String> defaultConditionPatterns = new ArrayList<String>();
        public List<String> conditionPatterns = defaultConditionPatterns;
        public static final List<AutoMessage> defaultAutoMessages = new ArrayList<AutoMessage>();
        public List<AutoMessage> autoMessages = defaultAutoMessages;
    }

    public static final class AutoMessage {
        public static final String defaultName = "";
        public String name = "";
        public static final List<String> defaultMessages = new ArrayList<String>();
        public List<String> messages = defaultMessages;
        public static final int defaultDelay = 1000;
        public int delay = 1000;

        public Iterator<String> getMessages() {
            return this.messages.iterator();
        }

        public int getDelay() {
            return this.delay;
        }
    }
}

