/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf.gui.screen;

import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.string.IStringController;
import dev.isxander.yacl3.gui.controllers.string.StringController;
import dev.isxander.yacl3.gui.controllers.string.StringControllerElement;
import dev.terminalmc.autoreconnectrf.AutoReconnect;
import dev.terminalmc.autoreconnectrf.config.Config;
import dev.terminalmc.autoreconnectrf.gui.screen.ConfigScreenProvider;
import dev.terminalmc.autoreconnectrf.mixin.accessor.YACLScreenAccessor;
import dev.terminalmc.autoreconnectrf.util.Localization;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetTooltipHolder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YaclScreenProvider {
    public static final List<String> DISCONNECT_KEYS = List.of("disconnect.closed", "disconnect.disconnected", "disconnect.endOfStream", "disconnect.exceeded_packet_rate", "disconnect.genericReason", "disconnect.ignoring_status_request", "disconnect.loginFailed", "disconnect.loginFailedInfo", "disconnect.loginFailedInfo.insufficientPrivileges", "disconnect.loginFailedInfo.invalidSession", "disconnect.loginFailedInfo.serversUnavailable", "disconnect.loginFailedInfo.userBanned", "disconnect.lost", "disconnect.overflow", "disconnect.packetError", "disconnect.spam", "disconnect.timeout", "disconnect.transfer", "disconnect.unknownHost", "multiplayer.disconnect.authservers_down", "multiplayer.disconnect.banned", "multiplayer.disconnect.banned_ip.reason", "multiplayer.disconnect.banned.reason", "multiplayer.disconnect.chat_validation_failed", "multiplayer.disconnect.duplicate_login", "multiplayer.disconnect.expired_public_key", "multiplayer.disconnect.flying", "multiplayer.disconnect.generic", "multiplayer.disconnect.idling", "multiplayer.disconnect.illegal_characters", "multiplayer.disconnect.incompatible", "multiplayer.disconnect.invalid_entity_attacked", "multiplayer.disconnect.invalid_packet", "multiplayer.disconnect.invalid_player_data", "multiplayer.disconnect.invalid_player_movement", "multiplayer.disconnect.invalid_public_key_signature", "multiplayer.disconnect.invalid_public_key_signature", "multiplayer.disconnect.invalid_vehicle_movement", "multiplayer.disconnect.ip_banned", "multiplayer.disconnect.kicked", "multiplayer.disconnect.missing_tags", "multiplayer.disconnect.name_taken", "multiplayer.disconnect.not_whitelisted", "multiplayer.disconnect.out_of_order_chat", "multiplayer.disconnect.outdated_client", "multiplayer.disconnect.outdated_server", "multiplayer.disconnect.server_full", "multiplayer.disconnect.server_shutdown", "multiplayer.disconnect.slow_login", "multiplayer.disconnect.too_many_pending_chats", "multiplayer.disconnect.transfers_disabled", "multiplayer.disconnect.unexpected_query_response", "multiplayer.disconnect.unsigned_chat", "multiplayer.disconnect.unverified_username", "multiplayer.requiredTexturePrompt.disconnect");

    static Screen getConfigScreen(Screen parent) {
        Config.Options options = Config.options();
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((Component)Localization.localized("name", new Object[0])).save(Config::save);
        ConfigCategory.Builder attemptsCat = ConfigCategory.createBuilder().name((Component)Localization.localized("option", "attempts", new Object[0]));
        attemptsCat.group((OptionGroup)ListOption.createBuilder().name((Component)Localization.localized("option", "attempts.delays", new Object[0])).description(OptionDescription.of((Component[])new Component[]{Localization.localized("option", "attempts.delays.tooltip", new Object[0])})).binding(Config.Options.defaultDelays, () -> options.delays, val -> {
            options.delays = val;
        }).controller(option -> IntegerFieldControllerBuilder.create((Option)option).min((Number)1)).initial((Object)0).insertEntriesAtEnd(true).minimumNumberOfEntries(1).build());
        attemptsCat.option(Option.createBuilder().name((Component)Localization.localized("option", "attempts.infinite", new Object[0])).description(OptionDescription.of((Component[])new Component[]{Localization.localized("option", "attempts.infinite.tooltip", new Object[0])})).binding((Object)false, () -> options.infinite, val -> {
            options.infinite = val;
        }).controller(BooleanControllerBuilder::create).build());
        ConfigCategory.Builder conditionsCat = ConfigCategory.createBuilder().name((Component)Localization.localized("option", "conditions", new Object[0]));
        conditionsCat.option(Option.createBuilder().name((Component)Localization.localized("option", "conditions.type", new Object[0])).description(OptionDescription.of((Component[])new Component[]{Localization.localized("option", "conditions.type.tooltip", Localization.localized("option", "conditions.type.positive", new Object[0]).withStyle(ChatFormatting.GREEN), Localization.localized("option", "conditions.type.negative", new Object[0]).withStyle(ChatFormatting.RED))})).binding((Object)false, () -> options.conditionType, val -> {
            options.conditionType = val;
        }).controller(option -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)option).formatValue(val2 -> val2 != false ? Localization.localized("option", "conditions.type.positive", new Object[0]) : Localization.localized("option", "conditions.type.negative", new Object[0]))).coloured(true)).build());
        conditionsCat.group((OptionGroup)ListOption.createBuilder().name((Component)Localization.localized("option", "conditions.keys", new Object[0])).description(OptionDescription.of((Component[])new Component[]{Localization.localized("option", "conditions.keys.tooltip", AutoReconnect.lastDcReasonKey == null ? Localization.localized("option", "conditions.last.none", new Object[0]) : String.format("\"%s\"", AutoReconnect.lastDcReasonKey))})).binding(Config.Options.defaultConditionKeys, () -> options.conditionKeys, val -> {
            options.conditionKeys = val;
        }).controller(option -> DropdownStringControllerBuilder.create((Option)option).values(DISCONNECT_KEYS).allowAnyValue(true).allowEmptyValue(false)).initial((Object)"").insertEntriesAtEnd(true).build());
        conditionsCat.group((OptionGroup)ListOption.createBuilder().name((Component)Localization.localized("option", "conditions.patterns", new Object[0])).description(OptionDescription.of((Component[])new Component[]{Localization.localized("option", "conditions.patterns.tooltip", AutoReconnect.lastDcReasonStr == null ? Localization.localized("option", "conditions.last.none", new Object[0]) : String.format("\"%s\"", AutoReconnect.lastDcReasonStr))})).binding(Config.Options.defaultConditionPatterns, () -> options.conditionPatterns, val -> {
            options.conditionPatterns = val;
        }).controller(option -> IRestrictedStringControllerBuilder.create((Option<String>)option).validator(val -> {
            try {
                Pattern.compile(val);
                return Optional.empty();
            }
            catch (PatternSyntaxException e) {
                return Optional.of(e.getMessage().replaceAll("\\u000D", ""));
            }
        })).initial((Object)"").insertEntriesAtEnd(true).build());
        ConfigCategory.Builder messagesCat = ConfigCategory.createBuilder().name((Component)Localization.localized("option", "messages", new Object[0]));
        int i = 0;
        for (Config.AutoMessage am : options.autoMessages) {
            OptionGroup.Builder amGroup = OptionGroup.createBuilder();
            amGroup.name((Component)Localization.localized("option", "messages.instance", ++i));
            amGroup.description(OptionDescription.of((Component[])new Component[]{Localization.localized("option", "messages.instance.tooltip", new Object[0])}));
            amGroup.option((Option)ButtonOption.createBuilder().name((Component)Localization.localized("option", "messages.instance.delete", new Object[0]).withStyle(ChatFormatting.RED)).action((screen, buttonOption) -> {
                options.autoMessages.remove(am);
                YaclScreenProvider.reload(screen);
            }).build());
            amGroup.option(Option.createBuilder().name((Component)Localization.localized("option", "messages.instance.name", new Object[0])).description(OptionDescription.of((Component[])new Component[]{Localization.localized("option", "messages.instance.name.tooltip", new Object[0])})).binding((Object)"", () -> am.name, val -> {
                am.name = val;
            }).controller(StringControllerBuilder::create).build());
            amGroup.option(Option.createBuilder().name((Component)Localization.localized("option", "messages.instance.delay", new Object[0])).description(OptionDescription.of((Component[])new Component[]{Localization.localized("option", "messages.instance.delay.tooltip", new Object[0])})).binding((Object)1000, () -> am.delay, val -> {
                am.delay = val;
            }).controller(option -> IntegerFieldControllerBuilder.create((Option)option).min((Number)0)).build());
            messagesCat.group(amGroup.build());
            messagesCat.group((OptionGroup)ListOption.createBuilder().name((Component)Localization.localized("option", "messages.instance.messages", new Object[0])).description(OptionDescription.of((Component[])new Component[]{Localization.localized("option", "messages.instance.messages.tooltip", new Object[0])})).binding(Config.AutoMessage.defaultMessages, () -> am.messages, val -> {
                am.messages = val;
            }).controller(StringControllerBuilder::create).initial((Object)"").insertEntriesAtEnd(true).build());
        }
        messagesCat.option((Option)ButtonOption.createBuilder().name((Component)Localization.localized("option", "messages.instance.add", new Object[0]).withStyle(ChatFormatting.GREEN)).action((yaclScreen, buttonOption) -> {
            options.autoMessages.addFirst(new Config.AutoMessage());
            YaclScreenProvider.reload(yaclScreen);
        }).build());
        builder.category(attemptsCat.build());
        builder.category(conditionsCat.build());
        builder.category(messagesCat.build());
        YetAnotherConfigLib yacl = builder.build();
        return yacl.generateScreen(parent);
    }

    public static void reload(YACLScreen screen) {
        int tab;
        int n = tab = screen.tabNavigationBar != null ? screen.tabNavigationBar.getTabs().indexOf((Object)screen.tabManager.getCurrentTab()) : 0;
        if (tab == -1) {
            tab = 0;
        }
        screen.finishOrSave();
        screen.onClose();
        YACLScreen newScreen = (YACLScreen)ConfigScreenProvider.getConfigScreen(((YACLScreenAccessor)screen).getParent());
        Minecraft.getInstance().setScreen((Screen)newScreen);
        try {
            newScreen.tabNavigationBar.selectTab(tab, false);
        }
        catch (IndexOutOfBoundsException e) {
            AutoReconnect.LOG.warn("YACL reload hack attempted to set tab to index {} but max index was {}.", tab, newScreen.tabNavigationBar.getTabs().size() - 1);
        }
    }

    public static interface IRestrictedStringControllerBuilder
    extends ControllerBuilder<String> {
        public static IRestrictedStringControllerBuilder create(Option<String> option) {
            return new RestrictedStringControllerBuilder(option);
        }

        public IRestrictedStringControllerBuilder validator(Function<String, Optional<String>> var1);
    }

    private static class RestrictedStringControllerElement
    extends StringControllerElement {
        private final WidgetTooltipHolder tooltip = new WidgetTooltipHolder();

        public RestrictedStringControllerElement(IStringController<?> control, YACLScreen screen, Dimension<Integer> dim, boolean instantApply) {
            super(control, screen, dim, instantApply);
        }

        public void setTooltip(@Nullable Tooltip tooltip) {
            this.tooltip.set(tooltip);
        }

        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            super.render(graphics, mouseX, mouseY, delta);
            this.tooltip.refreshTooltipForNextRenderPass(super.isMouseOver((double)mouseX, (double)mouseY), super.isFocused(), super.getRectangle());
        }
    }

    private static class RestrictedStringController
    extends StringController {
        @Nullable
        private final Function<String, Optional<String>> validator;
        @Nullable
        private String displayValue;
        @Nullable
        private RestrictedStringControllerElement widget;

        public RestrictedStringController(Option<String> option, @Nullable Function<String, Optional<String>> validator) {
            super(option);
            this.validator = validator;
        }

        public Component formatValue() {
            if (this.displayValue == null) {
                return super.formatValue();
            }
            return Component.literal((String)this.displayValue).withStyle(ChatFormatting.RED);
        }

        public void setFromString(String value) {
            Optional<String> error;
            if (this.validator != null && (error = this.validator.apply(value)).isPresent()) {
                this.displayValue = value;
                if (this.widget != null) {
                    this.widget.setTooltip(Tooltip.create((Component)Component.literal((String)error.get())));
                }
                return;
            }
            this.displayValue = null;
            if (this.widget != null) {
                this.widget.setTooltip(null);
            }
            super.setFromString(value);
        }

        public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
            this.widget = new RestrictedStringControllerElement((IStringController<?>)this, screen, widgetDimension, true);
            return this.widget;
        }
    }

    public static class RestrictedStringControllerBuilder
    extends CustomAbstractControllerBuilder<String>
    implements IRestrictedStringControllerBuilder {
        private Function<String, Optional<String>> validator;

        public RestrictedStringControllerBuilder(Option<String> option) {
            super(option);
        }

        @Override
        public RestrictedStringControllerBuilder validator(Function<String, Optional<String>> validator) {
            this.validator = validator;
            return this;
        }

        public Controller<String> build() {
            return new RestrictedStringController((Option<String>)this.option, this.validator);
        }
    }

    public static abstract class CustomAbstractControllerBuilder<T>
    implements ControllerBuilder<T> {
        protected final Option<T> option;

        protected CustomAbstractControllerBuilder(Option<T> option) {
            this.option = option;
        }
    }
}

