/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf.mixin;

import dev.terminalmc.autoreconnectrf.AutoReconnect;
import dev.terminalmc.autoreconnectrf.util.Localization;
import dev.terminalmc.autoreconnectrf.util.ScreenMixinUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.realms.DisconnectedRealmsScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DisconnectedRealmsScreen.class})
public class MixinDisconnectedRealmsScreen
extends Screen {
    @Unique
    private boolean autoReconnect$shouldAutoReconnect;
    @Unique
    private Runnable autoReconnect$cancelCountdown;

    protected MixinDisconnectedRealmsScreen(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void init(CallbackInfo info) {
        if (!AutoReconnect.canReconnect()) {
            this.autoReconnect$shouldAutoReconnect = false;
        } else {
            Button cancelButton;
            this.autoReconnect$shouldAutoReconnect = ScreenMixinUtil.checkConditions(this);
            List<Button> buttons = this.autoReconnect$addButtons(this.autoReconnect$shouldAutoReconnect);
            Button reconnectButton = buttons.getFirst();
            Button button = cancelButton = buttons.size() == 2 ? buttons.getLast() : null;
            if (this.autoReconnect$shouldAutoReconnect) {
                AutoReconnect.startCountdown(seconds -> ScreenMixinUtil.countdownCallback(reconnectButton, seconds));
            }
            this.autoReconnect$cancelCountdown = () -> {
                AutoReconnect.cancelActiveReconnect();
                this.autoReconnect$shouldAutoReconnect = false;
                if (cancelButton != null) {
                    this.removeWidget((GuiEventListener)cancelButton);
                }
                reconnectButton.active = true;
                reconnectButton.setMessage((Component)Localization.localized("message", "reconnect", new Object[0]));
            };
        }
    }

    @Unique
    private List<Button> autoReconnect$addButtons(boolean canCancel) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        Button backButton = ScreenMixinUtil.findBackButton(this).orElseThrow(() -> new NoSuchElementException("Couldn't find the back button on the disconnect screen"));
        Button reconnectButton = Button.builder((Component)Localization.localized("message", "reconnect", new Object[0]), btn -> AutoReconnect.schedule(() -> Minecraft.getInstance().execute(AutoReconnect::manualReconnect), 100L, TimeUnit.MILLISECONDS)).bounds(backButton.getX(), backButton.getY() + backButton.getHeight() + 4, backButton.getWidth(), backButton.getHeight()).build();
        this.addRenderableWidget((GuiEventListener)reconnectButton);
        buttons.add(reconnectButton);
        if (canCancel) {
            Button cancelButton = Button.builder((Component)Component.literal((String)"x").withStyle(ChatFormatting.RED), btn -> {
                AutoReconnect.cancelActiveReconnect();
                this.autoReconnect$shouldAutoReconnect = false;
                this.removeWidget((GuiEventListener)this);
                reconnectButton.active = true;
                reconnectButton.setMessage((Component)Localization.localized("message", "reconnect", new Object[0]));
                reconnectButton.setWidth(backButton.getWidth());
            }).bounds(reconnectButton.getX(), reconnectButton.getY() + reconnectButton.getHeight() + 4, backButton.getWidth(), backButton.getHeight()).build();
            this.addRenderableWidget((GuiEventListener)cancelButton);
            buttons.add(cancelButton);
        }
        return buttons;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.autoReconnect$shouldAutoReconnect) {
            if (this.autoReconnect$cancelCountdown != null) {
                this.autoReconnect$cancelCountdown.run();
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

