/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf.mixin;

import dev.terminalmc.autoreconnectrf.AutoReconnect;
import dev.terminalmc.autoreconnectrf.mixin.accessor.DisconnectedScreenAccessor;
import dev.terminalmc.autoreconnectrf.util.Localization;
import dev.terminalmc.autoreconnectrf.util.ScreenMixinUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DisconnectedScreen.class})
public class MixinDisconnectedScreen
extends Screen {
    @Shadow
    @Mutable
    @Final
    private Screen parent;
    @Unique
    private boolean autoReconnect$shouldAutoReconnect;
    @Unique
    private Runnable autoReconnect$cancelCountdown;

    protected MixinDisconnectedScreen(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void init(CallbackInfo info) {
        if (AutoReconnect.isPlayingSingleplayer()) {
            ScreenMixinUtil.findBackButton(this).ifPresent(btn -> btn.setMessage((Component)Component.translatable((String)"gui.toWorld")));
        }
        if (AutoReconnect.isPlayingSingleplayer()) {
            this.parent = new SelectWorldScreen((Screen)new TitleScreen());
        }
        if (!AutoReconnect.canReconnect()) {
            this.autoReconnect$shouldAutoReconnect = false;
        } else {
            Button cancelButton;
            this.autoReconnect$shouldAutoReconnect = ScreenMixinUtil.checkConditions(this);
            List<Button> buttons = this.autoReconnect$addButtons(((DisconnectedScreenAccessor)((Object)this)).getLayout(), this.autoReconnect$shouldAutoReconnect);
            Button reconnectButton = buttons.getFirst();
            Button button = cancelButton = buttons.size() == 2 ? buttons.getLast() : null;
            if (this.autoReconnect$shouldAutoReconnect) {
                AutoReconnect.startCountdown(seconds -> ScreenMixinUtil.countdownCallback(reconnectButton, seconds));
            }
            this.autoReconnect$cancelCountdown = () -> {
                AutoReconnect.cancelActiveReconnect();
                this.autoReconnect$shouldAutoReconnect = false;
                if (cancelButton != null) {
                    this.removeWidget((GuiEventListener)cancelButton);
                }
                reconnectButton.active = true;
                reconnectButton.setMessage((Component)Localization.localized("message", "reconnect", new Object[0]));
            };
        }
    }

    @Unique
    private List<Button> autoReconnect$addButtons(LinearLayout layout, boolean canCancel) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        Button backButton = ScreenMixinUtil.findBackButton(this).orElseThrow(() -> new NoSuchElementException("Couldn't find the back button on the disconnect screen"));
        Button reconnectButton = Button.builder((Component)Localization.localized("message", "reconnect", new Object[0]), btn -> AutoReconnect.schedule(() -> Minecraft.getInstance().execute(AutoReconnect::manualReconnect), 100L, TimeUnit.MILLISECONDS)).bounds(0, 0, backButton.getWidth(), backButton.getHeight()).build();
        layout.addChild((LayoutElement)reconnectButton);
        buttons.add(reconnectButton);
        if (canCancel) {
            Button cancelButton = Button.builder((Component)Component.literal((String)"x").withStyle(ChatFormatting.RED), btn -> {
                if (this.autoReconnect$cancelCountdown != null) {
                    this.autoReconnect$cancelCountdown.run();
                }
            }).bounds(0, 0, backButton.getWidth(), backButton.getHeight()).build();
            layout.addChild((LayoutElement)cancelButton);
            buttons.add(cancelButton);
        }
        layout.arrangeElements();
        this.repositionElements();
        this.clearWidgets();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        return buttons;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.autoReconnect$shouldAutoReconnect) {
            if (this.autoReconnect$cancelCountdown != null) {
                this.autoReconnect$cancelCountdown.run();
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Inject(method={"shouldCloseOnEsc"}, at={@At(value="RETURN")}, cancellable=true)
    private void shouldCloseOnEsc(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)true);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }
}

