/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf.mixin;

import dev.terminalmc.autoreconnectrf.AutoReconnect;
import dev.terminalmc.autoreconnectrf.reconnect.SingleplayerReconnectStrategy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MixinMinecraft {
    @Shadow
    public Screen screen;

    @Inject(method={"doWorldLoad"}, at={@At(value="HEAD")})
    private void startIntegratedServer(LevelStorageSource.LevelStorageAccess session, PackRepository dataPackManager, WorldStem saveLoader, boolean newWorld, CallbackInfo info) {
        AutoReconnect.setReconnectStrategy(new SingleplayerReconnectStrategy(saveLoader.worldData().getLevelName()));
    }

    @Inject(method={"setScreen"}, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/Minecraft;screen:Lnet/minecraft/client/gui/screens/Screen;")})
    private void setScreen(Screen newScreen, CallbackInfo info) {
        AutoReconnect.onScreenChanged(this.screen, newScreen);
    }
}

