/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf.util;

import dev.terminalmc.autoreconnectrf.AutoReconnect;
import dev.terminalmc.autoreconnectrf.config.Config;
import dev.terminalmc.autoreconnectrf.mixin.accessor.DisconnectedScreenAccessor;
import dev.terminalmc.autoreconnectrf.util.Localization;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.spongepowered.asm.mixin.Unique;

public class ScreenMixinUtil {
    public static boolean checkConditions(Screen screen) {
        if (screen instanceof DisconnectedScreen) {
            String reasonStr;
            DisconnectedScreen ds = (DisconnectedScreen)screen;
            Component reason = ((DisconnectedScreenAccessor)ds).getDetails().reason();
            AutoReconnect.lastDcReasonStr = reasonStr = reason.getString();
            AutoReconnect.lastDcReasonKey = null;
            boolean match = false;
            ComponentContents componentContents = reason.getContents();
            if (componentContents instanceof TranslatableContents) {
                String key;
                TranslatableContents tc = (TranslatableContents)componentContents;
                AutoReconnect.lastDcReasonKey = key = tc.getKey();
                if (key.equals("disconnect.transfer")) {
                    return false;
                }
                for (String condition : Config.options().conditionKeys) {
                    if (!key.contains(condition)) continue;
                    AutoReconnect.LOG.info("Matched key '{}' against reason key '{}'", condition, key);
                    match = true;
                    break;
                }
            }
            if (!match) {
                for (Pattern condition : AutoReconnect.conditionPatterns) {
                    if (!condition.matcher(reasonStr).find()) continue;
                    AutoReconnect.LOG.info("Matched pattern '{}' against reason '{}'", condition, reasonStr);
                    match = true;
                    break;
                }
            }
            if (Config.options().conditionType) {
                return match;
            }
            return !match;
        }
        return Config.get().hasAttempts();
    }

    public static Optional<Button> findBackButton(Screen screen) {
        for (GuiEventListener element : screen.children()) {
            String translatableKey;
            if (!(element instanceof Button)) continue;
            Button button = (Button)element;
            Component component = button.getMessage();
            if (component instanceof TranslatableContents) {
                TranslatableContents translatable = (TranslatableContents)component;
                translatableKey = translatable.getKey();
            } else {
                component = button.getMessage().getContents();
                if (!(component instanceof TranslatableContents)) continue;
                TranslatableContents translatable = (TranslatableContents)component;
                translatableKey = translatable.getKey();
            }
            if (!translatableKey.equals("gui.back") && !translatableKey.startsWith("gui.to")) continue;
            return Optional.of(button);
        }
        return Optional.empty();
    }

    @Unique
    public static void countdownCallback(Button reconnectButton, int seconds) {
        if (seconds < 0) {
            reconnectButton.setMessage((Component)Localization.localized("message", "reconnectFailed", new Object[0]).withStyle(s -> s.withColor(ChatFormatting.RED)));
            reconnectButton.active = false;
        } else {
            reconnectButton.setMessage((Component)Localization.localized("message", "reconnectIn", seconds).withStyle(s -> s.withColor(ChatFormatting.GREEN)));
        }
    }
}

