/*
 * Decompiled with CFR 0.152.
 */
package top.realme.mc.homohttprouter;

import com.mojang.logging.LogUtils;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.slf4j.Logger;
import top.realme.mc.homohttprouter.Config;
import top.realme.mc.homohttprouter.event.HttpServiceBuildEvent;
import top.realme.mc.homohttprouter.http.HttpServerManager;
import top.realme.mc.homohttprouter.http.RouterRegistry;

@Mod(value="homohttprouter")
public class HomoHttpRouter {
    public static final String MODID = "homohttprouter";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static HttpServerManager httpServerManager;
    private static final RouterRegistry ROUTER_REGISTRY;

    public HomoHttpRouter(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HomoHttpRouter common setup");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        event.getServer().execute(() -> {
            int port = (Integer)Config.PORT.get();
            httpServerManager = new HttpServerManager(port, ROUTER_REGISTRY);
            httpServerManager.start();
            NeoForge.EVENT_BUS.post((Event)new HttpServiceBuildEvent(ROUTER_REGISTRY));
        });
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        if (httpServerManager != null) {
            httpServerManager.stop();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() != Config.SPEC) {
            return;
        }
        LOGGER.info("Config changed, restarting HTTP server.");
        if (httpServerManager != null) {
            httpServerManager.stop();
        }
        int port = (Integer)Config.PORT.get();
        httpServerManager = new HttpServerManager(port, ROUTER_REGISTRY);
        httpServerManager.start();
    }

    static {
        ROUTER_REGISTRY = new RouterRegistry();
    }
}

